/** Options.java.

	Purpose:
		
	Description:
		
	History:
		12:41:42 PM Jan 15, 2014, Created by jumperchen

Copyright (C) 2014 Potix Corporation. All Rights Reserved.
 */
package org.zkoss.chart;

/**
 * The global options for Highcharts
 * 
 * @author jumperchen
 */
public class Options extends Optionable {
	private enum Attrs implements PlotAttribute {
		global, lang
	}

	/**
	 * Sets the Global object. The Global object is global and it can't be set on
	 * each chart initiation. Instead, use
	 * {@link Charts#setOptions(Options)} to set it before any chart is
	 * initiated.
	 */
	public void setGlobal(Global global) {
		setAttr(Attrs.global, global);
	}

	/**
	 * Returns Global options
	 */
	public Global getGlobal() {
		Global global = (Global) getAttr(Attrs.global);
		if (global == null) {
			global = new Global();
			setAttr(Attrs.global, global);
		}
		return global;
	}

	/**
	 * Sets the Language object. The language object is global and it can't be set on
	 * each chart initiation. Instead, use
	 * {@link Charts#setOptions(Options)} to set it before any chart is
	 * initiated.
	 */
	public void setLang(Lang lang) {
		setAttr(Attrs.lang, lang);
	}

	/**
	 * Returns the Language options
	 */
	public Lang getLang() {
		Lang lang = (Lang) getAttr(Attrs.lang);
		if (lang == null) {
			lang = new Lang();
			setAttr(Attrs.lang, lang);
		}
		return lang;
	}
}
