/** NoData.java.

	Purpose:
		
	Description:
		
	History:
		3:54:59 PM May 26, 2014, Created by jumperchen

Copyright (C) 2014 Potix Corporation. All Rights Reserved.
*/
package org.zkoss.chart;

import java.util.LinkedHashMap;
import java.util.Map;

import org.zkoss.chart.util.DynamicalAttribute;
import org.zkoss.chart.util.MapsHelper;
import org.zkoss.lang.Generics;

/**
 * An option for no data message
 * @author jumperchen
 * @since 1.0.1
 */
public class NoData extends Optionable {
	private enum Attrs implements PlotAttribute, DynamicalAttribute {
		position, style, attr
	}

	/**
	 * Returns the position of the no-data label. This is an object that can hold the
	 * properties align, verticalAlign, x and y.
	 * <p>
	 * Defaults to:
	 * 
	 * <pre>
	 * position: {
	 * 	align: 'center',
	 * 	x: 0,
	 * 	verticalAlign: 'middle',
	 * 	y: 0
	 * }
	 * </pre>
	 */
	public Position getPosition() {
		if (!containsKey(Attrs.position)) {
			Position position = new Position(0, 0, "center", "middle");
			setPosition(position);
			return position;
		} else {
			return (Position) getAttr(Attrs.position);
		}
	}

	/**
	 * Sets the position of the no-data label. This is an object that can hold the
	 * properties align, verticalAlign, x and y.
	 */
	public void setPosition(Position position) {
		setAttr(Attrs.position, position, NOT_NULL_VALUE);
	}

	/**
	 * Returns the CSS styles for the no-data label. Defaults to:
	 * 
	 * <pre>
	 * fontWeight: bold; fontSize: 12px; color: #60606a;
	 * </pre>
	 */
	public <K, V> Map<K, V> getStyle() {
		if (!containsKey(Attrs.style)) {
			setStyle("fontWeight: bold; fontSize: 12px; color: #60606a;");
		}
		return Generics.cast(getAttr(Attrs.style));
	}

	/**
	 * Sets the CSS styles for the no-data label. Defaults to:
	 * 
	 * <pre>
	 * fontWeight: bold; fontSize: 12px; color: #60606a;
	 * </pre>
	 * 
	 * @see #setStyle(Map)
	 */
	public void setStyle(String style) {
		setStyle(MapsHelper.parse(new LinkedHashMap<String, String>(), style, ':', ';', '\''));
	}

	/**
	 * Sets the CSS styles for the no-data label. Defaults to:
	 * 
	 * <pre>
	 * fontWeight: bold; fontSize: 12px; color: #60606a;
	 * </pre>
	 * 
	 * @see #setStyle(String)
	 */
	public <K, V> void setStyle(Map<K, V> style) {
		setAttr(Attrs.style, style, NOT_NULL_VALUE);
	}

	/**
	 * Returns a collection of attributes for the no-data label. The object takes SVG
	 * attributes like <code>fill</code>, <code>stroke</code>,
	 * <code>stroke-width</code> or <code>r</code>, the border radius.
	 */
	public <K, V> Map<K, V> getAttribute() {
		return Generics.cast(getAttr(Attrs.attr, null).asValue());
	}

	/**
	 * Sets a collection of attributes for the no-data label. The object takes SVG
	 * attributes like <code>fill</code>, <code>stroke</code>,
	 * <code>stroke-width</code> or <code>r</code>, the border radius.
	 */
	public <K, V> void setAttribute(Map<K, V> attr) {
		setAttr(Attrs.attr, attr);
	}
}
