/* Navigation.java

	Purpose:
		
	Description:
		
	History:
		Fri, Jan 17, 2014 12:36:59 PM, Created by RaymondChao

Copyright (C) 2014 Potix Corporation. All Rights Reserved.

 */
package org.zkoss.chart;

import java.util.LinkedHashMap;
import java.util.Map;

import org.zkoss.chart.util.DynamicalAttribute;
import org.zkoss.chart.util.MapsHelper;
import org.zkoss.lang.Generics;

/**
 * A collection of options for buttons and menus appearing in the exporting
 * module.
 * <p>
 * All the options in this class support {@link DynamicalAttribute}.
 * 
 * @author RaymondChao
 */
public class Navigation extends Optionable {
	private enum Attrs implements PlotAttribute, DynamicalAttribute {
		buttonOptions, menuItemHoverStyle, menuItemStyle, menuStyle
	}

	/**
	 * Returns a collection of options for buttons appearing in the exporting
	 * module.
	 */
	public NavigationButton getButtonOptions() {
		 NavigationButton options = (NavigationButton) getAttr(Attrs.buttonOptions);
		 if (options == null) {
			 options = new NavigationButton();
			 setButtonOptions(options);
		 }
		 return options;
	}

	/**
	 * Sets a collection of options for buttons appearing in the exporting
	 * module.
	 */
	public void setButtonOptions(NavigationButton buttonOptions) {
		setAttr(Attrs.buttonOptions, buttonOptions);
	}

	/**
	 * Returns CSS styles for the hover state of the individual items within the
	 * popup menu appearing by default when the export icon is clicked. The menu
	 * items are rendered in HTML.
	 * <p>
	 * Defaults to
	 * 
	 * <pre>
	 * background: #4572A5;	color: #FFFFFF;
	 * </pre>
	 */
	public <K, V> Map<K, V> getMenuItemHoverStyle() {
		if (!containsKey(Attrs.menuItemHoverStyle)) {
			setMenuItemHoverStyle("background: #4572A5;	color: #FFFFFF;");
		}
		return Generics.cast(getAttr(Attrs.menuItemHoverStyle));
	}

	/**
	 * Sets CSS styles for the hover state of the individual items within the
	 * popup menu appearing by default when the export icon is clicked. The menu
	 * items are rendered in HTML.
	 * <p>
	 * Defaults to
	 * 
	 * <pre>
	 * background: #4572A5;	color: #FFFFFF;
	 * </pre>
	 */
	public void setMenuItemHoverStyle(String menuItemHoverStyle) {
		setMenuItemHoverStyle(MapsHelper.parse(new LinkedHashMap<String, String>(), menuItemHoverStyle, ':', ';',
				'\''));
	}

	/**
	 * Sets CSS styles for the hover state of the individual items within the
	 * popup menu appearing by default when the export icon is clicked. The menu
	 * items are rendered in HTML.
	 * <p>
	 * Defaults to
	 * 
	 * <pre>
	 * background: #4572A5;	color: #FFFFFF;
	 * </pre>
	 */
	public <K, V> void setMenuItemHoverStyle(Map<K, V> menuItemHoverStyle) {
		setAttr(Attrs.menuItemHoverStyle, menuItemHoverStyle, NOT_NULL_VALUE);
	}

	/**
	 * Returns CSS styles for the individual items within the popup menu
	 * appearing by default when the export icon is clicked. The menu items are
	 * rendered in HTML.
	 * <p>
	 * Defaults to
	 * 
	 * <pre>
	 * padding: 0 5px; background: NONE; color: #303030;
	 * </pre>
	 */
	public <K, V> Map<K, V> getMenuItemStyle() {
		if (!containsKey(Attrs.menuItemStyle)) {
			setMenuItemStyle("padding: 0 5px; background: NONE; color: #303030;");
		}
		return Generics.cast(getAttr(Attrs.menuItemStyle));
	}

	/**
	 * Sets CSS styles for the individual items within the popup menu appearing
	 * by default when the export icon is clicked. The menu items are rendered
	 * in HTML.
	 * <p>
	 * Defaults to
	 * 
	 * <pre>
	 * padding: 0 5px; background: NONE; color: #303030;
	 * </pre>
	 */
	public void setMenuItemStyle(String menuItemStyle) {
		setMenuItemStyle(MapsHelper.parse(new LinkedHashMap<String, String>(), menuItemStyle, ':', ';', '\''));
	}

	/**
	 * Sets CSS styles for the individual items within the popup menu appearing
	 * by default when the export icon is clicked. The menu items are rendered
	 * in HTML.
	 * <p>
	 * Defaults to
	 * 
	 * <pre>
	 * padding: 0 5px; background: NONE; color: #303030;
	 * </pre>
	 */
	public <K, V> void setMenuItemStyle(Map<K, V> menuItemStyle) {
		setAttr(Attrs.menuItemStyle, menuItemStyle, NOT_NULL_VALUE);
	}

	/**
	 * Returns CSS styles for the popup menu appearing by default when the
	 * export icon is clicked. This menu is rendered in HTML.
	 * <p>Defaults to
	 * 
	 * <pre>
	 * border: 1px solid #A0A0A0; background: #FFFFFF;
	 * </pre>
	 */
	public <K, V> Map<K, V> getMenuStyle() {
		if (!containsKey(Attrs.menuStyle)) {
			setMenuStyle("border: 1px solid #A0A0A0; background: #FFFFFF;");
		}
		return Generics.cast(getAttr(Attrs.menuStyle));
	}

	/**
	 * Sets CSS styles for the popup menu appearing by default when the
	 * export icon is clicked. This menu is rendered in HTML.
	 * <p>Defaults to
	 * 
	 * <pre>
	 * border: 1px solid #A0A0A0; background: #FFFFFF;
	 * </pre>
	 */
	public void setMenuStyle(String menuStyle) {
		setMenuStyle(MapsHelper.parse(new LinkedHashMap<String, String>(), menuStyle, ':', ';', '\''));
	}

	/**
	 * Sets CSS styles for the popup menu appearing by default when the
	 * export icon is clicked. This menu is rendered in HTML.
	 * <p>Defaults to
	 * 
	 * <pre>
	 * border: 1px solid #A0A0A0; background: #FFFFFF;
	 * </pre>
	 */
	public <K, V> void setMenuStyle(Map<K, V> menuStyle) {
		setAttr(Attrs.menuStyle, menuStyle, NOT_NULL_VALUE);
	}

}