/** LegendTitle.java.

	Purpose:
		
	Description:
		
	History:
		9:33:42 AM Jan 13, 2014, Created by RaymondChao

Copyright (C) 2014 Potix Corporation. All Rights Reserved.
 */

package org.zkoss.chart;

import java.util.LinkedHashMap;
import java.util.Map;

import org.zkoss.chart.util.DynamicalAttribute;
import org.zkoss.chart.util.MapsHelper;
import org.zkoss.lang.Generics;

/**
 * A title to be added on top of the legend.
 * <p>
 * All the options in this class support {@link DynamicalAttribute}.
 * 
 * @author jumperchen
 * @author RaymondChao
 */
public class LegendTitle extends Optionable {
	private enum Attrs implements PlotAttribute, DynamicalAttribute {
		style, text
	}

	/**
	 * Returns generic CSS styles for the legend title. Default:
	 * 
	 * <pre>
	 * fontWeight: bold;
	 * </pre>
	 * <p>
	 */
	public <K, V> Map<K, V> getStyle() {
		return Generics.cast(getAttr(Attrs.style, null).asValue());
	}

	/**
	 * Sets generic CSS styles for the legend title.
	 * 
	 * @see #setStyle(Map)
	 */
	public void setStyle(String style) {
		setStyle(MapsHelper.parse(new LinkedHashMap<String, String>(), style, ':', ';', '\''));
	}

	/**
	 * Sets generic CSS styles for the legend title.
	 * 
	 * @see #setStyle(String)
	 */
	public <K, V> void setStyle(Map<K, V> style) {
		setAttr(Attrs.style, style);
	}

	/**
	 * Returns a text or HTML string for the title.
	 * <p>
	 * Default: null
	 */
	public String getText() {
		return getAttr(Attrs.text, null).asString();
	}

	/**
	 * Sets a text or HTML string for the title.
	 */
	public void setText(String text) {
		setAttr(Attrs.text, text);
	}

}