/** Lang.java.

	Purpose:
		
	Description:
		
	History:
		2:00:01 PM Jan 15, 2014, Created by jumperchen

Copyright (C) 2014 Potix Corporation. All Rights Reserved.
 */
package org.zkoss.chart;

import java.util.List;

import org.zkoss.lang.Generics;

/**
 * The language object is global and it can't be set on each chart initiation.
 * Instead, use {@link Charts#setOptions(Options)} to set it before any
 * chart is initiated.
 * 
 * @author jumperchen
 */
public class Lang extends Optionable {
	private enum Attrs implements PlotAttribute {
		contextButtonTitle,
		decimalPoint,
		downloadJPEG,
		downloadPDF,
		downloadPNG,
		downloadSVG,
		drillUpText,
		loading,
		months,
		numericSymbols,
		printChart,
		resetZoom,
		resetZoomTitle,
		shortMonths,
		thousandsSep,
		weekdays,
		noData
	}

	/**
	 * Sets the message for no data.
	 * @since 1.0.1
	 */
	public void setNoData(String noData) {
		setAttr(Attrs.noData, noData, "No data to display");
	}

	/**
	 * Returns the message for no data.
	 * <p>Default: "No data to display"
	 * @since 1.0.1
	 */
	public String getNoData() {
		return getAttr(Attrs.noData, "No data to display").asString();
	}
	/**
	 * Returns the text for the button that appears when drilling down, linking
	 * back to the parent series. The parent series' name is inserted for
	 * {series.name}.
	 * <p>
	 * Defaults to "<code>Back to {series.name}</code>".
	 */
	public String getDrillUpText() {
		return getAttr(Attrs.drillUpText, "Back to {series.name}").asString();
	}

	/**
	 * Sets the text for the button that appears when drilling down, linking
	 * back to the parent series. The parent series' name is inserted for
	 * {series.name}.
	 * <p>
	 * Defaults to "<code>Back to {series.name}</code>".
	 */
	public void setDrillUpText(String drillUpText) {
		setAttr(Attrs.drillUpText, drillUpText, "Back to {series.name}");
	}

	/**
	 * Returns exporting module menu. The tooltip title for the context menu
	 * holding print and export menu items.
	 * <p>
	 * Default: "Chart context menu".
	 */
	public String getContextButtonTitle() {
		return getAttr(Attrs.contextButtonTitle, "Chart context menu")
				.asString();
	}

	/**
	 * Sets exporting module menu. The tooltip title for the context menu
	 * holding print and export menu items.
	 */
	public void setContextButtonTitle(String contextButtonTitle) {
		setAttr(Attrs.contextButtonTitle, contextButtonTitle, "Chart context menu");
	}

	/**
	 * Returns the default decimal point used in the
	 * {@link Charts#setNumberFormat(Number, Number, String, String)} method
	 * unless otherwise specified in the function arguments.
	 * <p>
	 * Default: ".".
	 */
	public String getDecimalPoint() {
		return getAttr(Attrs.decimalPoint, ".").asString();
	}

	/**
	 * Sets the default decimal point used in the
	 * {@link Charts#setNumberFormat(Number, Number, String, String)} method
	 * unless otherwise specified in the function arguments.
	 */
	public void setDecimalPoint(String decimalPoint) {
		setAttr(Attrs.decimalPoint, decimalPoint, ".");
	}

	/**
	 * Returns exporting module only. The text for the JPEG download menu item.
	 * <p>
	 * Default: "Download JPEG image".
	 */
	public String getDownloadJPEG() {
		return getAttr(Attrs.downloadJPEG, "Download JPEG image").asString();
	}

	/**
	 * Sets exporting module only. The text for the JPEG download menu item.
	 */
	public void setDownloadJPEG(String downloadJPEG) {
		setAttr(Attrs.downloadJPEG, downloadJPEG, "Download JPEG image");
	}

	/**
	 * Returns exporting module only. The text for the PDF download menu item.
	 * <p>
	 * Default: "Download PDF document".
	 */
	public String getDownloadPDF() {
		return getAttr(Attrs.downloadPDF, "Download PDF document").asString();
	}

	/**
	 * Sets exporting module only. The text for the PDF download menu item.
	 */
	public void setDownloadPDF(String downloadPDF) {
		setAttr(Attrs.downloadPDF, downloadPDF, "Download PDF document");
	}

	/**
	 * Returns exporting module only. The text for the PNG download menu item.
	 * <p>
	 * Default: "Download PNG image".
	 */
	public String getDownloadPNG() {
		return getAttr(Attrs.downloadPNG, "Download PNG image").asString();
	}

	/**
	 * Sets exporting module only. The text for the PNG download menu item.
	 */
	public void setDownloadPNG(String downloadPNG) {
		setAttr(Attrs.downloadPNG, downloadPNG, "Download PNG image");
	}

	/**
	 * Returns exporting module only. The text for the SVG download menu item.
	 * <p>
	 * Default: "Download SVG vector image".
	 */
	public String getDownloadSVG() {
		return getAttr(Attrs.downloadSVG, "Download SVG vector image")
				.asString();
	}

	/**
	 * Sets exporting module only. The text for the SVG download menu item.
	 */
	public void setDownloadSVG(String downloadSVG) {
		setAttr(Attrs.downloadSVG, downloadSVG, "Download SVG vector image");
	}

	/**
	 * Returns the loading text that appears when the chart is set into the
	 * loading state following a call to {@link Charts#showLoading(String)}.
	 * <p>
	 * Default: "Loading...".
	 */
	public String getLoading() {
		return getAttr(Attrs.loading, "Loading...").asString();
	}

	/**
	 * Sets the loading text that appears when the chart is set into the loading
	 * state following a call to {@link Charts#showLoading(String)}.
	 */
	public void setLoading(String loading) {
		setAttr(Attrs.loading, loading, "Loading...");
	}

	/**
	 * Returns an array containing the months names. Corresponds to the
	 * <code>%B</code> format in
	 * {@link Charts#setDateFormat(String, Number, boolean)}.
	 * <p>
	 * Default: [ "January" , "February" , "March" , "April" , "May" , "June" ,
	 * "July" , "August" , "September" , "October" , "November" , "December"].
	 */
	public <T> List<T> getMonths() {
		return Generics.cast(getAttr(
				Attrs.months,
				new String[] { "January", "February", "March", "April", "May",
						"June", "July", "August", "September", "October",
						"November", "December" }).asValue());
	}

	/**
	 * Sets an array containing the months names. Corresponds to the
	 * <code>%B</code> format in
	 * {@link Charts#setDateFormat(String, Number, boolean)}.
	 */
	public <T> void setMonths(List<T> months) {
		setAttr(Attrs.months, months, NOT_NULL_VALUE);
	}

	/**
	 * Returns <a href="http://en.wikipedia.org/wiki/Metric_prefix">Metric
	 * prefixes</a> used to shorten high numbers in axis labels. Replacing any
	 * of the positions with <code>null</code> causes the full number to be
	 * written. Setting {@link #setNumericSymbols(List)} to <code>null</code>
	 * disables shortening altogether.
	 * <p>
	 * Default: "[ "k" , "M" , "G" , "T" , "P" , "E"]".
	 */
	public <T> List<T> getNumericSymbols() {
		return Generics.cast(getAttr(Attrs.numericSymbols,
				new String[] { "k", "M", "G", "T", "P", "E" }).asValue());
	}

	/**
	 * Sets <a href="http://en.wikipedia.org/wiki/Metric_prefix">Metric
	 * prefixes</a> used to shorten high numbers in axis labels. Replacing any
	 * of the positions with <code>null</code> causes the full number to be
	 * written. Setting {@link #setNumericSymbols(List)} to <code>null</code>
	 * disables shortening altogether.
	 */
	public <T> void setNumericSymbols(List<T> numericSymbols) {
		setAttr(Attrs.numericSymbols, numericSymbols, NOT_NULL_VALUE);
	}

	/**
	 * Returns exporting module only. The text for the menu item to print the
	 * chart.
	 * <p>
	 * Default: "Print chart".
	 */
	public String getPrintChart() {
		return getAttr(Attrs.printChart, "Print chart").asString();
	}

	/**
	 * Sets exporting module only. The text for the menu item to print the
	 * chart.
	 */
	public void setPrintChart(String printChart) {
		setAttr(Attrs.printChart, printChart, "Print chart");
	}

	/**
	 * Returns the text for the label appearing when a chart is zoomed.
	 * <p>
	 * Default: "Reset zoom".
	 */
	public String getResetZoom() {
		return getAttr(Attrs.resetZoom, "Reset zoom").asString();
	}

	/**
	 * Sets the text for the label appearing when a chart is zoomed.
	 */
	public void setResetZoom(String resetZoom) {
		setAttr(Attrs.resetZoom, resetZoom, "Reset zoom");
	}

	/**
	 * Returns the tooltip title for the label appearing when a chart is zoomed.
	 * <p>
	 * Default: "Reset zoom level 1:1".
	 */
	public String getResetZoomTitle() {
		return getAttr(Attrs.resetZoomTitle, "Reset zoom level 1:1").asString();
	}

	/**
	 * Sets the tooltip title for the label appearing when a chart is zoomed.
	 */
	public void setResetZoomTitle(String resetZoomTitle) {
		setAttr(Attrs.resetZoomTitle, resetZoomTitle, "Reset zoom level 1:1");
	}

	/**
	 * Returns a list containing the months names in abbreviated form.
	 * Corresponds to the <code>%b</code> format in
	 * {@link Charts#setDateFormat(String, Number, boolean)}.
	 * <p>
	 * Default:
	 * "[ "Jan" , "Feb" , "Mar" , "Apr" , "May" , "Jun" , "Jul" , "Aug" , "
	 * Sep" , "Oct" , "Nov" , "Dec"]".
	 */
	public <T> List<T> getShortMonths() {
		return Generics.cast(getAttr(
				Attrs.shortMonths,
				new String[] { "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul",
						"Aug", "Sep", "Oct", "Nov", "Dec" }).asValue());
	}

	/**
	 * Sets a list containing the months names in abbreviated form. Corresponds
	 * to the <code>%b</code> format in
	 * {@link Charts#setDateFormat(String, Number, boolean)}.
	 */
	public <T> void setShortMonths(List<T> shortMonths) {
		setAttr(Attrs.shortMonths, shortMonths, NOT_NULL_VALUE);
	}

	/**
	 * Returns the default thousands separator used in the
	 * {@link Charts#setNumberFormat(Number, Number, String, String)} method
	 * unless otherwise specified in the function arguments.
	 * <p>
	 * Default: ",".
	 */
	public String getThousandsSep() {
		return getAttr(Attrs.thousandsSep, ",").asString();
	}

	/**
	 * Sets the default thousands separator used in the
	 * {@link Charts#setNumberFormat(Number, Number, String, String)} method
	 * unless otherwise specified in the function arguments. Defaults to
	 * <code>","</code>.
	 */
	public void setThousandsSep(String thousandsSep) {
		setAttr(Attrs.thousandsSep, thousandsSep, ",");
	}

	/**
	 * Returns an array containing the weekday names.
	 * <p>
	 * Default: ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday",
	 * "Friday* ", "Saturday"].
	 */
	public <T> List<T> getWeekdays() {
		return Generics.cast(getAttr(
				Attrs.weekdays,
				new String[] { "Sunday", "Monday", "Tuesday", "Wednesday",
						"Thursday", "Friday", "Saturday" }).asValue());
	}

	/**
	 * Sets an array containing the weekday names.
	 */
	public <T> void setWeekdays(List<T> weekdays) {
		setAttr(Attrs.weekdays, weekdays, NOT_NULL_VALUE);
	}

}
