/* LabelsItem.java

	Purpose:
		
	Description:
		
	History:
		Mon, Feb 17, 2014  6:46:04 PM, Created by RaymondChao

Copyright (C) 2014 Potix Corporation. All Rights Reserved.

 */
package org.zkoss.chart;

import java.util.LinkedHashMap;
import java.util.Map;

import org.zkoss.chart.util.DynamicalAttribute;
import org.zkoss.chart.util.MapsHelper;
import org.zkoss.lang.Generics;

/**
 * An option for Labels
 * <p>
 * All the options in this class support {@link DynamicalAttribute}.
 * 
 * @author RaymondChao
 */
public class LabelsItem extends Optionable {
	private enum Attrs implements PlotAttribute, DynamicalAttribute {
		html, style
	}

	public LabelsItem(String html) {
		setHtml(html);
	}

	/**
	 * Returns inner HTML or text for the label.
	 * <p>
	 * Default: null.
	 * 
	 * @return html inner HTML or text for the label
	 */
	public String getHtml() {
		return getAttr(Attrs.html, null).asString();
	}

	/**
	 * Sets inner HTML or text for the label.
	 * 
	 * @param html
	 *            inner HTML or text for the label
	 */
	public void setHtml(String html) {
		setAttr(Attrs.html, html);
	}

	/**
	 * Returns generic CSS styles for each label. To position the label, use
	 * left and top like this:
	 * 
	 * <pre>
	 * left: '100px';
	 * top: '100px';
	 * </pre>
	 * <p>
	 * Default: null.
	 */
	public <K, V> Map<K, V> getStyle() {
		return Generics.cast(getAttr(Attrs.style, null).asValue());
	}

	/**
	 * Sets generic CSS styles for each label.
	 * 
	 * @see #setStyle(Map)
	 */
	public void setStyle(String style) {
		setStyle(MapsHelper.parse(new LinkedHashMap<String, String>(), style, ':',
				';', '\''));
	}

	/**
	 * Sets generic CSS styles for each label.
	 * 
	 * @see #setStyle(String)
	 */
	public <K, V> void setStyle(Map<K, V> style) {
		setAttr(Attrs.style, style);
	}
}
