/* Labels.java

	Purpose:
		
	Description:
		
	History:
		Fri, Jan 24, 2014  3:06:03 PM, Created by RaymondChao

Copyright (C) 2014 Potix Corporation. All Rights Reserved.

 */
package org.zkoss.chart;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.zkoss.chart.util.DynamicalAttribute;
import org.zkoss.chart.util.MapsHelper;
import org.zkoss.lang.Generics;

/**
 * HTML labels that can be positioned anywhere in the chart area.
 * <p>
 * All the options in this class support {@link DynamicalAttribute}.
 * 
 * @author RaymondChao
 * @author jumperchen
 */
public class Labels extends Optionable {
	private enum Attrs implements PlotAttribute, DynamicalAttribute{
		items, style
	}

	/**
	 * Returns a HTML label that can be positioned anywhere in the chart area.
	 * <p>
	 * Default: null.
	 */
	public List<LabelsItem> getItems() {
		return Generics.cast(getAttr(Attrs.items, null).asValue());
	}

	/**
	 * Sets a HTML label that can be positioned anywhere in the chart area.
	 */
	public void setItems(List<LabelsItem> labelsItems) {
		setAttr(Attrs.items, labelsItems);
	}

	/**
	 * Returns shared generic CSS styles for all labels.
	 * <p>
	 * Default:
	 * 
	 * <pre>
	 * color: #3E576F;
	 * </pre>
	 */
	public <K, V> Map<K, V> getStyle() {
		if (!containsKey(Attrs.style)) {
			setStyle("color: #3E576F;");
		}
		return Generics.cast(getAttr(Attrs.style, null).asValue());
	}

	/**
	 * Sets shared generic CSS styles for all labels.
	 * 
	 * @see #setStyle(Map)
	 */
	public void setStyle(String style) {
		setStyle(MapsHelper.parse(new LinkedHashMap<String, String>(), style, ':', ';', '\''));
	}

	/**
	 * Sets shared generic CSS styles for all labels.
	 * 
	 * @see #setStyle(String)
	 */
	public <K, V> void setStyle(Map<K, V> style) {
		setAttr(Attrs.style, style, NOT_NULL_VALUE);
	}
}
