/** Global.java.

	Purpose:
		
	Description:
		
	History:
		12:43:26 PM Jan 15, 2014, Created by jumperchen

Copyright (C) 2014 Potix Corporation. All Rights Reserved.
 */
package org.zkoss.chart;

import java.io.UnsupportedEncodingException;

import org.zkoss.web.servlet.http.Encodes;

/**
 * The Global object is global and it can't be set on each chart initiation.
 * Instead, use {@link Charts#setOptions(Options)} to set it before any
 * chart is initiated.
 * 
 * @author jumperchen
 */
public class Global extends Optionable {

	private enum Attrs implements PlotAttribute {
		VMLRadialGradientURL, canvasToolsURL, timezoneOffset, useUTC
	}

	/**
	 * Sets the path to the pattern image required by VML browsers in order to
	 * draw radial gradients.
	 * <p>
	 * Defaults to "~./js/chart/ext/gfx/vml-radial-gradient.png"
	 * 
	 * @param VMLRadialGradientURL
	 */
	public void setVMLRadialGradientURL(String VMLRadialGradientURL) {
		setAttr(Attrs.VMLRadialGradientURL, VMLRadialGradientURL, NOT_NULL_VALUE);
	}

	/**
	 * Returns the path to the pattern image required by VML browsers in order
	 * to draw radial gradients.
	 * <p>
	 * Defaults to "~./js/chart/ext/gfx/vml-radial-gradient.png"
	 */
	public String getVMLRadialGradientURL() {
		String value = (String) getAttr(Attrs.VMLRadialGradientURL);
		if (value == null) {
			try {
				return Encodes
						.encodeURI("~./js/chart/ext/gfx/vml-radial-gradient.png");
			} catch (UnsupportedEncodingException e) {
				return null;
			}
		}
		return value;
	}

	/**
	 * Sets the URL to the additional file to lazy load for Android 2.x devices.
	 * These devices don't support SVG, so we download a helper file that
	 * contains canvg, its dependecy rbcolor, and our own CanVG Renderer class.
	 * To avoid hotlinking to our site, you can install canvas-tools.js on your
	 * own server and change this option accordingly.
	 * <p>
	 * Defaults to ~./js/chart/ext/modules/canvas-tools.js
	 * 
	 * @param canvasToolsURL
	 */
	public void setCanvasToolsURL(String canvasToolsURL) {
		setAttr(Attrs.canvasToolsURL, canvasToolsURL, NOT_NULL_VALUE);
	}

	/**
	 * Returns the URL to the additional file to lazy load for Android 2.x
	 * devices. These devices don't support SVG, so we download a helper file
	 * that contains canvg, its dependecy rbcolor, and our own CanVG Renderer
	 * class. To avoid hotlinking to our site, you can install canvas-tools.js
	 * on your own server and change this option accordingly.
	 * <p>
	 * Defaults to "~./js/chart/ext/modules/canvas-tools.js"
	 */
	public String getCanvasToolsURL() {
		String value = (String) getAttr(Attrs.canvasToolsURL);
		if (value == null) {
			try {
				return Encodes
						.encodeURI("~./js/chart/ext/modules/canvas-tools.js");
			} catch (UnsupportedEncodingException e) {
				return null;
			}
		}
		return value;
	}

	/**
	 * Sets the timezone offset in minutes. Positive values are west, negative
	 * values are east of UTC, as in the ECMAScript getTimezoneOffset method.
	 * Use this to display UTC based data in a predefined time zone.
	 * <p>
	 * Defaults to 0.
	 * 
	 * @param timezoneOffset
	 */
	public void setTimezoneOffset(Number timezoneOffset) {
		setAttr(Attrs.timezoneOffset, timezoneOffset, 0);
	}

	/**
	 * Returns the timezone offset in minutes. Positive values are west,
	 * negative values are east of UTC, as in the ECMAScript getTimezoneOffset
	 * method. Use this to display UTC based data in a predefined time zone.
	 * <p>
	 * Defaults to 0.
	 */
	public Number getTimezoneOffset() {
		return getAttr(Attrs.timezoneOffset, 0).asNumber();
	}

	/**
	 * Sets whether to use UTC time for axis scaling, tickmark placement and time
	 * display in {@link Charts#setDateFormat(String, Number, boolean)}. Advantages of using UTC is that the
	 * time displays equally regardless of the user agent's time zone settings.
	 * Local time can be used when the data is loaded in real time or when
	 * correct Daylight Saving Time transitions are required.
	 * <p>Defaults to true.
	 * 
	 * @param useUTC
	 */
	public void setUseUTC(boolean useUTC) {
		setAttr(Attrs.useUTC, useUTC);
	}

	/**
	 * Returns whether to use UTC time for axis scaling, tickmark placement and time
	 * display in {@link Charts#setDateFormat(String, Number, boolean)}. Advantages of using UTC is that the
	 * time displays equally regardless of the user agent's time zone settings.
	 * Local time can be used when the data is loaded in real time or when
	 * correct Daylight Saving Time transitions are required.
	 * <p>Defaults to true.
	 */
	public boolean isUseUTC() {
		return getAttr(Attrs.useUTC, true).asBoolean();
	}

}
