/** DateTimeLabelFormats.java.

	Purpose:
		
	Description:
		
	History:
		18:02:11 PM Jan 13, 2014, Created by RaymondChao

Copyright (C) 2014 Potix Corporation. All Rights Reserved.
 */

package org.zkoss.chart;

import org.zkoss.chart.util.DynamicalAttribute;

/**
 * For a datetime axis, the scale will automatically adjust to the appropriate
 * unit. This member gives the default string representations used for each
 * unit. For an overview of the replacement codes, see dateFormat. Defaults to:
 * 
 * <pre>
 * <code>
 * millisecond: '%H:%M:%S.%L',
 * second: '%H:%M:%S',
 * minute: '%H:%M',
 * hour: '%H:%M',
 * day: '%e. %b',
 * week: '%e. %b',
 * month: '%b \'%y',
 * year: '%Y'
 * </code>
 * </pre>
 * 
 * <p> All the options in this class support {@link DynamicalAttribute}.
 * 
 * @author jumperchen
 * @author RaymondChao
 */
public class DateTimeLabelFormats extends Optionable {
	private enum Attrs implements PlotAttribute, DynamicalAttribute {
		day, hour, millisecond, minute, month, second, week, year
	}

	/**
	 * Returns the label format for day.
	 * <p>Default: <code>%e. %b</code>
	 */
	public String getDay() {
		return getAttr(Attrs.day, "%e. %b").asString();
	}

	/**
	 * Sets the label format for day.
	 * <p>Default: <code>%e. %b</code>
	 */
	public void setDay(String day) {
		setAttr(Attrs.day, day, "%e. %b");
	}

	/**
	 * Returns the label format for hour.
	 * <p>Default: <code>%H:%M</code>
	 */
	public String getHour() {
		return getAttr(Attrs.hour, "%H:%M").asString();
	}

	/**
	 * Sets the label format for hour.
	 * <p>Default: <code>%H:%M</code>
	 */
	public void setHour(String hour) {
		setAttr(Attrs.hour, hour, "%H:%M");
	}

	/**
	 * Returns the label format for millisecond.
	 * <p>Default: <code>%H:%M:%S.%L</code>
	 */
	public String getMillisecond() {
		return getAttr(Attrs.millisecond, "%H:%M:%S.%L").asString();
	}

	/**
	 * Sets the label format for millisecond.
	 * <p>Default: <code>%H:%M:%S.%L</code>
	 */
	public void setMillisecond(String millisecond) {
		setAttr(Attrs.millisecond, millisecond, "%H:%M:%S.%L");
	}

	/**
	 * Returns the label format for minute.
	 * <p>Default: <code>%H:%M</code>
	 */
	public String getMinute() {
		return getAttr(Attrs.minute, "%H:%M").asString();
	}

	/**
	 * Sets the label format for minute.
	 * <p>Default: <code>%H:%M</code>
	 */
	public void setMinute(String minute) {
		setAttr(Attrs.minute, minute, "%H:%M");
	}

	/**
	 * Returns the label format for month.
	 * <p>Default: <code>%b \'%y</code>
	 */
	public String getMonth() {
		return getAttr(Attrs.month, "%b \'%y").asString();
	}

	/**
	 * Sets the label format for month.
	 * <p>Default: <code>%b \'%y</code>
	 */
	public void setMonth(String month) {
		setAttr(Attrs.month, month, "%b \'%y");
	}

	/**
	 * Returns the label format for second.
	 * <p>Default: <code>%H:%M:%S</code>
	 */
	public String getSecond() {
		return getAttr(Attrs.second, "%H:%M:%S").asString();
	}

	/**
	 * Sets the label format for second.
	 * <p>Default: <code>%H:%M:%S</code>
	 */
	public void setSecond(String second) {
		setAttr(Attrs.day, second, "%H:%M:%S");
	}

	/**
	 * Returns the label format for week.
	 * <p>Default: <code>%e. %b</code>
	 */
	public String getWeek() {
		return getAttr(Attrs.week, "%e. %b").asString();
	}

	/**
	 * Sets the label format for week.
	 * <p>Default: <code>%e. %b</code>
	 */
	public void setWeek(String week) {
		setAttr(Attrs.week, week, "%e. %b");
	}

	/**
	 * Returns the label format for year.
	 * <p>Default: <code>%Y</code>
	 */
	public String getYear() {
		return getAttr(Attrs.year, "%Y").asString();
	}

	/**
	 * Sets the label format for year.
	 * <p>Default: <code>%Y</code>
	 */
	public void setYear(String year) {
		setAttr(Attrs.year, year, "%Y");
	}
}
