/** Color.java.

	Purpose:
		
	Description:
		
	History:
		10:10:06 AM Mar 6, 2014, Created by jumperchen

Copyright (C) 2014 Potix Corporation. All Rights Reserved.
 */
package org.zkoss.chart;

import org.zkoss.chart.util.DynamicalAttribute;
import org.zkoss.json.JSONValue;

/**
 * A color option wrap for String type, {@link LinearGradient}, or
 * {@link RadialGradient}
 * <p>
 * All the options in this class support {@link DynamicalAttribute}.
 * 
 * @author jumperchen
 */
public class Color extends Optionable {
	private enum Attrs implements PlotAttribute, DynamicalAttribute {
		color, linearGradient, radialGradient
	}
	
	/**
	 * Constructs with a string color.
	 */
	public Color(String color) {
		setColor(color);
	}
	
	/**
	 * Constructs with a linear gradient color.
	 */
	public Color(LinearGradient color) {
		setColor(color);
	}
	
	/**
	 * Constructs with a radial gradient color.
	 */
	public Color(RadialGradient color) {
		setColor(color);
	}
	
	/**
	 * Sets the color with string format.
	 * @param color
	 */
	public void setColor(String color) {
		setAttr(Attrs.color, color);
	}
	
	/**
	 * Sets the color with linear gradient format.
	 * @param linear
	 */
	public void setColor(LinearGradient linear) {
		setAttr(Attrs.linearGradient, linear);
	}
	
	/**
	 * Sets the color with radial gradient format.
	 * @param radial
	 */
	public void setColor(RadialGradient radial) {
		setAttr(Attrs.radialGradient, radial);
	}
	
	/**
	 * Returns the string format's color, if any.
	 */
	public String stringValue() {
		return getAttr(Attrs.color, null).asString();
	}

	
	/**
	 * Returns the linear gradient format's color, if any.
	 */
	public LinearGradient linearValue() {
		return (LinearGradient) getAttr(Attrs.linearGradient, null).asValue();
	}
	
	/**
	 * Returns the radial gradient format's color, if any.
	 */
	public RadialGradient radialValue() {
		return (RadialGradient) getAttr(Attrs.radialGradient, null).asValue();
	}

	/**
	 * Encodes this object to a JSON string. It is the same as
	 * {@link #toString()}.
	 */
	public String toJSONString() {
		String color = stringValue();
		if (color != null)
			return JSONValue.toJSONString(color);
		LinearGradient linear = linearValue();
		if (linear != null)
			return linear.toJSONString();
		RadialGradient radial = radialValue();
		if (radial != null)
			return radial.toJSONString();
		return "null";
	}
	
}
