/* HighchartsSelectionEvent.java

	Purpose:
		
	Description:
		
	History:
		Fri, Feb 07, 2014  6:33:54 PM, Created by RaymondChao

Copyright (C) 2014 Potix Corporation. All Rights Reserved.

 */
package org.zkoss.chart;

import java.util.Map;

import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;

/**
 * A selection event used for {@link Charts} component to provide an extra
 * information on the selection spot can be found through event.getXAxis() and
 * event.getYAxis(), which are numbers containing each axis' value at the
 * selected spot.
 * 
 * @author RaymondChao
 */
public class ChartsSelectionEvent extends Event {

	private static final long serialVersionUID = 3749919058785036758L;

	Number _xAxisMin, _xAxisMax, _yAxisMin, _yAxisMax;

	public ChartsSelectionEvent(String name, Component target,
			Number xAxisMin, Number xAxisMax, Number yAxisMin, Number yAxisMax) {
		super(name, target);
		_xAxisMin = xAxisMin;
		_xAxisMax = xAxisMax;
		_yAxisMin = yAxisMin;
		_yAxisMax = yAxisMax;
	}

	public static ChartsSelectionEvent getChartsSelectionEvent(
			AuRequest request) {
		final Map<String, Object> data = request.getData();
		final String name = request.getCommand();
		return new ChartsSelectionEvent(name, request.getComponent(),
				(Number) data.get("xAxisMin"), (Number) data.get("xAxisMax"),
				(Number) data.get("yAxisMin"), (Number) data.get("yAxisMax"));
	}

	/**
	 * Returns the xAxis minimum value of the selection.
	 */
	public Number getXAxisMin() {
		return _xAxisMin;
	}

	/**
	 * Returns the xAxis maximum value of the selection.
	 */
	public Number getXAxisMax() {
		return _xAxisMax;
	}

	/**
	 * Returns the yAxis minimum value of the selection.
	 */
	public Number getYAxisMin() {
		return _yAxisMin;
	}

	/**
	 * Returns the yAxis maximum value of the selection.
	 */
	public Number getYAxisMax() {
		return _yAxisMax;
	}
}
