/** HighchartsEvents.java.

	Purpose:
		
	Description:
		
	History:
		3:04:11 PM Jan 8, 2014, Created by jumperchen

Copyright (C) 2013 Potix Corporation. All Rights Reserved.
 */
package org.zkoss.chart;

/**
 * Utilities to access events for Highcharts
 * 
 * @author jumperchen
 */
public class ChartsEvents {

	private ChartsEvents() {
	} // prevent from creation

	/**
	 * Fires when the series is clicked.
	 */
	public static final String ON_PLOT_CLICK = "onPlotClick";

	/**
	 * Fires when the checkbox next to the series' name in the legend is
	 * clicked.
	 */
	public static final String ON_PLOT_CHECKBOX_CLICK = "onPlotCheckboxClick";

	/**
	 * Fires when the series is hidden after chart generation time, by clicking the legend item
	 */
	public static final String ON_PLOT_HIDE = "onPlotHide";

	/**
	 * Not applicable to pies, as the legend item is per point
	 */
	public static final String ON_PLOT_LEGEND_ITEM_CLICK = "onPlotLegendItemClick";

	/**
	 * Fires when the mouse leaves the graph.
	 */
	public static final String ON_PLOT_MOUSE_OUT = "onPlotMouseOut";

	/**
	 * Fires when the mouse enters the graph.
	 */
	public static final String ON_PLOT_MOUSE_OVER = "onPlotMouseOver";

	/**
	 * Fires when the series is shown after chart generation time, by clicking the legend item
	 */
	public static final String ON_PLOT_SHOW = "onPlotShow";

	/**
	 * Fires when a drilldown point is clicked, before the new series is added.
	 * Event arguments include point for the originating point.
	 */
	public static final String ON_PLOT_DRILL_DOWN = "onPlotDrillDown";

	/**
	 * Fires when drilling up from a drilldown series.
	 */
	public static final String ON_PLOT_DRILL_UP = "onPlotDrillUp";
	
	/**
	 * Fires when selecting a point from a series.
	 */
	public static final String ON_PLOT_SELECT = "onPlotSelect";

	/**
	 * Fires when unselecting a point from a series.
	 */
	public static final String ON_PLOT_UNSELECT = "onPlotUnselect";
}
