/** HighchartsEvent.java.

	Purpose:
		
	Description:
		
	History:
		4:12:36 PM Jan 21, 2014, Created by jumperchen

Copyright (C) 2014 Potix Corporation. All Rights Reserved.
*/
package org.zkoss.chart;

import java.util.Map;

import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuRequests;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;

/**
 * Represents an event cause by user's interaction with the Highcharts.
 * @author jumperchen
 *
 */
public class ChartsEvent extends Event {
	
	private static final long serialVersionUID = 20140121161322L;

	private int _sIndex = -1;
	private int _pIndex = -1;
	private boolean _checked = false;
	private Comparable<?> _category;
	
	public ChartsEvent(String name, Component target, int sIndex, int pIndex, Comparable<?> category, boolean checked) {
		super(name, target);
		_sIndex = sIndex;
		_pIndex = pIndex;
		_checked = checked;
		_category = category;
	}

	public static final ChartsEvent getChartsEvent(AuRequest request) {
		final Map<String, Object> data = request.getData();
		return new ChartsEvent(request.getCommand(),
				request.getComponent(), AuRequests.getInt(data, "sIndex", -1),
				AuRequests.getInt(data, "pIndex", -1),
				(Comparable<?>)data.get("category"),
				AuRequests.getBoolean(data, "checked"));
	}
	
	/**
	 * Returns the category value, if any.
	 */
	public Comparable<?> getCategory() {
		return _category;
	}
	
	/**
	 * Returns the point index, if any.
	 * <p>Only support for {@link ChartsEvents#ON_PLOT_CLICK}
	 * @return -1 if not a point event
	 */
	public int getPointIndex() {
		return _pIndex;
	}

	
	/**
	 * Returns the series index, if any.
	 */
	public int getSeriesIndex() {
		return _sIndex;
	}
	
	/**
	 * Returns the checkbox event whether is checked, if any.
	 * <p>Only support for {@link ChartsEvents#ON_PLOT_CHECKBOX_CLICK}
	 * @return false if not a checkbox event
	 */
	public boolean isChecked() {
		return _checked;
	}
	
	/**
	 * Returns the point object, if any.
	 * <p>Only support for {@link ChartsEvents#ON_PLOT_CLICK}
	 * @return null if not a point event
	 */
	public Point getPoint() {
		Series series = getSeries();
		if (series == null) {
			return null;
		} else {
			int pIndex = getPointIndex();
			if (pIndex < 0) {
				return null;
			} else {
				return series.getPoint(pIndex);
			}
		}
	}
	
	/**
	 * Returns the series object.
	 */
	public Series getSeries() {
		final int sIndex = getSeriesIndex();
		if (sIndex < 0) {
			return null;
		} else {
			return ((Charts)getTarget()).getSeries(sIndex);
		}
	}
}
