/** HighchartsClickEvent.java.

	Purpose:
		
	Description:
		
	History:
		12:05:07 PM Jan 27, 2014, Created by jumperchen

Copyright (C) 2014 Potix Corporation. All Rights Reserved.
*/
package org.zkoss.chart;

import java.util.Map;

import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuRequests;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.MouseEvent;

/**
 * A click event used for {@link Charts} component to provide an extra
 * information on the clicked spot can be found through event.getXAxis() and
 * event.getYAxis(), which are numbers containing each axis' value at the clicked
 * spot.
 * 
 * @author jumperchen
 */
public class ChartsClickEvent extends MouseEvent {
	private static final long serialVersionUID = 20140127120822L;
	private Number _xAxis;
	private Number _yAxis;
	
	public ChartsClickEvent(String name, Component target, String area,
			int keys) {
		super(name, target, area, keys);
	}
	public ChartsClickEvent(String name, Component target, int x, int y,
	int pageX, int pageY, int keys, Number xAxis, Number yAxis) {
		super(name, target, x, y, pageX, pageY, keys);
		_xAxis = xAxis;
		_yAxis = yAxis;
	}
	
	public static ChartsClickEvent getChartsClickEvent(AuRequest request) {
		final Map<String, Object> data = request.getData();
		final String name = request.getCommand();
		final int keys = AuRequests.parseKeys(data);
		final String area = (String)data.get("area");
		return area != null ? new ChartsClickEvent(name, request.getComponent(), area, keys): //area
			new ChartsClickEvent(name, request.getComponent(), //coord
				AuRequests.getInt(data, "x", 0, true),
				AuRequests.getInt(data, "y", 0, true),
				AuRequests.getInt(data, "pageX", 0, true),
				AuRequests.getInt(data, "pageY", 0, true), keys,
				(Number)data.get("xAxis"),
				(Number)data.get("yAxis"));
	}

	/**
	 * Returns the xAxis value.
	 */
	public Number getXAxis() {
		return _xAxis;
	}
	/**
	 * Returns the yAxis value.
	 */
	public Number getYAxis() {
		return _yAxis;
	}
}
