/** Animation.java.

	Purpose:
		
	Description:
		
	History:
		12:35:54 PM Jan 22, 2014, Created by jumperchen

Copyright (C) 2014 Potix Corporation. All Rights Reserved.
 */
package org.zkoss.chart;

import org.zkoss.chart.util.DynamicalAttribute;
import org.zkoss.json.JSONObject;

/**
 * An animation class to set the overall animation for all chart updating.
 * 
 * <p> All the options in this class support {@link DynamicalAttribute}.
 * 
 * @author jumperchen
 * 
 */
public class Animation extends Optionable {
	private enum Attrs implements PlotAttribute, DynamicalAttribute {
		duration, easing
	}
	/**
	 * No animation at all
	 */
	public static Animation NONE = new EmptyAnimation();
	
	private static class EmptyAnimation extends Animation {
		public String toJSONString() {
			return "false";
		}
	}
	/**
	 * Sets the duration of the animation in milliseconds.
	 * 
	 * @param duration
	 */
	public void setDuration(Number duration) {
		setAttr(Attrs.duration, duration, 400);
	}

	/**
	 * Returns the duration of the animation in milliseconds.
	 * <p>
	 * Default: 400.
	 */
	public Number getDuration() {
		return getAttr(Attrs.duration, 400).asNumber();
	}

	/**
	 * Sets the easing animation function.
	 * <p>Default: swing
	 * @param easing
	 */
	public void setEasing(String easing) {
		setAttr(Attrs.easing, easing, "swing");
	}

	/**
	 * Returns the easing animation function.
	 * <p> Default: swing
	 */
	public String getEasing(String easing) {
		return getAttr(Attrs.easing, "swing").asString();
	}
	

	public String toJSONString() {
		if(options.isEmpty()) {
			return "true";
		} else
			return JSONObject.toJSONString(options);
	}
}
