/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zuti.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.bind.BindUtils;
import org.zkoss.io.Serializables;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Strings;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zuti.zul.DefaultNavigationLevel;
import org.zkoss.zuti.zul.NavigationLevel;
import org.zkoss.zuti.zul.NavigationNode;
import org.zkoss.zuti.zul.event.NavigationEvent;

public class NavigationModel<T>
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(NavigationModel.class);
    private static boolean HAS_ZKBIND = true;
    private NavigationNode<T> _root = new NavigationNode();
    private DefaultNavigationLevel<T> _firstLevel = new DefaultNavigationLevel(this, 1);
    private transient List<EventListener<NavigationEvent<T>>> _listeners = new ArrayList<EventListener<NavigationEvent<T>>>();

    private static void checkPath(String path) {
        if (Strings.isEmpty((String)path)) {
            throw new IllegalArgumentException("path cannot be null or empty");
        }
    }

    private static void checkLevels(String[] levels) {
        if (levels == null || levels.length == 0) {
            throw new IllegalArgumentException("levels cannot be null or empty");
        }
    }

    private static void checkKey(String key) {
        if (Strings.isEmpty((String)key)) {
            throw new IllegalArgumentException("key cannot be null or empty");
        }
    }

    public T put(String path, T data) {
        NavigationModel.checkPath(path);
        return this.put(path.split("/"), data);
    }

    public T put(String[] levels, T data) {
        NavigationModel.checkLevels(levels);
        NavigationNode<T> base = this._root;
        int len = levels.length;
        for (int i = 0; i < len; ++i) {
            T value;
            String key = levels[i];
            NavigationModel.checkKey(key);
            Object object = value = i + 1 == len ? data : null;
            if (base.getChild() == null) {
                NavigationNode<T> node = new NavigationNode<T>(key, value);
                base.setChild(node);
                node.setParent(base);
                base = node;
                continue;
            }
            base = base.getChild();
            boolean isDone = false;
            while (true) {
                if (base.getKey().equals(key)) {
                    if (i + 1 == len) {
                        T oldVal = base.getValue();
                        base.setValue(value);
                        this.notifyChange(len, NavigationEvent.Type.CHANGE_DATA, base);
                        return oldVal;
                    }
                    isDone = true;
                    break;
                }
                if (base.getRight() == null) break;
                base = base.getRight();
            }
            if (isDone) continue;
            NavigationNode<T> node = new NavigationNode<T>(key, value);
            base.setRight(node);
            node.setLeft(base);
            base = node;
        }
        this.notifyChange(levels.length, NavigationEvent.Type.ADD, base);
        return null;
    }

    private void notifyChange(int level, NavigationEvent.Type type, NavigationNode<T> newNode) {
        NavigationLevel<T> navLevel = this.getNavigationLevel(level);
        if (navLevel != null) {
            this.notify(type, navLevel, newNode, "itemIterator", "items");
        }
    }

    private void notify(NavigationEvent.Type type, NavigationLevel<T> level, NavigationNode<T> node, String ... props) {
        if (Executions.getCurrent() == null) {
            return;
        }
        this.fireEvent(level, type, node);
        if (HAS_ZKBIND) {
            BindUtils.postNotifyChange(null, null, level, (String[])props);
        }
    }

    public void append(String path, String key, T data) {
        NavigationModel.checkPath(path);
        this.append(path.split("/"), key, data);
    }

    public void append(String[] levels, String key, T data) {
        NavigationModel.checkLevels(levels);
        NavigationModel.checkKey(key);
        NavigationNode<T> base = this.findNode(levels);
        if (base == null) {
            throw new IllegalArgumentException("the path is invalid");
        }
        if (this.hasDuplicatedKeyInLevel(base, key)) {
            throw new IllegalArgumentException("the key is duplicated in the same level");
        }
        NavigationNode<T> newNode = new NavigationNode<T>(key, data);
        NavigationNode<T> right = base.getRight();
        newNode.setLeft(base);
        base.setRight(newNode);
        if (right != null) {
            newNode.setRight(right);
            right.setLeft(newNode);
        }
        this.notifyChange(levels.length, NavigationEvent.Type.ADD, newNode);
    }

    public void insertBefore(String path, String key, T data) {
        NavigationModel.checkPath(path);
        this.insertBefore(path.split("/"), key, data);
    }

    public void insertBefore(String[] levels, String key, T data) {
        NavigationModel.checkLevels(levels);
        NavigationModel.checkKey(key);
        NavigationNode<T> base = this.findNode(levels);
        if (base == null) {
            throw new IllegalArgumentException("the path is invalid");
        }
        if (this.hasDuplicatedKeyInLevel(base, key)) {
            throw new IllegalArgumentException("the key is duplicated in the same level");
        }
        NavigationNode<T> newNode = new NavigationNode<T>(key, data);
        NavigationNode<T> left = base.getLeft();
        NavigationNode<T> parent = base.getParent();
        if (left != null) {
            left.setRight(newNode);
            newNode.setLeft(left);
        }
        newNode.setRight(base);
        base.setLeft(newNode);
        base.setParent(null);
        if (parent != null) {
            parent.setChild(newNode);
            newNode.setParent(parent);
        }
        this.notifyChange(levels.length, NavigationEvent.Type.ADD, newNode);
    }

    private NavigationNode<T> findNode(String[] levels) {
        NavigationNode<T> base = this._root.getChild();
        int len = levels.length;
        for (int i = 0; i < len && base != null; base = base.getChild(), ++i) {
            String key = levels[i];
            NavigationModel.checkKey(key);
            boolean isFound = false;
            while (true) {
                if (base.getKey().equals(key)) {
                    isFound = true;
                    break;
                }
                if (base.getRight() == null) break;
                base = base.getRight();
            }
            if (!isFound) break;
            if (i + 1 != len) continue;
            return base;
        }
        return null;
    }

    private boolean hasDuplicatedKeyInLevel(NavigationNode<T> node, String key) {
        NavigationNode<T> n;
        if (node == null) {
            return false;
        }
        for (n = node; n != null; n = n.getRight()) {
            if (!n.getKey().equals(key)) continue;
            return true;
        }
        for (n = node.getLeft(); n != null; n = n.getLeft()) {
            if (!n.getKey().equals(key)) continue;
            return true;
        }
        return false;
    }

    public T remove(String path) {
        NavigationModel.checkPath(path);
        return this.remove(path.split("/"));
    }

    public T remove(String[] levels) {
        NavigationModel.checkLevels(levels);
        NavigationNode<T> node = this.findNode(levels);
        if (node == null) {
            throw new IllegalArgumentException("the path is invalid");
        }
        return this.removeNode(node, levels.length);
    }

    private T removeNode(NavigationNode<T> node, int level) {
        NavigationNode<T> parent = node.getParent();
        NavigationNode<T> left = node.getLeft();
        NavigationNode<T> right = node.getRight();
        T value = node.getValue();
        if (right != null) {
            right.setLeft(left);
            right.setParent(parent);
        }
        if (left != null) {
            left.setRight(right);
        }
        if (parent != null) {
            parent.setChild(right);
        }
        node.setParent(null);
        node.setLeft(null);
        node.setRight(null);
        node.setValue(null);
        NavigationLevel<T> navLevel = this.getNavigationLevel(level);
        if (navLevel != null) {
            if (((DefaultNavigationLevel)navLevel).getNode() == node) {
                if (right != null) {
                    ((DefaultNavigationLevel)navLevel).setNode(right);
                } else if (left != null) {
                    ((DefaultNavigationLevel)navLevel).setNode(left);
                }
                this.notify(NavigationEvent.Type.NAVIGATE, navLevel, ((DefaultNavigationLevel)navLevel).getNode(), "current");
            }
            this.notify(NavigationEvent.Type.REMOVE, navLevel, node, "itemIterator", "items");
        } else {
            int parentLevel = level - 1;
            if (parentLevel > 0) {
                NavigationLevel<T> pLevel = this.getNavigationLevel(parentLevel);
                this.notify(NavigationEvent.Type.REMOVE, pLevel, node, "child", "childItems");
            }
        }
        return value;
    }

    private NavigationLevel<T> getNavigationLevel(int level) {
        NavigationLevel<T> navLevel = this.getRoot();
        for (int l = 1; l < level && navLevel != null; navLevel = navLevel.getChild(), ++l) {
        }
        return navLevel;
    }

    public void navigateTo(String key) {
        this.getRoot().navigateTo(key);
    }

    public NavigationLevel<T> getRoot() {
        if (this._firstLevel.getNode() == null) {
            NavigationNode<T> child = this._root.getChild();
            this._firstLevel.setNode(child);
            this._firstLevel.setHead(child);
            this._firstLevel.setNavigated(true);
        }
        return this._firstLevel;
    }

    public void navigateToByPath(String path) {
        NavigationModel.checkPath(path);
        this.navigateToByPath(path.split("/"));
    }

    public void navigateToByPath(String[] levels) {
        NavigationModel.checkLevels(levels);
        if (this.findNode(levels) == null) {
            throw new IllegalArgumentException("the path is invalid");
        }
        NavigationLevel<T> level = this.getRoot();
        for (String key : levels) {
            if (level == null) break;
            level.navigateTo(key);
            level = level.getChild();
        }
    }

    public void addEventListener(EventListener<NavigationEvent<T>> listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this._listeners.add(listener);
    }

    public void removeEventListener(EventListener<NavigationEvent<T>> listener) {
        this._listeners.remove(listener);
    }

    protected void fireEvent(NavigationLevel<T> level, NavigationEvent.Type type, NavigationNode<T> node) {
        NavigationEvent<T> evt = new NavigationEvent<T>(this, level, type, node.getKey(), node.getValue());
        for (EventListener<NavigationEvent<T>> l : this._listeners) {
            try {
                l.onEvent(evt);
            }
            catch (Exception e) {
                log.warn("Failed to fire event", (Throwable)e);
            }
        }
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Serializables.smartWrite((ObjectOutputStream)s, this._listeners);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this._listeners = new ArrayList<EventListener<NavigationEvent<T>>>();
        Serializables.smartRead((ObjectInputStream)s, this._listeners);
    }

    static {
        try {
            Classes.forNameByThread((String)"org.zkoss.bind.BindUtils");
        }
        catch (ClassNotFoundException e) {
            HAS_ZKBIND = false;
        }
    }
}

