/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.Tree;
import org.zkoss.zul.Treecol;
import org.zkoss.zul.Treecols;
import org.zkoss.zul.Treerow;
import org.zkoss.zul.impl.LabelImageElement;

public class Treecell
extends LabelImageElement {
    private AuxInfo _auxinf;

    public Treecell() {
    }

    public Treecell(String label) {
        super(label);
    }

    public Treecell(String label, String src) {
        super(label, src);
    }

    public Tree getTree() {
        Treecell n = this;
        while ((n = n.getParent()) != null) {
            if (!(n instanceof Tree)) continue;
            return (Tree)((Object)n);
        }
        return null;
    }

    public Treecol getTreecol() {
        List lcschs;
        int j;
        Treecols lcs;
        Tree tree = this.getTree();
        if (tree != null && (lcs = tree.getTreecols()) != null && (j = this.getColumnIndex()) < (lcschs = lcs.getChildren()).size()) {
            return (Treecol)((Object)lcschs.get(j));
        }
        return null;
    }

    public int getColumnIndex() {
        int j = 0;
        Iterator it = this.getParent().getChildren().iterator();
        while (it.hasNext() && it.next() != this) {
            ++j;
        }
        return j;
    }

    public int getMaxlength() {
        Tree tree = this.getTree();
        if (tree == null) {
            return 0;
        }
        Treecol lc = this.getTreecol();
        return lc != null ? lc.getMaxlength() : 0;
    }

    public int getLevel() {
        Component parent = this.getParent();
        return parent != null ? ((Treerow)parent).getLevel() : 0;
    }

    public int getSpan() {
        return this._auxinf != null ? this._auxinf.span : 1;
    }

    public void setSpan(int span) {
        if (this.getSpan() != span) {
            this.initAuxInfoForTreecell().span = span;
            this.smartUpdate("colspan", this.getSpan());
        }
    }

    public String getZclass() {
        return this._zclass == null ? "z-treecell" : this._zclass;
    }

    @Override
    public Object clone() {
        Treecell clone = (Treecell)((Object)super.clone());
        if (this._auxinf != null) {
            clone._auxinf = (AuxInfo)this._auxinf.clone();
        }
        return clone;
    }

    public String getWidth() {
        Treecol col = this.getTreecol();
        return col != null ? col.getWidth() : null;
    }

    public void setWidth(String width) {
    }

    public void setHflex(String flex) {
    }

    @Override
    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        if (this.getSpan() > 1) {
            renderer.render("colspan", this.getSpan());
        }
    }

    public void beforeParentChanged(Component parent) {
        if (parent != null && !(parent instanceof Treerow)) {
            throw new UiException("Wrong parent: " + String.valueOf(parent));
        }
        super.beforeParentChanged(parent);
    }

    private AuxInfo initAuxInfoForTreecell() {
        if (this._auxinf == null) {
            this._auxinf = new AuxInfo();
        }
        return this._auxinf;
    }

    private static class AuxInfo
    implements Serializable,
    Cloneable {
        private int span = 1;

        private AuxInfo() {
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError();
            }
        }
    }
}

