/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import org.zkoss.lang.Objects;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.sys.BooleanPropertyAccess;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zk.ui.sys.IntPropertyAccess;
import org.zkoss.zk.ui.sys.PropertyAccess;
import org.zkoss.zk.ui.sys.StringPropertyAccess;
import org.zkoss.zul.impl.Utils;
import org.zkoss.zul.impl.XulElement;

public class Label
extends XulElement {
    private String _value = "";
    private AuxInfo _auxinf;
    private static HashMap<String, PropertyAccess> _properties = new HashMap(3);

    public Label() {
    }

    public Label(String value) {
        this.setValue(value);
    }

    public String getValue() {
        return this._value;
    }

    public void setValue(String value) {
        if (value == null) {
            value = "";
        }
        if (!Objects.equals((Object)this._value, (Object)value)) {
            this._value = value;
            this.smartUpdate("value", this.getValue());
        }
    }

    public int getMaxlength() {
        return this._auxinf != null ? this._auxinf.maxlength : 0;
    }

    public void setMaxlength(int maxlength) {
        if (maxlength < 0) {
            maxlength = 0;
        }
        if ((this._auxinf != null ? this._auxinf.maxlength : 0) != maxlength) {
            this.initAuxInfoForLabel().maxlength = maxlength;
            this.smartUpdate("maxlength", this.getMaxlength());
        }
    }

    public boolean isMultiline() {
        return this._auxinf != null && this._auxinf.multiline;
    }

    public void setMultiline(boolean multiline) {
        if ((this._auxinf != null && this._auxinf.multiline) != multiline) {
            this.initAuxInfoForLabel().multiline = multiline;
            this.smartUpdate("multiline", this.isMultiline());
        }
    }

    public boolean isPre() {
        return this._auxinf != null && this._auxinf.pre;
    }

    public void setPre(boolean pre) {
        if ((this._auxinf != null && this._auxinf.pre) != pre) {
            this.initAuxInfoForLabel().pre = pre;
            this.smartUpdate("pre", this.isPre());
        }
    }

    @Override
    public PropertyAccess getPropertyAccess(String prop) {
        PropertyAccess pa = _properties.get(prop);
        if (pa != null) {
            return pa;
        }
        return super.getPropertyAccess(prop);
    }

    @Override
    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        int v = this.getMaxlength();
        if (v > 0) {
            renderer.render("maxlength", v);
        }
        this.render(renderer, "multiline", this.isMultiline());
        this.render(renderer, "pre", this.isPre());
        String val = this.getValue();
        this.render(renderer, "value", val);
        Utils.renderCrawlableText(val);
    }

    public String getZclass() {
        return this._zclass == null ? "z-label" : this._zclass;
    }

    @Override
    public Object clone() {
        Label clone = (Label)((Object)super.clone());
        if (this._auxinf != null) {
            clone._auxinf = (AuxInfo)this._auxinf.clone();
        }
        return clone;
    }

    protected boolean isChildable() {
        return false;
    }

    private AuxInfo initAuxInfoForLabel() {
        if (this._auxinf == null) {
            this._auxinf = new AuxInfo();
        }
        return this._auxinf;
    }

    static {
        _properties.put("value", (PropertyAccess)new StringPropertyAccess(){

            public void setValue(Component cmp, String value) {
                ((Label)cmp).setValue(value);
            }

            public String getValue(Component cmp) {
                return ((Label)cmp).getValue();
            }
        });
        _properties.put("multiline", (PropertyAccess)new BooleanPropertyAccess(){

            public void setValue(Component cmp, Boolean multiline) {
                ((Label)cmp).setMultiline(multiline);
            }

            public Boolean getValue(Component cmp) {
                return ((Label)cmp).isMultiline();
            }
        });
        _properties.put("maxlength", (PropertyAccess)new IntPropertyAccess(){

            public void setValue(Component cmp, Integer maxlength) {
                ((Label)cmp).setMaxlength(maxlength);
            }

            public Integer getValue(Component cmp) {
                return ((Label)cmp).getMaxlength();
            }
        });
    }

    private static class AuxInfo
    implements Serializable,
    Cloneable {
        private int maxlength;
        private boolean multiline;
        private boolean pre;

        private AuxInfo() {
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError();
            }
        }
    }
}

