/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import org.zkoss.zul.Column;
import org.zkoss.zul.Label;
import org.zkoss.zul.Row;

public class RowComparator
implements Comparator<Object>,
Serializable {
    private final Column _column;
    private int _index;
    private final boolean _asc;
    private boolean _igcase;
    private boolean _maxnull;

    public RowComparator() {
        this(-1, true, true, false);
    }

    public RowComparator(int index) {
        this(index, true, true, false);
    }

    public RowComparator(int index, boolean ascending, boolean ignoreCase) {
        this(index, ascending, ignoreCase, false);
    }

    public RowComparator(int index, boolean ascending, boolean ignoreCase, boolean nullAsMax) {
        this._column = null;
        this._index = index;
        this._asc = ascending;
        this._igcase = ignoreCase;
        this._maxnull = nullAsMax;
    }

    public RowComparator(Column header, boolean ascending, boolean ignoreCase, boolean nullAsMax) {
        this._column = header;
        this._index = -1;
        this._asc = ascending;
        this._igcase = ignoreCase;
        this._maxnull = nullAsMax;
    }

    public Column getColumn() {
        return this._column;
    }

    public boolean isAscending() {
        return this._asc;
    }

    public boolean shallIgnoreCase() {
        return this._igcase;
    }

    @Override
    public int compare(Object o1, Object o2) {
        Object v2;
        Object v1;
        if (this._index < 0 && this._column != null) {
            this._index = this._column.getParent().getChildren().indexOf((Object)this._column);
        }
        if (o1 instanceof Row) {
            Row r1 = (Row)((Object)o1);
            Row r2 = (Row)((Object)o2);
            if (this._index < 0) {
                v1 = this.handleCase(r1.getValue());
                v2 = this.handleCase(r2.getValue());
            } else {
                List rcs1 = r1.getChildren();
                v1 = this._index >= rcs1.size() ? null : this.handleCase(rcs1.get(this._index));
                List rcs2 = r2.getChildren();
                v2 = this._index >= rcs2.size() ? null : this.handleCase(rcs2.get(this._index));
            }
        } else {
            v1 = this.handleCase(o1);
            v2 = this.handleCase(o2);
        }
        if (v1 == null) {
            return v2 == null ? 0 : (this._maxnull ? 1 : -1);
        }
        if (v2 == null) {
            return this._maxnull ? -1 : 1;
        }
        int v = RowComparator.compareTo((Comparable)v1, v2);
        return this._asc ? v : -v;
    }

    private static int compareTo(Comparable v1, Object v2) {
        return v1.compareTo(v2);
    }

    private Object handleCase(Object c) {
        if (c instanceof Label) {
            c = ((Label)((Object)c)).getValue();
        }
        if (this._igcase) {
            if (c instanceof String) {
                return ((String)c).toUpperCase();
            }
            if (c instanceof Character) {
                return new Character(Character.toUpperCase(((Character)c).charValue()));
            }
        }
        return c;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RowComparator)) {
            return false;
        }
        RowComparator c = (RowComparator)o;
        return c._index == this._index && c._asc == this._asc && c._igcase == this._igcase;
    }

    public int hashCode() {
        return this._index ^ (this._asc ? 1 : 5) ^ (this._igcase ? 9 : 3);
    }

    public String toString() {
        return "[Compare " + (String)(this._index < 0 ? "value" : this._index + "-th column") + "]";
    }
}

