/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.awt.image.RenderedImage;
import java.io.IOException;
import org.zkoss.image.Images;
import org.zkoss.lang.Objects;
import org.zkoss.util.media.Media;
import org.zkoss.zk.au.DeferredValue;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.ext.render.DynamicMedia;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.impl.Utils;
import org.zkoss.zul.impl.XulElement;

public class Image
extends XulElement {
    private String _src;
    private org.zkoss.image.Image _image;
    private String _hoversrc;
    private org.zkoss.image.Image _hoverimg;
    private byte _imgver;
    private byte _hoverimgver;

    public Image() {
    }

    public Image(String src) {
        this.setSrc(src);
    }

    public String getSrc() {
        return this._src;
    }

    public void setSrc(String src) {
        if (src != null && src.length() == 0) {
            src = null;
        }
        if (this._image != null || !Objects.equals((Object)this._src, (Object)src)) {
            this._src = src;
            this._image = null;
            this.smartUpdate("src", new EncodedURL());
        }
    }

    public void setContent(org.zkoss.image.Image image) {
        if (this._src != null || image != this._image) {
            this._image = image;
            this._src = null;
            if (this._image != null) {
                this._imgver = (byte)(this._imgver + 1);
            }
            this.smartUpdate("src", new EncodedURL());
        }
    }

    public void setContent(RenderedImage image) {
        try {
            this.setContent(image == null ? null : Images.encode((String)"a.png", (RenderedImage)image));
        }
        catch (IOException ex) {
            throw new UiException((Throwable)ex);
        }
    }

    public org.zkoss.image.Image getContent() {
        return this._image;
    }

    private String getEncodedURL() {
        if (this._image != null) {
            return Utils.getDynamicMediaURI((AbstractComponent)this, this._imgver, "c/" + this._image.getName(), this._image.getFormat());
        }
        if (this._src == null) {
            return "data:image/gif;base64,R0lGODlhAQABAIAAAP///////yH5BAUUAAEALAAAAAABAAEAAAICTAEAOw==";
        }
        Desktop dt = this.getDesktop();
        return dt != null ? dt.getExecution().encodeURL(this._src) : "";
    }

    private String getEncodedHoverURL() {
        if (this._hoverimg != null) {
            return Utils.getDynamicMediaURI((AbstractComponent)this, this._hoverimgver, "h/" + this._hoverimg.getName(), this._hoverimg.getFormat());
        }
        Desktop dt = this.getDesktop();
        return dt != null && this._hoversrc != null ? dt.getExecution().encodeURL(this._hoversrc) : null;
    }

    public String getHover() {
        return this._hoversrc;
    }

    public void setHover(String src) {
        if (src != null && src.length() == 0) {
            src = null;
        }
        if (this._hoverimg != null || !Objects.equals((Object)this._hoversrc, (Object)src)) {
            this._hoversrc = src;
            this._hoverimg = null;
            this.smartUpdate("hover", new EncodedHoverURL());
        }
    }

    public void setHoverContent(org.zkoss.image.Image image) {
        if (this._hoversrc != null || image != this._hoverimg) {
            this._hoverimg = image;
            this._hoversrc = null;
            if (this._hoverimg != null) {
                this._hoverimgver = (byte)(this._hoverimgver + 1);
            }
            this.smartUpdate("hover", new EncodedHoverURL());
        }
    }

    public void setHoverContent(RenderedImage image) {
        try {
            this.setHoverContent(Images.encode((String)"hover.png", (RenderedImage)image));
        }
        catch (IOException ex) {
            throw new UiException((Throwable)ex);
        }
    }

    @Override
    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        this.render(renderer, "_preloadImage", Utils.testAttribute((Component)this, "org.zkoss.zul.image.preload", false, true));
        this.render(renderer, "src", this.getEncodedURL());
        if (this._hoversrc != null || this._hoverimg != null) {
            this.render(renderer, "hover", this.getEncodedHoverURL());
        }
    }

    protected boolean isChildable() {
        return false;
    }

    public Object getExtraCtrl() {
        return new ExtraCtrl();
    }

    private class EncodedHoverURL
    implements DeferredValue {
        private EncodedHoverURL() {
        }

        public Object getValue() {
            return Image.this.getEncodedHoverURL();
        }
    }

    private class EncodedURL
    implements DeferredValue {
        private EncodedURL() {
        }

        public Object getValue() {
            return Image.this.getEncodedURL();
        }
    }

    protected class ExtraCtrl
    extends HtmlBasedComponent.ExtraCtrl
    implements DynamicMedia {
        protected ExtraCtrl() {
            super((HtmlBasedComponent)Image.this);
        }

        public Media getMedia(String pathInfo) {
            int k;
            int j;
            if (pathInfo != null && (j = pathInfo.indexOf(47, 1)) >= 0 && (k = pathInfo.indexOf(47, ++j)) == j + 1 && pathInfo.charAt(j) == 'h') {
                return Image.this._hoverimg;
            }
            return Image.this._image;
        }
    }
}

