/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.chrono.Chronology;
import java.time.chrono.Era;
import java.time.chrono.IsoEra;
import java.time.chrono.JapaneseEra;
import java.time.chrono.MinguoDate;
import java.time.chrono.MinguoEra;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.format.TextStyle;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.json.JavaScriptValue;
import org.zkoss.lang.Library;
import org.zkoss.lang.Objects;
import org.zkoss.lang.Strings;
import org.zkoss.mesg.Messages;
import org.zkoss.text.DateFormats;
import org.zkoss.util.Locales;
import org.zkoss.util.TimeZones;
import org.zkoss.util.WaitLock;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuInvoke;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Components;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.ext.Blockable;
import org.zkoss.zk.ui.impl.Utils;
import org.zkoss.zk.ui.sys.BooleanPropertyAccess;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zk.ui.sys.PropertyAccess;
import org.zkoss.zul.SimpleDateConstraint;
import org.zkoss.zul.impl.DateTimeFormatInputElement;
import org.zkoss.zul.mesg.MZul;

public class Datebox
extends DateTimeFormatInputElement {
    private static final Logger log = LoggerFactory.getLogger(Datebox.class);
    public static final String DEFAULT_FORMAT = "yyyy/MM/dd";
    private List<TimeZone> _dtzones;
    private boolean _btnVisible = true;
    private boolean _lenient = true;
    private boolean _dtzonesReadonly = false;
    private static Map<Locale, Object> _symbols = new HashMap<Locale, Object>(8);
    private boolean _weekOfYear;
    private boolean _showTodayLink = false;
    private boolean _strictDate = false;
    private String _position = "after_start";
    private String _todayLinkLabel = Messages.get((int)MZul.CALENDAR_TODAY);
    private LocalDateTime _defaultDateTime;
    private String _selectLevel = "day";
    private boolean _closePopupOnTimezoneChange = true;
    private static HashMap<String, PropertyAccess> _properties;

    public Datebox() {
        this.setFormat("");
        this.setCols(11);
    }

    public Datebox(Date date) throws WrongValueException {
        this();
        this.setValue(date);
    }

    public Datebox(ZonedDateTime value) throws WrongValueException {
        this();
        this.setValueInZonedDateTime(value);
    }

    public Datebox(LocalDateTime value) throws WrongValueException {
        this();
        this.setValueInLocalDateTime(value);
    }

    public Datebox(LocalDate value) throws WrongValueException {
        this();
        this.setValueInLocalDate(value);
    }

    public Datebox(LocalTime value) throws WrongValueException {
        this();
        this.setValueInLocalTime(value);
    }

    public void setWeekOfYear(boolean weekOfYear) {
        if (this._weekOfYear != weekOfYear) {
            this._weekOfYear = weekOfYear;
            this.smartUpdate("weekOfYear", this._weekOfYear);
        }
    }

    public boolean isWeekOfYear() {
        return this._weekOfYear;
    }

    public void setStrictDate(boolean strictDate) {
        if (this._strictDate != strictDate) {
            this._strictDate = strictDate;
            this.smartUpdate("strictDate", strictDate);
        }
    }

    public boolean isStrictDate() {
        return this._strictDate;
    }

    protected String getDefaultFormat() {
        return DateFormats.getDateFormat((int)2, (Locale)this._locale, (String)DEFAULT_FORMAT);
    }

    protected String getLocalizedFormat() {
        return new SimpleDateFormat(this.getRealFormat(), this._locale != null ? this._locale : Locales.getCurrent()).toLocalizedPattern();
    }

    public boolean isLenient() {
        return this._lenient;
    }

    public void setLenient(boolean lenient) {
        if (this._lenient != lenient) {
            this._lenient = lenient;
            this.smartUpdate("lenient", this._lenient);
        }
    }

    public boolean isButtonVisible() {
        return this._btnVisible;
    }

    public void setButtonVisible(boolean visible) {
        if (this._btnVisible != visible) {
            this._btnVisible = visible;
            this.smartUpdate("buttonVisible", visible);
        }
    }

    public String getPosition() {
        return this._position;
    }

    public void setPosition(String position) {
        if (!Objects.equals((Object)this._position, (Object)position)) {
            this._position = position;
            this.smartUpdate("position", this._position);
        }
    }

    @Override
    public void setFormat(String format) throws WrongValueException {
        if (format == null) {
            format = "";
        } else if (format.length() != 0) {
            boolean bCustom;
            int j = format.indexOf(43);
            if (j > 0) {
                bCustom = Datebox.toStyle(format.substring(j + 1)) == -111 || Datebox.toStyle(format.substring(0, j)) == -111;
            } else {
                boolean bl = bCustom = Datebox.toStyle(format) == -111;
            }
            if (bCustom) {
                this.getDateFormat(format);
            }
        }
        super.setFormat(format);
        this.smartUpdate("localizedFormat", this.getLocalizedFormat());
    }

    public static int toStyle(String format) {
        if ("short".equals(format = format.trim().toLowerCase(Locale.ENGLISH))) {
            return 3;
        }
        if ("medium".equals(format)) {
            return 2;
        }
        if ("long".equals(format)) {
            return 1;
        }
        if ("full".equals(format)) {
            return 0;
        }
        return -111;
    }

    @Override
    public String getRealFormat() {
        String format = this.getFormat();
        if (format == null || format.length() == 0) {
            return this.getDefaultFormat();
        }
        int ds = format.indexOf(43);
        if (ds > 0) {
            int ts = Datebox.toStyle(format.substring(ds + 1));
            if (ts != -111 && (ds = Datebox.toStyle(format.substring(0, ds))) != -111) {
                return DateFormats.getDateTimeFormat((int)ds, (int)ts, (Locale)this._locale, (String)"yyyy/MM/dd HH:mm");
            }
        } else {
            ds = Datebox.toStyle(format);
            if (ds != -111) {
                return DateFormats.getDateFormat((int)ds, (Locale)this._locale, (String)DEFAULT_FORMAT);
            }
        }
        return format;
    }

    @Override
    public void setTimeZone(TimeZone tzone) {
        if (this._tzone != tzone) {
            if (this._dtzones != null) {
                tzone = this._dtzones.contains(tzone) ? tzone : this._dtzones.get(0);
            }
            super.setTimeZone(tzone);
        }
    }

    public List<TimeZone> getDisplayedTimeZones() {
        return this._dtzones;
    }

    public void setDisplayedTimeZones(List<TimeZone> dtzones) {
        if (dtzones != null && dtzones.isEmpty()) {
            dtzones = null;
        }
        if (this._dtzones != dtzones) {
            this._dtzones = dtzones;
            StringBuffer sb = new StringBuffer();
            if (dtzones != null) {
                int i = 0;
                Iterator<TimeZone> it = dtzones.iterator();
                while (it.hasNext()) {
                    if (i != 0) {
                        sb.append(',');
                    }
                    sb.append(it.next().getID());
                    ++i;
                }
            }
            this.smartUpdate("displayedTimeZones", sb.toString());
            if (this._tzone == null && this._dtzones != null && this._dtzones.get(0) != null) {
                this._tzone = this._dtzones.get(0);
            }
        }
    }

    public void setDisplayedTimeZones(String dtzones) {
        if (dtzones == null || dtzones.length() == 0) {
            this.setDisplayedTimeZones((List<TimeZone>)null);
            return;
        }
        LinkedList<TimeZone> list = new LinkedList<TimeZone>();
        String[] ids = dtzones.split(",");
        for (int i = 0; i < ids.length; ++i) {
            TimeZone tzone = TimeZone.getTimeZone(ids[i].trim());
            if (tzone == null) continue;
            list.add(tzone);
        }
        this.setDisplayedTimeZones(list);
    }

    public boolean isTimeZonesReadonly() {
        return this._dtzonesReadonly;
    }

    public void setTimeZonesReadonly(boolean readonly) {
        if (readonly != this._dtzonesReadonly) {
            this._dtzonesReadonly = readonly;
            this.smartUpdate("timeZonesReadonly", this._dtzonesReadonly);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map loadSymbols(Locale locale) {
        WaitLock lock = null;
        while (true) {
            Object o;
            Map<Locale, Object> map = _symbols;
            synchronized (map) {
                o = _symbols.get(locale);
                if (o == null) {
                    lock = new WaitLock();
                    _symbols.put(locale, lock);
                }
            }
            if (o instanceof Map) {
                return (Map)o;
            }
            if (o == null) break;
            if (((WaitLock)o).waitUntilUnlock(300000)) continue;
            log.warn("Take too long to wait loading localized symbol: " + String.valueOf(locale) + "\nTry to load again automatically...");
        }
        try {
            HashMap<Locale, Object> map = new HashMap<Locale, Object>();
            Calendar cal = Calendar.getInstance(locale);
            int firstDayOfWeek = org.zkoss.zk.ui.http.Utils.getFirstDayOfWeek();
            cal.clear();
            if (firstDayOfWeek < 0) {
                firstDayOfWeek = cal.getFirstDayOfWeek();
            }
            map.put((Locale)((Object)"DOW_1ST"), firstDayOfWeek - 1);
            map.put((Locale)((Object)"MINDAYS"), cal.getMinimalDaysInFirstWeek());
            boolean zhlang = locale.getLanguage().equals("zh");
            SimpleDateFormat df = new SimpleDateFormat("E", locale);
            String[] sdow = new String[7];
            String[] s2dow = new String[7];
            int j = firstDayOfWeek;
            for (int k = 0; k < 7; ++k) {
                int len;
                char cc;
                cal.set(7, j);
                sdow[k] = df.format(cal.getTime());
                if (++j > 7) {
                    j = 1;
                }
                s2dow[k] = zhlang ? (sdow[k].length() >= 3 ? sdow[k].substring(2) : sdow[k]) : ((cc = sdow[k].charAt((len = sdow[k].length()) - 1)) == '.' || cc == ',' ? sdow[k].substring(0, len - 1) : sdow[k]);
            }
            map.put((Locale)((Object)"LAN_TAG"), locale.toLanguageTag());
            HashMap eras = new HashMap();
            Chronology chronology = Chronology.ofLocale(locale);
            String format = "G-yyyy/MM/dd";
            DateTimeFormatter dtf = DateTimeFormatter.ofPattern(format, locale);
            String ce = IsoEra.CE.getDisplayName(TextStyle.SHORT, locale);
            String bce = IsoEra.BCE.getDisplayName(TextStyle.SHORT, locale);
            List<Era> eraList = chronology.eras();
            for (Era era : eraList) {
                try {
                    int firstYear;
                    String eraName = era.getDisplayName(TextStyle.SHORT, locale);
                    if (era instanceof MinguoEra) {
                        if (eraName.equalsIgnoreCase(ce)) {
                            eraName = dtf.format(MinguoDate.of(1, 1, 1)).split("-")[0];
                        } else if (eraName.equalsIgnoreCase(bce)) {
                            eraName = dtf.format(MinguoDate.of(-1, 1, 1)).split("-")[0];
                        }
                    }
                    HashMap<String, Integer> eraData = new HashMap<String, Integer>(2);
                    if (era instanceof JapaneseEra) {
                        firstYear = LocalDate.parse(eraName + "-0006/01/01", dtf.withChronology(chronology)).minusYears(5L).getYear();
                        eraData.put("firstYear", firstYear);
                        eraData.put("direction", 1);
                    } else {
                        firstYear = LocalDate.parse(eraName + "-0001/01/01", dtf.withChronology(chronology)).getYear();
                        eraData.put("firstYear", firstYear);
                        eraData.put("direction", era.getValue() <= 0 ? -1 : 1);
                    }
                    eras.put(eraName, eraData);
                }
                catch (DateTimeParseException e) {
                    log.warn("LocalizedSymbols ERAS parsing failed with Locale: " + String.valueOf(locale) + "and Era: " + String.valueOf(era));
                }
            }
            map.put((Locale)((Object)"ERAS"), eras);
            if (locale.getCountry().equals("TH")) {
                df = new SimpleDateFormat("G", locale);
                map.put((Locale)((Object)"ERA"), df.format(new Date()));
                Calendar ec = Calendar.getInstance(Locale.ENGLISH);
                Calendar lc = Calendar.getInstance(locale);
                map.put((Locale)((Object)"YDELTA"), lc.get(1) - ec.get(1));
            } else {
                map.put((Locale)((Object)"ERA"), "");
                map.put((Locale)((Object)"YDELTA"), 0);
            }
            df = new SimpleDateFormat("EEEE", locale);
            String[] fdow = new String[7];
            int j2 = firstDayOfWeek;
            for (int k = 0; k < 7; ++k) {
                cal.set(7, j2);
                fdow[k] = df.format(cal.getTime());
                if (++j2 <= 7) continue;
                j2 = 1;
            }
            df = new SimpleDateFormat("MMM", locale);
            String[] smon = new String[12];
            String[] s2mon = new String[12];
            for (int j3 = 0; j3 < 12; ++j3) {
                int len;
                char cc;
                cal.set(2, j3);
                smon[j3] = df.format(cal.getTime());
                s2mon[j3] = zhlang ? (smon[0].length() >= 2 ? smon[j3].substring(0, smon[j3].length() - 1) : smon[j3]) : ((cc = smon[j3].charAt((len = smon[j3].length()) - 1)) == '.' || cc == ',' ? smon[j3].substring(0, len - 1) : smon[j3]);
            }
            df = new SimpleDateFormat("MMMM", locale);
            String[] fmon = new String[12];
            for (int j4 = 0; j4 < 12; ++j4) {
                cal.set(2, j4);
                fmon[j4] = df.format(cal.getTime());
            }
            map.put((Locale)((Object)"SDOW"), sdow);
            if (Objects.equals((Object)s2dow, (Object)sdow)) {
                map.put((Locale)((Object)"S2DOW"), sdow);
            } else {
                map.put((Locale)((Object)"S2DOW"), s2dow);
            }
            if (Objects.equals((Object)fdow, (Object)sdow)) {
                map.put((Locale)((Object)"FDOW"), sdow);
            } else {
                map.put((Locale)((Object)"FDOW"), fdow);
            }
            map.put((Locale)((Object)"SMON"), smon);
            if (Objects.equals((Object)s2mon, (Object)smon)) {
                map.put((Locale)((Object)"S2MON"), smon);
            } else {
                map.put((Locale)((Object)"S2MON"), s2mon);
            }
            if (Objects.equals((Object)fmon, (Object)smon)) {
                map.put((Locale)((Object)"FMON"), smon);
            } else {
                map.put((Locale)((Object)"FMON"), fmon);
            }
            df = new SimpleDateFormat("a", locale);
            cal.set(11, 3);
            String[] ampm = new String[2];
            ampm[0] = df.format(cal.getTime());
            cal.set(11, 15);
            ampm[1] = df.format(cal.getTime());
            map.put((Locale)((Object)"APM"), ampm);
            Map<Locale, Object> map2 = _symbols;
            synchronized (map2) {
                _symbols.put(locale, map);
                Datebox.cloneSymbols();
            }
            map2 = map;
            return map2;
        }
        finally {
            lock.unlock();
        }
    }

    private static void cloneSymbols() {
        HashMap<Locale, Object> symbols = new HashMap<Locale, Object>();
        for (Map.Entry<Locale, Object> me : _symbols.entrySet()) {
            Object value = me.getValue();
            if (!(value instanceof Map)) continue;
            symbols.put(me.getKey(), value);
        }
        _symbols = symbols;
    }

    private static Object[] getRealSymbols(Locale locale, Datebox box) {
        if (locale != null) {
            String localeName = locale.toString();
            if (Utils.markClientInfoPerDesktop((Desktop)box.getDesktop(), (String)(box.getClass().getName() + localeName))) {
                Map symbols = (Map)_symbols.get(locale);
                if (symbols == null) {
                    symbols = Datebox.loadSymbols(locale);
                }
                return new Object[]{localeName, symbols};
            }
            return new Object[]{localeName, null};
        }
        return null;
    }

    public void setOpen(boolean open) {
        if (this.isVisible()) {
            if (open) {
                this.open();
            } else {
                this.close();
            }
        }
    }

    public void open() {
        this.response("open", (AuResponse)new AuInvoke((Component)this, "setOpen", true));
    }

    public void close() {
        this.response("open", (AuResponse)new AuInvoke((Component)this, "setOpen", false));
    }

    @Override
    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        if (cmd.equals("onTimeZoneChange")) {
            Map data = request.getData();
            String timezone = (String)data.get("timezone");
            this.setTimeZone(timezone);
        } else {
            super.service(request, everError);
        }
    }

    public Object getExtraCtrl() {
        return new ExtraCtrl();
    }

    @Override
    public void setConstraint(String constr) {
        this.setConstraint(constr != null ? new SimpleDateConstraint(constr) : null);
    }

    @Override
    protected Object coerceFromString(String value) throws WrongValueException {
        Date date;
        if (value == null || value.length() == 0) {
            return null;
        }
        String fmt = this.getRealFormat();
        DateFormat df = this.getDateFormat(fmt);
        df.setLenient(this._lenient);
        try {
            date = df.parse(value);
        }
        catch (ParseException ex) {
            throw this.showCustomError(new WrongValueException((Component)this, MZul.DATE_REQUIRED, new Object[]{value, fmt}));
        }
        return date;
    }

    @Override
    protected String coerceToString(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof Date) {
            DateFormat df = this.getDateFormat(this.getRealFormat());
            return df.format((Date)value);
        }
        throw this.showCustomError(new WrongValueException((Component)this, MZul.DATE_REQUIRED, new Object[]{value, this.getRealFormat()}));
    }

    protected DateFormat getDateFormat(String fmt) {
        SimpleDateFormat df = new SimpleDateFormat(fmt, this._locale != null ? this._locale : Locales.getCurrent());
        TimeZone tz = this._tzone != null ? this._tzone : TimeZones.getCurrent();
        df.setTimeZone(tz);
        return df;
    }

    private String getUnformater() {
        if (Utils.markClientInfoPerDesktop((Desktop)this.getDesktop(), (String)"org.zkoss.zul.Datebox.unformater.isSent")) {
            return Library.getProperty((String)"org.zkoss.zul.Datebox.unformater");
        }
        return null;
    }

    public String getZclass() {
        return this._zclass == null ? "z-datebox" : this._zclass;
    }

    public boolean getShowTodayLink() {
        return this._showTodayLink;
    }

    public void setShowTodayLink(boolean showTodayLink) {
        if (this._showTodayLink != showTodayLink) {
            this._showTodayLink = showTodayLink;
            this.smartUpdate("showTodayLink", this._showTodayLink);
        }
    }

    public String getTodayLinkLabel() {
        return this._todayLinkLabel;
    }

    public void setTodayLinkLabel(String todayLinkLabel) {
        if (!Objects.equals((Object)this._todayLinkLabel, (Object)todayLinkLabel)) {
            this._todayLinkLabel = todayLinkLabel;
            this.smartUpdate("todayLinkLabel", todayLinkLabel);
        }
    }

    public LocalDateTime getDefaultDateTime() {
        return this._defaultDateTime;
    }

    public void setDefaultDateTime(LocalDateTime defaultDateTime) {
        if (this._defaultDateTime != defaultDateTime) {
            this._defaultDateTime = defaultDateTime;
            this.smartUpdate("defaultDateTime", this.toDate(this._defaultDateTime));
        }
    }

    public String getSelectLevel() {
        return this._selectLevel;
    }

    public void setSelectLevel(String selectLevel) {
        if (!("day".equals(selectLevel) || "month".equals(selectLevel) || "year".equals(selectLevel))) {
            throw new WrongValueException("Only allowed day, month, and year, not " + selectLevel);
        }
        if (!Objects.equals((Object)this._selectLevel, (Object)selectLevel)) {
            this._selectLevel = selectLevel;
            this.smartUpdate("selectLevel", selectLevel);
        }
    }

    public boolean getClosePopupOnTimezoneChange() {
        return this._closePopupOnTimezoneChange;
    }

    public void setClosePopupOnTimezoneChange(boolean closePopupOnTimezoneChange) {
        if (this._closePopupOnTimezoneChange != closePopupOnTimezoneChange) {
            this._closePopupOnTimezoneChange = closePopupOnTimezoneChange;
            this.smartUpdate("closePopupOnTimezoneChange", this._closePopupOnTimezoneChange);
        }
    }

    @Override
    public PropertyAccess getPropertyAccess(String prop) {
        PropertyAccess pa = _properties.get(prop);
        if (pa != null) {
            return pa;
        }
        return super.getPropertyAccess(prop);
    }

    @Override
    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        if (!this._btnVisible) {
            renderer.render("buttonVisible", false);
        }
        if (!this._lenient) {
            renderer.render("lenient", false);
        }
        if (this._dtzonesReadonly) {
            renderer.render("timeZonesReadonly", true);
        }
        if (this._dtzones != null) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < this._dtzones.size(); ++i) {
                if (i != 0) {
                    sb.append(',');
                }
                TimeZone tz = this._dtzones.get(i);
                sb.append(tz.getID());
            }
            renderer.render("displayedTimeZones", sb.toString());
        }
        this.render(renderer, "weekOfYear", this._weekOfYear);
        this.render(renderer, "position", this._position);
        renderer.render("localizedFormat", this.getLocalizedFormat());
        String unformater = this.getUnformater();
        if (!Strings.isBlank((String)unformater)) {
            renderer.render("unformater", (Object)new JavaScriptValue(unformater));
        }
        if (this._locale != null) {
            renderer.render("localizedSymbols", (Object)Datebox.getRealSymbols(this._locale, this));
        }
        if (this._strictDate) {
            this.render(renderer, "strictDate", this._strictDate);
        }
        this.render(renderer, "showTodayLink", this._showTodayLink);
        this.render(renderer, "todayLinkLabel", this._todayLinkLabel);
        if (this._defaultDateTime != null) {
            this.render(renderer, "defaultDateTime", this.toDate(this._defaultDateTime));
        }
        if (!"day".equals(this._selectLevel)) {
            this.render(renderer, "selectLevel", this._selectLevel);
        }
        if (!this._closePopupOnTimezoneChange) {
            renderer.render("closePopupOnTimezoneChange", false);
        }
    }

    static {
        Datebox.addClientEvent(Datebox.class, (String)"onTimeZoneChange", (int)8193);
        _properties = new HashMap(2);
        _properties.put("buttonVisible", (PropertyAccess)new BooleanPropertyAccess(){

            public void setValue(Component cmp, Boolean value) {
                ((Datebox)cmp).setButtonVisible(value);
            }

            public Boolean getValue(Component cmp) {
                return ((Datebox)cmp).isButtonVisible();
            }
        });
        _properties.put("lenient", (PropertyAccess)new BooleanPropertyAccess(){

            public void setValue(Component cmp, Boolean value) {
                ((Datebox)cmp).setLenient(value);
            }

            public Boolean getValue(Component cmp) {
                return ((Datebox)cmp).isLenient();
            }
        });
    }

    protected class ExtraCtrl
    extends HtmlBasedComponent.ExtraCtrl
    implements Blockable {
        protected ExtraCtrl() {
            super((HtmlBasedComponent)Datebox.this);
        }

        public boolean shallBlock(AuRequest request) {
            String cmd = request.getCommand();
            if ("onOpen".equals(cmd)) {
                return false;
            }
            return Datebox.this.isDisabled() || Datebox.this.isReadonly() && "onChanging".equals(cmd) || !Components.isRealVisible((Component)Datebox.this);
        }
    }
}

