/******/ (function() { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./extends.js":
/*!********************!*\
  !*** ./extends.js ***!
  \********************/
/***/ (function(__unused_webpack_module, exports) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
/* extends.js

    Purpose:

    Description:

    History:
        1:02 PM 2023/8/21, Created by jumperchen

Copyright (C) 2023 Potix Corporation. All Rights Reserved.
*/
var extendStatics = function (d, b) {
  extendStatics = Object.setPrototypeOf || {
    __proto__: []
  } instanceof Array && function (d, b) {
    d.__proto__ = b;
  } || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
  };
  return extendStatics(d, b);
};
// refer tslib#__extends
function default_1(d, b) {
  extendStatics(d, b);
  function __() {
    this.constructor = d;
  }
  d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  d.prototype._$super = d.name == '$subclass$' && b.prototype._$super ? b.prototype._$super : b.prototype; // Potix: Jumper Chen adds to support `$supers(foo.Bar, 'bind_')`
}
exports["default"] = default_1;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/layout/Absolutechildren.ts":
/*!**********************************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/layout/Absolutechildren.ts ***!
  \**********************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


/* Absolutechildren.ts

    Purpose:

    Description:

    History:
        Mon Oct  3 11:14:17 TST 2011, Created by jumperchen

Copyright (C) 2011 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 3.0 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
if (!window.zul) window.zul = {};
if (!window.zul.layout) window.zul.layout = {};
if (!window.zul.layout.Absolutechildren_) window.zul.layout.Absolutechildren_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Absolutechildren = void 0;
/**
 * <p>A container component that can contain any other ZK component and can only
 * be contained as direct child of Absolutelayout component. It can be absolutely
 * positioned within Absolutelayout component by either setting "x" and "y"
 * attribute or calling {@link setX} and {@link setY} methods.
 *
 * @defaultValue {@link getZclass}: z-absolutechildren.
 *
 * @author ashish
 * @since 6.0.0
 */
var Absolutechildren = /** @class */function (_super) {
  __extends(Absolutechildren, _super);
  function Absolutechildren() {
    var _this = _super !== null && _super.apply(this, arguments) || this;
    /** @internal */
    _this._x = 0;
    /** @internal */
    _this._y = 0;
    return _this;
  }
  /**
   * Sets current "x" position within parent container component.
   * @defaultValue `0`
   * @param x - the x position
   */
  Absolutechildren.prototype.setX = function (x, opts) {
    var o = this._x;
    this._x = x;
    if (o !== x || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      if (this.desktop) {
        this._rePositionX();
      }
    }
    return this;
  };
  /**
   * @returns the current "x" position within parent container component
   */
  Absolutechildren.prototype.getX = function () {
    return this._x;
  };
  /**
   * Sets current "y" position within parent container component.
   * @defaultValue `0`
   * @param y - the y position
   */
  Absolutechildren.prototype.setY = function (y, opts) {
    var o = this._y;
    this._y = y;
    if (o !== y || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      if (this.desktop) {
        this._rePositionY();
      }
    }
    return this;
  };
  /**
   * @returns the current "y" position within parent container component
   */
  Absolutechildren.prototype.getY = function () {
    return this._y;
  };
  /** @internal */
  Absolutechildren.prototype._rePositionBoth = function () {
    this._rePositionX();
    this._rePositionY();
  };
  /** @internal */
  Absolutechildren.prototype._rePositionX = function () {
    jq(this.$n()).css('left', this._x);
  };
  /** @internal */
  Absolutechildren.prototype._rePositionY = function () {
    jq(this.$n()).css('top', this._y);
  };
  /** @internal */
  Absolutechildren.prototype.bind_ = function (desktop, skipper, after) {
    _super.prototype.bind_.call(this, desktop, skipper, after);
    this._rePositionBoth();
  };
  Absolutechildren = __decorate([zk.WrapClass('zul.layout.Absolutechildren')], Absolutechildren);
  return Absolutechildren;
}(zul.Widget);
exports.Absolutechildren = Absolutechildren;
window.zul.layout.Absolutechildren_.Absolutechildren = Absolutechildren;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/layout/Absolutelayout.ts":
/*!********************************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/layout/Absolutelayout.ts ***!
  \********************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


/* Absolutelayout.ts

    Purpose:

    Description:

    History:
        Mon Oct  3 11:14:17 TST 2011, Created by jumperchen

Copyright (C) 2011 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 3.0 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
if (!window.zul) window.zul = {};
if (!window.zul.layout) window.zul.layout = {};
if (!window.zul.layout.Absolutelayout_) window.zul.layout.Absolutelayout_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Absolutelayout = void 0;
/**
 * <p>An Absolutelayout component can contain absolute positioned multiple
 * absolutechildren components.
 *
 * @defaultValue {@link getZclass}: z-absolutelayout.
 *
 * @author ashish
 * @since 6.0.0
 */
var Absolutelayout = /** @class */function (_super) {
  __extends(Absolutelayout, _super);
  function Absolutelayout() {
    return _super !== null && _super.apply(this, arguments) || this;
  }
  Absolutelayout.redraw = function (out) {
    out.push('<div ', this.domAttrs_(), '>');
    for (var w = this.firstChild; w; w = w.nextSibling) w.redraw(out);
    out.push('</div>');
  };
  Absolutelayout = __decorate([zk.WrapClass('zul.layout.Absolutelayout')], Absolutelayout);
  return Absolutelayout;
}(zul.Widget);
exports.Absolutelayout = Absolutelayout;
window.zul.layout.Absolutelayout_.Absolutelayout = Absolutelayout;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/layout/Anchorchildren.ts":
/*!********************************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/layout/Anchorchildren.ts ***!
  \********************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


if (!window.zul) window.zul = {};
if (!window.zul.layout) window.zul.layout = {};
if (!window.zul.layout.Anchorchildren_) window.zul.layout.Anchorchildren_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Anchorchildren = void 0;
/* Anchorchildren.ts

    Purpose:

    Description:

    History:
        Mon Oct  3 11:14:17 TST 2011, Created by jumperchen

Copyright (C) 2011 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 3.0 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
/**
 * The children of Anchorlayout. <br>
 * Can accept any ZK component as child.
 *
 * @defaultValue {@link getZclass}: z-anchorchildren.
 * @author peterkuo
 * @since 6.0.0
 */
var Anchorchildren = /** @class */function (_super) {
  __extends(Anchorchildren, _super);
  function Anchorchildren() {
    return _super !== null && _super.apply(this, arguments) || this;
  }
  /**
   * Sets the width, height relative to parent, anchorlayout.
   * It can use % or number.
   * Accept one argument, or two argument separated by space.
   * The first argument is for width, and second for height.
   * For example, "50% 50%" means the anchorchildren width and height is 50%
   * of {@link Anchorlayout}.
   * "-30 20%" means the width is 20px less than parent, and height is 20% of parent.
   * "50%" means the width is 50% of parent, and the height is no assumed.
   */
  Anchorchildren.prototype.setAnchor = function (anchor, opts) {
    var o = this._anchor;
    this._anchor = anchor;
    if (o !== anchor || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      if (this.desktop) this.onSize();
    }
    return this;
  };
  /**
   * @returns the anchor setting.
   */
  Anchorchildren.prototype.getAnchor = function () {
    return this._anchor;
  };
  /** @internal */
  Anchorchildren.prototype.bind_ = function (desktop, skipper, after) {
    _super.prototype.bind_.call(this, desktop, skipper, after);
    zWatch.listen({
      onSize: this
    });
  };
  /** @internal */
  Anchorchildren.prototype.unbind_ = function (skipper, after, keepRod) {
    zWatch.unlisten({
      onSize: this
    });
    _super.prototype.unbind_.call(this, skipper, after, keepRod);
  };
  Anchorchildren.prototype.onSize = function () {
    //calculate the height and width in pixel based on _anchor
    var n = this.$n_(),
      parentn = this.parent.$n_(),
      parentwidth = jq(parentn).width(),
      parentheight = jq(parentn).height(),
      arr = this._anchor ? this._anchor.split(' ', 2) : [],
      anchorWidth = arr[0],
      anchorHeight = arr[1];
    if (anchorWidth) {
      if (anchorWidth.indexOf('%') > 0) {
        n.style.width = anchorWidth;
      } else {
        n.style.width = jq.px0(parentwidth + zk.parseInt(anchorWidth));
      }
    }
    if (anchorHeight) {
      if (anchorHeight.indexOf('%') > 0) {
        n.style.height = anchorHeight;
      } else {
        n.style.height = jq.px0(parentheight + zk.parseInt(anchorHeight));
      }
    }
  };
  Anchorchildren = __decorate([zk.WrapClass('zul.layout.Anchorchildren')], Anchorchildren);
  return Anchorchildren;
}(zul.Widget);
exports.Anchorchildren = Anchorchildren;
window.zul.layout.Anchorchildren_.Anchorchildren = Anchorchildren;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/layout/Anchorlayout.ts":
/*!******************************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/layout/Anchorlayout.ts ***!
  \******************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


if (!window.zul) window.zul = {};
if (!window.zul.layout) window.zul.layout = {};
if (!window.zul.layout.Anchorlayout_) window.zul.layout.Anchorlayout_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Anchorlayout = void 0;
/* Anchorlayout.ts

    Purpose:

    Description:

    History:
        Mon Oct  3 11:14:17 TST 2011, Created by jumperchen

Copyright (C) 2011 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 3.0 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
/**
 * An anchorlayout lays out a container which can resize
 * it's children base on its width and height<br>
 *
 * @defaultValue {@link getZclass}: z-anchorlayout.
 *
 * @author peterkuo
 * @since 6.0.0
 */
var Anchorlayout = /** @class */function (_super) {
  __extends(Anchorlayout, _super);
  function Anchorlayout() {
    return _super !== null && _super.apply(this, arguments) || this;
  }
  Anchorlayout = __decorate([zk.WrapClass('zul.layout.Anchorlayout')], Anchorlayout);
  return Anchorlayout;
}(zul.Widget);
exports.Anchorlayout = Anchorlayout;
window.zul.layout.Anchorlayout_.Anchorlayout = Anchorlayout;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/layout/Borderlayout.ts":
/*!******************************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/layout/Borderlayout.ts ***!
  \******************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


if (!window.zul) window.zul = {};
if (!window.zul.layout) window.zul.layout = {};
if (!window.zul.layout.Borderlayout_) window.zul.layout.Borderlayout_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Borderlayout = void 0;
var _ambit = {
  'north': function (ambit, center, width, height) {
    ambit.w = width - ambit.w;
    center.y = ambit.ts;
    center.h -= ambit.ts;
  },
  'south': function (ambit, center, width, height) {
    ambit.w = width - ambit.w;
    ambit.y = height - ambit.y;
    center.h -= ambit.ts;
  },
  'east': function (ambit, center, width, height) {
    ambit.y += center.y;
    ambit.h = center.h - ambit.h;
    ambit.x = width - ambit.x;
    center.w -= ambit.ts;
  },
  'west': function (ambit, center, width, height) {
    ambit.y += center.y;
    ambit.h = center.h - ambit.h;
    center.x += ambit.ts;
    center.w -= ambit.ts;
  }
};
window.zul.layout.Borderlayout_._getRegionSize = function (wgt, hor, ext) {
  if (!wgt) return 0;
  var n = wgt.$n_('real'),
    sz = hor ? 'offsetWidth' : 'offsetHeight',
    sum = n[sz];
  if (ext) {
    var cn = wgt.$n('colled'),
      sn = wgt.$n('split');
    if (cn) sum += cn[sz];
    if (sn) sum += sn[sz];
  }
  return sum;
};
/**
 * A border layout is a layout container for arranging and resizing
 * child components to fit in five regions: north, south, east, west, and center.
 * Each region may
 * contain no more than one component, and is identified by a corresponding
 * constant: `NORTH`, `SOUTH`, `EAST`,
 * `WEST`, and `CENTER`.
 *
 * @defaultValue {@link getZclass}: z-borderlayout.
 *
 */
var Borderlayout = /** @class */function (_super) {
  __extends(Borderlayout, _super);
  function Borderlayout() {
    var _this = _super !== null && _super.apply(this, arguments) || this;
    /** @internal */
    _this._animationDisabled = false;
    return _this;
  }
  Borderlayout_1 = Borderlayout;
  Borderlayout.prototype.setResize = function () {
    this.resize();
    return this;
  };
  /**
   * @returns whether disable animation effects
   * @defaultValue `false`.
   * @since 5.0.8
   */
  Borderlayout.prototype.isAnimationDisabled = function () {
    return this._animationDisabled;
  };
  /**
   * Sets to disable animation effects.
   * @since 5.0.8
   */
  Borderlayout.prototype.setAnimationDisabled = function (animationDisabled) {
    if (this._animationDisabled != animationDisabled) {
      this._animationDisabled = animationDisabled;
    }
    return this;
  };
  Borderlayout.prototype.setWidth = function (width) {
    _super.prototype.setWidth.call(this, width);
    this.resize();
    return this;
  };
  Borderlayout.prototype.setHeight = function (height) {
    _super.prototype.setHeight.call(this, height);
    this.resize();
    return this;
  };
  //-- super --//
  /** @internal */
  Borderlayout.prototype.onChildAdded_ = function (child) {
    _super.prototype.onChildAdded_.call(this, child);
    switch (child.getPosition()) {
      case Borderlayout_1.NORTH:
        this.north = child;
        break;
      case Borderlayout_1.SOUTH:
        this.south = child;
        break;
      case Borderlayout_1.CENTER:
        this.center = child;
        break;
      case Borderlayout_1.WEST:
        this.west = child;
        break;
      case Borderlayout_1.EAST:
        this.east = child;
        break;
    }
    this._shallResize = true;
  };
  /** @internal */
  Borderlayout.prototype.onChildRemoved_ = function (child) {
    _super.prototype.onChildRemoved_.call(this, child);
    if (child == this.north) delete this.north;else if (child == this.south) delete this.south;else if (child == this.center) delete this.center;else if (child == this.west) delete this.west;else if (child == this.east) delete this.east;
    if (!this.childReplacing_) this._shallResize = true;
  };
  /** @internal */
  Borderlayout.prototype.bind_ = function (desktop, skipper, after) {
    _super.prototype.bind_.call(this, desktop, skipper, after);
    zWatch.listen({
      onSize: this,
      onCommandReady: this
    });
  };
  /** @internal */
  Borderlayout.prototype.unbind_ = function (skipper, after, keepRod) {
    zWatch.unlisten({
      onSize: this,
      onCommandReady: this
    });
    _super.prototype.unbind_.call(this, skipper, after, keepRod);
  };
  Borderlayout.prototype.onCommandReady = function () {
    if (this._shallResize) this.resize();
  };
  /** @internal */
  Borderlayout.prototype.beforeMinFlex_ = function (o) {
    // B50-ZK-309
    var east = this.east,
      west = this.west,
      north = this.north,
      south = this.south,
      center = this.center;
    return o == 'w' ? Math.max(window.zul.layout.Borderlayout_._getRegionSize(north, true), window.zul.layout.Borderlayout_._getRegionSize(south, true), window.zul.layout.Borderlayout_._getRegionSize(east, true, true) + window.zul.layout.Borderlayout_._getRegionSize(west, true, true) + window.zul.layout.Borderlayout_._getRegionSize(center, true)) : window.zul.layout.Borderlayout_._getRegionSize(north, false, true) + window.zul.layout.Borderlayout_._getRegionSize(south, false, true) + Math.max(window.zul.layout.Borderlayout_._getRegionSize(east), window.zul.layout.Borderlayout_._getRegionSize(west), window.zul.layout.Borderlayout_._getRegionSize(center));
  };
  //@Override, region with vflex/hflex, must wait flex resolved then do resize
  /** @internal */
  Borderlayout.prototype.afterChildrenFlex_ = function () {
    //region's min vflex/hflex resolved and try the border resize
    //@see #_resize
    if (this._isOnSize) this._resize(true);
  };
  /**
   * Re-sizes this layout component.
   */
  Borderlayout.prototype.resize = function () {
    if (this.desktop) this._resize();
  };
  /** @internal */
  Borderlayout.prototype._resize = function (isOnSize) {
    this._shallResize = false;
    this._isOnSize = isOnSize;
    if (!zk(this.$n()).isRealVisible()) return; //ZK-2686: incorrect borderlayout resizing to 0px in tabbox
    //make sure all regions size is resolved
    var rs = ['north', 'south', 'west', 'east'],
      k = rs.length;
    for (var region, j = 0; j < k; ++j) {
      region = this[rs[j]];
      if (region && zk(region.$n()).isVisible() && (region._nvflex && region._vflexsz === undefined || region._nhflex && region._hflexsz === undefined)) return; //region size unknown, border cannot _resize() now,
      //return and keep this._isOnSize true
      //onSize event will be fired to region later, and region will
      //call back to _resize() via afterChildrenFlex_() when it resolve
      //itself the vflex and hflex
    }
    var el = this.$n_(),
      width = el.offsetWidth,
      height = el.offsetHeight,
      center = {
        x: 0,
        y: 0,
        w: width,
        h: height
      };
    // fixed Opera 10.5+ bug
    if (zk.opera && !height && (!el.style.height || el.style.height == '100%')) {
      var parent = el.parentElement;
      center.h = height = parent.offsetHeight;
    }
    for (var region, ambit, j = 0; j < k; ++j) {
      region = this[rs[j]];
      if (region && zk(region.$n()).isVisible()) {
        ambit = region._ambit();
        _ambit[rs[j]](ambit, center, width, height);
        this._resizeWgt(region, ambit); //might recursive back
        var directionToCalculate = region._isVertical() ? 'width' : 'height';
        jq(region.$n('title')).width(jq(region.$n('colled'))[directionToCalculate]() - jq(region.$n('btned'))[directionToCalculate]());
      }
    }
    if (this.center && zk(this.center.$n()).isVisible()) {
      var mars = this.center.getCurrentMargins_();
      center.x += mars.left;
      center.y += mars.top;
      center.w -= mars.width;
      center.h -= mars.height;
      this._resizeWgt(this.center, center); //might recursive back
    }
    this._isOnSize = false; // reset
  };
  /** @internal */
  Borderlayout.prototype._resizeWgt = function (wgt, ambit, ignoreSplit) {
    if (wgt._open) {
      if (!ignoreSplit && wgt.$n('split')) {
        wgt._fixSplit();
        ambit = wgt._reszSplt(ambit);
      }
      zk.copy(wgt.$n_('real').style, {
        left: jq.px(ambit.x),
        top: jq.px(ambit.y)
      });
      this._resizeBody(wgt, ambit);
    } else {
      wgt.$n_('split').style.display = 'none';
      var colled = wgt.$n('colled');
      if (colled) {
        zk.copy(colled.style, {
          left: jq.px(ambit.x),
          top: jq.px(ambit.y),
          width: jq.px0(ambit.w),
          height: jq.px0(ambit.h)
        });
      }
      //Bug ZK-1406: resize body after onSize if it is visible but is not open
      var real = wgt.$n('real');
      if (real && zk(real).isVisible()) {
        var isSouch = wgt instanceof zul.layout.South,
          isEast = wgt instanceof zul.layout.East;
        if (isSouch || wgt instanceof zul.layout.North) {
          ambit.h = real.offsetHeight;
          if (isSouch) real.style.top = jq.px(ambit.y - ambit.h);
        }
        if (isEast || wgt instanceof zul.layout.West) {
          ambit.w = real.offsetWidth;
          if (isEast) real.style.left = jq.px(ambit.x - ambit.w);
        }
        this._resizeBody(wgt, ambit);
      }
    }
  };
  /** @internal */
  Borderlayout.prototype._resizeBody = function (wgt, ambit) {
    ambit.w = Math.max(0, ambit.w);
    ambit.h = Math.max(0, ambit.h);
    var el = wgt.$n_('real');
    if (!this._ignoreResize(el, ambit.w, ambit.h)) {
      var fchild = wgt.isFlex() && wgt.getFirstChild(),
        bodyEl = fchild ? wgt.getFirstChild().$n_() : wgt.$n_('cave'),
        bs = bodyEl.style,
        $el = zk(el);
      el.style.width = jq.px0(ambit.w);
      var contentWidth = $el.contentWidth();
      //ZK-2750, prevent parent region grows up infinitely
      if ((wgt instanceof zul.layout.West || wgt instanceof zul.layout.East) && !wgt._width && !wgt._hflex) contentWidth++; // B50-ZK-641: text wrap in IE
      bs.width = jq.px0(contentWidth);
      el.style.height = jq.px0(ambit.h);
      if (wgt.$n('cap')) ambit.h = Math.max(0, ambit.h - wgt.$n_('cap').offsetHeight);
      // Bug: B50-3201762: Borderlayout flex has issue with listbox hflex in IE 6
      if (fchild) {
        // B50-ZK-198: always need cave height
        var cv = wgt.$n('cave');
        if (cv) cv.style.height = jq.px0(ambit.h - $el.padBorderHeight());
      }
      bs.height = jq.px0(ambit.h - $el.padBorderHeight());
      if (wgt._nativebar && wgt.isAutoscroll()) {
        bs.overflow = 'auto';
        bs.position = 'relative';
      }
      if (!this._isOnSize) zUtl.fireSized(wgt);
    }
  };
  /** @internal */
  Borderlayout.prototype._ignoreResize = function (el, w, h) {
    if (el._lastSize && el._lastSize.width == w && el._lastSize.height == h) {
      return true;
    }
    // store fot next time to check
    el._lastSize = {
      width: w,
      height: h
    };
    return false;
  };
  //zWatch//
  Borderlayout.prototype.onSize = function () {
    this._resize(true);
  };
  var Borderlayout_1;
  /**
   * The north layout constraint (top of container).
   */
  Borderlayout.NORTH = 'north';
  /**
   * The south layout constraint (bottom of container).
   */
  Borderlayout.SOUTH = 'south';
  /**
   * The east layout constraint (right side of container).
   */
  Borderlayout.EAST = 'east';
  /**
   * The west layout constraint (left side of container).
   */
  Borderlayout.WEST = 'west';
  /**
   * The center layout constraint (middle of container).
   */
  Borderlayout.CENTER = 'center';
  Borderlayout = Borderlayout_1 = __decorate([zk.WrapClass('zul.layout.Borderlayout')], Borderlayout);
  return Borderlayout;
}(zul.Widget);
exports.Borderlayout = Borderlayout;
window.zul.layout.Borderlayout_._ambit = _ambit;
window.zul.layout.Borderlayout_.Borderlayout = Borderlayout;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/layout/Center.ts":
/*!************************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/layout/Center.ts ***!
  \************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


if (!window.zul) window.zul = {};
if (!window.zul.layout) window.zul.layout = {};
if (!window.zul.layout.Center_) window.zul.layout.Center_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Center = void 0;
/* Center.ts

    Purpose:

    Description:

    History:
        Wed Jan  7 12:15:02     2009, Created by jumperchen

Copyright (C) 2008 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
/**
 * A center region of a borderlayout.
 * <strong>Note:</strong> This component doesn't support the following method,
 * including {@link setSplittable}, {@link setOpen},
 * {@link setCollapsible}, {@link setMaxsize},
 * {@link setMinsize}, {@link setHeight},
 * {@link setWidth}, {@link getSize}, {@link setSize},
 * {@link setSlide}, {@link setSlidable}, {@link setClosable}
 * and {@link setVisible}.
 *
 * @defaultValue {@link getZclass}: z-center.
 */
var Center = /** @class */function (_super) {
  __extends(Center, _super);
  function Center() {
    var _this = _super !== null && _super.apply(this, arguments) || this;
    /** @internal */
    _this._sumFlexWidth = true; //indicate shall add this flex width for borderlayout. @See _fixMinFlex in widget.js
    /** @internal */
    _this._maxFlexHeight = true; //indicate shall check if the maximum flex height for borderlayout. @See _fixMinFlex in widget.js
    /** @internal */
    _this._slidable = false; //Center region can't be slided
    /** @internal */
    _this._closable = false; //Center region can't be closed
    return _this;
  }
  /**
   * The height can't be specified in this component because its height is
   * determined by other region components ({@link North} or {@link South}).
   */
  Center.prototype.setHeight = function (height) {
    return this;
  };
  /**
   * The width can't be specified in this component because its width is
   * determined by other region components ({@link West} or {@link East}).
   */
  Center.prototype.setWidth = function (width) {
    return this;
  };
  /**
   * This component can't be hidden.
   */
  Center.prototype.setVisible = function (visible) {
    return this;
  };
  /**
   * The size can't be returned in this component.
   */
  Center.prototype.getSizegetSize = function () {
    return;
  }; // readonly
  /**
   * The size can't be specified in this component.
   */
  Center.prototype.setSize = function (size) {
    return this;
  }; // readonly
  /**
   * Center region can't be enabled the collapsed margin functionality.
   */
  Center.prototype.setCmargins = function (cmargins) {
    return this;
  };
  /**
   * Center region can't be enabled the split functionality.
   */
  Center.prototype.setSplittable = function (splittable, opts) {
    return this;
  };
  /**
   * Center region can't be closed.
   */
  Center.prototype.setOpen = function (open, opts) {
    return this;
  };
  /**
   * Center region can't be enabled the collapse functionality.
   */
  Center.prototype.setCollapsible = function (collapsible, opts) {
    return this;
  };
  /**
   * Center region can't be enabled the maxsize.
   */
  Center.prototype.setMaxsize = function (maxsize) {
    return this;
  };
  /**
   * Center region can't be enabled the minsize.
   */
  Center.prototype.setMinsize = function (minsize) {
    return this;
  };
  /**
   * Center region can't be slided.
   */
  Center.prototype.setSlide = function (slide, opts) {
    return this;
  };
  /**
   * Center region can't be slided.
   */
  Center.prototype.setSlidable = function (slidable) {
    return this;
  };
  /**
   * Center region can't be closed.
   */
  Center.prototype.setClosable = function (closable, opts) {
    return this;
  };
  /** @internal */
  Center.prototype.doMouseOver_ = function (evt) {
    return;
  }; // do nothing.
  /** @internal */
  Center.prototype.doMouseOut_ = function (evt) {
    return;
  }; // do nothing.
  /** @internal */
  Center.prototype.doClick_ = function (evt) {
    return;
  }; // do nothing.
  /**
   * @returns The value {@link zul.layout.Borderlayout.CENTER}.
   */
  Center.prototype.getPosition = function () {
    return zul.layout.Borderlayout.CENTER;
  };
  Center = __decorate([zk.WrapClass('zul.layout.Center')], Center);
  return Center;
}(zul.layout.LayoutRegion);
exports.Center = Center;
window.zul.layout.Center_.Center = Center;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/layout/East.ts":
/*!**********************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/layout/East.ts ***!
  \**********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


if (!window.zul) window.zul = {};
if (!window.zul.layout) window.zul.layout = {};
if (!window.zul.layout.East_) window.zul.layout.East_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.East = void 0;
/* East.ts

    Purpose:

    Description:

    History:
        Wed Jan  7 12:14:59     2009, Created by jumperchen

Copyright (C) 2008 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
/**
 * An east region of a border layout.
 * @defaultValue {@link getZclass}: z-east.
 * @defaultValue {@link getCmargins} is "0,0,0,0"</p>
 */
var East = /** @class */function (_super) {
  __extends(East, _super);
  function East() {
    var _this = _super !== null && _super.apply(this, arguments) || this;
    /** @internal */
    _this._sumFlexWidth = true; //indicate shall add this flex width for borderlayout. @See _fixMinFlex in widget.js
    /** @internal */
    _this._maxFlexHeight = true; //indicate shall check if the maximum flex height for borderlayout. @See _fixMinFlex in widget.js
    /** @internal */
    _this._cmargins = [0, 0, 0, 0];
    _this.sanchor = 'r';
    return _this;
  }
  /**
   * The height can't be specified in this component because its height is
   * determined by other region components ({@link North} or {@link South}).
   */
  East.prototype.setHeight = function (height) {
    return this;
  };
  /**
   * @returns The value {@link zul.layout.Borderlayout.EAST}.
   */
  East.prototype.getPosition = function () {
    return zul.layout.Borderlayout.EAST;
  };
  /**
   * @returns the size of this region. This method is shortcut for {@link getWidth}.
   */
  East.prototype.getSize = function () {
    // Bug ZK-1490: Cannot find 'getWidth' method in widget.js
    return this.getWidth();
  };
  /**
   * Sets the size of this region. This method is shortcut for {@link setWidth}.
   */
  East.prototype.setSize = function (size) {
    return this.setWidth(size);
  };
  /** @internal */
  East.prototype._ambit2 = function (ambit, mars, split) {
    ambit.w += split.offsetWidth;
    ambit.h = mars.height;
    ambit.ts = ambit.x + ambit.w + (mars.width - mars.left); // total size;
    ambit.x = ambit.w + (mars.width - mars.left);
  };
  /** @internal */
  East.prototype._reszSp2 = function (ambit, split) {
    ambit.w -= split.w;
    ambit.x += split.w;
    return {
      left: jq.px0(ambit.x - split.w),
      top: jq.px0(ambit.y),
      height: jq.px0(ambit.h)
    };
  };
  East = __decorate([zk.WrapClass('zul.layout.East')], East);
  return East;
}(zul.layout.LayoutRegion);
exports.East = East;
window.zul.layout.East_.East = East;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/layout/LayoutRegion.ts":
/*!******************************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/layout/LayoutRegion.ts ***!
  \******************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


if (!window.zul) window.zul = {};
if (!window.zul.layout) window.zul.layout = {};
if (!window.zul.layout.LayoutRegion_) window.zul.layout.LayoutRegion_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.LayoutRegion = void 0;
/* LayoutRegion.ts

    Purpose:

    Description:

    History:
        Wed Jan  7 12:15:02     2009, Created by jumperchen

Copyright (C) 2008 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
window.zul.layout.LayoutRegion_._setFirstChildFlex = function (wgt, flex, ignoreMin) {
  var cwgt = wgt.getFirstChild();
  if (cwgt) {
    if (flex) {
      wgt._fcvflex = cwgt.getVflex();
      wgt._fchflex = cwgt.getHflex();
      if (!ignoreMin || cwgt._vflex != 'min')
        // B50-ZK-237
        cwgt.setVflex('true');
      if (!ignoreMin || cwgt._hflex != 'min')
        // B50-ZK-237
        cwgt.setHflex('true');
    } else {
      cwgt.setVflex(wgt._fcvflex);
      cwgt.setHflex(wgt._fchflex);
      delete wgt._fcvflex;
      delete wgt._fchflex;
    }
  }
};
/**
 * A layout region in a border layout.
 * <p>
 * Events:<br/> onOpen, onSize, onSlide.<br/>
 */
var LayoutRegion = /** @class */function (_super) {
  __extends(LayoutRegion, _super);
  function LayoutRegion() {
    var _this = _super !== null && _super.apply(this, arguments) || this;
    /** @internal */
    _this._open = true;
    /** @internal */
    _this._border = 'normal';
    /** @internal */
    _this._maxsize = 2000;
    /** @internal */
    _this._minsize = 0;
    /** @internal */
    _this._slidable = true;
    /** @internal */
    _this._closable = true;
    /** @internal */
    _this._nativebar = true;
    /** @internal */
    _this._margins = [0, 0, 0, 0];
    /** @internal */
    _this._cmargins = [3, 3, 3, 3]; //center
    /** @internal */
    _this._collapsible = false;
    /** @internal */
    _this._splittable = false;
    /** @internal */
    _this._flex = false;
    /** @internal */
    _this._autoscroll = false;
    /** @internal */
    _this._slide = false;
    /** @internal */
    _this._isSlide = false;
    return _this;
  }
  LayoutRegion_1 = LayoutRegion;
  /**
   * Sets whether to grow and shrink vertical/horizontal to fit their given
   * space, so called flexibility.
   */
  LayoutRegion.prototype.setFlex = function (flex, opts) {
    var o = this._flex;
    this._flex = flex;
    if (o !== flex || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      window.zul.layout.LayoutRegion_._setFirstChildFlex(this, flex);
      this.rerender();
    }
    return this;
  };
  /**
   * @returns whether to grow and shrink vertical/horizontal to fit their given
   * space, so called flexibility.
   * @defaultValue `false`.
   */
  LayoutRegion.prototype.isFlex = function () {
    return this._flex;
  };
  /**
   * Sets the border (either none or normal).
   * @param border - the border. If null or "0", "none" is assumed.
   */
  LayoutRegion.prototype.setBorder = function (border, opts) {
    var o = this._border;
    this._border = border;
    if (o !== border || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      if (!border || '0' == border) this._border = 'none';
      if (this.desktop) {
        var n = this.$n('real');
        if (n) n._lastSize = undefined;
      }
      this.updateDomClass_();
    }
    return this;
  };
  /**
   * @returns the border.
   * <p>
   * The border actually controls what CSS class to use: If border is null, it
   * implies "none".
   *
   * <p>
   * If you also specify the CSS class ({@link setSclass}), it overwrites
   * whatever border you specify here.
   *
   * @defaultValue `"normal"`.
   */
  LayoutRegion.prototype.getBorder = function () {
    return this._border;
  };
  /**
   * Sets the title.
   */
  LayoutRegion.prototype.setTitle = function (title, opts) {
    var o = this._title;
    this._title = title;
    if (o !== title || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      this.rerender();
    }
    return this;
  };
  /**
   * @returns the title.
   * @defaultValue `null`.
   */
  LayoutRegion.prototype.getTitle = function () {
    return this._title;
  };
  /**
   * Sets whether enable the split functionality.
   */
  LayoutRegion.prototype.setSplittable = function (splittable, opts) {
    var o = this._splittable;
    this._splittable = splittable;
    if (o !== splittable || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      if (this.parent && this.desktop) this.parent.resize();
    }
    return this;
  };
  /**
   * @returns whether enable the split functionality.
   * @defaultValue `false`.
   */
  LayoutRegion.prototype.isSplittable = function () {
    return this._splittable;
  };
  /**
   * Sets the maximum size of the resizing element.
   */
  LayoutRegion.prototype.setMaxsize = function (maxsize) {
    this._maxsize = maxsize;
    return this;
  };
  /**
   * @returns the maximum size of the resizing element.
   * @defaultValue `2000`.
   */
  LayoutRegion.prototype.getMaxsize = function () {
    return this._maxsize;
  };
  /**
   * Sets the minimum size of the resizing element.
   */
  LayoutRegion.prototype.setMinsize = function (minsize) {
    this._minsize = minsize;
    return this;
  };
  /**
   * @returns the minimum size of the resizing element.
   * @defaultValue `0`.
   */
  LayoutRegion.prototype.getMinsize = function () {
    return this._minsize;
  };
  /**
   * Sets whether set the initial display to collapse.
   *
   * <p>It only applied when {@link getTitle} is not null.
   */
  LayoutRegion.prototype.setCollapsible = function (collapsible, opts) {
    var o = this._collapsible;
    this._collapsible = collapsible;
    if (o !== collapsible || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var btn = this.$n(this._open ? 'btn' : 'btned');
      if (btn && (!collapsible || this._closable)) btn.style.display = collapsible ? '' : 'none';
    }
    return this;
  };
  /**
   * @returns whether set the initial display to collapse.
   * @defaultValue `false`.
   */
  LayoutRegion.prototype.isCollapsible = function () {
    return this._collapsible;
  };
  /**
   * Sets whether enable overflow scrolling.
   */
  LayoutRegion.prototype.setAutoscroll = function (autoscroll, opts) {
    var o = this._autoscroll;
    this._autoscroll = autoscroll;
    if (o !== autoscroll || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var cave = this.$n('cave');
      if (cave) {
        var bodyEl = this.isFlex() && this.getFirstChild() ? this.getFirstChild().$n_() : cave;
        if (autoscroll) {
          if (this._nativebar) {
            bodyEl.style.overflow = 'auto';
            bodyEl.style.position = 'relative';
            this.domListen_(bodyEl, 'onScroll');
            zWatch.listen({
              onResponse: this
            });
          } else {
            zWatch.listen({
              onSize: this
            });
          }
        } else {
          if (this._nativebar) {
            bodyEl.style.overflow = 'hidden';
            bodyEl.style.position = '';
            this.domUnlisten_(bodyEl, 'onScroll');
            zWatch.unlisten({
              onResponse: this
            });
          } else {
            zWatch.unlisten({
              onSize: this
            });
          }
        }
        this._fireSizedIfChildFlex();
      }
    }
    return this;
  };
  /**
   * @returns whether enable overflow scrolling.
   * @defaultValue `false`.
   */
  LayoutRegion.prototype.isAutoscroll = function () {
    return this._autoscroll;
  };
  /**
   * Opens or collapses the splitter. Meaningful only if
   * {@link isCollapsible} is not false.
   */
  LayoutRegion.prototype.setOpen = function (open, fromServer, nonAnima) {
    var o = this._open;
    this._open = open;
    if (o !== open || (fromServer === null || fromServer === void 0 ? void 0 : fromServer.force)) {
      if (!this.$n() || !this.isCollapsible() || !this.parent || !fromServer && !this._closable) {
        return this; //nothing changed
      }
      nonAnima = this.parent._animationDisabled || nonAnima;
      var colled = this.$n('colled'),
        real = this.$n_('real');
      if (open) {
        // Bug 2994592
        if (fromServer) {
          // Bug 2995770
          if (!zk(this.$n()).isRealVisible()) {
            if (colled) {
              jq(real).show();
              jq(colled).hide();
            }
            return this;
          }
          var s = real.style;
          s.visibility = 'hidden';
          s.display = '';
          this._syncSize(true);
          s.visibility = '';
          s.display = 'none';
          this._open = true;
        }
        if (colled) {
          if (!nonAnima) zk(colled).slideOut(this, {
            anchor: this.sanchor,
            duration: 200,
            afterAnima: fromServer ? LayoutRegion_1.afterSlideOut : LayoutRegion_1._afterSlideOutX
          });else {
            jq(real).show();
            jq(colled).hide();
            zUtl.fireShown(this);
          }
        }
      } else {
        if (colled && !nonAnima) zk(real).slideOut(this, {
          anchor: this.sanchor,
          beforeAnima: LayoutRegion_1.beforeSlideOut,
          afterAnima: fromServer ? LayoutRegion_1.afterSlideOut : LayoutRegion_1._afterSlideOutX
        });else {
          if (colled) jq(colled).show();
          jq(real).hide();
        }
      }
      if (nonAnima) this.parent.resize();
      if (!fromServer && nonAnima)
        // B50-ZK-301: onOpen is fire after animation
        this.fire('onOpen', {
          open: open
        });
    }
    return this;
  };
  /**
   * @returns whether it is open (i.e., not collapsed. Meaningful only if
   * {@link isCollapsible} is not false.
   * @defaultValue `true`.
   */
  LayoutRegion.prototype.isOpen = function () {
    return this._open;
  };
  /**
   * Slides down or up the region. Meaningful only if
   * {@link isCollapsible} is not false and {@link isOpen} is false.
   * @since 8.0.2
   */
  LayoutRegion.prototype.setSlide = function (slide, fromServer, nonAnima) {
    var o = this._slide;
    this._slide = slide;
    if (o !== slide || (fromServer === null || fromServer === void 0 ? void 0 : fromServer.force)) {
      if (!this._isSlide) {
        this._isSlide = true;
        var real = this.$n_('real'),
          s = real.style;
        s.visibility = 'hidden';
        s.display = '';
        this._syncSize();
        this._original = [s.left, s.top];
        this._alignTo();
        s.zIndex = '100';
        if (this.$n('btn')) this.$n_('btn').style.display = 'none';
        s.visibility = '';
        s.display = 'none';
        jq(this.$n()).addClass(this.$s('slide'));
        zk(real).slideDown(this, {
          anchor: this.sanchor,
          afterAnima: LayoutRegion_1.afterSlideDown
        });
      } else {
        if (nonAnima) LayoutRegion_1.afterSlideUp.call(this, this.$n_('real'));else {
          zk(this.$n('real')).slideUp(this, {
            anchor: this.sanchor,
            afterAnima: LayoutRegion_1.afterSlideUp
          });
        }
      }
      if (!fromServer) this.fire('onSlide', {
        slide: slide
      });
    }
    return this;
  };
  /**
   * @returns whether it is slide down.
   * @defaultValue `false`.
   * @since 8.0.2
   */
  LayoutRegion.prototype.isSlide = function () {
    return this._slide;
  };
  /**
   * Sets whether users can slide (preview) the region when clicked on a collapsed region.
   * Meaningful only if {@link isCollapsible} is true and {@link isOpen} is false.
   *
   * @param slidable - whether users can slide (preview) the region.
   * @since 8.5.2
   */
  LayoutRegion.prototype.setSlidable = function (slidable) {
    this._slidable = slidable;
    return this;
  };
  /**
   * @returns whether users can slide (preview) the region when clicked on a collapsed region.
   * In other words, if false, clicking on a collapsed region will open it instead of sliding.
   * @defaultValue `true`.
   * @since 8.5.2
   */
  LayoutRegion.prototype.isSlidable = function () {
    return this._slidable;
  };
  /**
   * Sets whether users can open or close the region.
   * Meaningful only if {@link isCollapsible} is true.
   *
   * @param closable - whether users can open or close the region.
   * @since 8.5.2
   */
  LayoutRegion.prototype.setClosable = function (closable, opts) {
    var o = this._closable;
    this._closable = closable;
    if (o !== closable || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      if (this.desktop && this._collapsible) {
        jq(this.$n('btn')).toggle(closable);
        jq(this.$n('btned')).toggle(closable);
        jq(this.$n('splitbtn')).toggleClass(this.$s('splitter-button-disabled'), !closable);
      }
    }
    return this;
  };
  /**
   * @returns whether users can open or close the region.
   * In other words, if false, users are no longer allowed to
   * change the open status (by clicking the button on the bar).
   * @defaultValue `true`.
   * @since 8.5.2
   */
  LayoutRegion.prototype.isClosable = function () {
    return this._closable;
  };
  //bug #3014664
  LayoutRegion.prototype.setVflex = function (vflex) {
    if (vflex != 'min') vflex = 'false';
    return _super.prototype.setVflex.call(this, vflex);
  };
  //bug #3014664
  LayoutRegion.prototype.setHflex = function (hflex) {
    if (hflex != 'min') hflex = 'false';
    return _super.prototype.setHflex.call(this, hflex);
  };
  /**
   * @returns the collapsed margins, which is a list of numbers separated by comma.
   * @defaultValue `"3,3,3,3"`.
   */
  LayoutRegion.prototype.getCmargins = function () {
    return zUtl.intsToString(this._open ? this._margins : this._cmargins);
  };
  /**
   * Sets the collapsed margins for the element "0,1,2,3" that direction is
   * "top,left,right,bottom"
   */
  LayoutRegion.prototype.setCmargins = function (cmargins) {
    if (this.getCmargins() != cmargins) {
      this._cmargins = zUtl.stringToInts(cmargins, 0);
      if (this.parent && this.desktop) this.parent.resize();
    }
    return this;
  };
  /**
   * @returns the current margins.
   * @internal
   */
  LayoutRegion.prototype.getCurrentMargins_ = function () {
    return LayoutRegion_1._aryToObject(this._open ? this._margins : this._cmargins);
  };
  /**
   * @returns the margins, which is a list of numbers separated by comma.
   * @defaultValue `"0,0,0,0"`.
   */
  LayoutRegion.prototype.getMargins = function () {
    return zUtl.intsToString(this._margins);
  };
  /**
   * Sets margins for the element "0,1,2,3" that direction is "top,left,right,bottom"
   */
  LayoutRegion.prototype.setMargins = function (margins) {
    if (this.getMargins() != margins) {
      this._margins = zUtl.stringToInts(margins, 0);
      if (this.parent && this.desktop) this.parent.resize();
    }
    return this;
  };
  /** @internal */
  LayoutRegion.prototype.domClass_ = function (no) {
    var /*safe*/scls = _super.prototype.domClass_.call(this, no);
    if (!no || !no.zclass) {
      var added = 'normal' == this.getBorder() ? '' : this.$s('noborder');
      if (added) scls += (scls ? ' ' : '') + added;
    }
    return scls;
  };
  LayoutRegion.prototype.getZclass = function () {
    return this._zclass == null ? 'z-' + this.getPosition() : this._zclass;
  };
  //-- super --//
  /** @internal */
  LayoutRegion.prototype.getMarginSize_ = function (attr) {
    return zk(this.$n('real')).sumStyles(attr == 'h' ? 'tb' : 'lr', jq.margins);
  };
  LayoutRegion.prototype.setWidth = function (width) {
    this._width = width;
    var real = this.$n('real');
    if (real) {
      real.style.width = width ? width : '';
      real._lastSize = undefined;
      this.parent.resize();
    }
    return this;
  };
  LayoutRegion.prototype.setHeight = function (height) {
    this._height = height;
    var real = this.$n('real');
    if (real) {
      real.style.height = height ? height : '';
      real._lastSize = undefined;
      this.parent.resize();
    }
    return this;
  };
  LayoutRegion.prototype.setVisible = function (visible) {
    if (this._visible != visible) {
      _super.prototype.setVisible.call(this, visible);
      var real = this.$n('real'),
        colled = this.$n('colled');
      if (real) {
        if (this._visible) {
          if (this._open) {
            jq(real).show();
            if (colled) jq(colled).hide();
          } else {
            jq(real).hide();
            if (colled) jq(colled).show();
          }
        } else {
          jq(real).hide();
          if (colled) jq(colled).hide();
        }
        this.parent.resize();
      }
    }
    return this;
  };
  //@Override to apply the calculated value on xxx-real element
  /** @internal */
  LayoutRegion.prototype.setFlexSize_ = function (flexSize, isFlexMin) {
    if (this._cssflex && this.parent.getFlexContainer_() != null && !isFlexMin) return;
    var n = this.$n_('real'),
      ns = n.style;
    if (flexSize.height !== undefined) {
      if (flexSize.height == 'auto') ns.height = '';else if (flexSize.height == '') ns.height = this._height ? this._height : '';else {
        var cave = this.$n('cave'),
          cap = this.$n('cap'),
          hgh = cave && this._vflex != 'min' ? cave.offsetHeight + cave.offsetTop : +flexSize.height - zk(n).marginHeight();
        if (cap)
          // B50-ZK-236: add header height
          hgh += cap.offsetHeight;
        ns.height = jq.px0(hgh);
      }
    }
    if (flexSize.width !== undefined) {
      if (flexSize.width == 'auto') n.style.width = '';else if (flexSize.width == '') n.style.width = this._width ? this._width : '';else {
        n.style.width = jq.px0(+flexSize.width - zk(n).marginWidth());
      }
    }
  };
  /** @internal */
  LayoutRegion.prototype.updateDomClass_ = function () {
    if (this.desktop) {
      var real = this.$n('real');
      if (real) {
        /*safe*/real.className = this.domClass_();
        if (this.parent) this.parent.resize();
      }
    }
  };
  /** @internal */
  LayoutRegion.prototype.updateDomStyle_ = function () {
    if (this.desktop) {
      var real = this.$n('real');
      if (real) {
        zk(real).clearStyles().jq.css(jq.parseStyle(this.domStyle_()));
        if (this.parent) this.parent.resize();
      }
    }
  };
  /** @internal */
  LayoutRegion.prototype.onChildAdded_ = function (child) {
    _super.prototype.onChildAdded_.call(this, child);
    if (child instanceof zul.layout.Borderlayout) {
      this._flex = true;
      jq(this.$n()).addClass(this.$s('nested'));
    }
    // Bug for B36-2841185.zul, resync flex="true"
    if (this.isFlex()) window.zul.layout.LayoutRegion_._setFirstChildFlex(this, true, true);
    // reset
    var n = this.$n('real');
    if (n) n._lastSize = undefined;
    if (this.parent && this.desktop) {
      // B65-ZK-1076 for tabpanel, should fix in isRealVisible() when zk 7
      if (this.parent.isRealVisible({
        dom: true
      })) this.parent.resize();
    }
  };
  /** @internal */
  LayoutRegion.prototype.onChildRemoved_ = function (child) {
    _super.prototype.onChildRemoved_.call(this, child);
    // check before "if (child.$instanceof(zul.layout.Borderlayout)) {"
    if (this.isFlex()) window.zul.layout.LayoutRegion_._setFirstChildFlex(this, false);
    if (child instanceof zul.layout.Borderlayout) {
      this._flex = false;
      jq(this.$n_()).removeClass(this.$s('nested'));
    }
    // reset
    var n = this.$n('real');
    if (n) n._lastSize = undefined;
    if (this.parent && this.desktop && !this.childReplacing_) {
      // B65-ZK-1076 for tabpanel, should fix in isRealVisible() when zk 7
      if (this.parent.isRealVisible({
        dom: true
      })) this.parent.resize();
    }
  };
  LayoutRegion.prototype.rerender = function (skipper) {
    _super.prototype.rerender.call(this, skipper);
    if (this.parent) {
      this.parent.resize();
    }
    return this;
  };
  /** @internal */
  LayoutRegion.prototype.bind_ = function (desktop, skipper, after) {
    _super.prototype.bind_.call(this, desktop, skipper, after);
    if (this.getPosition() != zul.layout.Borderlayout.CENTER) {
      var split = this.$n('split');
      if (split) {
        this._fixSplit();
        var vert = this._isVertical(),
          LR = LayoutRegion_1;
        this._drag = new zk.Draggable(this, split, {
          constraint: vert ? 'vertical' : 'horizontal',
          ghosting: LR._ghosting,
          snap: LR._snap,
          zIndex: '12000',
          overlay: true,
          initSensitivity: 0,
          ignoredrag: LR._ignoredrag,
          endeffect: LR._endeffect
        });
        if (!this._open) {
          var colled = this.$n('colled'),
            real = this.$n('real');
          if (colled) jq(colled).show();
          jq(real).hide();
        }
        if (!this._visible) {
          var colled = this.$n('colled'),
            real = this.$n('real');
          jq(real).hide();
          if (colled) jq(colled).hide();
        }
      }
    }
    if (this._open && !this.isVisible()) this.$n_().style.display = 'none';
    if (this.isAutoscroll()) {
      if (this._nativebar) {
        var bodyEl = this.isFlex() && this.getFirstChild() ? this.getFirstChild().$n() : this.$n('cave');
        this.domListen_(bodyEl, 'onScroll');
      } else {
        zWatch.listen({
          onSize: this
        });
      }
    }
    if (this.isFlex()) window.zul.layout.LayoutRegion_._setFirstChildFlex(this, true, true);
  };
  /** @internal */
  LayoutRegion.prototype.unbind_ = function (skipper, after, keepRod) {
    if (this.isAutoscroll()) {
      if (this._nativebar) {
        var bodyEl = this.isFlex() && this.getFirstChild() ? this.getFirstChild().$n() : this.$n('cave');
        this.domUnlisten_(bodyEl, 'onScroll');
      } else {
        zWatch.unlisten({
          onSize: this
        });
      }
    }
    this.destroyBar_();
    if (this.$n('split')) {
      if (this._drag) {
        this._drag.destroy();
        this._drag = undefined;
      }
    }
    if (this.isFlex()) window.zul.layout.LayoutRegion_._setFirstChildFlex(this, false);
    _super.prototype.unbind_.call(this, skipper, after, keepRod);
  };
  /** @internal */
  LayoutRegion.prototype.afterChildMinFlexChanged_ = function (wgt, o) {
    if (this.desktop) {
      var cave = this.$n('cave'),
        real = this.$n('real');
      if (cave) cave.style[o == 'h' ? 'height' : 'width'] = '';
      if (real) real.style[o == 'h' ? 'height' : 'width'] = '';
      // resize again
      this.parent.resize();
    }
  };
  LayoutRegion.prototype.onSize = function () {
    var _this = this;
    // Bug ZK-2784 we should reset the height of the target before doing children's onSize
    if (this._fixBarHeight && this.firstChild) {
      var child = this.firstChild.$n();
      if (child) child.style.height = '';
    }
    setTimeout(function () {
      if (_this.desktop) {
        // ZK-2217: should init scrollbar if the cave first child exists
        var cave = _this.$n('cave');
        if (!_this._scrollbar && !_this._nativebar && cave && cave.firstChild) _this._scrollbar = _this.initScrollbar_();
        _this.refreshBar_();
      }
    }, 200);
  };
  /** @internal */
  LayoutRegion.prototype.initScrollbar_ = function () {
    var _this = this;
    var embed = jq(this.$n_('real')).data('embedscrollbar') !== false,
      // change default value to true since 7.0.2
      cave = this.$n_('cave');
    return new zul.Scrollbar(cave, cave.firstChild, {
      embed: embed,
      onScrollEnd: function () {
        _this._doScroll();
      }
    });
  };
  /** @internal */
  LayoutRegion.prototype.refreshBar_ = function (showBar, scrollToTop) {
    var bar = this._scrollbar;
    if (bar && this._open) {
      var p = this.$n_('cave'),
        fc = this.firstChild,
        fch = fc ? fc.getHeight() : '',
        c = p.firstChild,
        ph = p.offsetHeight;
      while (c && c.nodeType == 3) c = c.nextSibling;
      if (c) {
        var cs = c.style;
        if (!fch || !fch.indexOf('px')) {
          // only recalculate size if no fixed height
          // force to recalculate size
          cs.height = '';
          if (c.offsetHeight) {
            // empty to force recalculate size
          }
          cs.height = jq.px(c.scrollHeight >= ph ? c.scrollHeight : ph);
          this._fixBarHeight = true;
        } else {
          this._fixBarHeight = false;
        }
        bar.scroller = c;
        bar.syncSize(showBar);
        if (scrollToTop) bar.scrollTo(0, 0);
      }
    }
  };
  /** @internal */
  LayoutRegion.prototype.destroyBar_ = function () {
    var bar = this._scrollbar;
    if (bar) {
      bar.destroy();
      delete this._scrollbar;
    }
  };
  /** @internal */
  LayoutRegion.prototype.doResizeScroll_ = function () {
    _super.prototype.doResizeScroll_.call(this);
    this.refreshBar_(true);
  };
  LayoutRegion.prototype.onResponse = function () {
    this._fireSizedIfChildFlex();
  };
  /** @internal */
  LayoutRegion.prototype._fireSizedIfChildFlex = function () {
    // only fire when child has h/vflex
    for (var w = this.firstChild; w; w = w.nextSibling) {
      if (w._nvflex && w._nvflex > 0 || w._nhflex && w._nhflex > 0) {
        zUtl.fireSized(this);
        break;
      }
    }
  };
  /** @internal */
  LayoutRegion.prototype.doClick_ = function (evt, popupOnly) {
    var target = evt.domTarget;
    if (!target.id) target = target.parentNode;
    switch (target) {
      case this.$n('colled'):
      case this.$n('title'):
        if (this._slidable) {
          this.setSlide(!this._isSlide);
          break;
        }
      // fall through if not sildable
      case this.$n('btn'):
      case this.$n('btned'):
      case this.$n('splitbtn'):
        if (!this.isCollapsible() || this._isSlide || zk.animating() || !this._closable) return;
        if (!this._open) {
          var s = this.$n_('real').style;
          s.visibility = 'hidden';
          s.display = '';
          this._syncSize(true);
          s.visibility = '';
          s.display = 'none';
        }
        this.setOpen(!this._open);
        break;
    }
    _super.prototype.doClick_.call(this, evt, popupOnly);
  };
  /** @internal */
  LayoutRegion.prototype._docClick = function (evt) {
    var target = evt.target;
    if (this._isSlide && !jq.isAncestor(this.$n('real'), target)) {
      var btned = this.$n('btned');
      if (this._closable && (btned == target || btned == target.parentNode)) {
        this.setSlide(false, undefined, true);
        this.setOpen(true, undefined, true);
        this.$n_('real').style.zIndex = ''; //reset
      } else if (LayoutRegion_1.uuid(target) != this.uuid || !zk.animating()) {
        this.setSlide(false);
      }
    }
  };
  /** @internal */
  LayoutRegion.prototype._syncSize = function (inclusive) {
    var layout = this.parent,
      el = layout.$n_(),
      width = el.offsetWidth,
      height = el.offsetHeight,
      center = {
        x: 0,
        y: 0,
        w: width,
        h: height
      };
    this._open = true;
    for (var region, rs = ['north', 'south', 'west', 'east'], j = 0, k = rs.length; j < k; ++j) {
      region = layout[rs[j]];
      if (region && (zk(region.$n()).isVisible() || zk(region.$n('colled')).isVisible())) {
        var ignoreSplit = region == this,
          ambit = region._ambit(ignoreSplit),
          LR = LayoutRegion_1;
        switch (rs[j]) {
          case 'north':
          case 'south':
            ambit.w = width - ambit.w;
            if (rs[j] == 'north') center.y = ambit.ts;else ambit.y = height - ambit.y;
            center.h -= ambit.ts;
            if (ignoreSplit) {
              ambit.w = this.$n_('colled').offsetWidth;
              if (inclusive) {
                var cmars = LR._aryToObject(this._cmargins);
                ambit.w += cmars.width;
              }
              layout._resizeWgt(region, ambit, true);
              this._open = false;
              return;
            }
            break;
          default:
            ambit.y += center.y;
            ambit.h = center.h - ambit.h;
            if (rs[j] == 'east') ambit.x = width - ambit.x;else center.x += ambit.ts;
            center.w -= ambit.ts;
            if (ignoreSplit) {
              ambit.h = this.$n_('colled').offsetHeight;
              if (inclusive) {
                var cmars = LR._aryToObject(this._cmargins);
                ambit.h += cmars.height;
              }
              layout._resizeWgt(region, ambit, true);
              this._open = false;
              return;
            }
            break;
        }
      }
    }
  };
  /** @internal */
  LayoutRegion.prototype._alignTo = function () {
    var from = this.$n_('colled'),
      to = this.$n_('real'),
      ts = to.style,
      BL = zul.layout.Borderlayout;
    switch (this.getPosition()) {
      case BL.NORTH:
        ts.top = jq.px(from.offsetTop + from.offsetHeight);
        ts.left = jq.px(from.offsetLeft);
        break;
      case BL.SOUTH:
        ts.top = jq.px(from.offsetTop - to.offsetHeight);
        ts.left = jq.px(from.offsetLeft);
        break;
      case BL.WEST:
        ts.left = jq.px(from.offsetLeft + from.offsetWidth);
        ts.top = jq.px(from.offsetTop);
        break;
      case BL.EAST:
        ts.left = jq.px(from.offsetLeft - to.offsetWidth);
        ts.top = jq.px(from.offsetTop);
        break;
    }
  };
  /** @internal */
  LayoutRegion.prototype._doScroll = function () {
    zWatch.fireDown('onScroll', this);
    zWatch.fire('_onSyncScroll', this); // ZK-4408: for Popup only
  };
  /** @internal */
  LayoutRegion.prototype._fixSplit = function () {
    var split = this.$n('split');
    if (split) split.style.display = this._splittable ? 'block' : 'none';
  };
  /** @internal */
  LayoutRegion.prototype._fixFontIcon = function () {
    zk(this).redoCSS(-1, {
      'fixFontIcon': true,
      'selector': '.z-borderlayout-icon'
    });
  };
  /** @internal */
  LayoutRegion.prototype._isVertical = function () {
    var BL = zul.layout.Borderlayout;
    return this.getPosition() != BL.WEST && this.getPosition() != BL.EAST;
  };
  // returns the ambit of the specified cmp for region calculation.
  /** @internal */
  LayoutRegion.prototype._ambit = function (ignoreSplit) {
    var _a, _b, _c;
    var ambit,
      mars = this.getCurrentMargins_(),
      region = this.getPosition();
    if (region && !this._open) {
      var colled = this.$n('colled');
      ambit = {
        x: mars.left,
        y: mars.top,
        w: colled ? colled.offsetWidth : 0,
        h: colled ? colled.offsetHeight : 0
      };
      ignoreSplit = true;
    } else {
      var pn = this.parent.$n_(),
        w = (_a = this.getWidth()) !== null && _a !== void 0 ? _a : '',
        h = (_b = this.getHeight()) !== null && _b !== void 0 ? _b : '',
        pert;
      ambit = {
        x: mars.left,
        y: mars.top,
        w: (pert = w.indexOf('%')) > 0 ? Math.max(Math.floor(pn.offsetWidth * zk.parseInt(w.substring(0, pert)) / 100), 0) : this.$n_('real').offsetWidth,
        h: (pert = h.indexOf('%')) > 0 ? Math.max(Math.floor(pn.offsetHeight * zk.parseInt(h.substring(0, pert)) / 100), 0) : this.$n_('real').offsetHeight
      };
    }
    var split = ignoreSplit ? {
      offsetHeight: 0,
      offsetWidth: 0
    } : (_c = this.$n('split')) !== null && _c !== void 0 ? _c : {
      offsetHeight: 0,
      offsetWidth: 0
    };
    if (!ignoreSplit) this._fixSplit();
    this._ambit2(ambit, mars, split);
    return ambit;
  };
  /** @internal */
  LayoutRegion.prototype._ambit2 = function (ambit, mars, split) {
    // empty
  };
  /** @internal */
  LayoutRegion.prototype.setBtnPos_ = function (btnPos, ver) {
    var sbtn = this.$n_('splitbtn');
    if (ver) sbtn.style.marginLeft = jq.px0((btnPos.w - sbtn.offsetWidth) / 2);else sbtn.style.marginTop = jq.px0((btnPos.h - sbtn.offsetHeight) / 2);
  };
  /** @internal */
  LayoutRegion.prototype._reszSplt = function (ambit) {
    var split = this.$n_('split'),
      sbtn = this.$n('splitbtn');
    if (zk(split).isVisible()) {
      if (zk(sbtn).isVisible()) {
        this.setBtnPos_(ambit, this._isVertical());
      }
      zk.copy(split.style, this._reszSp2(ambit, {
        w: split.offsetWidth,
        h: split.offsetHeight
      }));
    }
    return ambit;
  };
  /** @internal */
  LayoutRegion.prototype._reszSp2 = function (ambit, split) {
    // empty;
    return {};
  };
  /** @internal */
  LayoutRegion.prototype.getIconClass_ = function (collapsed) {
    var BL = zul.layout.Borderlayout;
    switch (this.getPosition()) {
      case BL.NORTH:
        return collapsed ? 'z-icon-angle-double-down' : 'z-icon-angle-double-up';
      case BL.SOUTH:
        return collapsed ? 'z-icon-angle-double-up' : 'z-icon-angle-double-down';
      case BL.WEST:
        return collapsed ? 'z-icon-angle-double-right' : 'z-icon-angle-double-left';
      case BL.EAST:
        return collapsed ? 'z-icon-angle-double-left' : 'z-icon-angle-double-right';
    }
    return ''; // no icon
  };
  /** @internal */
  LayoutRegion.prototype.titleRenderer_ = function (out) {
    if (this._title) {
      var uuidHTML = this.uuid,
        pos = this.getPosition(),
        noCenter = pos != zul.layout.Borderlayout.CENTER,
        parent = this.parent;
      out.push('<div id="', uuidHTML, '-cap" class="', this.$s('header'), '">');
      if (noCenter) {
        out.push('<i id="', uuidHTML, '-btn" class="', parent.$s('icon'), ' ', /*safe*/this.getIconClass_(), '"');
        if (!this._collapsible || !this._closable) out.push(' style="display:none;"');
        out.push('></i>');
      }
      out.push(zUtl.encodeXML(this._title), '</div>');
    }
  };
  LayoutRegion.prototype.getPosition = function () {
    return '';
  };
  LayoutRegion.prototype.getFirstChild = function () {
    return this.firstChild;
  };
  /** @internal */
  LayoutRegion._aryToObject = function (array) {
    return {
      top: array[0],
      left: array[1],
      width: array[1] + array[2],
      height: array[0] + array[3]
    };
  };
  // invokes border layout's renderer before the component slides out
  LayoutRegion.beforeSlideOut = function (_n) {
    var s = this.$n_('colled').style;
    s.display = '';
    s.visibility = 'hidden';
    s.zIndex = '1';
    this.parent.resize();
  };
  /** @internal */
  LayoutRegion._afterSlideOutX = function (n) {
    // B50-ZK-301: fire onOpen after animation
    LayoutRegion_1.afterSlideOut.call(this, n, true);
    this._fixFontIcon();
  };
  // a callback function after the component slides out.
  LayoutRegion.afterSlideOut = function (n, fireOnOpen) {
    if (this._open) zk(this.$n('real')).slideIn(this, {
      anchor: this.sanchor,
      afterAnima: fireOnOpen ? LayoutRegion_1._afterSlideInX : LayoutRegion_1.afterSlideIn
    });else {
      var colled = this.$n_('colled'),
        s = colled.style;
      s.zIndex = ''; // reset z-index refered to the beforeSlideOut()
      s.visibility = '';
      zk(colled).slideIn(this, {
        anchor: this.sanchor,
        duration: 200,
        // B50-ZK-301: fire onOpen after animation
        afterAnima: fireOnOpen ? function (_n) {
          this.fire('onOpen', {
            open: this._open
          });
        } : zk.$void
      });
    }
    this._fixFontIcon();
  };
  /** @internal */
  LayoutRegion._afterSlideInX = function (n) {
    // B50-ZK-301: fire onOpen after animation
    LayoutRegion_1.afterSlideIn.call(this, n);
    this.fire('onOpen', {
      open: this._open
    });
    this._fixFontIcon();
  };
  // recalculates the size of the whole border layout after the component sildes in.
  LayoutRegion.afterSlideIn = function (_n) {
    this.parent.resize();
    this._fixFontIcon();
  };
  // a callback function after the collapsed region slides down
  LayoutRegion.afterSlideDown = function (_n) {
    jq(document).on('click', this.proxy(this._docClick));
    this._fixFontIcon();
  };
  // a callback function after the collapsed region slides up
  LayoutRegion.afterSlideUp = function (n) {
    var s = n.style;
    s.left = this._original[0];
    s.top = this._original[1];
    n._lastSize = undefined; // reset size for Borderlayout
    s.zIndex = '';
    if (this.$n('btn')) this.$n_('btn').style.display = this._closable ? '' : 'none';
    jq(this.$n_()).removeClass(this.$s('slide'));
    jq(document).off('click', this.proxy(this._docClick));
    this._isSlide = false;
    this._fixFontIcon();
  };
  //drag
  /** @internal */
  LayoutRegion._ignoredrag = function (dg, _pointer, evt) {
    var _a, _b;
    var target = evt.domTarget,
      wgt = dg.control,
      split = wgt.$n_('split');
    if (!target || split != target && !jq.contains(split, target)) return true;
    if (wgt.isSplittable() && wgt._open) {
      var BL = zul.layout.Borderlayout,
        pos = wgt.getPosition(),
        maxs = wgt.getMaxsize(),
        mins = wgt.getMinsize(),
        ol = wgt.parent,
        real = wgt.$n_('real'),
        mars = zul.layout.LayoutRegion._aryToObject(wgt._margins),
        pbw = zk(real).padBorderWidth(),
        lr = pbw + (pos == BL.WEST ? mars.left : mars.width - mars.left),
        tb = pbw + (pos == BL.NORTH ? mars.top : mars.height - mars.top),
        min = 0;
      switch (pos) {
        case BL.NORTH:
        case BL.SOUTH:
          {
            var r = (_a = ol.center) !== null && _a !== void 0 ? _a : pos == BL.NORTH ? ol.south : ol.north;
            if (r) {
              if (BL.CENTER == r.getPosition()) {
                maxs = Math.min(maxs, real.offsetHeight + r.$n_('real').offsetHeight - min);
              } else {
                maxs = Math.min(maxs, ol.$n_().offsetHeight - r.$n_('real').offsetHeight - r.$n_('split').offsetHeight - wgt.$n_('split').offsetHeight - min);
              }
            } else {
              maxs = ol.$n_().offsetHeight - wgt.$n_('split').offsetHeight;
            }
            break;
          }
        case BL.WEST:
        case BL.EAST:
          {
            var r = (_b = ol.center) !== null && _b !== void 0 ? _b : pos == BL.WEST ? ol.east : ol.west;
            if (r) {
              if (BL.CENTER == r.getPosition()) {
                maxs = Math.min(maxs, real.offsetWidth + r.$n_('real').offsetWidth - min);
              } else {
                maxs = Math.min(maxs, ol.$n_().offsetWidth - r.$n_('real').offsetWidth - r.$n_('split').offsetWidth - wgt.$n_('split').offsetWidth - min);
              }
            } else {
              maxs = ol.$n_().offsetWidth - wgt.$n_('split').offsetWidth;
            }
            break;
          }
      }
      var ofs = zk(real).cmOffset();
      dg._rootoffs = {
        maxs: maxs,
        mins: mins,
        top: ofs[1] + tb,
        left: ofs[0] + lr,
        right: real.offsetWidth,
        bottom: real.offsetHeight
      };
      return false;
    }
    return true;
  };
  /** @internal */
  LayoutRegion._endeffect = function (dg, evt) {
    var wgt = dg.control;
    if (wgt._isVertical()) wgt.setHeight("".concat(dg._point[1], "px"));else wgt.setWidth("".concat(dg._point[0], "px"));
    // Bug #1939859
    wgt.$n_().style.zIndex = '';
    dg._rootoffs = dg._point = undefined;
    wgt.parent.resize();
    wgt.fire('onSize', zk.copy({
      width: wgt.$n_('real').style.width,
      height: wgt.$n_('real').style.height
    }, evt.data));
  };
  /** @internal */
  LayoutRegion._snap = function (dg, pointer) {
    var wgt = dg.control,
      x = pointer[0],
      y = pointer[1],
      BL = zul.layout.Borderlayout,
      split = wgt.$n_('split'),
      b = dg._rootoffs,
      w,
      h;
    switch (wgt.getPosition()) {
      case BL.NORTH:
        if (y > b.maxs + b.top) y = b.maxs + b.top;
        if (y < b.mins + b.top) y = b.mins + b.top;
        w = x;
        h = y - b.top;
        break;
      case BL.SOUTH:
        if (b.top + b.bottom - y - split.offsetHeight > b.maxs) {
          y = b.top + b.bottom - b.maxs - split.offsetHeight;
          h = b.maxs;
        } else if (b.top + b.bottom - b.mins - split.offsetHeight <= y) {
          y = b.top + b.bottom - b.mins - split.offsetHeight;
          h = b.mins;
        } else h = b.top - y + b.bottom - split.offsetHeight;
        w = x;
        break;
      case BL.WEST:
        if (x > b.maxs + b.left) x = b.maxs + b.left;
        if (x < b.mins + b.left) x = b.mins + b.left;
        w = x - b.left;
        h = y;
        break;
      case BL.EAST:
        if (b.left + b.right - x - split.offsetWidth > b.maxs) {
          x = b.left + b.right - b.maxs - split.offsetWidth;
          w = b.maxs;
        } else if (b.left + b.right - b.mins - split.offsetWidth <= x) {
          x = b.left + b.right - b.mins - split.offsetWidth;
          w = b.mins;
        } else w = b.left - x + b.right - split.offsetWidth;
        h = y;
        break;
    }
    dg._point = [w, h];
    return [x, y];
  };
  /** @internal */
  LayoutRegion._ghosting = function (dg, ofs, evt) {
    var el = dg.node,
      $el = zk(el);
    jq(document.body).prepend( /*safe*/'<div id="zk_layoutghost" class="z-splitter-ghost" style="font-size:0;line-height:0;background:#AAA;position:absolute;top:' + jq.px(ofs[1]) + ';left:' + jq.px(ofs[0]) + ';width:' + jq.px($el.offsetWidth()) + ';height:' + jq.px($el.offsetHeight()) + ';cursor:' + /*safe*/el.style.cursor + ';"></div>');
    return jq('#zk_layoutghost')[0];
  };
  var LayoutRegion_1;
  LayoutRegion = LayoutRegion_1 = __decorate([zk.WrapClass('zul.layout.LayoutRegion')], LayoutRegion);
  return LayoutRegion;
}(zul.Widget);
exports.LayoutRegion = LayoutRegion;
window.zul.layout.LayoutRegion_.LayoutRegion = LayoutRegion;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/layout/North.ts":
/*!***********************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/layout/North.ts ***!
  \***********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


if (!window.zul) window.zul = {};
if (!window.zul.layout) window.zul.layout = {};
if (!window.zul.layout.North_) window.zul.layout.North_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.North = void 0;
/* North.ts

    Purpose:

    Description:

    History:
        Wed Jan  7 12:14:57     2009, Created by jumperchen

Copyright (C) 2008 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
/**
 * A north region of a border layout.
 * @defaultValue {@link getZclass}: z-north.
 */
var North = /** @class */function (_super) {
  __extends(North, _super);
  function North() {
    var _this = _super !== null && _super.apply(this, arguments) || this;
    /** @internal */
    _this._sumFlexHeight = true; //indicate shall add this flex height for borderlayout. @See _fixMinFlex in widget.js
    _this.sanchor = 't';
    /** @internal */
    _this._cmargins = [0, 0, 0, 0];
    return _this;
  }
  /**
   * The width can't be specified in this component because its width is
   * determined by other region components ({@link West} or {@link East}).
   */
  North.prototype.setWidth = function (width) {
    return this;
  };
  /**
   * @returns The value {@link zul.layout.Borderlayout.NORTH}.
   */
  North.prototype.getPosition = function () {
    return zul.layout.Borderlayout.NORTH;
  };
  /**
   * @returns the size of this region. This method is shortcut for {@link getHeight}.
   */
  North.prototype.getSize = function () {
    return this.getHeight();
  };
  /**
   * Sets the size of this region. This method is shortcut for {@link setHeight}.
   */
  North.prototype.setSize = function (size) {
    return this.setHeight(size);
  };
  /** @internal */
  North.prototype._ambit2 = function (ambit, mars, split) {
    ambit.w = mars.width;
    ambit.h += split.offsetHeight;
    ambit.ts = ambit.y + ambit.h + (mars.height - mars.top); // total size;
  };
  /** @internal */
  North.prototype._reszSp2 = function (ambit, split) {
    ambit.h -= split.h;
    return {
      left: jq.px0(ambit.x),
      top: jq.px0(ambit.y + ambit.h),
      width: jq.px0(ambit.w)
    };
  };
  North = __decorate([zk.WrapClass('zul.layout.North')], North);
  return North;
}(zul.layout.LayoutRegion);
exports.North = North;
window.zul.layout.North_.North = North;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/layout/South.ts":
/*!***********************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/layout/South.ts ***!
  \***********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


if (!window.zul) window.zul = {};
if (!window.zul.layout) window.zul.layout = {};
if (!window.zul.layout.South_) window.zul.layout.South_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.South = void 0;
/* South.ts

    Purpose:

    Description:

    History:
        Wed Jan  7 12:14:58     2009, Created by jumperchen

Copyright (C) 2008 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
/**
 * A south region of a border layout.
 * @defaultValue {@link getZclass}: z-south.
 */
var South = /** @class */function (_super) {
  __extends(South, _super);
  function South() {
    var _this = _super !== null && _super.apply(this, arguments) || this;
    /** @internal */
    _this._sumFlexHeight = true; //indicate shall add this flex height for borderlayout. @See _fixMinFlex in widget.js
    /** @internal */
    _this._cmargins = [0, 0, 0, 0];
    _this.sanchor = 'b';
    return _this;
  }
  /**
   * The width can't be specified in this component because its width is
   * determined by other region components ({@link West} or {@link East}).
   */
  South.prototype.setWidth = function (width) {
    return this;
  };
  /**
   * @returns The value {@link zul.layout.Borderlayout.SOUTH}.
   */
  South.prototype.getPosition = function () {
    return zul.layout.Borderlayout.SOUTH;
  };
  /**
   * @returns the size of this region. This method is shortcut for {@link getHeight}.
   */
  South.prototype.getSize = function () {
    return this.getHeight();
  };
  /**
   * Sets the size of this region. This method is shortcut for {@link setHeight}.
   */
  South.prototype.setSize = function (size) {
    return this.setHeight(size);
  };
  /** @internal */
  South.prototype._ambit2 = function (ambit, mars, split) {
    ambit.w = mars.width;
    ambit.h += split.offsetHeight;
    ambit.ts = ambit.y + ambit.h + (mars.height - mars.top); // total size;
    ambit.y = ambit.h + (mars.height - mars.top);
  };
  /** @internal */
  South.prototype._reszSp2 = function (ambit, split) {
    ambit.h -= split.h;
    ambit.y += split.h;
    return {
      left: jq.px0(ambit.x),
      top: jq.px0(ambit.y - split.h),
      width: jq.px0(ambit.w)
    };
  };
  South = __decorate([zk.WrapClass('zul.layout.South')], South);
  return South;
}(zul.layout.LayoutRegion);
exports.South = South;
window.zul.layout.South_.South = South;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/layout/West.ts":
/*!**********************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/layout/West.ts ***!
  \**********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


/* West.ts

    Purpose:

    Description:

    History:
        Wed Jan  7 12:15:01     2009, Created by jumperchen

Copyright (C) 2008 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
if (!window.zul) window.zul = {};
if (!window.zul.layout) window.zul.layout = {};
if (!window.zul.layout.West_) window.zul.layout.West_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.West = void 0;
/**
 * A west region of a border layout.
 * @defaultValue {@link getZclass}: z-west.
 * @defaultValue {@link getCmargins} is "0,0,0,0"
 */
var West = /** @class */function (_super) {
  __extends(West, _super);
  function West() {
    var _this = _super !== null && _super.apply(this, arguments) || this;
    /** @internal */
    _this._sumFlexWidth = true; //indicate shall add this flex width for borderlayout. @See _fixMinFlex in widget.js
    /** @internal */
    _this._maxFlexHeight = true; //indicate shall check if the maximum flex height for borderlayout. @See _fixMinFlex in widget.js
    _this.sanchor = 'l';
    /** @internal */
    _this._cmargins = [0, 0, 0, 0];
    return _this;
  }
  /**
   * The height can't be specified in this component because its height is
   * determined by other region components ({@link North} or {@link South}).
   */
  West.prototype.setHeight = function (height) {
    return this;
  };
  /**
   * @returns The value {@link zul.layout.Borderlayout.WEST}.
   */
  West.prototype.getPosition = function () {
    return zul.layout.Borderlayout.WEST;
  };
  /**
   * @returns the size of this region. This method is shortcut for {@link getWidth}.
   */
  West.prototype.getSize = function () {
    return this.getWidth();
  };
  /**
   * Sets the size of this region. This method is shortcut for {@link setWidth}.
   */
  West.prototype.setSize = function (size) {
    return this.setWidth(size);
  };
  /** @internal */
  West.prototype._ambit2 = function (ambit, mars, split) {
    ambit.w += split.offsetWidth;
    ambit.h = mars.height;
    ambit.ts = ambit.x + ambit.w + (mars.width - mars.left); // total size;
  };
  /** @internal */
  West.prototype._reszSp2 = function (ambit, split) {
    ambit.w -= split.w;
    return {
      left: jq.px0(ambit.x + ambit.w),
      top: jq.px0(ambit.y),
      height: jq.px0(ambit.h)
    };
  };
  West = __decorate([zk.WrapClass('zul.layout.West')], West);
  return West;
}(zul.layout.LayoutRegion);
exports.West = West;
window.zul.layout.West_.West = West;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/layout/index.ts":
/*!***********************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/layout/index.ts ***!
  \***********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __exportStar = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__exportStar"];


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = {};
__exportStar(__webpack_require__(/*! ./Borderlayout */ "./zul/src/main/resources/web/js/zul/layout/Borderlayout.ts"), exports);
__exportStar(__webpack_require__(/*! ./LayoutRegion */ "./zul/src/main/resources/web/js/zul/layout/LayoutRegion.ts"), exports);
__exportStar(__webpack_require__(/*! ./North */ "./zul/src/main/resources/web/js/zul/layout/North.ts"), exports);
__exportStar(__webpack_require__(/*! ./South */ "./zul/src/main/resources/web/js/zul/layout/South.ts"), exports);
__exportStar(__webpack_require__(/*! ./Center */ "./zul/src/main/resources/web/js/zul/layout/Center.ts"), exports);
__exportStar(__webpack_require__(/*! ./East */ "./zul/src/main/resources/web/js/zul/layout/East.ts"), exports);
__exportStar(__webpack_require__(/*! ./West */ "./zul/src/main/resources/web/js/zul/layout/West.ts"), exports);
__exportStar(__webpack_require__(/*! ./Absolutelayout */ "./zul/src/main/resources/web/js/zul/layout/Absolutelayout.ts"), exports);
__exportStar(__webpack_require__(/*! ./Absolutechildren */ "./zul/src/main/resources/web/js/zul/layout/Absolutechildren.ts"), exports);
__exportStar(__webpack_require__(/*! ./Anchorlayout */ "./zul/src/main/resources/web/js/zul/layout/Anchorlayout.ts"), exports);
__exportStar(__webpack_require__(/*! ./Anchorchildren */ "./zul/src/main/resources/web/js/zul/layout/Anchorchildren.ts"), exports);

/***/ }),

/***/ "./node_modules/tslib/tslib.es6.js":
/*!*****************************************!*\
  !*** ./node_modules/tslib/tslib.es6.js ***!
  \*****************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __addDisposableResource: function() { return /* binding */ __addDisposableResource; },
/* harmony export */   __assign: function() { return /* binding */ __assign; },
/* harmony export */   __asyncDelegator: function() { return /* binding */ __asyncDelegator; },
/* harmony export */   __asyncGenerator: function() { return /* binding */ __asyncGenerator; },
/* harmony export */   __asyncValues: function() { return /* binding */ __asyncValues; },
/* harmony export */   __await: function() { return /* binding */ __await; },
/* harmony export */   __awaiter: function() { return /* binding */ __awaiter; },
/* harmony export */   __classPrivateFieldGet: function() { return /* binding */ __classPrivateFieldGet; },
/* harmony export */   __classPrivateFieldIn: function() { return /* binding */ __classPrivateFieldIn; },
/* harmony export */   __classPrivateFieldSet: function() { return /* binding */ __classPrivateFieldSet; },
/* harmony export */   __createBinding: function() { return /* binding */ __createBinding; },
/* harmony export */   __decorate: function() { return /* binding */ __decorate; },
/* harmony export */   __disposeResources: function() { return /* binding */ __disposeResources; },
/* harmony export */   __esDecorate: function() { return /* binding */ __esDecorate; },
/* harmony export */   __exportStar: function() { return /* binding */ __exportStar; },
/* harmony export */   __extends: function() { return /* binding */ __extends; },
/* harmony export */   __generator: function() { return /* binding */ __generator; },
/* harmony export */   __importDefault: function() { return /* binding */ __importDefault; },
/* harmony export */   __importStar: function() { return /* binding */ __importStar; },
/* harmony export */   __makeTemplateObject: function() { return /* binding */ __makeTemplateObject; },
/* harmony export */   __metadata: function() { return /* binding */ __metadata; },
/* harmony export */   __param: function() { return /* binding */ __param; },
/* harmony export */   __propKey: function() { return /* binding */ __propKey; },
/* harmony export */   __read: function() { return /* binding */ __read; },
/* harmony export */   __rest: function() { return /* binding */ __rest; },
/* harmony export */   __runInitializers: function() { return /* binding */ __runInitializers; },
/* harmony export */   __setFunctionName: function() { return /* binding */ __setFunctionName; },
/* harmony export */   __spread: function() { return /* binding */ __spread; },
/* harmony export */   __spreadArray: function() { return /* binding */ __spreadArray; },
/* harmony export */   __spreadArrays: function() { return /* binding */ __spreadArrays; },
/* harmony export */   __values: function() { return /* binding */ __values; }
/* harmony export */ });
/******************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */
/* global Reflect, Promise, SuppressedError, Symbol */

var extendStatics = function(d, b) {
    extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
    return extendStatics(d, b);
};

function __extends(d, b) {
    if (typeof b !== "function" && b !== null)
        throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
    extendStatics(d, b);
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
}

var __assign = function() {
    __assign = Object.assign || function __assign(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
        }
        return t;
    }
    return __assign.apply(this, arguments);
}

function __rest(s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
}

function __decorate(decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
}

function __param(paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
}

function __esDecorate(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
    function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
    var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
    var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
    var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
    var _, done = false;
    for (var i = decorators.length - 1; i >= 0; i--) {
        var context = {};
        for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
        for (var p in contextIn.access) context.access[p] = contextIn.access[p];
        context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
        var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
        if (kind === "accessor") {
            if (result === void 0) continue;
            if (result === null || typeof result !== "object") throw new TypeError("Object expected");
            if (_ = accept(result.get)) descriptor.get = _;
            if (_ = accept(result.set)) descriptor.set = _;
            if (_ = accept(result.init)) initializers.unshift(_);
        }
        else if (_ = accept(result)) {
            if (kind === "field") initializers.unshift(_);
            else descriptor[key] = _;
        }
    }
    if (target) Object.defineProperty(target, contextIn.name, descriptor);
    done = true;
};

function __runInitializers(thisArg, initializers, value) {
    var useValue = arguments.length > 2;
    for (var i = 0; i < initializers.length; i++) {
        value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
    }
    return useValue ? value : void 0;
};

function __propKey(x) {
    return typeof x === "symbol" ? x : "".concat(x);
};

function __setFunctionName(f, name, prefix) {
    if (typeof name === "symbol") name = name.description ? "[".concat(name.description, "]") : "";
    return Object.defineProperty(f, "name", { configurable: true, value: prefix ? "".concat(prefix, " ", name) : name });
};

function __metadata(metadataKey, metadataValue) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(metadataKey, metadataValue);
}

function __awaiter(thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
}

function __generator(thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
}

var __createBinding = Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
});

function __exportStar(m, o) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(o, p)) __createBinding(o, m, p);
}

function __values(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
}

function __read(o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
}

/** @deprecated */
function __spread() {
    for (var ar = [], i = 0; i < arguments.length; i++)
        ar = ar.concat(__read(arguments[i]));
    return ar;
}

/** @deprecated */
function __spreadArrays() {
    for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
    for (var r = Array(s), k = 0, i = 0; i < il; i++)
        for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
            r[k] = a[j];
    return r;
}

function __spreadArray(to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
}

function __await(v) {
    return this instanceof __await ? (this.v = v, this) : new __await(v);
}

function __asyncGenerator(thisArg, _arguments, generator) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var g = generator.apply(thisArg, _arguments || []), i, q = [];
    return i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i;
    function verb(n) { if (g[n]) i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); }; }
    function resume(n, v) { try { step(g[n](v)); } catch (e) { settle(q[0][3], e); } }
    function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
    function fulfill(value) { resume("next", value); }
    function reject(value) { resume("throw", value); }
    function settle(f, v) { if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]); }
}

function __asyncDelegator(o) {
    var i, p;
    return i = {}, verb("next"), verb("throw", function (e) { throw e; }), verb("return"), i[Symbol.iterator] = function () { return this; }, i;
    function verb(n, f) { i[n] = o[n] ? function (v) { return (p = !p) ? { value: __await(o[n](v)), done: false } : f ? f(v) : v; } : f; }
}

function __asyncValues(o) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var m = o[Symbol.asyncIterator], i;
    return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
    function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
    function settle(resolve, reject, d, v) { Promise.resolve(v).then(function(v) { resolve({ value: v, done: d }); }, reject); }
}

function __makeTemplateObject(cooked, raw) {
    if (Object.defineProperty) { Object.defineProperty(cooked, "raw", { value: raw }); } else { cooked.raw = raw; }
    return cooked;
};

var __setModuleDefault = Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
};

function __importStar(mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
}

function __importDefault(mod) {
    return (mod && mod.__esModule) ? mod : { default: mod };
}

function __classPrivateFieldGet(receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
}

function __classPrivateFieldSet(receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
}

function __classPrivateFieldIn(state, receiver) {
    if (receiver === null || (typeof receiver !== "object" && typeof receiver !== "function")) throw new TypeError("Cannot use 'in' operator on non-object");
    return typeof state === "function" ? receiver === state : state.has(receiver);
}

function __addDisposableResource(env, value, async) {
    if (value !== null && value !== void 0) {
        if (typeof value !== "object" && typeof value !== "function") throw new TypeError("Object expected.");
        var dispose;
        if (async) {
            if (!Symbol.asyncDispose) throw new TypeError("Symbol.asyncDispose is not defined.");
            dispose = value[Symbol.asyncDispose];
        }
        if (dispose === void 0) {
            if (!Symbol.dispose) throw new TypeError("Symbol.dispose is not defined.");
            dispose = value[Symbol.dispose];
        }
        if (typeof dispose !== "function") throw new TypeError("Object not disposable.");
        env.stack.push({ value: value, dispose: dispose, async: async });
    }
    else if (async) {
        env.stack.push({ async: true });
    }
    return value;
}

var _SuppressedError = typeof SuppressedError === "function" ? SuppressedError : function (error, suppressed, message) {
    var e = new Error(message);
    return e.name = "SuppressedError", e.error = error, e.suppressed = suppressed, e;
};

function __disposeResources(env) {
    function fail(e) {
        env.error = env.hasError ? new _SuppressedError(e, env.error, "An error was suppressed during disposal.") : e;
        env.hasError = true;
    }
    function next() {
        while (env.stack.length) {
            var rec = env.stack.pop();
            try {
                var result = rec.dispose && rec.dispose.call(rec.value);
                if (rec.async) return Promise.resolve(result).then(next, function(e) { fail(e); return next(); });
            }
            catch (e) {
                fail(e);
            }
        }
        if (env.hasError) throw env.error;
    }
    return next();
}

/* harmony default export */ __webpack_exports__["default"] = ({
    __extends: __extends,
    __assign: __assign,
    __rest: __rest,
    __decorate: __decorate,
    __param: __param,
    __metadata: __metadata,
    __awaiter: __awaiter,
    __generator: __generator,
    __createBinding: __createBinding,
    __exportStar: __exportStar,
    __values: __values,
    __read: __read,
    __spread: __spread,
    __spreadArrays: __spreadArrays,
    __spreadArray: __spreadArray,
    __await: __await,
    __asyncGenerator: __asyncGenerator,
    __asyncDelegator: __asyncDelegator,
    __asyncValues: __asyncValues,
    __makeTemplateObject: __makeTemplateObject,
    __importStar: __importStar,
    __importDefault: __importDefault,
    __classPrivateFieldGet: __classPrivateFieldGet,
    __classPrivateFieldSet: __classPrivateFieldSet,
    __classPrivateFieldIn: __classPrivateFieldIn,
    __addDisposableResource: __addDisposableResource,
    __disposeResources: __disposeResources,
});


/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	!function() {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = function(exports, definition) {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	!function() {
/******/ 		__webpack_require__.o = function(obj, prop) { return Object.prototype.hasOwnProperty.call(obj, prop); }
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	!function() {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = function(exports) {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	}();
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module is referenced by other modules so it can't be inlined
/******/ 	var __webpack_exports__ = __webpack_require__("./zul/src/main/resources/web/js/zul/layout/index.ts");
/******/ 	var __webpack_export_target__ = window;
/******/ 	var __webpack_exports_export__ = __webpack_exports__["default"];
/******/ 	for(var i in __webpack_exports_export__) __webpack_export_target__[i] = __webpack_exports_export__[i];
/******/ 	if(__webpack_exports_export__.__esModule) Object.defineProperty(__webpack_export_target__, "__esModule", { value: true });
/******/ 	
/******/ })()
;