/******/ (function() { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./extends.js":
/*!********************!*\
  !*** ./extends.js ***!
  \********************/
/***/ (function(__unused_webpack_module, exports) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
/* extends.js

    Purpose:

    Description:

    History:
        1:02 PM 2023/8/21, Created by jumperchen

Copyright (C) 2023 Potix Corporation. All Rights Reserved.
*/
var extendStatics = function (d, b) {
  extendStatics = Object.setPrototypeOf || {
    __proto__: []
  } instanceof Array && function (d, b) {
    d.__proto__ = b;
  } || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
  };
  return extendStatics(d, b);
};
// refer tslib#__extends
function default_1(d, b) {
  extendStatics(d, b);
  function __() {
    this.constructor = d;
  }
  d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  d.prototype._$super = d.name == '$subclass$' && b.prototype._$super ? b.prototype._$super : b.prototype; // Potix: Jumper Chen adds to support `$supers(foo.Bar, 'bind_')`
}
exports["default"] = default_1;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/ContainerWidget.ts":
/*!**************************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/ContainerWidget.ts ***!
  \**************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


/* ContainerWidget.ts

    Purpose:

    Description:

    History:
        Thu Feb 13 12:31:44     2014, Created by NoahHuang

Copyright (C) 2014 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 3.0 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
/** The container related widgets, such as window, groupbox, tabpanel, panelchildren.
 */
//zk.$package('zul');
if (!window.zul) window.zul = {};
if (!window.zul.ContainerWidget_) window.zul.ContainerWidget_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.ContainerWidget = void 0;
/**
 * 	A ContainerWidget.
 *  <p>Note: it remains empty extension for compatibility after ZK-4894
 *  @see zul.wnd.Window
 *  @see zul.wnd.Panelchildren
 *  @see zul.wgt.Groupbox
 *  @see zul.tab.Tabpanel
 *
 */
var ContainerWidget = /** @class */function (_super) {
  __extends(ContainerWidget, _super);
  // eslint-disable-next-line @typescript-eslint/no-useless-constructor
  function ContainerWidget(props) {
    return _super.call(this, props) || this;
  }
  ContainerWidget = __decorate([zk.WrapClass('zul.ContainerWidget')], ContainerWidget);
  return ContainerWidget;
}(zul.Widget);
exports.ContainerWidget = ContainerWidget;
window.zul.ContainerWidget_.ContainerWidget = ContainerWidget;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/LabelImageWidget.ts":
/*!***************************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/LabelImageWidget.ts ***!
  \***************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


/* LabelImageWidget.ts

    Purpose:

    Description:

    History:
        Sun Nov 16 14:59:07     2008, Created by tomyeh

Copyright (C) 2008 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
if (!window.zul) window.zul = {};
if (!window.zul.LabelImageWidget_) window.zul.LabelImageWidget_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.LabelImageWidget = void 0;
/**
 * A skeletal implementation for ZUL widgets that support both label and image.
 */
var LabelImageWidget = /** @class */function (_super) {
  __extends(LabelImageWidget, _super);
  function LabelImageWidget() {
    var _this = _super !== null && _super.apply(this, arguments) || this;
    /** @internal */
    _this._label = '';
    return _this;
  }
  /**
   * Sets the label.
   * Thus, you want to smart-update, you have to override {@link updateDomContent_}.
   */
  LabelImageWidget.prototype.setLabel = function (label, opts) {
    var o = this._label;
    this._label = label;
    if (o !== label || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      if (this.desktop) {
        var n = this.$n();
        // avoid to invalidate the whole widget if only changed by label.
        if (n && n.firstChild == n.lastChild && n.firstChild instanceof Text) {
          jq(n).text(label);
          return this;
        }
        this.updateDomContent_();
      }
    }
    return this;
  };
  /**
   * @returns the label (never null).
   * @defaultValue `""`.
   */
  LabelImageWidget.prototype.getLabel = function () {
    return this._label;
  };
  /**
   * Sets the icon font, if iconSclasses is set, iconSclass will be ignored, iconSclasses will take precedence over iconSclass
   * @param iconSclass - a CSS class name for the icon font
   * @since 7.0.0
   */
  LabelImageWidget.prototype.setIconSclass = function (iconSclass, opts) {
    var o = this._iconSclass;
    this._iconSclass = iconSclass;
    if (o !== iconSclass || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      if (this.desktop) this.updateDomContent_();
    }
    return this;
  };
  /**
   * Sets multiple icons font, if iconSclasses is set, iconSclass will be ignored, iconSclasses will take precedence over iconSclass
   * @param iconSclasses - a CSS class name String array for the icon font
   * @since 10.0.0
   */
  LabelImageWidget.prototype.setIconSclasses = function (iconSclasses, opts) {
    var o = this._iconSclasses;
    this._iconSclasses = iconSclasses;
    if (o !== iconSclasses || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      if (this.desktop) this.updateDomContent_();
    }
    return this;
  };
  /**
   * @returns the CSS class name for the icon font (`iconSclass`)
   * @since 7.0.0
   */
  LabelImageWidget.prototype.getIconSclass = function () {
    return this._iconSclass;
  };
  /**
   * @returns the CSS class name string array for the icon font (`iconSclass`)
   * @since 10.0.0
   */
  LabelImageWidget.prototype.getIconSclasses = function () {
    return this._iconSclasses;
  };
  /**
   * * Sets the iconTooltip, if iconTooltips is set, iconTooltip will be ignored, iconTooltips will take precedence over iconTooltip
   * @param iconTooltip - a content string for iconTooltip
   * @since 10.0.0
   */
  LabelImageWidget.prototype.setIconTooltip = function (iconTooltip, opts) {
    var o = this._iconTooltip;
    this._iconTooltip = iconTooltip;
    if (o !== iconTooltip || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      if (this.desktop) this.updateDomContent_();
    }
    return this;
  };
  /**
   * Sets multiple iconTooltips, if iconTooltips is set, iconTooltip will be ignored, iconTooltips will take precedence over iconTooltip
   * @param iconTooltips - a content string array for iconTooltip
   * @since 10.0.0
   */
  LabelImageWidget.prototype.setIconTooltips = function (iconTooltips, opts) {
    var o = this._iconTooltips;
    this._iconTooltips = iconTooltips;
    if (o !== iconTooltips || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      if (this.desktop) this.updateDomContent_();
    }
    return this;
  };
  /**
   * @returns the iconTooltip content
   * @since 10.0.0
   */
  LabelImageWidget.prototype.getIconTooltip = function () {
    return this._iconTooltip;
  };
  /**
   * @returns the iconTooltip content string array
   * @since 10.0.0
   */
  LabelImageWidget.prototype.getIconTooltips = function () {
    return this._iconTooltips;
  };
  /**
   * Sets the image URI. The image would hide if `src == null`
   * @param image - the URI of the image
   */
  LabelImageWidget.prototype.setImage = function (image, opts) {
    var o = this._image;
    this._image = image;
    if (o !== image || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      if (image && this._preloadImage) zUtl.loadImage(image);
      var n = this.getImageNode(),
        jqn = jq(n);
      if (n) {
        var img = image || '';
        if (jq.nodeName(n, 'img'))
          // ZK-1100
          n.src = img;else jqn.css('background-image', 'url(' + img + ')');
        jqn[!img ? 'hide' : 'show']();
      } else if (this.desktop)
        //<IMG> might not be generated (Bug 3007738)
        this.updateDomContent_();
    }
    return this;
  };
  /**
   * @returns the image URI.
   * @defaultValue `null`.
   */
  LabelImageWidget.prototype.getImage = function () {
    return this._image;
  };
  /**
   * Sets the image URI.
   * The hover image is used when the mouse is moving over this component.
   */
  LabelImageWidget.prototype.setHoverImage = function (hoverImage) {
    this._hoverImage = hoverImage;
    return this;
  };
  /**
   * @returns the URI of the hover image.
   * The hover image is used when the mouse is moving over this component.
   * @defaultValue `null`.
   */
  LabelImageWidget.prototype.getHoverImage = function () {
    return this._hoverImage;
  };
  // for stateless and client mvvm to treat as "image" attribute at client side
  LabelImageWidget.prototype.getImageContent = function () {
    return this.getImage();
  };
  // for stateless and client mvvm to treat as "image" attribute at client side
  LabelImageWidget.prototype.setImageContent = function (imageContent, opts) {
    return this.setImage(imageContent, opts);
  };
  // for stateless and client mvvm to treat as "hoverImage" attribute at client side
  LabelImageWidget.prototype.getHoverImageContent = function () {
    return this.getHoverImage();
  };
  // for stateless and client mvvm to treat as "hoverImage" attribute at client side
  LabelImageWidget.prototype.setHoverImageContent = function (hoverImageContent) {
    return this.setHoverImage(hoverImageContent);
  };
  /**
   * Updates the DOM tree for the modified label and image. It is called by
   * {@link setLabel} and {@link setImage} to update the new content of the
   * label and/or image to the DOM tree.
   * @defaultValue invoke {@link zk.Widget#rerender} to redraw and re-bind.
   * @internal
   */
  LabelImageWidget.prototype.updateDomContent_ = function () {
    this.rerender();
  };
  /**
   * @returns the HTML image content.
   * @internal
   */
  LabelImageWidget.prototype.domImage_ = function () {
    var img = this._image;
    return img ? '<img src="' + zUtl.encodeXMLAttribute(img) + '" align="absmiddle" alt="" aria-hidden="true">' : '';
  };
  /**
   * @returns the icon font class name with HTML content.
   * @since 7.0.0
   * @internal
   */
  LabelImageWidget.prototype.domIcon_ = function () {
    var iconSclass = this.getIconSclass(),
      iconSclasses = this.getIconSclasses(),
      iconTooltip = this.getIconTooltip(),
      iconTooltips = this.getIconTooltips(),
      icon = iconSclasses ? iconSclasses : iconSclass ? [iconSclass] : undefined,
      tooltip = iconTooltips ? iconTooltips : iconTooltip ? [iconTooltip] : undefined;
    if (icon) {
      if (icon.length > 1) {
        var html = '<span class="z-icon-stack" aria-hidden="true">';
        for (var i = 0, icon_length = icon.length; i < icon_length; i++) {
          if (icon[i]) {
            // add icon if icon[i] not undefined
            html += '<i class="' + /*safe*/zUtl.encodeXMLAttribute(icon[i]) + '"';
            if (tooltip === null || tooltip === void 0 ? void 0 : tooltip[i]) {
              // add iconTooltip if iconTooltip[i] not undefined
              html += ' title="' + /*safe*/zUtl.encodeXMLAttribute(tooltip[i]) + '"';
            }
            html += '></i>';
          }
        }
        html += '</span>';
        return html;
      } else {
        return '<i class="' + zUtl.encodeXMLAttribute(icon[0]) + '"' + ((tooltip === null || tooltip === void 0 ? void 0 : tooltip[0]) ? ' title="' + zUtl.encodeXMLAttribute(tooltip[0]) + '"' : '') + ' aria-hidden="true"></i>';
      }
    }
    return '';
  };
  /**
   * @returns the encoded label.
   * @see {@link zUtl.encodeXML}
   * @internal
   */
  LabelImageWidget.prototype.domLabel_ = function () {
    return zUtl.encodeXML(this.getLabel());
  };
  /**
   * @returns the HTML content of the label and image.
   * It is a fragment of HTML that you can use in the mold.
   * @see {@link domImage_}
   * @see {@link domLabel_}
   * @internal
   */
  LabelImageWidget.prototype.domContent_ = function () {
    var labelHTML = this.domLabel_(),
      iconHTML = this.domIcon_(),
      imgHTML = this.domImage_();
    if (imgHTML) {
      if (iconHTML) {
        return imgHTML + ' ' + iconHTML + (labelHTML ? ' ' + labelHTML : '');
      } else {
        return labelHTML ? imgHTML + ' ' + labelHTML : imgHTML;
      }
    } else {
      return iconHTML ? labelHTML ? iconHTML + ' ' + labelHTML : iconHTML : labelHTML;
    }
  };
  /** @internal */
  LabelImageWidget.prototype.doMouseOver_ = function (evt) {
    this._updateHoverImage(true);
    _super.prototype.doMouseOver_.call(this, evt);
  };
  /** @internal */
  LabelImageWidget.prototype.doMouseOut_ = function (evt) {
    this._updateHoverImage();
    _super.prototype.doMouseOut_.call(this, evt);
  };
  /**
   * @returns the image node if any.
   */
  LabelImageWidget.prototype.getImageNode = function () {
    if (!this._eimg && this._image) {
      var n = this.$n();
      if (n) this._eimg = jq(n).find('img:first')[0];
    }
    return this._eimg;
  };
  /** @internal */
  LabelImageWidget.prototype._updateHoverImage = function (inHover) {
    var n = this.getImageNode(),
      img = inHover ? this._hoverImage : this._image;
    if (n && this._hoverImage) {
      if (jq.nodeName(n, 'img')) n.src = img;else jq(n).css('background-image', 'url(' + img + ')');
    }
  };
  LabelImageWidget.prototype.clearCache = function () {
    this._eimg = undefined;
    _super.prototype.clearCache.call(this);
  };
  LabelImageWidget = __decorate([zk.WrapClass('zul.LabelImageWidget')], LabelImageWidget);
  return LabelImageWidget;
}(zul.Widget);
exports.LabelImageWidget = LabelImageWidget;
window.zul.LabelImageWidget_.LabelImageWidget = LabelImageWidget;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/Scrollbar.ts":
/*!********************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/Scrollbar.ts ***!
  \********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


if (!window.zul) window.zul = {};
if (!window.zul.Scrollbar_) window.zul.Scrollbar_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Scrollbar = void 0;
/* Scrollbar.ts

    Purpose:

    Description:
        A scrollbar used for mesh element
    History:
        Thu, May 23, 2013 4:44:22 PM, Created by vincentjian

Copyright (C) 2013 Potix Corporation. All Rights Reserved.

*/
window.zul.Scrollbar_._showScrollbar = function (wgt, orient, opacity) {
  var isHide = opacity == 0,
    bar = wgt.$n(orient),
    embed = wgt.$n(orient + '-embed'),
    style;
  if (bar) {
    style = bar.style;
    style.display = isHide ? 'none' : 'block';
    style.opacity = opacity;
  }
  if (embed) {
    style = embed.style;
    style.display = isHide ? 'block' : 'none';
  }
};
window.zul.Scrollbar_._setScrollPos = function (position, min, max) {
  if (min > max) return position;
  if (position < min) position = min;
  if (position > max) position = max;
  return position;
};
/**
 * A Scrollbar used to replace browser native scrollbar on Mesh Element to
 * navigate the content, such as Grid/Listbox/Tree.
 */
var Scrollbar = /** @class */function (_super) {
  __extends(Scrollbar, _super);
  function Scrollbar(cave, scroller, opts) {
    var _this = _super.call(this) || this;
    /** The container object for this scrolling that user can scroll the whole content
     * @type DOMElement
     */
    //cave: null,
    /** The content inside container object that will be scrolled.
     * @type DOMElement
     */
    //scroller: null,
    /**
     * The opts of this scrollbar controls.
     *
     * <h4>embed</h4>
     * boolean embed
     * <p>Embed the scrollbar inside container or not.
     * @defaultValue `false`
     *
     * <h4>step</h4>
     * int step
     * <p>Specifies scrolling pixels each time click on scroll-bar arrow.
     * @defaultValue `20`
     *
     * <h4>wheelAmountStep</h4>
     * int wheelAmountStep
     * <p>Specifies the multiple of step when mouse wheel scrolling.
     * @defaultValue `3`
     *
     * <h4>startPositionX</h4>
     * int startPositionX
     * <p>Specifies the horizontal scroll-bar start position according to the scrolling area.
     * @defaultValue `0`
     *
     * <h4>startPositionY</h4>
     * int startPositionY
     * <p>Specifies the vertical scroll-bar start position according to the scrolling area.
     * @defaultValue `0`
     *
     * @type Map
     */
    //opts: null,
    /** @internal */
    _this._pos = undefined;
    /** @internal */
    _this._barPos = undefined;
    /** @internal */
    _this._pressTimer = undefined;
    if (!cave || !scroller) throw 'Both wrapper and scroller dom element are required to generate scrollbar';
    //define cave container style to hide native browser scroll-bar
    _this.cave = cave;
    var cs = cave.style;
    cs.position = 'relative';
    cs.overflow = 'hidden';
    //scrolling content
    _this.scroller = scroller;
    //default options
    _this.opts = zk.$default(opts, {
      embed: false,
      step: 20,
      //scrolling pixels
      wheelAmountStep: 3,
      //wheel amount of step
      startPositionX: 0,
      //hor-bar start position
      startPositionY: 0 //ver-bar start position
    });
    _this.widget = zk.Widget.$(cave);
    _this.uid = _this.widget.uuid;
    //initialize scroll-bar position
    _this._pos = [0, 0];
    _this._barPos = [0, 0];
    _this.currentPos = {
      x: _this._pos[0],
      y: _this._pos[1]
    };
    jq(cave)
    //bind scroll event for input tab key scroll
    .on('scroll', _this.proxy(_this._fixScroll))
    //bind mouse enter / mouse leave
    .on('mouseenter', _this.proxy(_this._mouseEnter)).on('mouseleave', _this.proxy(_this._mouseLeave));
    return _this;
  }
  Scrollbar.prototype.$n = function (id) {
    return jq(this.uid + '-' + id, zk)[0];
  };
  Scrollbar.prototype.destroy = function () {
    var cave = this.cave;
    jq(cave)
    //unbind scroll event for input tab scroll
    .off('scroll', this.proxy(this._fixScroll))
    //unbind mouse enter / mouse leave
    .off('mouseenter', this.proxy(this._mouseEnter)).off('mouseleave', this.proxy(this._mouseLeave));
    this._unbindMouseEvent('hor');
    this._unbindMouseEvent('ver');
    var hbar = this.$n('hor'),
      vbar = this.$n('ver');
    if (hbar) jq(hbar).remove();
    if (vbar) jq(vbar).remove();
    if (this.opts.embed) {
      var hembed = this.$n('hor-embed'),
        vembed = this.$n('ver-embed');
      if (hembed) jq(hembed).remove();
      if (vembed) jq(vembed).remove();
    }
    this._pos = this._barPos = this.currentPos = undefined;
  };
  Scrollbar.prototype.hasVScroll = function () {
    return !!this.needV;
  };
  Scrollbar.prototype.hasHScroll = function () {
    return !!this.needH;
  };
  Scrollbar.prototype.syncSize = function (showScrollbar) {
    this._checkBarRequired();
    var wgt = this.widget,
      frozen = wgt.frozen,
      froenScrollWidth = 0,
      tpad = wgt.$n('tpad'),
      bpad = wgt.$n('bpad'),
      cave = this.cave,
      scroller = this.scroller,
      hbar = this.$n('hor'),
      vbar = this.$n('ver'),
      needH = this.needH,
      needV = this.needV,
      opts = this.opts,
      scrollHeight = scroller.scrollHeight;
    if (tpad && bpad)
      //for Mesh Widget ROD
      scrollHeight += tpad.offsetHeight + bpad.offsetHeight;
    if (frozen)
      //for Frozen component
      froenScrollWidth = 50 * (frozen._scrollScale || 0);
    if (needH) {
      var old = hbar.style.display;
      hbar.style.display = 'block'; // for calculate size
      var embed = this.$n('hor-embed'),
        left = this.$n('hor-left'),
        right = this.$n('hor-right'),
        wrapper = this.$n('hor-wrapper'),
        ws = wrapper.style,
        startX = opts.startPositionX,
        wdh = cave.offsetWidth - startX,
        swdh = scroller.scrollWidth - startX + froenScrollWidth,
        lwdh = left.offsetWidth,
        rwdh = right.offsetWidth,
        hwdh = wdh - lwdh - rwdh;
      if (swdh < wdh)
        //only happened with Frozen
        swdh = wdh + froenScrollWidth;
      if (startX) {
        left.style.left = jq.px(startX);
        ws.left = jq.px(startX + lwdh);
        if (embed) embed.style.left = jq.px(startX);
      }
      if (needV) {
        ws.width = jq.px(hwdh - rwdh);
        right.style.right = jq.px(rwdh);
        var oldv = vbar.style.display;
        vbar.style.display = 'block';
        swdh += jq(vbar).outerWidth(true);
        vbar.style.display = oldv;
      } else {
        ws.width = jq.px(hwdh);
      }
      var indicator = this.$n('hor-indicator'),
        wwdh = wrapper.offsetWidth,
        iwdh = Math.round(wwdh * wdh / swdh),
        iwdh = iwdh > 15 ? iwdh : 15;
      indicator.style.width = iwdh + 'px';
      if (embed) embed.style.width = iwdh + lwdh + rwdh + 'px';
      //sync scroller position limit
      this.hLimit = swdh - wdh;
      //sync scroll-bar indicator position limit
      var limit = wwdh - iwdh;
      if (limit <= 0) {
        this.hBarLimit = 0;
        indicator.style.display = 'none';
      } else {
        this.hBarLimit = limit;
      }
      //sync indicator/scroller width ratio
      this.hRatio = Math.abs(this.hLimit / this.hBarLimit);
      hbar.style.display = old; // for calculate size
    }
    if (needV) {
      var old = vbar.style.display;
      vbar.style.display = 'block'; // for calculate size
      var embed = this.$n('ver-embed'),
        up = this.$n('ver-up'),
        down = this.$n('ver-down'),
        wrapper = this.$n('ver-wrapper'),
        ws = wrapper.style,
        startY = opts.startPositionY,
        hgh = cave.offsetHeight - startY,
        shgh = scrollHeight - startY,
        uhgh = up.offsetHeight,
        dhgh = down.offsetHeight,
        vhgh = hgh - uhgh - dhgh;
      if (startY) {
        vbar.style.top = jq.px(cave.offsetTop + startY);
        down.style.bottom = jq.px(startY);
        if (embed) embed.style.top = vbar.style.top;
      }
      if (needH) {
        ws.height = jq.px0(vhgh - dhgh);
        down.style.bottom = jq.px(startY + dhgh);
        var oldh = hbar.style.display;
        hbar.style.display = 'block';
        shgh += jq(hbar).outerHeight(true);
        hbar.style.display = oldh;
      } else {
        ws.height = jq.px(vhgh);
      }
      var indicator = this.$n('ver-indicator'),
        whgh = wrapper.offsetHeight,
        ihgh = Math.round(whgh * hgh / shgh),
        ihgh = ihgh > 15 ? ihgh : 15;
      indicator.style.height = ihgh + 'px';
      if (embed) embed.style.height = ihgh + uhgh + dhgh + 'px';
      //sync scroller position limit
      this.vLimit = shgh - hgh;
      //sync scroll-bar indicator position limit
      var limit = whgh - ihgh;
      if (limit <= 0) {
        this.vBarLimit = 0;
        indicator.style.display = 'none';
      } else {
        this.vBarLimit = limit;
      }
      //sync indicator/scroller width ratio
      this.vRatio = Math.abs(this.vLimit / this.vBarLimit);
      vbar.style.display = old; // for calculate size
    }
    this.scrollTo(this._pos[0], this._pos[1]); //keep scroll position
    if (showScrollbar) {
      window.zul.Scrollbar_._showScrollbar(this, 'hor', 1);
      window.zul.Scrollbar_._showScrollbar(this, 'ver', 1);
    }
  };
  Scrollbar.prototype.scrollTo = function (x, y, time /* Compatibility with IScroll */, relative /* Compatibility with IScroll */) {
    if (this.needH) {
      x = window.zul.Scrollbar_._setScrollPos(x, 0, this.hLimit);
      var barPos = x / this.hRatio;
      this._syncPosition('hor', x);
      this._syncBarPosition('hor', barPos);
      this._syncEmbedBarPosition('hor', x + barPos);
    }
    if (this.needV) {
      y = window.zul.Scrollbar_._setScrollPos(y, 0, this.vLimit);
      var barPos = y / this.vRatio;
      this._syncPosition('ver', y);
      this._syncBarPosition('ver', barPos);
      this._syncEmbedBarPosition('ver', y + barPos);
    }
    //onScrollEnd callback
    this._onScrollEnd();
  };
  Scrollbar.prototype.scrollToElement = function (dom) {
    var cave = this.cave,
      domTop = jq(dom).offset().top,
      domBottom = domTop + dom.offsetHeight,
      domLeft = jq(dom).offset().left,
      domRight = domLeft + dom.offsetWidth,
      viewTop = jq(cave).offset().top,
      viewBottom = viewTop + cave.offsetHeight,
      viewLeft = jq(cave).offset().left,
      viewRight = viewLeft + cave.offsetWidth,
      scrollUp = true,
      // if the offsetWidth are the same, we don't need to move to left.
      scrollLeft = dom.offsetWidth == cave.offsetWidth;
    // Bug ZK-2418 should consider the case when dom size is greater than view size
    if ((domRight >= viewLeft && domRight <= viewRight || domLeft >= viewLeft && domLeft <= viewRight || domLeft <= viewLeft && domRight >= viewRight) && (domTop >= viewTop && domTop <= viewBottom || domBottom >= viewTop && domBottom <= viewBottom || domTop <= viewTop && domBottom >= viewBottom)) {
      return; //already in the view port
    }
    if (domTop < viewTop) scrollUp = false;
    if (domLeft < viewLeft) scrollLeft = false;
    //calculate scrolling movement
    var movementY = scrollUp ? domBottom - viewBottom : viewTop - domTop,
      posY = this._pos[1] + (scrollUp ? movementY : -movementY),
      movementX = scrollLeft ? domRight - viewRight : viewLeft - domLeft,
      posX = this._pos[0] + (scrollLeft ? movementX : -movementX),
      barPos;
    if (this.needV) {
      //set and check if exceed scrolling limit
      posY = window.zul.Scrollbar_._setScrollPos(posY, 0, this.vLimit);
      barPos = posY / this.vRatio;
      //sync scroll position
      this._syncPosition('ver', posY);
      this._syncBarPosition('ver', barPos);
      this._syncEmbedBarPosition('ver', posY + barPos);
    }
    if (this.needH) {
      //set and check if exceed scrolling limit
      posX = window.zul.Scrollbar_._setScrollPos(posX, 0, this.hLimit);
      barPos = posX / this.hRatio;
      //sync scroll position
      this._syncPosition('hor', posX);
      this._syncBarPosition('hor', barPos);
      this._syncEmbedBarPosition('hor', posX + barPos);
    }
    //onScrollEnd callback
    this._onScrollEnd();
    // Bug ZK-2194
    // always sync with native scrollbar, if any.
    zk(dom).scrollIntoView();
  };
  Scrollbar.prototype.isScrollIntoView = function (dom) {
    var cave = this.cave,
      domTop = jq(dom).offset().top,
      domBottom = domTop + dom.offsetHeight,
      domLeft = jq(dom).offset().left,
      domRight = domLeft + dom.offsetWidth,
      viewTop = jq(cave).offset().top,
      viewBottom = viewTop + cave.offsetHeight,
      viewLeft = jq(cave).offset().left,
      viewRight = viewLeft + cave.offsetWidth;
    if (this.needV && domBottom <= viewBottom && domTop >= viewTop || this.needH && domRight <= viewRight && domLeft >= viewLeft) return true;else return false;
  };
  Scrollbar.prototype.getCurrentPosition = function () {
    return this.currentPos;
  };
  Scrollbar.prototype.setBarPosition = function (barPosition) {
    var frozen = this.widget.frozen;
    if (frozen && this.needH) {
      var step = this.hBarLimit / frozen._scrollScale,
        barPos = barPosition * step;
      this._syncBarPosition('hor', barPos);
      this._syncEmbedBarPosition('hor', barPos);
    }
    return this;
  };
  /** @internal */
  Scrollbar.prototype._checkBarRequired = function () {
    var cave = this.cave,
      scroller = this.scroller,
      frozen = this.widget.frozen;
    //check if horizontal scroll-bar required
    this.needH = frozen ? true : cave.offsetWidth < scroller.scrollWidth;
    var hbar = this.$n('hor');
    if (!this.needH) {
      if (hbar) {
        this._unbindMouseEvent('hor');
        this._syncPosition('hor', 0);
        jq(hbar).remove();
        if (this.opts.embed) {
          var hembed = this.$n('hor-embed');
          if (hembed) jq(hembed).remove();
        }
      }
    } else {
      if (!this.$n('hor')) {
        this.redraw(cave, 'hor');
        this._bindMouseEvent('hor');
      }
    }
    //check if vertical scroll-bar required
    this.needV = cave.offsetHeight < scroller.offsetHeight;
    var vbar = this.$n('ver');
    if (!this.needV) {
      if (vbar) {
        this._unbindMouseEvent('ver');
        this._syncPosition('ver', 0);
        jq(vbar).remove();
        if (this.opts.embed) {
          var vembed = this.$n('ver-embed');
          if (vembed) jq(vembed).remove();
        }
      }
    } else {
      if (!vbar) {
        this.redraw(cave, 'ver');
        this._bindMouseEvent('ver');
      }
    }
  };
  /** @internal */
  Scrollbar.prototype._bindMouseEvent = function (orient) {
    var self = this,
      cave = self.cave,
      isH = orient == 'hor',
      bar = self.$n(orient),
      ind = self.$n(orient + '-indicator'),
      rail = self.$n(orient + '-rail'),
      arrow1 = self.$n(orient + (isH ? '-left' : '-up')),
      arrow2 = self.$n(orient + (isH ? '-right' : '-down'));
    if (isH && !zk.opera) {
      //IE and Opera does not support mouse wheel
      jq(cave).mousewheel(self._mousewheelX.bind(self));
    } else {
      jq(cave).mousewheel(self._mousewheelY.bind(self));
    }
    jq(bar).click(zk.$void);
    jq(ind).on('mousedown', self.proxy(self._dragStart));
    jq(rail).on('mousedown', self.proxy(self._mouseDown)).on('mouseup', self.proxy(self._mouseUp));
    jq(arrow1).on('mousedown', self.proxy(self._mouseDown)).on('mouseup', self.proxy(self._mouseUp));
    jq(arrow2).on('mousedown', self.proxy(self._mouseDown)).on('mouseup', self.proxy(self._mouseUp));
  };
  /** @internal */
  Scrollbar.prototype._unbindMouseEvent = function (orient) {
    var self = this,
      cave = self.cave,
      isH = orient == 'hor',
      bar = self.$n(orient),
      ind = self.$n(orient + '-indicator'),
      rail = self.$n(orient + '-rail'),
      arrow1 = self.$n(orient + (isH ? '-left' : '-up')),
      arrow2 = self.$n(orient + (isH ? '-right' : '-down'));
    if (isH && !zk.opera) {
      //IE and Opera does not support mouse wheel
      jq(cave).unmousewheel(self._mousewheelX.bind(self));
    } else {
      jq(cave).unmousewheel(self._mousewheelY.bind(self));
    }
    jq(bar).off('click', zk.$void);
    jq(ind).off('mousedown', self.proxy(self._dragStart));
    jq(rail).off('mousedown', self.proxy(self._mouseDown)).off('mouseup', self.proxy(self._mouseUp));
    jq(arrow1).off('mousedown', self.proxy(self._mouseDown)).off('mouseup', self.proxy(self._mouseUp));
    jq(arrow2).off('mousedown', self.proxy(self._mouseDown)).off('mouseup', self.proxy(self._mouseUp));
  };
  /** @internal */
  Scrollbar.prototype._fixScroll = function (evt) {
    var cave = this.cave;
    if (!this.dragging) this.scrollTo(cave.scrollLeft, cave.scrollTop);
  };
  /** @internal */
  Scrollbar.prototype._mouseEnter = function (evt) {
    window.zul.Scrollbar_._showScrollbar(this, 'hor', 1);
    window.zul.Scrollbar_._showScrollbar(this, 'ver', 1);
  };
  /** @internal */
  Scrollbar.prototype._mouseLeave = function (evt) {
    if (this.dragging) return;
    window.zul.Scrollbar_._showScrollbar(this, 'hor', 0);
    window.zul.Scrollbar_._showScrollbar(this, 'ver', 0);
  };
  /** @internal */
  Scrollbar.prototype._dragStart = function (evt) {
    if (this._pressTimer) {
      //just in case
      clearInterval(this._pressTimer);
      this._pressTimer = undefined;
    }
    evt.preventDefault();
    var self = this,
      orient = self.$n('hor-indicator') == evt.currentTarget ? 'hor' : 'ver',
      isHor = orient == 'hor',
      point = isHor ? evt.pageX : evt.pageY,
      pos = isHor ? self._barPos[0] : self._barPos[1],
      data = {
        orient: orient,
        point: point,
        pos: pos
      };
    jq(document).on('mousemove', data, self.proxy(self._dragMove)).on('mouseup', self.proxy(self._dragEnd));
  };
  /** @internal */
  Scrollbar.prototype._dragEnd = function (evt) {
    var self = this,
      x = evt.pageX,
      y = evt.pageY,
      cave = self.cave,
      left = jq(cave).offset().left,
      top = jq(cave).offset().top;
    jq(document).off('mousemove', self.proxy(self._dragMove)).off('mouseup', self.proxy(self._dragEnd));
    self.dragging = false;
    if (x < left || x > left + cave.offsetWidth || y < top || y > top + cave.offsetHeight) {
      window.zul.Scrollbar_._showScrollbar(self, 'hor', 0);
      window.zul.Scrollbar_._showScrollbar(self, 'ver', 0);
    }
  };
  /** @internal */
  Scrollbar.prototype._dragMove = function (evt) {
    var data = evt.data,
      orient = data.orient,
      point = data.point,
      pos = data.pos,
      isHor = orient == 'hor',
      disp = (isHor ? evt.pageX : evt.pageY) - point,
      barPos = pos + disp,
      limit = isHor ? this.hBarLimit : this.vBarLimit,
      ratio = isHor ? this.hRatio : this.vRatio,
      frozen = this.widget.frozen;
    this.dragging = true;
    //set and check if exceed scrolling limit
    barPos = window.zul.Scrollbar_._setScrollPos(barPos, 0, limit);
    //sync position
    this._syncBarPosition(orient, barPos);
    if (frozen && isHor) {
      var step = limit / frozen._scrollScale;
      frozen._doScroll(barPos / step);
      this._syncEmbedBarPosition('hor', barPos);
    } else {
      var pos = barPos * ratio;
      this._syncPosition(orient, pos);
      this._syncEmbedBarPosition(orient, pos + barPos);
      //onScrollEnd callback
      this._onScrollEnd();
    }
  };
  /** @internal */
  Scrollbar.prototype._mousewheelX = function (evt, delta, deltaX, deltaY) {
    var opts = this.opts,
      step = opts.step * opts.wheelAmountStep,
      pos = this._pos[0];
    if (deltaX) {
      evt.stop();
      //left: -step, right: step
      pos += deltaX > 0 ? -step : step;
      //set and check if exceed scrolling limit
      pos = window.zul.Scrollbar_._setScrollPos(pos + step, 0, this.hLimit);
      //sync position
      var frozen = this.widget.frozen,
        barPos = pos / this.hRatio;
      if (frozen) {
        step = this.hBarLimit / frozen._scrollScale;
        barPos = barPos / step;
        frozen._doScroll(barPos);
        this._syncEmbedBarPosition('hor', barPos);
      } else {
        this._syncPosition('hor', pos);
        this._syncEmbedBarPosition('hor', pos + barPos);
      }
      this._syncBarPosition('hor', barPos);
      //onScrollEnd callback
      this._onScrollEnd();
    }
  };
  /** @internal */
  Scrollbar.prototype._mousewheelY = function (evt, delta, deltaX, deltaY) {
    var opts = this.opts,
      step = opts.step * opts.wheelAmountStep,
      pos = this._pos[1],
      barPos;
    if (deltaY) {
      var scrollUp = deltaY > 0;
      if (scrollUp && pos == 0) return;
      if (!scrollUp && pos == this.vLimit) return;
      evt.stop();
      //up: -step, down: step
      pos += scrollUp ? -step : step;
      //set and check if exceed scrolling limit
      pos = window.zul.Scrollbar_._setScrollPos(pos, 0, this.vLimit);
      barPos = pos / this.vRatio;
      //sync position
      this._syncPosition('ver', pos);
      this._syncBarPosition('ver', barPos);
      this._syncEmbedBarPosition('ver', pos + barPos);
      //onScrollEnd callback
      this._onScrollEnd();
    }
  };
  /** @internal */
  Scrollbar.prototype._mouseUp = function (evt) {
    clearInterval(this._pressTimer);
    this._pressTimer = undefined;
  };
  /** @internal */
  Scrollbar.prototype._mouseDown = function (evt) {
    var _this = this;
    if (this._pressTimer) {
      clearInterval(this._pressTimer);
      this._pressTimer = undefined;
    }
    var target = evt.currentTarget,
      hRail = this.$n('hor-rail'),
      vRail = this.$n('ver-rail'),
      up = this.$n('ver-up'),
      down = this.$n('ver-down'),
      left = this.$n('hor-left'),
      right = this.$n('hor-right'),
      frozen = this.widget.frozen,
      hBarLimit = this.hBarLimit,
      step = frozen ? hBarLimit / frozen._scrollScale : this.opts.step;
    //click on rail
    if (target == hRail || target == vRail) {
      var isHor = target == hRail,
        orient = isHor ? 'hor' : 'ver',
        offset0 = jq(target).offset(),
        offset = isHor ? offset0.left : offset0.top,
        ind = this.$n(orient + '-indicator'),
        indsz = isHor ? ind.offsetWidth : ind.offsetHeight,
        point = (isHor ? evt.pageX : evt.pageY) - offset - indsz / 2,
        limit = isHor ? this.hLimit : this.vLimit,
        ratio = isHor ? this.hRatio : this.vRatio,
        pos = isHor ? this._pos[0] : this._pos[1],
        barPos = isHor ? this._barPos[0] : this._barPos[1],
        pointlimit = point * ratio,
        rstep = step * 10;
      if (frozen) {
        point = window.zul.Scrollbar_._setScrollPos(point, 0, hBarLimit);
        this._syncBarPosition('hor', point);
        this._syncEmbedBarPosition('hor', point);
        frozen._doScroll(point / step);
      } else {
        //setInterval for long press on scroll rail
        this._pressTimer = setInterval(function () {
          var isLeftDown = point > barPos,
            min,
            max,
            bPos;
          min = isLeftDown ? pos : pointlimit;
          min = min < 0 ? 0 : min;
          max = isLeftDown ? pointlimit : pos;
          max = max > limit ? limit : max;
          //left/down: rstep, right/up: -rstep
          pos += isLeftDown ? rstep : -rstep;
          //set and check if exceed scrolling limit
          pos = window.zul.Scrollbar_._setScrollPos(pos, min, max);
          bPos = pos / ratio;
          if (pos == pointlimit || pos <= min || pos >= max) {
            clearInterval(_this._pressTimer);
            _this._pressTimer = undefined;
          }
          //sync position
          _this._syncPosition(orient, pos);
          _this._syncBarPosition(orient, bPos);
          _this._syncEmbedBarPosition(orient, pos + bPos);
          //onScrollEnd callback
          _this._onScrollEnd();
        }, 50);
      }
    }
    //click on arrows
    if (target == left || target == right || target == up || target == down) {
      var isHor = target == left || target == right,
        orient = isHor ? 'hor' : 'ver',
        limit = isHor ? this.hLimit : this.vLimit,
        ratio = isHor ? this.hRatio : this.vRatio,
        pos = isHor ? this._pos[0] : this._pos[1],
        barPos = this._barPos[0];
      //setInterval for long press on arrow button
      this._pressTimer = setInterval(function () {
        if (frozen && isHor) {
          //Frozen Mesh
          barPos += target == left ? -step : step;
          barPos = window.zul.Scrollbar_._setScrollPos(barPos, 0, hBarLimit);
          _this._syncBarPosition(orient, barPos);
          _this._syncEmbedBarPosition(orient, barPos);
          frozen._doScroll(barPos / step);
        } else {
          //horizontal scroll
          if (isHor)
            //left: -step, right: step
            pos += target == left ? -step : step;else
            //up: -step, down: step
            pos += target == up ? -step : step;
          //set and check if exceed scrolling limit
          pos = window.zul.Scrollbar_._setScrollPos(pos, 0, limit);
          barPos = pos / ratio;
          //sync position
          _this._syncPosition(orient, pos);
          _this._syncBarPosition(orient, barPos);
          _this._syncEmbedBarPosition(orient, pos + barPos);
          //onScrollEnd callback
          _this._onScrollEnd();
        }
      }, 50);
    }
  };
  /** @internal */
  Scrollbar.prototype._syncPosition = function (orient, pos) {
    if (!this._pos) return;
    var isH = orient == 'hor',
      cave = this.cave,
      bar = this.$n(orient),
      embed = this.opts.embed;
    if (bar) {
      pos = Math.round(pos);
      this._pos[isH ? 0 : 1] = pos;
      bar.style[isH ? 'left' : 'top'] = pos + 'px';
      if (isH && this.needV) {
        this.$n('ver').style.right = -pos + 'px';
        if (embed) this.$n('ver-embed').style.right = -pos + 'px';
      }
      if (!isH && this.needH) {
        this.$n('hor').style.bottom = -pos + 'px';
        if (embed) this.$n('hor-embed').style.bottom = -pos + 'px';
      }
      cave[isH ? 'scrollLeft' : 'scrollTop'] = pos;
      //onSyncPosition callback
      var onSyncPosition = this.opts.onSyncPosition;
      if (onSyncPosition) {
        this.currentPos = {
          x: this._pos[0],
          y: this._pos[1]
        };
        onSyncPosition.call(this);
      }
    }
  };
  /** @internal */
  Scrollbar.prototype._syncBarPosition = function (orient, pos) {
    var isH = orient == 'hor',
      indicator = this.$n(orient + '-indicator');
    this._barPos[isH ? 0 : 1] = pos;
    indicator.style[isH ? 'left' : 'top'] = pos + 'px';
  };
  /** @internal */
  Scrollbar.prototype._syncEmbedBarPosition = function (orient, pos) {
    if (this.opts.embed) {
      var isH = orient == 'hor',
        embed = this.$n(orient + '-embed'),
        opts = this.opts,
        start = isH ? opts.startPositionX : opts.startPositionY;
      embed.style[isH ? 'left' : 'top'] = pos + start + 'px';
    }
  };
  /** @internal */
  Scrollbar.prototype._onScrollEnd = function () {
    var onScrollEnd = this.opts.onScrollEnd;
    if (onScrollEnd) {
      this.currentPos = {
        x: this._pos[0],
        y: this._pos[1]
      };
      onScrollEnd.call(this);
    }
  };
  Scrollbar.prototype.redraw = function (cave, orient) {
    var isH = orient == 'hor',
      uidHTML = /*safe*/this.uid + '-' + /*safe*/orient,
      hvHTML = isH ? 'horizontal' : 'vertical',
      luHTML = isH ? 'left' : 'up',
      rdHTML = isH ? 'right' : 'down',
      outHTML = '';
    if (this.opts.embed) {
      outHTML += '<div id="' + uidHTML + '-embed" class="z-scrollbar-' + hvHTML + '-embed"></div>';
    }
    outHTML += '<div id="' + uidHTML + '" class="z-scrollbar z-scrollbar-' + hvHTML + '">' + '<div id="' + uidHTML + '-' + luHTML + '" class="z-scrollbar-' + luHTML + '">' + '<i class="z-icon-caret-' + luHTML + '"></i>' + '</div>' + '<div id="' + uidHTML + '-wrapper" class="z-scrollbar-wrapper">' + '<div id="' + uidHTML + '-indicator" class="z-scrollbar-indicator">' + '<i class="z-scrollbar-icon z-icon-reorder"></i></div>' + '<div id="' + uidHTML + '-rail" class="z-scrollbar-rail"></div>' + '</div>' + '<div id="' + uidHTML + '-' + rdHTML + '" class="z-scrollbar-' + rdHTML + '">' + '<i class="z-icon-caret-' + rdHTML + '"></i>' + '</div>' + '</div>';
    jq(cave).append( /*safe*/outHTML);
  };
  Scrollbar = __decorate([zk.WrapClass('zul.Scrollbar')], Scrollbar);
  return Scrollbar;
}(zk.Object);
exports.Scrollbar = Scrollbar;
window.zul.Scrollbar_.Scrollbar = Scrollbar;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/Upload.ts":
/*!*****************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/Upload.ts ***!
  \*****************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


if (!window.zul) window.zul = {};
if (!window.zul.Upload_) window.zul.Upload_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.UploadViewer = exports.Uploader = exports.Upload = void 0;
/* Upload.ts

    Purpose:

    Description:

    History:
        Fri Jul 17 16:44:50     2009, Created by tomyeh

Copyright (C) 2009 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
window.zul.Upload_._cancel = function (o, sid, finish) {
  var key = o.getKey(sid),
    uplder = o.uploaders[key];
  if (uplder) uplder.destroy(finish);
  delete o.uploaders[key];
};
window.zul.Upload_._initUploader = function (o, form, val) {
  var key = o.getKey(o.sid),
    uplder = new zul.Uploader(o, key, form, val);
  if (zul.Upload.start(uplder)) o.uploaders[key] = uplder;
};
window.zul.Upload_._start = function (o, form, val) {
  // delete old upload temp file, if it's not uploaded yet.
  var oldKey = o.getKey(o.sid - 1),
    oldUploader = o.uploaders[oldKey];
  if (oldUploader && oldUploader.isStart && !zk.processing) {
    // delete the old file
    window.zul.Upload_._cancel(o, o.sid - 1, false);
  }
  //B50-ZK-255: FileUploadBase$SizeLimitExceededException
  //will not warning in browser
  window.zul.Upload_._initUploader(o, form, val);
  o.sid++;
  o.initContent();
};
window.zul.Upload_._onchange = function (_evt) {
  var n = this,
    upload = n._ctrl,
    form = n.form,
    // we don't use jq().remove() in this case, because we have to use its reference.
    p = form.parentNode;
  p.parentNode.removeChild(p);
  upload._formDetached = true;
  var fileName = !n.files || n.files.length == 1 ? n.value : function (files) {
    var fns = [];
    for (var len = files.length; len--;) fns.unshift(files[len].name);
    return fns.join(',');
  }(n.files);
  window.zul.Upload_._start(n._ctrl, form, fileName);
};
if (zk.opera) {
  //opera only
  var _syncQue = [],
    _syncId,
    _syncNow = function () {
      for (var j = _syncQue.length; j--;) _syncQue[j].sync();
    },
    _addSyncQue = function (upld) {
      if (!_syncQue.length) _syncId = setInterval(_syncNow, 1500);
      _syncQue.push(upld);
    },
    _rmSyncQue = function (upld) {
      _syncQue.$remove(upld);
      if (_syncId && !_syncQue.length) {
        clearInterval(_syncId);
        _syncId = undefined;
      }
    };
}
/** Helper class for implementing the fileupload.
 */
var Upload = /** @class */function (_super) {
  __extends(Upload, _super);
  /**
   * @param wgt - the widget belongs to the file upload
   * @param parent - the element representing where the upload element
   * 		is appended
   * @param option - the upload option.
   *      It contains upload options like maxsize, multiple, and so on.
   *      It specifies the widget class name of the fileupload.
   */
  function Upload(wgt, parent, option) {
    var _this = _super.call(this) || this;
    _this.sid = 0;
    _this.uploaders = {};
    _this.suppressedErrors = [];
    var cls;
    for (var attrs = option.split(','), i = 0, len = attrs.length; i < len; i++) {
      var attr = attrs[i].trim();
      if (attr.startsWith('maxsize=')) _this.maxsize = attr.match(new RegExp(/maxsize=([^,]*)/))[1];else if (attr.startsWith('multiple=')) _this.multiple = attr.match(new RegExp(/multiple=([^,]*)/))[1];else if (attr.startsWith('accept=')) _this.accept = attr.match(new RegExp(/accept=([^,]*)/))[1];else if (attr.startsWith('suppressedErrors=')) _this.suppressedErrors = attr.match(new RegExp(/suppressedErrors=([^,]*)/))[1].split('|');else if (attr == 'native') _this.isNative = true;else if (attr != 'true') cls = attr;
    }
    _this._clsnm = cls !== null && cls !== void 0 ? cls : '';
    _this._wgt = wgt;
    _this._parent = parent;
    if (wgt._tooltiptext)
      // ZK-751
      _this._tooltiptext = wgt._tooltiptext;
    _this.initContent();
    return _this;
  }
  /**
   * Synchronizes the visual states of the element with fileupload
   */
  Upload.prototype.sync = function () {
    if (!this._formDetached) {
      var wgt = this._wgt,
        ref = wgt.$n(),
        parent = this._parent,
        outer = parent ? parent.lastChild : ref.nextSibling,
        inp = outer.firstChild.firstChild,
        refof = zk(ref).revisedOffset(),
        outerof = jq(outer).css({
          top: '0',
          left: '0'
        }).zk.revisedOffset(),
        st = outer.style;
      st.top = refof[1] - outerof[1] + 'px';
      st.left = refof[0] - outerof[0] + 'px';
      inp.style.height = '0px';
      inp.style.width = '0px'; // ZK-4222: Replace deprecated CSS property clip:rect(...)
    }
  };
  Upload.prototype.initContent = function () {
    var wgt = this._wgt,
      parent = this._parent,
      ref = wgt.$n(),
      html = '<span class="z-upload"' + (this._tooltiptext ? ' title="' + zUtl.encodeXML(this._tooltiptext) + '"' : '') // ZK-751
      + '><form enctype="multipart/form-data" method="POST">' + '<input name="file" type="file"'
      // multiple="" for Firefox, multiple for Chrome
      + (this.multiple == 'true' ? ' multiple="" multiple' : '') + (this.accept ? ' accept="' + this.accept.replace(new RegExp('\\|', 'g'), ',') + '"' : '') + ' hidefocus="true" tabindex="-1" style="height:' + ref.offsetHeight + 'px"/></form></span>';
    if (parent) jq(parent).append(DOMPurify.sanitize(html));else jq(wgt).after(DOMPurify.sanitize(html));
    delete this._formDetached;
    //B50-3304877: autodisable and Upload
    if (!wgt._autodisable_self) {
      var self = this;
      //B65-ZK-2111: Sync later to prevent the external style change button offset height/width.
      setTimeout(function () {
        self.sync();
      }, 50);
    }
    var outer = this._outer = parent ? parent.lastChild : ref.nextSibling,
      inp = outer.firstChild.firstChild;
    this._inp = inp;
    if (zk.opera) {
      //in opera, relative not correct (test2/B50-ZK-363.zul)
      outer.style.position = 'absolute';
      _addSyncQue(this);
    }
    inp.z$proxy = ref;
    inp._ctrl = this;
    jq(inp).change(window.zul.Upload_._onchange);
  };
  /**
   * trigger file input's click to open file dialog
   */
  Upload.prototype.openFileDialog = function () {
    jq(this._inp).click();
  };
  /**
   * Destroys the fileupload. You cannot use this object any more.
   */
  Upload.prototype.destroy = function () {
    if (zk.opera) _rmSyncQue(this);
    jq(this._outer).remove();
    this._inp = undefined;
    this._wgt = this._parent = undefined;
    for (var v in this.uploaders) {
      var uplder = this.uploaders[v];
      if (uplder) {
        delete this.uploaders[v];
        uplder.destroy();
      }
    }
  };
  /**
   * @returns the uuid of the uploader with its sequential number
   */
  Upload.prototype.getKey = function (sid) {
    return (this._wgt ? this._wgt.uuid : '') + '_uplder_' + sid;
  };
  /**
   * Cancels the fileupload if the fileupload is progressing.
   * @param sid - the sequential number of the uploader
   */
  Upload.prototype.cancel = function (sid) {
    window.zul.Upload_._cancel(this, sid);
  };
  /**
   * Finishes the fileupload if the fileupload is done.
   * @param sid - the sequential number of the uploader
   */
  Upload.prototype.finish = function (sid) {
    window.zul.Upload_._cancel(this, sid, true);
  };
  Upload.prototype.getFile = function () {
    var uploader = this.uploaders[this.getKey(this.sid - 1)];
    if (uploader) {
      return uploader.getFile();
    }
    return undefined;
  };
  /**
   * Shows the error message of the fileupload
   * @param msg - the error message
   * @param uuid - the ID of the widget
   * @param sid - the sequential number of the uploader
   */
  Upload.error = function (msg, uuid, sid) {
    var wgt = zk.Widget.$(uuid);
    if (wgt) {
      var errorType,
        matched = msg.match('^([\\w-]+?):'),
        uploader = wgt._uplder,
        suppressedErrors = uploader ? uploader.suppressedErrors : [];
      if (matched) {
        msg = msg.replace(matched[0], '');
        errorType = matched[1];
      }
      if (!errorType || !suppressedErrors.includes(errorType)) {
        jq.alert(msg, {
          desktop: wgt.desktop,
          icon: 'ERROR'
        });
      }
      zul.Upload.close(uuid, sid);
    }
  };
  /**
   * Closes the fileupload
   * @param uuid - the ID of the widget
   * @param sid - the sequential number of the uploader
   */
  Upload.close = function (uuid, sid) {
    var wgt = zk.Widget.$(uuid);
    if (!wgt || !wgt._uplder) return;
    wgt._uplder.cancel(sid);
  };
  /**
   * Sends the upload result to server.
   * @param uuid - the ID of the widget
   * @param contentId - the ID of the content being uploaded
   * @param sid - the sequential number of the uploader
   */
  Upload.sendResult = function (uuid, contentId, sid) {
    var wgt = zk.Widget.$(uuid);
    if (!wgt || !wgt._uplder) return;
    wgt._uplder.finish(sid);
    zAu.send(new zk.Event(wgt.desktop, 'updateResult', {
      contentId: contentId,
      wid: wgt.uuid,
      sid: sid
    }));
  };
  /**
   * @returns the fileupload of the widget whether is finish or not.
   * @param wgt - the widget
   */
  Upload.isFinish = function (wgt) {
    for (var key = (typeof wgt == 'string' ? wgt : wgt.uuid) + '_uplder_', f = zul.Upload.files, i = f.length; i--;) if (f[0].id.startsWith(key)) return false;
    return true;
  };
  /**
   * Starts the uploader to upload a file.
   * @param uplder - the uploader
   */
  Upload.start = function (uplder) {
    var files = zul.Upload.files;
    if (uplder) files.push(uplder);
    if (files[0] && !files[0].isStart) {
      files[0].isStart = true;
      return files[0].start();
    }
    return true;
  };
  /**
   * Destroys the uploader to upload
   */
  Upload.destroy = function (uplder) {
    for (var files = zul.Upload.files, i = files.length; i--;) if (files[i].id == uplder.id) {
      files.splice(i, 1);
      break;
    }
    zul.Upload.start();
  };
  Upload.files = [];
  Upload = __decorate([zk.WrapClass('zul.Upload')], Upload);
  return Upload;
}(zk.Object);
exports.Upload = Upload;
/**
 * @defaultValue file uploader for the upload widget.
 * <p> One upload widget can have multi-instance of uploader to upload multiple
 * files at the same time.
 */
var Uploader = /** @class */function (_super) {
  __extends(Uploader, _super);
  /**
   * @param upload - the upload object belong to the file uploader
   * @param id - the ID of the uploader
   * @param form - the element representing where the uploader element is appended
   * @param flnm - the name of the file to be uploaded
   */
  function Uploader(upload, id, form, flnm) {
    var _this = _super.call(this) || this;
    _this.id = id;
    _this.flnm = flnm;
    _this._upload = upload;
    _this._form = form;
    _this._parent = form.parentNode;
    _this._sid = upload.sid;
    _this._wgt = upload._wgt;
    var viewer,
      self = _this;
    if (!upload._clsnm) viewer = new zul.UploadViewer(_this, flnm);else zk.$import(upload._clsnm, function (cls) {
      viewer = new cls(self, flnm);
    });
    _this.viewer = viewer;
    return _this;
  }
  Uploader.prototype.getFile = function () {
    return this._form ? this._form[0].files : undefined;
  };
  /**
   * @returns the widget which the uploader belongs to.
   */
  Uploader.prototype.getWidget = function () {
    return this._wgt;
  };
  /**
   * Destroys the uploader to upload.
   * @param finish - if true, the upload is finish.
   */
  Uploader.prototype.destroy = function (finish) {
    this.end(finish);
    if (this._form) {
      jq(this._form.parentNode).remove();
      jq('#' + this.id + '_ifm').remove();
    }
    this._form = undefined;
    this._upload = this._wgt = undefined;
  };
  /**
   * Starts the uploader to upload
   */
  Uploader.prototype.start = function () {
    var wgt = this._wgt;
    if (this._passSizeCheck()) {
      wgt.fire('onUpload', {
        file: this._form[0].files
      }, {
        uploadCallback: {
          onprogress: this._onprogress(),
          onload: this._onload()
        }
      });
      //B50-3304877: autodisable and Upload
      zul.wgt.ADBS.autodisable(wgt); // FIXME: type of `wgt` should be made more explicit
      return true;
    }
    return false;
  };
  /** @internal */
  Uploader.prototype._passSizeCheck = function () {
    var uploadMaxsize = this._upload.maxsize,
      maxBytes = uploadMaxsize > 0 ? uploadMaxsize * 1024 : -1;
    if (maxBytes != -1) {
      var files = this._form[0].files,
        sizeBytes = 0;
      for (var i = 0; i < files.length; i++) {
        sizeBytes += files[i].size;
      }
      if (sizeBytes > maxBytes) {
        this._showMaxsizeErrorAndDestroy(sizeBytes, maxBytes);
        return false;
      }
    }
    return true;
  };
  /** @internal */
  Uploader.prototype._showMaxsizeErrorAndDestroy = function (sizeBytes, maxBytes) {
    var uploader = this;
    zk.load('zk.fmt', function () {
      var kb = ' ' + msgzk.KBYTES,
        mb = ' ' + msgzk.MBYTES,
        sizeKB = Math.round(sizeBytes / 1024),
        maxKB = Math.round(maxBytes / 1024),
        sizeMB = Math.round(sizeKB / 1024),
        maxMB = Math.round(maxKB / 1024),
        formatFileSize = zk.fmt.Text.formatFileSize,
        errorMessage = zk.fmt.Text.format(msgzul.UPLOAD_ERROR_EXCEED_MAXSIZE, formatFileSize(sizeBytes), formatFileSize(maxBytes), sizeBytes, maxBytes, sizeKB + kb, maxKB + kb, sizeMB + mb, maxMB + mb);
      zul.Upload.error('size-limit-exceeded:' + errorMessage, uploader._wgt.uuid, uploader._sid);
      uploader.destroy();
    });
  };
  /** @internal */
  Uploader.prototype._onprogress = function () {
    var viewer = this.viewer,
      wgt = this._wgt;
    return function (event) {
      wgt._uploading = true;
      var total = event.total,
        percentage = event.loaded / total * 100;
      viewer.update(percentage, total);
    };
  };
  /** @internal */
  Uploader.prototype._onload = function () {
    var uploader = this,
      wgt = this._wgt;
    return function (_event) {
      if (this.readyState === 4) {
        wgt._uploading = false;
        if (this.status === 200) {
          wgt._uplder.finish(uploader._sid);
        } else {
          zul.Upload.error('server-out-of-service:' + this.statusText, wgt.uuid, uploader._sid);
        }
      }
    };
  };
  /**
   * Cancels the uploader to upload.
   */
  Uploader.prototype.cancel = function () {
    if (this._upload) this._upload.cancel(this._sid);
  };
  /**
   * Updates the status of the file being uploaded.
   * @param sent - how many percentage being sent
   * @param total - the size of the file
   */
  Uploader.prototype.update = function (sent, total) {
    var wgt = this.getWidget();
    if (!wgt || total <= 0) {
      if (this._echo) this.end();else return true; // B50-3309632: server may not even see the file yet, keep asking
    } else if (zul.Uploader._tmupload) {
      this._echo = true;
      if (sent >= 0 && sent <= 100) this.viewer.update(sent, total);
      return sent >= 0 && sent < 100;
    }
    return false;
  };
  /**
   * Ends the uploader to upload.
   * @param finish - whether the file is finish.
   */
  Uploader.prototype.end = function (finish) {
    this.viewer.destroy(finish);
    zul.Upload.destroy(this);
    this._echo = true;
    //B50-3304877: autodisable and Upload
    var wgt, upload, aded, parent;
    if ((wgt = this._wgt) && (upload = this._upload) && (aded = upload._aded)) {
      wgt._uplder = undefined; // prevent destory during onResponse(sync disabled status by rerender will destory _uplder)
      aded.onResponse();
      upload._aded = undefined;
      //restore uploader
      wgt._uplder.destroy();
      if ((parent = upload._parent) && !jq(parent).parents('html').length) {
        upload._parent = wgt._getUploadRef();
        upload.initContent();
      }
      wgt._uplder = upload;
      wgt._uplder.sync();
      delete wgt._autodisable_self;
    }
  };
  Uploader = __decorate([zk.WrapClass('zul.Uploader')], Uploader);
  return Uploader;
}(zk.Object);
exports.Uploader = Uploader;
// default UploadViewer
window.zul.Upload_._addUM = function (uplder, _flnm) {
  var wgt = uplder.getWidget(),
    flman = zul.UploadViewer.flman;
  if (!wgt) return;
  if (!flman || !flman.desktop) {
    if (flman) flman.detach();
    zul.UploadViewer.flman = flman = new zul.UploadManager();
    wgt.getPage().appendChild(flman);
  }
  flman.removeFile(uplder);
  flman.addFile(uplder);
};
window.zul.Upload_._initUM = function (uplder, flnm) {
  if (zul.UploadManager) return window.zul.Upload_._addUM(uplder, flnm);
  zk.load('zul.wgt,zul.box', function () {
    /**
     * @defaultValue file upload manager to manage the uploading files in a panel.
     * Users can add/delete the file upon the panel.
     */
    // @zk.WrapClass('zul.UploadManager')
    var UploadManager = /** @class */function (_super) {
      __extends(UploadManager, _super);
      function UploadManager() {
        var _this = _super.call(this) || this;
        _this._files = {};
        _this.setSclass('z-fileupload-manager');
        return _this;
      }
      UploadManager.prototype.onFloatUp = function (_ctl) {
        if (!this.isVisible()) return;
        this.setTopmost();
      };
      /**
       * @returns the file item.
       * @param id - the ID of the file or the ID of upload widget
       */
      UploadManager.prototype.getFileItem = function (id) {
        return this._files[id] || zk.Widget.$(id);
      };
      /**
       * Adds the file item to upload.
       * @returns the file item {@link zul.wgt.Div} widget
       */
      UploadManager.prototype.addFile = function (uplder) {
        var id = uplder.id,
          flnm = uplder.flnm,
          prog = this.getFileItem(id);
        if (!prog) {
          prog = new zul.wgt.Div({
            uuid: id,
            children: [new zul.wgt.Label({
              value: flnm + ':'
            }), new zul.box.Box({
              mold: 'horizontal',
              children: [new zul.wgt.Progressmeter({
                id: id,
                sclass: 'z-fileupload-progress'
              }), new zul.wgt.Div({
                sclass: 'z-fileupload-remove z-icon-times',
                listeners: {
                  onClick: function () {
                    uplder.cancel();
                  }
                }
              })]
            }), new zul.wgt.Label({
              id: id + '_total'
            }), new zul.wgt.Separator()]
          });
          // Bug 2987059: IE may cause JS error in the appendChild()
          try {
            this.appendChild(prog);
          } catch (e) {
            zk.debugLog(e.message || e);
          }
          this._files[id] = prog;
        }
        return prog;
      };
      /**
       * Updates the status of the file item.
       * @param val - how many percentage being uploaded
       * @param total - the size of the file
       */
      UploadManager.prototype.updateFile = function (uplder, val, total) {
        var id = uplder.id,
          prog = this.getFileItem(id);
        if (!prog) return;
        prog.$f(id).setValue(val);
        prog.$f(id + '_total').setValue(total);
      };
      /**
       * Removes the file item.
       */
      UploadManager.prototype.removeFile = function (uplder) {
        var id = uplder.id,
          prog = this.getFileItem(id);
        if (prog) prog.detach();
        delete this._files[id];
        var close = Object.keys(this._files).length === 0;
        if (close) this.close();
      };
      /**
       * Opens the file manager to show.
       * @param wgt - the wgt where the file manager is shown
       * @param position - the position where the file manager is located
       */
      // @ts-expect-error: signature doesn't match that of super
      UploadManager.prototype.open = function (wgt, position) {
        _super.prototype.open.call(this, wgt, undefined, position || 'after_start', {
          sendOnOpen: false,
          disableMask: true
        });
      };
      return UploadManager;
    }(zul.wgt.Popup);
    zul.UploadManager = zk.regClass(UploadManager);
    window.zul.Upload_._addUM(uplder, flnm);
  });
};
/**
 * @defaultValue file viewer to see the upload status.
 */
var UploadViewer = /** @class */function (_super) {
  __extends(UploadViewer, _super);
  /**
   * @param flnm - the name of the file to be uploaded
   */
  function UploadViewer(uplder, flnm) {
    var _this = _super.call(this) || this;
    _this._uplder = uplder;
    window.zul.Upload_._initUM(uplder, flnm);
    return _this;
  }
  /**
   * Updates the status of the file being uploaded.
   * @param sent - how many percentage being sent
   * @param total - the size of the file
   */
  UploadViewer.prototype.update = function (sent, total) {
    var flman = zul.UploadViewer.flman;
    if (flman) {
      if (!flman.isOpen()) flman.open(this._uplder.getWidget());
      var acc = msgzk.FILE_SIZE + Math.round(total / 1024) + msgzk.KBYTES;
      flman.updateFile(this._uplder, sent, acc);
    }
  };
  /**
   * Destroys the upload viewer.
   */
  UploadViewer.prototype.destroy = function (_finish) {
    var flman = zul.UploadViewer.flman;
    if (flman) flman.removeFile(this._uplder);
  };
  UploadViewer = __decorate([zk.WrapClass('zul.UploadViewer')], UploadViewer);
  return UploadViewer;
}(zk.Object);
exports.UploadViewer = UploadViewer;
window.zul.Upload_.Upload = Upload;
window.zul.Upload_.Uploader = Uploader;
window.zul.Upload_.UploadViewer = UploadViewer;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/WScroll.ts":
/*!******************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/WScroll.ts ***!
  \******************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


if (!window.zul) window.zul = {};
if (!window.zul.WScroll_) window.zul.WScroll_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.WScroll = void 0;
/* WScroll.ts

    Purpose:

    Description:
        A wave scrollbar control
    History:
        Wed, Feb 22, 2012  4:16:53 PM, Created by jumperchen

Copyright (C) 2012 Potix Corporation. All Rights Reserved.

*/
window.zul.WScroll_.easing = function (x, t, b, c, d) {
  return -c * ((t = t / d - 1) * t * t * t - 1) + b; // easeOutQuart
};
window.zul.WScroll_.snap = function (dg, pointer) {
  var x = pointer[0],
    y = pointer[1];
  if (dg._isVer) {
    var move = y;
    if (move - dg._start < 0) {
      move = pointer[1] = dg._start;
    } else if (move > dg._end) {
      move = pointer[1] = dg._end;
    }
    if (dg._lastPos) {
      // optimized
      if (Math.abs(dg._lastPos - move) < 3) return pointer;
    }
    dg._lastPos = move;
  } else {
    var move = x;
    if (move - dg._start < 0) {
      move = pointer[0] = dg._start;
    } else if (move > dg._end) {
      move = pointer[0] = dg._end;
    }
    if (dg._lastPos) {
      // optimized
      if (Math.abs(dg._lastPos - move) < 3) return pointer;
    }
    dg._lastPos = move;
  }
  return pointer;
};
window.zul.WScroll_.starteffect = function (dg) {
  var ctrl = dg.control,
    opts = ctrl.opts;
  dg._steps = opts.startStep;
  dg._endStep = opts.endStep - opts.viewport;
  dg._scale = ctrl._scale;
  dg._epos = ctrl.epos;
  dg._lastPos = dg._start;
  if (ctrl._isVer) {
    dg._isVer = true;
    dg._start = opts.startPosition;
    if (zk(ctrl.eend).isVisible()) {
      dg._end = ctrl.eend.offsetTop + Math.ceil(dg.handle.offsetHeight / 2);
      if (dg._end > opts.viewportSize + dg._start) dg._end = opts.viewportSize + dg._start;
    } else {
      dg._end = opts.viewportSize + dg._start;
    }
    dg._end -= dg.node.offsetHeight - ctrl._gap;
  } else {
    dg._isVer = false;
    dg._start = opts.startPosition;
    if (zk(ctrl.eend).isVisible()) {
      dg._end = ctrl.eend.offsetLeft + Math.ceil(dg.handle.offsetWidth / 2);
      if (dg._end > opts.viewportSize + dg._start) dg._end = opts.viewportSize + dg._start;
    } else {
      dg._end = opts.viewportSize + dg._start;
    }
    dg._end -= dg.node.offsetWidth - ctrl._gap;
  }
  jq(dg._epos).show().delay(200).fadeIn(500);
  if (dg._timer) {
    clearTimeout(dg._timer);
  }
  var lastP,
    lastS = [],
    timeout = 30,
    duration = timeout * 20,
    t = 10,
    running = function (orient) {
      var norient = zk.parseFloat(dg.node.style[orient]),
        diff = norient - zk.parseFloat(dg._epos.style[orient]);
      if (lastP == norient) {
        lastS.push(dg._lastSteps);
        if (lastS.length > 4 && lastS.shift() == dg._lastSteps) {
          lastS[0] = dg._lastSteps;
          clearTimeout(dg._timer);
          dg._timer = setTimeout(function () {
            running(orient);
          }, 100);
          return;
        }
      } else t = 10; // reset
      lastP = norient;
      var down = diff > 0,
        total = down ? Math.max(0, diff / dg._scale) : Math.min(0, diff / dg._scale),
        step = Math.round(zul.WScroll.easing(t / duration, t, 0, total, duration));
      if (down) {
        if (total > 1) step = Math.max(1, step);
      } else {
        if (-total > 1) step = Math.min(-1, step);
      }
      if (diff == 0 && step == 0) {
        if (norient == dg._start) step = -dg._steps;else if (norient == dg._end) step = dg._endStep - dg._steps;
      }
      dg._steps += step;
      if (down) {
        if (dg._steps > dg._endStep) dg._steps = dg._endStep;
      } else {
        if (dg._steps < 0) dg._steps = 0;
      }
      dg._epos.style[orient] = dg._start + dg._scale * dg._steps + 'px';
      t += timeout;
      if (dg._lastSteps != dg._steps) {
        dg._lastSteps = dg._steps;
        var func = orient == 'top' ? ctrl.opts.onScrollY : ctrl.opts.onScrollX;
        if (typeof func == 'function') {
          func.call(dg.control.widget, dg._steps + ctrl.opts.offset);
        }
      }
      clearTimeout(dg._timer);
      dg._timer = setTimeout(function () {
        running(orient);
      }, timeout);
    };
  dg._timer = setTimeout(function () {
    running(dg._isVer ? 'top' : 'left');
  }, 50);
};
window.zul.WScroll_.endeffect = function (dg) {
  var ctrl = dg.control;
  if (dg._timer) {
    clearTimeout(dg._timer);
  }
  var move, end;
  if (dg._isVer) {
    move = zk.parseInt(dg._epos.style.top);
    end = dg._end;
    if (move > end) move = end;
    jq(dg.node).animate({
      top: move + 'px'
    }, 400, 'swing');
  } else {
    move = zk.parseInt(dg._epos.style.left);
    end = dg._end;
    if (move > end) move = end;
    jq(dg.node).animate({
      left: move + 'px'
    }, 400, 'swing');
  }
  ctrl.opts.startStep = dg._steps;
  ctrl._syncButtonStatus();
  var $jq = jq(dg._epos),
    old = $jq.css('opacity'); // fix old IE version
  jq(dg._epos).delay(300).fadeOut(500).css('opacity', old);
};
window.zul.WScroll_.ignoredrag = function (dg, p, evt) {
  return dg.control.edragBody != evt.domTarget;
};
/**
 * A wave Scrollbar used to scroll the specific content and provides four controls
 * to navigate the content, such as Home/Previous/Next/End, and also supports the
 * mousewheel control.
 */
var WScroll = /** @class */function (_super) {
  __extends(WScroll, _super);
  function WScroll(control, opts) {
    var _this = _super.call(this) || this;
    /** @internal */
    _this._gap = 0;
    _this.control = control;
    _this.opts = zk.$default(opts, {
      orient: 'horizontal',
      startPosition: 0,
      startStep: 0,
      offset: 0
    });
    _this.anchor = _this.opts.anchor || control.parentNode;
    _this.widget = zk.Widget.$(control);
    _this.uid = _this.widget.uuid;
    _this.zcls = /*safe*/_this.widget.getZclass();
    _this._isVer = opts.orient == 'vertical';
    // ZK-2178: viewportSize is 0 if biglistbox has not model
    if (!opts.viewportSize && opts.viewportSize != 0) throw 'Handle required for a viewport size: {viewportSize: size}';
    _this.redraw(_this.anchor);
    _this._initDragdrop();
    _this._listenMouseEvent();
    if (_this.opts.syncSize) _this.syncSize();
    _this._syncButtonStatus();
    return _this;
  }
  /**
   * Syncs the scrolling area and control bar size.
   * @param opts - the opts can override the initail opts data for resizing.
   */
  WScroll.prototype.syncSize = function (opts) {
    if (opts) {
      this.opts = zk.copy(this.opts, opts);
    }
    this.edrag.style.display = '';
    if (this._isVer) {
      var opts_1 = this.opts,
        top = opts_1.startPosition,
        start = opts_1.startStep,
        view = opts_1.viewport,
        end = opts_1.endStep,
        rest = end - view,
        edragHeight = this.edrag.offsetHeight - this._gap;
      var vsize = opts_1.viewportSize;
      if (rest <= 0) {
        this.eend.style.display = this.edrag.style.display = 'none';
        if (typeof this.opts.onScrollY == 'function') this.opts.onScrollY.call(this.widget, opts_1.offset); //reset scrolling
        return;
      }
      vsize -= edragHeight;
      if (vsize > rest) {
        this.epos.style.height = edragHeight + 'px';
        this._scale = 1;
        var es = this.eend.style;
        es.display = '';
        es.top = top + edragHeight + rest + 'px';
      } else {
        var rate = vsize / rest,
          height = Math.max(edragHeight * rate, 5);
        this.epos.style.height = height + 'px';
        this._scale = rate;
        this.eend.style.display = 'none'; // no end point
        if (vsize < 10) this.edrag.style.display = 'none';
      }
      var top1 = top + this._scale * start,
        top2 = top + vsize;
      if (top1 > top2) top1 = top2;
      this.epos.style.top = this.edrag.style.top = top1 + 'px';
    } else {
      var opts_2 = this.opts,
        left = opts_2.startPosition,
        start = opts_2.startStep,
        view = opts_2.viewport,
        end = opts_2.endStep,
        rest = end - view,
        edragWidth = this.edrag.offsetWidth - this._gap;
      var vsize = opts_2.viewportSize;
      if (rest <= 0) {
        this.eend.style.display = this.edrag.style.display = 'none';
        if (typeof this.opts.onScrollX == 'function') this.opts.onScrollX.call(this.widget, opts_2.offset); //reset scrolling
        return;
      }
      vsize -= edragWidth;
      if (vsize > rest) {
        this.epos.style.width = edragWidth + 'px';
        this._scale = 1;
        var es = this.eend.style;
        es.display = '';
        es.left = left + edragWidth + rest + 'px';
      } else {
        var rate = vsize / rest,
          width = Math.max(edragWidth * rate, 5);
        this.epos.style.width = width + 'px';
        this._scale = rate;
        this.eend.style.display = 'none'; // no end point
        if (vsize < 10) this.edrag.style.display = 'none';
      }
      var left1 = left + this._scale * start,
        left2 = left + vsize;
      if (left1 > left2) left1 = left2;
      this.epos.style.left = this.edrag.style.left = left1 + 'px';
    }
  };
  /** @internal */
  WScroll.prototype._listenMouseEvent = function () {
    if (this._isVer) {
      // @ts-expect-error: zk.Event is not completely compatible with JQueryMousewheelEventObject
      jq(this.control).mousewheel(this._mousewheelY.bind(this));
    } else if (!zk.opera) {
      // ie and opera unsupported
      // @ts-expect-error: zk.Event is not completely compatible with JQueryMousewheelEventObject
      jq(this.control).mousewheel(this._mousewheelX.bind(this));
    }
    var $drag = jq(this.edrag);
    $drag.children('div').on('mouseover', this._mouseOver.bind(this)).on('mouseout', this._mouseOut.bind(this)).on('mouseup', this._mouseUp.bind(this)).on('mousedown', this._mouseDown.bind(this));
    $drag.on('click', zk.$void);
  };
  /** @internal */
  WScroll.prototype._unlistenMouseEvent = function () {
    if (this._isVer)
      // @ts-expect-error: unmousewheel expects 0 arguments, but got 1
      jq(this.control).unmousewheel(this._mousewheelY.bind(this));else if (!zk.opera)
      // ie and opera unsupported
      // @ts-expect-error: unmousewheel expects 0 arguments, but got 1
      jq(this.control).unmousewheel(this._mousewheelX.bind(this));
    var $drag = jq(this.edrag);
    $drag.children('div').off('mouseover', this._mouseOver.bind(this)).off('mouseout', this._mouseOut.bind(this)).off('mouseup', this._mouseUp.bind(this)).off('mousedown', this._mouseDown.bind(this));
    $drag.off('click', zk.$void);
  };
  /** @internal */
  WScroll.prototype._mouseOver = function (evt) {
    var cls = evt.target.className,
      index = cls.lastIndexOf('-'),
      key = cls.substring(index + 1),
      $drag = jq(this.edrag);
    if ($drag.hasClass(cls + '-clk')) {
      $drag.removeClass(cls + '-clk');
    }
    switch (key) {
      case 'home':
      case 'up':
        if (this.opts.startStep > 0) $drag.addClass(cls + '-over');
        break;
      case 'down':
      case 'end':
        var opts = this.opts;
        if (opts.startStep < opts.endStep - opts.viewport) {
          $drag.addClass(cls + '-over');
        }
        break;
    }
  };
  /** @internal */
  WScroll.prototype._mouseOut = function (evt) {
    var cls = evt.target.className,
      $drag = jq(this.edrag);
    $drag.removeClass(cls + '-over');
    if ($drag.hasClass(cls + '-clk')) {
      $drag.removeClass(cls + '-clk');
    }
  };
  /** @internal */
  WScroll.prototype._mouseUp = function (evt) {
    jq(this.edrag).removeClass(evt.target.className + '-clk');
  };
  /** @internal */
  WScroll.prototype._mouseDown = function (evt) {
    var cls = evt.target.className,
      index = cls.lastIndexOf('-'),
      key = cls.substring(index + 1),
      $drag = jq(this.edrag);
    if (!$drag.hasClass(cls + '-over') && !zk.mobile)
      //no mouse over for mobile
      return; // disable
    $drag.addClass(cls + '-clk');
    var opts = this.opts;
    switch (key) {
      case 'home':
        if (opts.startStep > 0) {
          opts.startStep = 0;
          if (this._isVer) {
            var moving = opts.startPosition + 'px';
            this.epos.style.top = moving;
            $drag.animate({
              top: moving
            }, 500);
            if (typeof this.opts.onScrollY == 'function') this.opts.onScrollY.call(this.widget, opts.startStep + opts.offset);
          } else {
            var moving = opts.startPosition + 'px';
            this.epos.style.left = moving;
            $drag.animate({
              left: moving
            }, 500);
            if (typeof this.opts.onScrollX == 'function') this.opts.onScrollX.call(this.widget, opts.startStep + opts.offset);
          }
          $drag.removeClass(cls + '-over');
        }
        break;
      case 'up':
        if (opts.startStep > 0) {
          opts.startStep -= 1;
          var move = opts.startPosition + opts.startStep * this._scale;
          if (this._isVer) {
            var end;
            if (zk(this.eend).isVisible()) {
              end = this.eend.offsetTop;
            } else {
              end = opts.viewportSize + opts.startPosition;
            }
            end -= this.edrag.offsetHeight - this._gap;
            this.epos.style.top = move + 'px';
            if (end < move) {
              this.edrag.style.top = end + 'px';
            } else {
              this.edrag.style.top = move + 'px';
            }
            if (typeof this.opts.onScrollY == 'function') this.opts.onScrollY.call(this.widget, opts.startStep + opts.offset);
          } else {
            var end;
            if (zk(this.eend).isVisible()) {
              end = this.eend.offsetLeft;
            } else {
              end = opts.viewportSize + opts.startPosition;
            }
            end -= this.edrag.offsetWidth - this._gap;
            this.epos.style.left = move + 'px';
            if (end < move) {
              this.edrag.style.left = end + 'px';
            } else {
              this.edrag.style.left = move + 'px';
            }
            if (typeof this.opts.onScrollX == 'function') this.opts.onScrollX.call(this.widget, opts.startStep + opts.offset);
          }
          if (opts.startStep == 0) $drag.removeClass(cls + '-over');
        }
        break;
      case 'down':
        if (opts.startStep < opts.endStep - opts.viewport) {
          opts.startStep += 1;
          var move = opts.startPosition + opts.startStep * this._scale;
          if (this._isVer) {
            var end;
            if (zk(this.eend).isVisible()) {
              end = this.eend.offsetTop;
            } else {
              end = opts.viewportSize + opts.startPosition;
            }
            end -= this.edrag.offsetHeight - this._gap;
            this.epos.style.top = move + 'px';
            if (end < move) {
              this.edrag.style.top = end + 'px';
            } else {
              this.edrag.style.top = move + 'px';
            }
            if (typeof this.opts.onScrollY == 'function') this.opts.onScrollY.call(this.widget, opts.startStep + opts.offset);
          } else {
            var end;
            if (zk(this.eend).isVisible()) {
              end = this.eend.offsetLeft;
            } else {
              end = opts.viewportSize + opts.startPosition;
            }
            end -= this.edrag.offsetWidth - this._gap;
            this.epos.style.left = move + 'px';
            if (end < move) {
              this.edrag.style.left = end + 'px';
            } else {
              this.edrag.style.left = move + 'px';
            }
            if (typeof this.opts.onScrollX == 'function') this.opts.onScrollX.call(this.widget, opts.startStep + opts.offset);
          }
          if (opts.startStep == opts.endStep - opts.viewport) $drag.removeClass(cls + '-over');
        }
        break;
      case 'end':
        if (opts.startStep < opts.endStep - opts.viewport) {
          opts.startStep = opts.endStep - opts.viewport;
          if (this._isVer) {
            var moving = void 0;
            if (zk(this.eend).isVisible()) {
              moving = this.eend.offsetTop - (this.edrag.offsetHeight - this._gap);
            } else {
              moving = opts.startPosition + opts.viewportSize - (this.edrag.offsetHeight - this._gap);
            }
            this.epos.style.top = moving;
            $drag.animate({
              top: moving
            }, 500);
            if (typeof this.opts.onScrollY == 'function') this.opts.onScrollY.call(this.widget, opts.startStep + opts.offset);
          } else {
            var moving = void 0;
            if (zk(this.eend).isVisible()) {
              moving = this.eend.offsetLeft - (this.edrag.offsetWidth - this._gap);
            } else {
              moving = opts.startPosition + opts.viewportSize - (this.edrag.offsetWidth - this._gap);
            }
            this.epos.style.left = moving;
            $drag.animate({
              left: moving
            }, 500);
            if (typeof this.opts.onScrollX == 'function') this.opts.onScrollX.call(this.widget, opts.startStep + opts.offset);
          }
          $drag.removeClass(cls + '-over');
        }
        break;
    }
    this._syncButtonStatus();
  };
  /** @internal */
  WScroll.prototype._mousewheelY = function (evt, delta, deltaX, deltaY) {
    if (deltaY) {
      evt.stop();
      var opts = this.opts,
        steps = opts.startStep,
        endStep = opts.endStep - opts.viewport,
        scale = this._scale,
        wgt = this.widget;
      if (deltaY > 0) {
        // up
        opts.startStep -= Math.max(Math.round(wgt._cols / 5), 1);
        if (opts.startStep < 0) opts.startStep = 0;
      } else {
        // down
        opts.startStep += Math.max(Math.round(wgt._cols / 5), 1);
        if (opts.startStep > endStep) opts.startStep = endStep;
      }
      if (steps == opts.startStep) return; // nothing changed
      var moving = opts.startPosition + opts.startStep * scale,
        end = zk(this.eend).isVisible() ? this.eend.offsetTop - (this.edrag.offsetHeight - this._gap) : opts.startPosition + opts.viewportSize - (this.edrag.offsetHeight - this._gap);
      this.epos.style.top = moving + 'px';
      if (moving > end) moving = end;
      this.edrag.style.top = moving + 'px';
      if (typeof this.opts.onScrollY == 'function') this.opts.onScrollY.call(this.widget, opts.startStep + opts.offset);
      this._syncButtonStatus();
    }
  };
  /** @internal */
  WScroll.prototype._mousewheelX = function (evt, delta, deltaX, deltaY) {
    if (deltaX) {
      evt.stop();
      var opts = this.opts,
        steps = opts.startStep,
        endStep = opts.endStep - opts.viewport,
        scale = this._scale,
        wgt = this.widget;
      if (deltaX < 0) {
        // up
        opts.startStep -= Math.max(Math.round(wgt._cols / 5), 1);
        if (opts.startStep < 0) opts.startStep = 0;
      } else {
        // down
        opts.startStep += Math.max(Math.round(wgt._cols / 5), 1);
        if (opts.startStep > endStep) opts.startStep = endStep;
      }
      if (steps == opts.startStep) return; // nothing changed
      var moving = opts.startPosition + opts.startStep * scale,
        end = zk(this.eend).isVisible() ? this.eend.offsetLeft - (this.edrag.offsetWidth - this._gap) : opts.startPosition + opts.viewportSize - (this.edrag.offsetWidth - this._gap);
      this.epos.style.left = moving + 'px';
      if (moving > end) moving = end;
      this.edrag.style.left = moving + 'px';
      if (typeof this.opts.onScrollX == 'function') this.opts.onScrollX.call(this.widget, opts.startStep + opts.offset);
      this._syncButtonStatus();
    }
  };
  /** @internal */
  WScroll.prototype._initDragdrop = function () {
    var orient = this._isVer ? 'v' : 'h',
      uuid = this.uid + '-' + orient + 'bar';
    this.node = jq(uuid, zk)[0];
    this.edrag = this.node.firstChild;
    this.edragBody = this.edrag.childNodes[2];
    this.epos = this.edrag.nextSibling;
    this.eend = this.node.lastChild;
    // sync the gap between edrag and epos
    var s = this.epos.style,
      old = s.display;
    s.display = 'block';
    this._gap = this._isVer ? this.edrag.offsetHeight - this.epos.offsetHeight : this.edrag.offsetWidth - this.epos.offsetWidth;
    s.display = old;
    this.drag = new zk.Draggable(this, this.edrag, {
      constraint: this._isVer ? 'vertical' : 'horizontal',
      snap: window.zul.WScroll_.snap,
      starteffect: window.zul.WScroll_.starteffect,
      zIndex: '12000',
      ignoredrag: window.zul.WScroll_.ignoredrag,
      endeffect: window.zul.WScroll_.endeffect
    });
    jq(this.epos).hide();
  };
  WScroll.prototype.destroy = function () {
    this.drag.destroy();
    this._unlistenMouseEvent();
    jq(this.node).remove();
    // @ts-expect-error: these variables should only become undefined after destroy
    this.node = this.edrag = this.epos = this.drag = undefined;
  };
  WScroll.prototype.redraw = function (p) {
    var orient = this._isVer ? 'v' : 'h',
      ocls = this._isVer ? 'vertical' : 'horizontal',
      uuid = this.uid + '-' + orient + 'bar',
      zcls = this.widget.$s('wscroll');
    jq(p).append( /*safe*/'<div id="' + uuid + '" class="' + zcls + '-' + ocls + '">' + '<div class="' + zcls + '-drag">' + '<div class="' + zcls + '-home" title="' + /*safe*/msgzul.WS_HOME + '"></div>' + '<div class="' + zcls + '-up" title="' + /*safe*/msgzul.WS_PREV + '"></div>' + '<div class="' + zcls + '-body"></div>' + '<div class="' + zcls + '-down" title="' + /*safe*/msgzul.WS_NEXT + '"></div>' + '<div class="' + zcls + '-end" title="' + /*safe*/msgzul.WS_END + '"></div>' + '</div>' + '<div class="' + zcls + '-pos"></div>' + '<div class="' + zcls + '-endbar"></div>' + '</div>');
  };
  /** @internal */
  WScroll.prototype._syncButtonStatus = function () {
    var zcls = this.zcls + '-wscroll',
      $drag = jq(this.edrag),
      opts = this.opts;
    $drag.toggleClass(zcls + '-head', opts.startStep == 0);
    $drag.toggleClass(zcls + '-tail', opts.startStep == opts.endStep - opts.viewport);
  };
  /**
   * Sets the easing animation function for the scrolling effects.
   * For more details, please refer to jquery's easing plugin.
   * http://gsgd.co.uk/sandbox/jquery/easing/
   */
  WScroll.easing = window.zul.WScroll_.easing;
  WScroll = __decorate([zk.WrapClass('zul.WScroll')], WScroll);
  return WScroll;
}(zk.Object);
exports.WScroll = WScroll;
window.zul.WScroll_.WScroll = WScroll;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/Widget.ts":
/*!*****************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/Widget.ts ***!
  \*****************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


/* Widget.ts

    Purpose:

    Description:

    History:
        Fri Nov  7 17:14:59     2008, Created by tomyeh

Copyright (C) 2008 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
/** The ZUL widgets and utilities
 */
//zk.$package('zul');
if (!window.zul) window.zul = {};
if (!window.zul.Widget_) window.zul.Widget_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Widget = void 0;
//Tooltip
var _tt_inf, _tt_tmClosing, _tt_tip, _tt_ref;
window.zul.Widget_._tt_beforeBegin = function (ref) {
  if (_tt_tip && !_tt_tip.isOpen()) {
    //closed by other (such as clicking on menuitem)
    window.zul.Widget_._tt_clearOpening_();
    window.zul.Widget_._tt_clearClosing_();
    _tt_tip = _tt_ref = undefined;
  }
  var overTip = _tt_tip && zUtl.isAncestor(_tt_tip, ref);
  if (overTip) window.zul.Widget_._tt_clearClosing_(); //not close tip if over tip
  return !overTip; //disable tip in tip
};
window.zul.Widget_._tt_begin = function (tip, ref, params, event) {
  if (_tt_tip != tip || _tt_ref != ref) {
    window.zul.Widget_._tt_close_();
    _tt_inf = {
      tip: tip,
      ref: ref,
      params: params,
      timer: setTimeout(function () {
        window.zul.Widget_._tt_open_(event);
      }, params.delay !== undefined ? params.delay : zk.tipDelay)
    };
  } else window.zul.Widget_._tt_clearClosing_();
};
window.zul.Widget_._tt_end = function (ref) {
  if (_tt_ref == ref || _tt_tip == ref) {
    window.zul.Widget_._tt_clearClosing_(); //just in case
    _tt_tmClosing = setTimeout(window.zul.Widget_._tt_close_, 100);
    //don't cloes immediate since user might move from ref to toolip
  } else window.zul.Widget_._tt_clearOpening_();
};
window.zul.Widget_._tt_clearOpening_ = function () {
  var inf = _tt_inf;
  if (inf) {
    _tt_inf = undefined;
    clearTimeout(inf.timer);
  }
};
window.zul.Widget_._tt_clearClosing_ = function () {
  var tmClosing = _tt_tmClosing;
  if (tmClosing) {
    _tt_tmClosing = undefined;
    clearTimeout(tmClosing);
  }
};
window.zul.Widget_._tt_open_ = function (event) {
  var inf = _tt_inf;
  if (inf) {
    _tt_tip = inf.tip, _tt_ref = inf.ref;
    _tt_inf = undefined;
    var n = _tt_ref.$n();
    // B65-ZK-1934: If reference's dom is null or not visible, then just return.
    if (!n || !zk(n).isRealVisible())
      //gone
      return _tt_tip = _tt_ref = undefined;
    // `params.x/y` should be `number` throughout except being initialized by Java.
    // Hence, we define `params.x/y` as number and force-cast to string here.
    var params = inf.params,
      x = params.x,
      y = params.y;
    if (x) params.x = window.zul.Widget_._parseParamFunc(event, x);
    if (y) params.y = window.zul.Widget_._parseParamFunc(event, y);
    var xy = params.x !== undefined ? [params.x, params.y] : zk.currentPointer;
    _tt_tip.open(params.ref || _tt_ref, xy, zul.Widget._getPopupPosition(params), {
      focusFirst: true,
      sendOnOpen: true
    });
  }
};
window.zul.Widget_._tt_close_ = function () {
  window.zul.Widget_._tt_clearOpening_();
  window.zul.Widget_._tt_clearClosing_();
  var tip = _tt_tip;
  if (tip === null || tip === void 0 ? void 0 : tip.desktop) {
    //check still attached to desktop
    // Bug ZK-1222, ZK-1594
    // If the tooltip (popup) and mouse pointer overlapped, a TooltipOut event
    // will be triggered again that closes the tooltip immediately, then another
    // TooltipOver event will open the tooltip again...
    // If mouse pointer still overlapped on tooltip, do not close.
    // IE10: Bug ZK-1519, Chrome: Bug ZK-3583
    var $tip = jq(tip.$n()),
      $tipOff = $tip.offset(),
      pointer = zk.currentPointer;
    if (pointer[0] >= $tipOff.left && pointer[0] <= $tipOff.left + $tip.width() && pointer[1] >= $tipOff.top && pointer[1] <= $tipOff.top + $tip.height()) return;
    _tt_tip = _tt_ref = undefined;
    tip.close({
      sendOnOpen: true
    });
  }
};
window.zul.Widget_._setCtrlKeysErr = function (msg) {
  zk.error('setCtrlKeys: ' + msg);
};
window.zul.Widget_._parseParamFunc = function (event, funcBody) {
  if (funcBody.includes('(') && funcBody.includes(')')) {
    // eslint-disable-next-line no-new-func
    var func = new Function('event', 'return ' + funcBody + ';');
    return func(event);
  } else {
    return zk.parseInt(funcBody);
  }
};
/** The base class for ZUL widget.
 * <p>The corresponding Java class is org.zkoss.zul.impl.XulElement.
 * <p>If a widget has a client attribute 'scrollable', it will listen `onScroll` event.
 */
var Widget = /** @class */function (_super) {
  __extends(Widget, _super);
  // eslint-disable-next-line @typescript-eslint/no-useless-constructor
  function Widget(props) {
    return _super.call(this, props) || this;
  }
  /** @internal */
  Widget.prototype.bind_ = function (desktop, skipper, after) {
    _super.prototype.bind_.call(this, desktop, skipper, after);
    // B70-ZK-2069: some widget need fire onScroll event, which has
    // characteristic of container
    if (jq(this.uuid, zk).data('scrollable')) {
      // Avoid caching $n() too early
      this._doScrollableSyncScroll = zUtl.throttle(function () {
        if (jq(this).data('scrollable')) {
          zWatch.fireDown('onScroll', this);
          zWatch.fire('_onSyncScroll', this); // ZK-4408: for Popup only
        }
      }, 1000 / 60); // 60fps
      this.domListen_(this.getCaveNode(), 'onScroll', '_doScrollableSyncScroll');
    }
  };
  /** @internal */
  Widget.prototype.unbind_ = function (skipper, after, keepRod) {
    if (this._doScrollableSyncScroll) {
      this.domUnlisten_(this.getCaveNode(), 'onScroll', '_doScrollableSyncScroll');
    }
    _super.prototype.unbind_.call(this, skipper, after, keepRod);
  };
  /**
   * @returns the ID of the popup ({@link zul.wgt.Popup}) that should appear
   * when the user right-clicks on the element (aka., context menu).
   *
   * @defaultValue `null` (no context menu).
   */
  Widget.prototype.getContext = function () {
    return this._context;
  };
  Widget.prototype.setContext = function (context) {
    if (context instanceof zk.Widget) context = 'uuid(' + context.uuid + ')';
    this._context = context;
    return this;
  };
  /**
   * @returns the ID of the popup ({@link zul.wgt.Popup}) that should appear
   * when the user clicks on the element.
   *
   * @defaultValue `null` (no popup).
   */
  Widget.prototype.getPopup = function () {
    return this._popup;
  };
  Widget.prototype.setPopup = function (popup) {
    if (popup instanceof zk.Widget) popup = 'uuid(' + popup.uuid + ')';
    this._popup = popup;
    return this;
  };
  /**
   * @returns the ID of the popup ({@link zul.wgt.Popup}) that should be used
   * as a tooltip window when the mouse hovers over the element for a moment.
   * The tooltip will automatically disappear when the mouse is moved away.
   *
   * @defaultValue `null` (no tooltip).
   */
  Widget.prototype.getTooltip = function () {
    return this._tooltip;
  };
  Widget.prototype.setTooltip = function (tooltip) {
    if (tooltip instanceof zk.Widget) tooltip = 'uuid(' + tooltip.uuid + ')';
    this._tooltip = tooltip;
    return this;
  };
  /**
   * @returns what keystrokes to intercept.
   * @defaultValue `null`.
   */
  Widget.prototype.getCtrlKeys = function () {
    return this._ctrlKeys;
  };
  /**
   * Sets what keystrokes to intercept.
   *
   * <p>The string could be a combination of the following:
   * <dl>
   * <dt>^k</dt>
   * <dd>A control key, i.e., Ctrl+k, where k could be a~z, 0~9, #n</dd>
   * <dt>\@k</dt>
   * <dd>A alt key, i.e., Alt+k, where k could be a~z, 0~9, #n</dd>
   * <dt>$n</dt>
   * <dd>A shift key, i.e., Shift+n, where n could be #n.
   * Note: $a ~ $z are not supported.</dd>
   * <dt>#home</dt>
   * <dd>Home</dd>
   * <dt>#end</dt>
   * <dd>End</dd>
   * <dt>#ins</dt>
   * <dd>Insert</dd>
   * <dt>#del</dt>
   * <dd>Delete</dd>
   * <dt>#bak</dt>
   * <dd>Backspace</dd>
   * <dt>#left</dt>
   * <dd>Left arrow</dd>
   * <dt>#right</dt>
   * <dd>Right arrow</dd>
   * <dt>#up</dt>
   * <dd>Up arrow</dd>
   * <dt>#down</dt>
   * <dd>Down arrow</dd>
   * <dt>#pgup</dt>
   * <dd>PageUp</dd>
   * <dt>#pgdn</dt>
   * <dd>PageDn</dd>
   * <dt>#f1 #f2 ... #f12</dt>
   * <dd>Function keys representing F1, F2, ... F12</dd>
   * </dl>
   *
   * <p>For example,
   * <dl>
   * <dt>^a^d\@c#f10#left#right</dt>
   * <dd>It means you want to intercept Ctrl+A, Ctrl+D, Alt+C, F10,
   * Left and Right.</dd>
   * <dt>^#left</dt>
   * <dd>It means Ctrl+Left.</dd>
   * <dt>^#f1</dt>
   * <dd>It means Ctrl+F1.</dd>
   * <dt>\@#f3</dt>
   * <dd>It means Alt+F3.</dd>
   * </dl>
   */
  Widget.prototype.setCtrlKeys = function (ctrlKeys) {
    if (this._ctrlKeys == ctrlKeys) return this;
    if (!ctrlKeys) {
      this._ctrlKeys = this._parsedCtlKeys = undefined;
      return this;
    }
    //ext(#), ctrl(001), alt(010), ctrl + alt(011), shift(100), ctrl + shift(101), alt + shift(110), ctrl + alt + shift(111)
    var parsed = [{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}],
      which = 0;
    for (var j = 0, len = ctrlKeys.length; j < len; ++j) {
      var cc = ctrlKeys.charAt(j); //ext
      switch (cc) {
        case '^': //ctrl
        case '@': //alt
        case '$': //shift
        case '%':
          //meta
          var flag = cc == '^' ? 1 : cc == '@' ? 2 : cc == '$' ? 4 : 8;
          if ((which & flag) != 0) {
            window.zul.Widget_._setCtrlKeysErr('Unexpected key combination: ' + ctrlKeys);
            return this;
          } else which |= flag;
          break;
        case '#':
          {
            var k = j + 1;
            for (; k < len; ++k) {
              var c2 = ctrlKeys.charAt(k);
              if ((c2 > 'Z' || c2 < 'A') && (c2 > 'z' || c2 < 'a') && (c2 > '9' || c2 < '0')) break;
            }
            if (k == j + 1) {
              window.zul.Widget_._setCtrlKeysErr('Unexpected character # in ' + ctrlKeys);
              return this;
            }
            var cc_1 = void 0;
            var s = ctrlKeys.substring(j + 1, k).toLowerCase();
            if ('pgup' == s) cc_1 = 33;else if ('pgdn' == s) cc_1 = 34;else if ('end' == s) cc_1 = 35;else if ('home' == s) cc_1 = 36;else if ('left' == s) cc_1 = 37;else if ('up' == s) cc_1 = 38;else if ('right' == s) cc_1 = 39;else if ('down' == s) cc_1 = 40;else if ('ins' == s) cc_1 = 45;else if ('del' == s) cc_1 = 46;else if ('bak' == s) cc_1 = 8;else if ('tab' == s) cc_1 = 9;else if ('space' == s) cc_1 = 32;else if (s.length > 1 && s.startsWith('f')) {
              var v = zk.parseInt(s.substring(1));
              if (v == 0 || v > 12) {
                window.zul.Widget_._setCtrlKeysErr('Unsupported function key: #f' + v);
                return this;
              }
              cc_1 = 112 + v - 1;
            } else {
              window.zul.Widget_._setCtrlKeysErr('Unknown #' + s + ' in ' + ctrlKeys);
              return this;
            }
            parsed[which][cc_1] = true;
            which = 0;
            j = k - 1;
            break;
          }
        default:
          if (!which || (cc > 'Z' || cc < 'A') && (cc > 'z' || cc < 'a') && (cc > '9' || cc < '0')) {
            window.zul.Widget_._setCtrlKeysErr('Unexpected character ' + cc + ' in ' + ctrlKeys);
            return this;
          }
          if (which == 4) {
            window.zul.Widget_._setCtrlKeysErr('$a - $z not supported (found in ' + ctrlKeys + '). Allowed: $#f1, $#home and so on.');
            return this;
          }
          if (cc <= 'z' && cc >= 'a') cc = cc.toUpperCase();
          parsed[which][cc.charCodeAt(0)] = true;
          which = 0;
          break;
      }
    }
    this._parsedCtlKeys = parsed;
    this._ctrlKeys = ctrlKeys;
    return this;
  };
  /** @internal */
  Widget.prototype._parsePopParams = function (txt, event) {
    var params = {},
      index = txt.indexOf(','),
      start = txt.indexOf('='),
      t = txt;
    if (start != -1) t = txt.substring(0, txt.substring(0, start).lastIndexOf(','));
    if (index != -1) {
      params.id = t.substring(0, index).trim();
      var t2 = t.substring(index + 1, t.length);
      if (t2) params.position = t2.trim();
      zk.copy(params, zUtl.parseMap(txt.substring(t.length, txt.length)));
    } else params.id = txt.trim();
    if (this._popup || this._context) {
      //should prepare tooltip in _tt_open_
      var x = params.x,
        y = params.y;
      if (x) params.x = window.zul.Widget_._parseParamFunc(event, x);
      if (y) params.y = window.zul.Widget_._parseParamFunc(event, y);
    }
    if (params.delay) params.delay = zk.parseInt(params.delay);
    if (params.ref) params.ref = this._smartFellow(params.ref);
    return params;
  };
  /** @internal */
  Widget.prototype.doClick_ = function (evt, popupOnly) {
    if (!this.shallIgnoreClick_(evt) && !evt.contextSelected) {
      var params = this._popup ? this._parsePopParams(this._popup, evt) : {},
        popup = this._smartFellow(params.id);
      if (popup) {
        evt.contextSelected = true;
        // to avoid a focus in IE, we have to pop up it later. for example, zksandbox/#t5
        var self = this,
          xy = params.x !== undefined ? [params.x, params.y] : [evt.pageX, evt.pageY];
        // F70-ZK-2007: When type=toggle, close the popup
        if (params.type && params.type == 'toggle' && popup.isOpen()) {
          popup.close({
            sendOnOpen: true
          });
        } else {
          setTimeout(function () {
            if (self.desktop) popup.open(params.ref || self, xy, zul.Widget._getPopupPosition(params), {
              focusFirst: true,
              sendOnOpen: true,
              type: params.type,
              which: 1
            });
          }, 0);
        }
        evt.stop({
          dom: true
        });
      }
    }
    if (popupOnly !== true) _super.prototype.doClick_.call(this, evt); // super method doesn't accept a second parameter
  };
  /** @internal */
  Widget.prototype.doRightClick_ = function (evt) {
    if (!this.shallIgnoreClick_(evt) && !evt.contextSelected) {
      var params = this._context ? this._parsePopParams(this._context, evt) : {},
        ctx = this._smartFellow(params.id);
      if (ctx) {
        evt.contextSelected = true;
        // to avoid a focus in IE, we have to pop up it later. for example, zksandbox/#t5
        var self = this,
          xy = params.x !== undefined ? [params.x, params.y] : [evt.pageX, evt.pageY];
        // F70-ZK-2007: When type=toggle, close the popup
        if (params.type && params.type == 'toggle' && ctx.isOpen()) {
          ctx.close({
            sendOnOpen: true
          });
        } else {
          setTimeout(function () {
            if (self.desktop) ctx.open(params.ref || self, xy, zul.Widget._getPopupPosition(params), {
              focusFirst: true,
              sendOnOpen: true,
              type: params.type,
              which: 3
            }); //Bug #2870620
          }, 0);
        }
        evt.stop({
          dom: true
        }); //prevent default context menu to appear
      }
    }
    _super.prototype.doRightClick_.call(this, evt);
  };
  /** @internal */
  Widget.prototype.doTooltipOver_ = function (evt) {
    if (!evt.tooltipped && window.zul.Widget_._tt_beforeBegin(this)) {
      var params = this._tooltip ? this._parsePopParams(this._tooltip) : {},
        tip = this._smartFellow(params.id);
      if (tip) {
        evt.tooltipped = true;
        //still call parent's doTooltipOver_ for better extensibility (though not necessary)
        window.zul.Widget_._tt_begin(tip, this, params, evt);
      }
    }
    _super.prototype.doTooltipOver_.call(this, evt);
  };
  /** @internal */
  Widget.prototype.doTooltipOut_ = function (evt) {
    window.zul.Widget_._tt_end(this);
    _super.prototype.doTooltipOut_.call(this, evt);
  };
  /** @internal */
  Widget.prototype._smartFellow = function (id) {
    return id ? id.startsWith('uuid(') && id.endsWith(')') ? zk.Widget.$(id.substring(5, id.length - 1)) : this.$f(id, true) : undefined;
  };
  //B70-ZK-2435: catch key down event right now rather than propagate it
  /** @internal */
  Widget.prototype.doKeyDown_ = function (evt) {
    if (this.getCtrlKeys() || this.isListen('onOK') || this.isListen('onCancel')) {
      //B70-ZK-2532: if afterKeyDown_ doesn't handle evt, then propagate to super
      if (!this.afterKeyDown_(evt)) _super.prototype.doKeyDown_.call(this, evt);
    } else _super.prototype.doKeyDown_.call(this, evt);
  };
  /**
   * Called after {@link zk.Widget#doKeyDown_} is called and the event
   * propagation is not stopped.
   * @defaultValue handles the control keys, including onOK and onCancel,
   * by searching up the ancestor chain to see if any one is listening.
   * If found, it calls {@link beforeCtrlKeys_} for each widget that were
   * searched, and then fire the event.
   * @param evt - the widget event.
   * @param simulated - if the event was not sent to the widget originally (rather,
   * it is caused by pressing when none of widget but document gains the focus)
   * @returns true if the event has been processed
   * @see {@link setCtrlKeys}
   * @internal
   */
  Widget.prototype.afterKeyDown_ = function (evt, simulated) {
    var keyCode = evt.keyCode,
      evtnm = 'onCtrlKey',
      okcancel,
      commandKey = zk.mac && evt.metaKey;
    switch (keyCode) {
      case 13:
        {
          //ENTER
          var target_1 = evt.domTarget,
            tn = jq.nodeName(target_1);
          if (tn == 'textarea' || tn == 'button'
          // if button's ID end with '-a' still fire onOK(Like Listbox and Menupopup)
          && (!target_1.id || !target_1.id.endsWith('-a')) || tn == 'input' && target_1.type.toLowerCase() == 'button') return false; //don't change button's behavior (Bug 1556836)
          okcancel = evtnm = 'onOK';
          break;
        }
      case 27:
        //ESC
        okcancel = evtnm = 'onCancel';
        break;
      case 16: //Shift
      case 17: //Ctrl
      case 18:
        //Alt
        return false;
      case 45: //Ins
      case 46: //Del
      case 8: //Backspace
      case 9: //Tab
      case 32:
        //Space
        break;
      default:
        if (keyCode >= 33 && keyCode <= 40 //PgUp, PgDn, End, Home, L, U, R, D
        || keyCode >= 112 && keyCode <= 123 //F1: 112, F12: 123
        || evt.ctrlKey || evt.altKey || commandKey) break;
        return false;
    }
    var target = evt.target,
      wgt = target;
    for (;; wgt = wgt.parent) {
      if (!wgt) return false;
      if (!wgt.isListen(evtnm, {
        any: true
      })) continue;
      if (okcancel) break;
      var parsed = wgt._parsedCtlKeys,
        which = 0;
      if (parsed) {
        if (evt.ctrlKey) which |= 1;
        if (evt.altKey) which |= 2;
        if (evt.shiftKey) which |= 4;
        if (commandKey) which |= 8;
        if (parsed[which][keyCode]) break; //found
      }
    }
    //Bug 3304408: SELECT fixes the selected index later than mousedown
    //so we have to defer the firing of ctrl keys
    setTimeout(function () {
      var _a;
      for (var w = target;; w = w.parent) {
        if ((_a = w.beforeCtrlKeys_) === null || _a === void 0 ? void 0 : _a.call(w, evt)) return;
        if (w == wgt) break;
      }
      wgt.fire(evtnm, zk.copy({
        reference: target
      }, evt.data));
    }, 0);
    evt.stop();
    if (jq.nodeName(evt.domTarget, 'select')) evt.stop({
      dom: true,
      revoke: true
    }); //Bug 1756559: don't stop DOM since it affects IE and Opera's SELECT's closing dropdown
    return true; //handled
  };
  /**
   * Called before a control key is pressed. A control key includes onOK and
   * onCancel; refer to #setCtrlKeys for details.
   * @defaultValue does nothing (but return false)
   * It is usually overridden by a stateful widget, such as an input box,
   * to update its state to the server, such as firing the onChange event.
   * @param _evt - the widget event.
   * @returns if true, the widget want to abort the firing of the control
   * 		key. In other words, if true is returned, the control key is ignored.
   * @internal
   */
  Widget.prototype.beforeCtrlKeys_ = function (_evt) {
    // empty on purpose
  };
  /**
   * @returns the tooltip that is opened, or null if no tooltip is opened.
   * @since 5.0.5
   */
  Widget.getOpenTooltip = function () {
    return (_tt_tip === null || _tt_tip === void 0 ? void 0 : _tt_tip.isOpen()) ? _tt_tip : undefined;
  };
  /** @internal */
  Widget._getPopupPosition = function (params) {
    if (params.position) return params.position;
    if ('x' in params || 'y' in params)
      // ZK-1655
      return undefined;
    return 'at_pointer';
  };
  Widget = __decorate([zk.WrapClass('zul.Widget')], Widget);
  return Widget;
}(zk.Widget);
exports.Widget = Widget;
window.zul.Widget_._tt_inf = _tt_inf;
window.zul.Widget_._tt_tmClosing = _tt_tmClosing;
window.zul.Widget_._tt_tip = _tt_tip;
window.zul.Widget_._tt_ref = _tt_ref;
window.zul.Widget_.Widget = Widget;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/dom.ts":
/*!**************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/dom.ts ***!
  \**************************************************/
/***/ (function() {



/* dom.ts

    Purpose:

    Description:

    History:
        Fri Jul 31 16:37:36     2009, Created by tomyeh

Copyright (C) 2009 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
//handle theme
if (!window.zul) window.zul = {};
if (!window.zul.dom_) window.zul.dom_ = {};
jq(function () {
  var zktheme = zk.themeName,
    tname = 'iceblue'; // shall sync with default theme name
  if (zktheme) tname = zktheme;
  jq(document.body).addClass(tname);
});
var $alert = jq.alert,
  icons = {
    QUESTION: 'z-messagebox-icon z-messagebox-question',
    EXCLAMATION: 'z-messagebox-icon z-messagebox-exclamation',
    INFORMATION: 'z-messagebox-icon z-messagebox-information',
    ERROR: 'z-messagebox-icon z-messagebox-error',
    NONE: 'z-messagebox z-messagebox-none'
  };
window.zul.dom_.newButton = function (nm, f) {
  return new zul.wgt.Button({
    label: msgzul[nm.toUpperCase()] || nm,
    listeners: {
      onClick: function (evt) {
        if (typeof f == 'function') f.call(this, evt);
        // backup first
        var dt = this.desktop;
        this.$o().detach();
        // B70-ZK-1683
        if (zAu.disabledRequest) {
          zAu.disabledRequest = false;
          zAu.sendNow(dt);
        }
      }
    }
  });
};
window.zul.dom_.getButtons = function (opts) {
  var btns = [];
  for (var nm in opts) {
    var f = opts[nm];
    // eslint-disable-next-line zk/noNull
    btns.push(window.zul.dom_.newButton(nm, typeof f == 'function' ? f : null));
  }
  if (!btns.length) btns.push(window.zul.dom_.newButton(msgzul.OK));
  return btns;
};
jq.alert = function (msg, opts) {
  if (opts && opts.mode == 'os') return $alert(msg);
  opts = opts || {};
  // NOTE: From this line on, opts is no longer undefined, but tsc has can't assert
  // this inside a new function scope, even though the scope is nested.
  zk.load('zul.wnd,zul.wgt,zul.box', function () {
    var wnd = zk.Widget.$(jq('$aualert'));
    if (!wnd) {
      var wnd_1 = new zul.wnd.Window({
        id: 'aualert',
        closable: true,
        sclass: 'z-messagebox-window',
        title: opts.title || zk.appName,
        border: 'normal',
        listeners: {
          onClose: function () {
            // B70-ZK-1683
            if (zAu.disabledRequest) {
              zAu.disabledRequest = false;
              zAu.sendNow(this.desktop);
            }
          }
        },
        children: [new zul.wgt.Div({
          sclass: 'z-messagebox-viewport',
          children: [new zul.wgt.Div({
            sclass: icons[(opts.icon || '').toUpperCase()] || opts.icon || icons.INFORMATION
          }), new zul.wgt.Div({
            id: 'content',
            sclass: 'z-messagebox',
            children: [new zul.wgt.Label({
              id: 'msg',
              value: msg,
              multiline: true
            })]
          })]
        }), new zul.box.Hlayout({
          sclass: 'z-messagebox-buttons',
          children: window.zul.dom_.getButtons(opts.button)
        })],
        mode: opts.mode || 'modal'
      });
      var p_1 = opts.desktop || zk.Desktop.$();
      if (p_1 && (p_1 = p_1.firstChild) && p_1.desktop) p_1.appendChild(wnd_1);else jq(document.body).append(wnd_1);
    } else {
      var label = wnd.$f('msg'),
        p = label.parent,
        pn = p.$n_();
      label.setValue(label.getValue() + '\n' + msg);
      if (!pn.style.height && pn.offsetHeight >= jq.innerHeight() * 0.6) {
        pn.style.height = jq.px0(jq.innerHeight() * 0.6);
      }
    }
  });
};
zAu.wrongValue_ = function (wgt, msg) {
  var efs = wgt.effects_;
  if (efs.errMesg) {
    efs.errMesg.destroy();
    delete efs.errMesg;
  }
  if (msg !== false) {
    efs.errMesg = {
      destroy: zk.$void
    };
    zk.load('zul.inp', function () {
      if (efs.errMesg)
        //not destroyed yet
        (efs.errMesg = new zul.inp.Errorbox(wgt, msg)).show();
    });
  }
};
window.zul.dom_.$alert = $alert;
window.zul.dom_.icons = icons;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/index.ts":
/*!****************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/index.ts ***!
  \****************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __exportStar = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__exportStar"];


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = {};
__webpack_require__(/*! ./dom */ "./zul/src/main/resources/web/js/zul/dom.ts"); // side-effect-only import
__exportStar(__webpack_require__(/*! ./Widget */ "./zul/src/main/resources/web/js/zul/Widget.ts"), exports); // jsdoc="true"
__exportStar(__webpack_require__(/*! ./LabelImageWidget */ "./zul/src/main/resources/web/js/zul/LabelImageWidget.ts"), exports); // jsdoc="true"
__exportStar(__webpack_require__(/*! ./ContainerWidget */ "./zul/src/main/resources/web/js/zul/ContainerWidget.ts"), exports); // jsdoc="true"
__exportStar(__webpack_require__(/*! ./Upload */ "./zul/src/main/resources/web/js/zul/Upload.ts"), exports); // jsdoc="true"
__exportStar(__webpack_require__(/*! ./WScroll */ "./zul/src/main/resources/web/js/zul/WScroll.ts"), exports); // jsdoc="true"
__exportStar(__webpack_require__(/*! ./Scrollbar */ "./zul/src/main/resources/web/js/zul/Scrollbar.ts"), exports); // jsdoc="true"

/***/ }),

/***/ "./node_modules/tslib/tslib.es6.js":
/*!*****************************************!*\
  !*** ./node_modules/tslib/tslib.es6.js ***!
  \*****************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __addDisposableResource: function() { return /* binding */ __addDisposableResource; },
/* harmony export */   __assign: function() { return /* binding */ __assign; },
/* harmony export */   __asyncDelegator: function() { return /* binding */ __asyncDelegator; },
/* harmony export */   __asyncGenerator: function() { return /* binding */ __asyncGenerator; },
/* harmony export */   __asyncValues: function() { return /* binding */ __asyncValues; },
/* harmony export */   __await: function() { return /* binding */ __await; },
/* harmony export */   __awaiter: function() { return /* binding */ __awaiter; },
/* harmony export */   __classPrivateFieldGet: function() { return /* binding */ __classPrivateFieldGet; },
/* harmony export */   __classPrivateFieldIn: function() { return /* binding */ __classPrivateFieldIn; },
/* harmony export */   __classPrivateFieldSet: function() { return /* binding */ __classPrivateFieldSet; },
/* harmony export */   __createBinding: function() { return /* binding */ __createBinding; },
/* harmony export */   __decorate: function() { return /* binding */ __decorate; },
/* harmony export */   __disposeResources: function() { return /* binding */ __disposeResources; },
/* harmony export */   __esDecorate: function() { return /* binding */ __esDecorate; },
/* harmony export */   __exportStar: function() { return /* binding */ __exportStar; },
/* harmony export */   __extends: function() { return /* binding */ __extends; },
/* harmony export */   __generator: function() { return /* binding */ __generator; },
/* harmony export */   __importDefault: function() { return /* binding */ __importDefault; },
/* harmony export */   __importStar: function() { return /* binding */ __importStar; },
/* harmony export */   __makeTemplateObject: function() { return /* binding */ __makeTemplateObject; },
/* harmony export */   __metadata: function() { return /* binding */ __metadata; },
/* harmony export */   __param: function() { return /* binding */ __param; },
/* harmony export */   __propKey: function() { return /* binding */ __propKey; },
/* harmony export */   __read: function() { return /* binding */ __read; },
/* harmony export */   __rest: function() { return /* binding */ __rest; },
/* harmony export */   __runInitializers: function() { return /* binding */ __runInitializers; },
/* harmony export */   __setFunctionName: function() { return /* binding */ __setFunctionName; },
/* harmony export */   __spread: function() { return /* binding */ __spread; },
/* harmony export */   __spreadArray: function() { return /* binding */ __spreadArray; },
/* harmony export */   __spreadArrays: function() { return /* binding */ __spreadArrays; },
/* harmony export */   __values: function() { return /* binding */ __values; }
/* harmony export */ });
/******************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */
/* global Reflect, Promise, SuppressedError, Symbol */

var extendStatics = function(d, b) {
    extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
    return extendStatics(d, b);
};

function __extends(d, b) {
    if (typeof b !== "function" && b !== null)
        throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
    extendStatics(d, b);
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
}

var __assign = function() {
    __assign = Object.assign || function __assign(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
        }
        return t;
    }
    return __assign.apply(this, arguments);
}

function __rest(s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
}

function __decorate(decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
}

function __param(paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
}

function __esDecorate(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
    function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
    var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
    var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
    var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
    var _, done = false;
    for (var i = decorators.length - 1; i >= 0; i--) {
        var context = {};
        for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
        for (var p in contextIn.access) context.access[p] = contextIn.access[p];
        context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
        var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
        if (kind === "accessor") {
            if (result === void 0) continue;
            if (result === null || typeof result !== "object") throw new TypeError("Object expected");
            if (_ = accept(result.get)) descriptor.get = _;
            if (_ = accept(result.set)) descriptor.set = _;
            if (_ = accept(result.init)) initializers.unshift(_);
        }
        else if (_ = accept(result)) {
            if (kind === "field") initializers.unshift(_);
            else descriptor[key] = _;
        }
    }
    if (target) Object.defineProperty(target, contextIn.name, descriptor);
    done = true;
};

function __runInitializers(thisArg, initializers, value) {
    var useValue = arguments.length > 2;
    for (var i = 0; i < initializers.length; i++) {
        value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
    }
    return useValue ? value : void 0;
};

function __propKey(x) {
    return typeof x === "symbol" ? x : "".concat(x);
};

function __setFunctionName(f, name, prefix) {
    if (typeof name === "symbol") name = name.description ? "[".concat(name.description, "]") : "";
    return Object.defineProperty(f, "name", { configurable: true, value: prefix ? "".concat(prefix, " ", name) : name });
};

function __metadata(metadataKey, metadataValue) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(metadataKey, metadataValue);
}

function __awaiter(thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
}

function __generator(thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
}

var __createBinding = Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
});

function __exportStar(m, o) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(o, p)) __createBinding(o, m, p);
}

function __values(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
}

function __read(o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
}

/** @deprecated */
function __spread() {
    for (var ar = [], i = 0; i < arguments.length; i++)
        ar = ar.concat(__read(arguments[i]));
    return ar;
}

/** @deprecated */
function __spreadArrays() {
    for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
    for (var r = Array(s), k = 0, i = 0; i < il; i++)
        for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
            r[k] = a[j];
    return r;
}

function __spreadArray(to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
}

function __await(v) {
    return this instanceof __await ? (this.v = v, this) : new __await(v);
}

function __asyncGenerator(thisArg, _arguments, generator) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var g = generator.apply(thisArg, _arguments || []), i, q = [];
    return i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i;
    function verb(n) { if (g[n]) i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); }; }
    function resume(n, v) { try { step(g[n](v)); } catch (e) { settle(q[0][3], e); } }
    function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
    function fulfill(value) { resume("next", value); }
    function reject(value) { resume("throw", value); }
    function settle(f, v) { if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]); }
}

function __asyncDelegator(o) {
    var i, p;
    return i = {}, verb("next"), verb("throw", function (e) { throw e; }), verb("return"), i[Symbol.iterator] = function () { return this; }, i;
    function verb(n, f) { i[n] = o[n] ? function (v) { return (p = !p) ? { value: __await(o[n](v)), done: false } : f ? f(v) : v; } : f; }
}

function __asyncValues(o) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var m = o[Symbol.asyncIterator], i;
    return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
    function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
    function settle(resolve, reject, d, v) { Promise.resolve(v).then(function(v) { resolve({ value: v, done: d }); }, reject); }
}

function __makeTemplateObject(cooked, raw) {
    if (Object.defineProperty) { Object.defineProperty(cooked, "raw", { value: raw }); } else { cooked.raw = raw; }
    return cooked;
};

var __setModuleDefault = Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
};

function __importStar(mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
}

function __importDefault(mod) {
    return (mod && mod.__esModule) ? mod : { default: mod };
}

function __classPrivateFieldGet(receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
}

function __classPrivateFieldSet(receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
}

function __classPrivateFieldIn(state, receiver) {
    if (receiver === null || (typeof receiver !== "object" && typeof receiver !== "function")) throw new TypeError("Cannot use 'in' operator on non-object");
    return typeof state === "function" ? receiver === state : state.has(receiver);
}

function __addDisposableResource(env, value, async) {
    if (value !== null && value !== void 0) {
        if (typeof value !== "object" && typeof value !== "function") throw new TypeError("Object expected.");
        var dispose;
        if (async) {
            if (!Symbol.asyncDispose) throw new TypeError("Symbol.asyncDispose is not defined.");
            dispose = value[Symbol.asyncDispose];
        }
        if (dispose === void 0) {
            if (!Symbol.dispose) throw new TypeError("Symbol.dispose is not defined.");
            dispose = value[Symbol.dispose];
        }
        if (typeof dispose !== "function") throw new TypeError("Object not disposable.");
        env.stack.push({ value: value, dispose: dispose, async: async });
    }
    else if (async) {
        env.stack.push({ async: true });
    }
    return value;
}

var _SuppressedError = typeof SuppressedError === "function" ? SuppressedError : function (error, suppressed, message) {
    var e = new Error(message);
    return e.name = "SuppressedError", e.error = error, e.suppressed = suppressed, e;
};

function __disposeResources(env) {
    function fail(e) {
        env.error = env.hasError ? new _SuppressedError(e, env.error, "An error was suppressed during disposal.") : e;
        env.hasError = true;
    }
    function next() {
        while (env.stack.length) {
            var rec = env.stack.pop();
            try {
                var result = rec.dispose && rec.dispose.call(rec.value);
                if (rec.async) return Promise.resolve(result).then(next, function(e) { fail(e); return next(); });
            }
            catch (e) {
                fail(e);
            }
        }
        if (env.hasError) throw env.error;
    }
    return next();
}

/* harmony default export */ __webpack_exports__["default"] = ({
    __extends: __extends,
    __assign: __assign,
    __rest: __rest,
    __decorate: __decorate,
    __param: __param,
    __metadata: __metadata,
    __awaiter: __awaiter,
    __generator: __generator,
    __createBinding: __createBinding,
    __exportStar: __exportStar,
    __values: __values,
    __read: __read,
    __spread: __spread,
    __spreadArrays: __spreadArrays,
    __spreadArray: __spreadArray,
    __await: __await,
    __asyncGenerator: __asyncGenerator,
    __asyncDelegator: __asyncDelegator,
    __asyncValues: __asyncValues,
    __makeTemplateObject: __makeTemplateObject,
    __importStar: __importStar,
    __importDefault: __importDefault,
    __classPrivateFieldGet: __classPrivateFieldGet,
    __classPrivateFieldSet: __classPrivateFieldSet,
    __classPrivateFieldIn: __classPrivateFieldIn,
    __addDisposableResource: __addDisposableResource,
    __disposeResources: __disposeResources,
});


/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	!function() {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = function(exports, definition) {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	!function() {
/******/ 		__webpack_require__.o = function(obj, prop) { return Object.prototype.hasOwnProperty.call(obj, prop); }
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	!function() {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = function(exports) {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	}();
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module is referenced by other modules so it can't be inlined
/******/ 	var __webpack_exports__ = __webpack_require__("./zul/src/main/resources/web/js/zul/index.ts");
/******/ 	var __webpack_export_target__ = window;
/******/ 	var __webpack_exports_export__ = __webpack_exports__["default"];
/******/ 	for(var i in __webpack_exports_export__) __webpack_export_target__[i] = __webpack_exports_export__[i];
/******/ 	if(__webpack_exports_export__.__esModule) Object.defineProperty(__webpack_export_target__, "__esModule", { value: true });
/******/ 	
/******/ })()
;