/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.util.Objects;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuInvoke;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.OpenEvent;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.Bandpopup;
import org.zkoss.zul.Textbox;

public class Bandbox
extends Textbox {
    public static final String ICON_SCLASS = "z-icon-search";
    private boolean _autodrop;
    private boolean _btnVisible = true;
    private boolean _open;
    private String _popupWidth;
    private String _iconSclass = "z-icon-search";

    public Bandbox() {
    }

    public Bandbox(String value) throws WrongValueException {
        this();
        this.setValue(value);
    }

    public Bandpopup getDropdown() {
        return (Bandpopup)this.getFirstChild();
    }

    public boolean isAutodrop() {
        return this._autodrop;
    }

    public void setAutodrop(boolean autodrop) {
        if (this._autodrop != autodrop) {
            this._autodrop = autodrop;
            this.smartUpdate("autodrop", autodrop);
        }
    }

    public boolean isButtonVisible() {
        return this._btnVisible;
    }

    public void setButtonVisible(boolean visible) {
        if (this._btnVisible != visible) {
            this._btnVisible = visible;
            this.smartUpdate("buttonVisible", visible);
        }
    }

    public boolean isOpen() {
        return this._open;
    }

    public void setOpen(boolean open) {
        if (this.isVisible() && this._open != open) {
            this._open = open;
            this.smartUpdate("open", open);
        }
    }

    public void open() {
        this._open = true;
        this.response("open", (AuResponse)new AuInvoke((Component)this, "setOpen", true), -1000);
    }

    public void close() {
        this._open = false;
        this.response("open", (AuResponse)new AuInvoke((Component)this, "setOpen", false), -1000);
    }

    @Override
    public void setMultiline(boolean multiline) {
        if (multiline) {
            throw new UnsupportedOperationException("Bandbox doesn't support multiline");
        }
    }

    @Override
    public void setRows(int rows) {
        if (rows != 1) {
            throw new UnsupportedOperationException("Bandbox doesn't support multiple rows, " + rows);
        }
    }

    public void setIconSclass(String iconSclass) {
        if (!Objects.equals(this._iconSclass, iconSclass)) {
            this._iconSclass = iconSclass;
            this.smartUpdate("iconSclass", iconSclass);
        }
    }

    public String getIconSclass() {
        return this._iconSclass;
    }

    @Override
    public String getZclass() {
        return this._zclass == null ? "z-bandbox" : this._zclass;
    }

    @Override
    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        this.render(renderer, "autodrop", this._autodrop);
        if (!this._btnVisible) {
            renderer.render("buttonVisible", false);
        }
        if (this._popupWidth != null) {
            renderer.render("popupWidth", this._popupWidth);
        }
        if (!ICON_SCLASS.equals(this._iconSclass)) {
            renderer.render("iconSclass", this._iconSclass);
        }
        if (this._open) {
            renderer.render("open", true);
        }
    }

    @Override
    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        if (cmd.equals("onOpen")) {
            OpenEvent evt = OpenEvent.getOpenEvent((AuRequest)request);
            this._open = evt.isOpen();
            Events.postEvent((Event)evt);
        } else {
            super.service(request, everError);
        }
    }

    public void beforeChildAdded(Component newChild, Component refChild) {
        if (!(newChild instanceof Bandpopup)) {
            throw new UiException("Unsupported child for Bandbox: " + String.valueOf(newChild));
        }
        if (this.getFirstChild() != null) {
            throw new UiException("At most one bandpopup is allowed, " + String.valueOf(this));
        }
        super.beforeChildAdded(newChild, refChild);
    }

    @Override
    protected boolean isChildable() {
        return true;
    }

    public String getPopupWidth() {
        return this._popupWidth;
    }

    public void setPopupWidth(String popupWidth) {
        if (!Objects.equals(popupWidth, this._popupWidth)) {
            this._popupWidth = popupWidth;
            this.smartUpdate("popupWidth", popupWidth);
        }
    }

    static {
        Bandbox.addClientEvent(Bandbox.class, (String)"onOpen", (int)8193);
    }
}

