/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import org.zkoss.lang.Objects;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.ScrollEvent;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.impl.XulElement;

public class Slider
extends XulElement {
    private String _orient = "horizontal";
    private String _mode = "integer";
    private Double _curpos = 0.0;
    private Double _minpos = 0.0;
    private Double _maxpos = 100.0;
    private Double _pginc = -1.0;
    private Double _step = -1.0;
    private String _name;
    private String _slidingtext = "{0}";
    private double _angleArc = 360.0;
    private double _strokeWidth = 10.0;
    private double _scaleInput = 1.0;
    private boolean _isInitialRender = false;
    public static final String INTEGER = "integer";
    public static final String DECIMAL = "decimal";

    public Slider() {
    }

    public Slider(int curpos) {
        this();
        this.setCurpos(curpos);
    }

    boolean inScaleMold() {
        return "scale".equals(this.getMold());
    }

    boolean inSphereMold() {
        return "sphere".equals(this.getMold());
    }

    public String getZclass() {
        return this._zclass == null ? "z-slider" : this._zclass;
    }

    public String getOrient() {
        return this._orient;
    }

    public void setOrient(String orient) throws WrongValueException {
        if (!"horizontal".equals(orient) && !"vertical".equals(orient)) {
            throw new WrongValueException("orient cannot be " + orient);
        }
        if (!Objects.equals((Object)orient, (Object)this._orient)) {
            this._orient = orient;
            this.smartUpdate("orient", this._orient);
        }
    }

    public String getSlidingtext() {
        return this._slidingtext;
    }

    public void setSlidingtext(String slidingtext) {
        if (slidingtext == null || slidingtext.length() == 0) {
            slidingtext = "{0}";
        }
        if (!slidingtext.equals(this._slidingtext)) {
            this._slidingtext = slidingtext;
            this.smartUpdate("slidingtext", this._slidingtext);
        }
    }

    public int getCurpos() {
        return this._curpos.intValue();
    }

    public double getCurposInDouble() {
        return this._curpos;
    }

    public void setCurpos(int curpos) {
        this.setCurpos((double)curpos);
    }

    public void setCurpos(double curpos) throws WrongValueException {
        if (this._isInitialRender) {
            this.validateCurpos();
        }
        if (Double.compare(this._curpos, curpos) != 0) {
            this._curpos = curpos;
            this.smartUpdate("curpos", this._curpos);
        }
    }

    private void validateCurpos() {
        if (this._curpos < this._minpos) {
            this._curpos = this._minpos;
        } else if (this._curpos > this._maxpos) {
            this._curpos = this._maxpos;
        }
        this._isInitialRender = true;
    }

    public int getMinpos() {
        return this._minpos.intValue();
    }

    public double getMinposInDouble() {
        return this._minpos;
    }

    public void setMinpos(int minpos) {
        this.setMinpos((double)minpos);
    }

    public void setMinpos(double minpos) throws WrongValueException {
        if (minpos < 0.0) {
            throw new WrongValueException("Nonpositive is not allowed: " + minpos);
        }
        if (Double.compare(this._minpos, minpos) != 0) {
            if (this._curpos < minpos) {
                this._curpos = minpos;
            }
            this._minpos = minpos;
            this.smartUpdate("minpos", this._minpos);
        }
    }

    public int getMaxpos() {
        return this._maxpos.intValue();
    }

    public double getMaxposInDouble() {
        return this._maxpos;
    }

    public void setMaxpos(int maxpos) {
        this.setMaxpos((double)maxpos);
    }

    public void setMaxpos(double maxpos) throws WrongValueException {
        if (maxpos <= 0.0) {
            throw new WrongValueException("Nonpositive is not allowed: " + maxpos);
        }
        if (Double.compare(this._maxpos, maxpos) != 0) {
            if (this._curpos > maxpos) {
                this._curpos = maxpos;
            }
            this._maxpos = maxpos;
            this.smartUpdate("maxpos", this._maxpos);
        }
    }

    public boolean isVertical() {
        return "vertical".equals(this.getOrient());
    }

    public int getPageIncrement() {
        return this._pginc.intValue();
    }

    public double getPageIncrementInDouble() {
        return this._pginc;
    }

    public void setPageIncrement(int pginc) {
        this.setPageIncrement((double)pginc);
    }

    public void setPageIncrement(double pginc) throws WrongValueException {
        if (Double.compare(this._pginc, pginc) != 0) {
            this._pginc = pginc;
            this.smartUpdate("pageIncrement", this._pginc);
        }
    }

    public int getStep() {
        return this._step.intValue();
    }

    public double getStepInDouble() {
        return this._step;
    }

    public void setStep(int step) {
        this.setStep((double)step);
    }

    public void setStep(double step) throws WrongValueException {
        if (step <= 0.0) {
            step = -1.0;
        }
        if (Double.compare(this._step, step) != 0) {
            this._step = step;
            this.smartUpdate("step", this._step);
        }
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        if (name != null && name.length() == 0) {
            name = null;
        }
        if (!Objects.equals((Object)this._name, (Object)name)) {
            this._name = name;
            this.smartUpdate("name", this._name);
        }
    }

    public void setMold(String mold) {
        if (this.isVertical()) {
            if (mold.startsWith("scale")) {
                throw new WrongValueException("Unsupported vertical orient in mold : " + mold);
            }
            super.setMold(mold);
        } else {
            super.setMold(mold);
        }
    }

    public void setMode(String mode) {
        if (!INTEGER.equals(mode) && !DECIMAL.equals(mode)) {
            throw new WrongValueException("mode cannot be " + mode);
        }
        if (!Objects.equals((Object)this._mode, (Object)mode)) {
            this._mode = mode;
            this.smartUpdate("mode", this._mode);
        }
    }

    public boolean isDecimal() {
        return DECIMAL.equals(this._mode);
    }

    public void setRange(int minpos, int maxpos) {
        this.setRange((double)minpos, (double)maxpos);
    }

    public void setRange(double minpos, double maxpos) {
        this.setMinpos(minpos);
        this.setMaxpos(maxpos);
    }

    public void setAngleArc(double angleArc) {
        if (angleArc > 360.0 || angleArc <= 0.0) {
            throw new WrongValueException("The value of angleArc should be between 0 and 360 degree");
        }
        if (this._angleArc != angleArc) {
            this._angleArc = angleArc;
            this.smartUpdate("angleArc", this._angleArc);
        }
    }

    public double getAngleArc() {
        return this._angleArc;
    }

    public void setStrokeWidth(double strokeWidth) {
        if (strokeWidth <= 0.0) {
            throw new WrongValueException("The value of strokeWidth should be larger than 0");
        }
        if (this._strokeWidth != strokeWidth) {
            this._strokeWidth = strokeWidth;
            this.smartUpdate("strokeWidth", this._strokeWidth);
        }
    }

    public double getStrokeWidth() {
        return this._strokeWidth;
    }

    public void setScaleInput(double scaleInput) {
        if (this._scaleInput <= 0.0) {
            throw new WrongValueException("The value of scaleInput should be larger than 0");
        }
        if (this._scaleInput != scaleInput) {
            this._scaleInput = scaleInput;
            this.smartUpdate("scaleInput", this._scaleInput);
        }
    }

    public double getScaleInput() {
        return this._scaleInput;
    }

    protected boolean isChildable() {
        return false;
    }

    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        if ("onScroll".equals(cmd)) {
            ScrollEvent evt = ScrollEvent.getScrollEvent((AuRequest)request);
            double curpos = evt.getPosInDouble();
            this._curpos = curpos > this._minpos ? curpos : this._minpos;
            Events.postEvent((Event)evt);
        } else if ("onScrolling".equals(cmd)) {
            ScrollEvent evt = ScrollEvent.getScrollEvent((AuRequest)request);
            Events.postEvent((Event)evt);
        } else {
            super.service(request, everError);
        }
    }

    @Override
    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        this.validateCurpos();
        if (!"horizontal".equals(this._orient)) {
            renderer.render("orient", this._orient);
        }
        if (!"{0}".equals(this._slidingtext)) {
            renderer.render("slidingtext", this._slidingtext);
        }
        if (this._curpos != 0.0) {
            renderer.render("curpos", (Object)this._curpos);
        }
        if (this._maxpos != 100.0) {
            renderer.render("maxpos", (Object)this._maxpos);
        }
        if (this._minpos != 0.0) {
            renderer.render("minpos", (Object)this._minpos);
        }
        if (this._pginc >= 0.0) {
            renderer.render("pageIncrement", (Object)this._pginc);
        }
        if (this._step > 0.0) {
            renderer.render("step", (Object)this._step);
        }
        if (this._strokeWidth != 10.0) {
            renderer.render("strokeWidth", this._strokeWidth);
        }
        if (this._angleArc != 360.0) {
            renderer.render("angleArc", this._angleArc);
        }
        if (this._scaleInput != 1.0) {
            renderer.render("scaleInput", this._scaleInput);
        }
        if (this._name != null) {
            renderer.render("name", this._name);
        }
        if (!INTEGER.equals(this._mode)) {
            renderer.render("mode", this._mode);
        }
    }

    static {
        Slider.addClientEvent(Slider.class, (String)"onScroll", (int)8193);
        Slider.addClientEvent(Slider.class, (String)"onScrolling", (int)8192);
    }
}

