/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.zkoss.lang.Objects;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zul.AbstractChartModel;

public class GanttModel
extends AbstractChartModel {
    private static final long serialVersionUID = 20091008183023L;
    private Map<Comparable<?>, List<GanttTask>> _taskMap = new LinkedHashMap(8);

    public void addValue(Comparable<?> series, GanttTask task) {
        List<GanttTask> tasks = this._taskMap.get(series);
        if (tasks == null) {
            tasks = new ArrayList<GanttTask>(13);
            this._taskMap.put(series, tasks);
        }
        if (task.getSeries() != null) {
            throw new UiException("A GanttTask in a series cannot be added again: " + String.valueOf(task.getSeries()) + ":" + task.getDescription());
        }
        task.setSeries(series);
        task.setOwner(this);
        tasks.add(task);
        this.fireEvent(1, series, null, -1, -1, task);
    }

    public void removeValue(Comparable<?> series, GanttTask task) {
        List<GanttTask> tasks = this._taskMap.get(series);
        if (tasks == null) {
            return;
        }
        tasks.remove(task);
        task.setSeries(null);
        task.setOwner(null);
        this.fireEvent(2, series, null, -1, -1, task);
    }

    public Comparable<?>[] getAllSeries() {
        Set<Comparable<?>> allseries = this._taskMap.keySet();
        return allseries.toArray(new Comparable[allseries.size()]);
    }

    public GanttTask[] getTasks(Comparable<?> series) {
        List<GanttTask> tasks = this._taskMap.get(series);
        return tasks == null ? new GanttTask[]{} : tasks.toArray(new GanttTask[tasks.size()]);
    }

    @Override
    public Object clone() {
        GanttModel clone = (GanttModel)super.clone();
        if (this._taskMap != null) {
            clone._taskMap = new LinkedHashMap(this._taskMap);
        }
        return clone;
    }

    public static class GanttTask
    implements Serializable {
        private static final long serialVersionUID = 20091008183314L;
        private Comparable<?> _series;
        private Date _start;
        private Date _end;
        private String _description;
        private double _percent;
        private Collection<GanttTask> _subtasks;
        private GanttModel _owner;

        public GanttTask(String description, Date start, Date end, double percent) {
            this._description = description;
            this._start = start;
            this._end = end;
            this._percent = percent;
            this._subtasks = new LinkedList<GanttTask>();
        }

        public Date getStart() {
            return this._start;
        }

        public void setStart(Date start) {
            if (!Objects.equals((Object)start, (Object)this._start)) {
                this._start = start;
                this.fireChartChange();
            }
        }

        public Date getEnd() {
            return this._end;
        }

        public void setEnd(Date end) {
            if (!Objects.equals((Object)end, (Object)this._end)) {
                this._end = end;
                this.fireChartChange();
            }
        }

        public String getDescription() {
            return this._description;
        }

        public void setDescription(String description) {
            if (!Objects.equals((Object)description, (Object)this._description)) {
                this._description = description;
                this.fireChartChange();
            }
        }

        public double getPercent() {
            return this._percent;
        }

        public void setPercent(double percent) {
            if (Double.compare(percent, this._percent) != 0) {
                this._percent = percent;
                if (this._owner != null) {
                    this._owner.fireEvent(0, this._series, null, -1, -1, this);
                }
            }
        }

        public void addSubtask(GanttTask task) {
            if (task.getSeries() != null) {
                throw new UiException("A GanttTask in a series cannot be added again: " + String.valueOf(task.getSeries()) + ":" + task.getDescription());
            }
            task.setSeries(this._series);
            task.setOwner(this._owner);
            this._subtasks.add(task);
            if (this._owner != null) {
                this._owner.fireEvent(0, this._series, null, -1, -1, this);
            }
        }

        public void removeSubtask(GanttTask task) {
            if (this._subtasks.remove(task)) {
                task.setSeries(null);
                task.setOwner(null);
                if (this._owner != null) {
                    this._owner.fireEvent(0, this._series, null, -1, -1, this);
                }
            }
        }

        public GanttTask[] getSubtasks() {
            return this._subtasks.toArray(new GanttTask[this._subtasks.size()]);
        }

        private Comparable<?> getSeries() {
            return this._series;
        }

        private void setSeries(Comparable<?> series) {
            this._series = series;
        }

        private void setOwner(GanttModel owner) {
            this._owner = owner;
        }

        protected void fireChartChange() {
            if (this._owner != null) {
                this._owner.fireEvent(0, this._series, null, -1, -1, this);
            }
        }
    }
}

