/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.Serializable;
import org.zkoss.lang.Objects;
import org.zkoss.zul.Chart;
import org.zkoss.zul.DialModelScale;
import org.zkoss.zul.event.DialChartDataEvent;

public class DialModelRange
implements Serializable {
    private DialModelScale _scale;
    private double _lower;
    private double _upper;
    private String _color;
    private int[] _RGB = new int[]{0, 0, 255};
    private double _innerRadius;
    private double _outerRadius;

    DialModelRange(DialModelScale scale) {
        this._scale = scale;
    }

    public void setRange(double lower, double upper, String color, double innerRadius, double outerRadius) {
        this._lower = lower;
        this._upper = upper;
        this.setRangeColor(color);
        this._innerRadius = innerRadius;
        this._outerRadius = outerRadius;
    }

    public void setRangeColor(String color) {
        if (Objects.equals((Object)color, (Object)this._color)) {
            return;
        }
        this._color = color;
        if (this._color == null) {
            this._RGB = null;
        } else {
            this._RGB = new int[3];
            Chart.decode(this._color, this._RGB);
        }
        this._scale.fireEvent(0, DialChartDataEvent.RANGE_COLOR, color);
    }

    public String getRangeColor() {
        return this._color;
    }

    public int[] getRangeRGB() {
        return this._RGB;
    }

    public void setInnerRadius(double radius) {
        this._innerRadius = radius;
        this._scale.fireEvent(0, DialChartDataEvent.INNER_RADIUS, radius);
    }

    public double getInnerRadius() {
        return this._innerRadius;
    }

    public void setOuterRadius(double radius) {
        this._outerRadius = radius;
        this._scale.fireEvent(0, DialChartDataEvent.OUTER_RADIUS, radius);
    }

    public double getOuterRadius() {
        return this._outerRadius;
    }

    public double getLowerBound() {
        return this._lower;
    }

    public void setLowerBound(double lower) {
        if (Double.compare(this._lower, lower) != 0) {
            this._lower = lower;
            this._scale.fireEvent(0, DialChartDataEvent.LOWER_BOUND, lower);
        }
    }

    public double getUpperBound() {
        return this._upper;
    }

    public void setUpperBound(double upper) {
        if (Double.compare(this._upper, upper) != 0) {
            this._upper = upper;
            this._scale.fireEvent(0, DialChartDataEvent.UPPER_BOUND, upper);
        }
    }
}

