/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.ext.render.Cropper;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.Grid;
import org.zkoss.zul.Group;
import org.zkoss.zul.Groupfoot;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.Row;
import org.zkoss.zul.ext.Pageable;
import org.zkoss.zul.ext.Paginal;
import org.zkoss.zul.impl.DataLoader;
import org.zkoss.zul.impl.GroupsListModel;
import org.zkoss.zul.impl.XulElement;

public class Rows
extends XulElement {
    private int _visibleItemCount;
    private transient List<int[]> _groupsInfo;
    private transient List<Group> _groups;
    private transient boolean _isReplacingRow;

    public Rows() {
        this.init();
    }

    private void init() {
        this._groupsInfo = new LinkedList<int[]>();
        this._groups = new AbstractList<Group>(){

            @Override
            public int size() {
                return Rows.this.getGroupCount();
            }

            @Override
            public Iterator<Group> iterator() {
                return new IterGroups();
            }

            @Override
            public Group get(int index) {
                int realIndex = Rows.this.getRealIndex(Rows.this._groupsInfo.get(index)[0]);
                return realIndex >= 0 && realIndex < Rows.this.getChildren().size() ? (Group)((Object)Rows.this.getChildren().get(realIndex)) : null;
            }
        };
    }

    private int getRealIndex(int index) {
        Grid grid = this.getGrid();
        int offset = grid != null && grid.getModel() != null ? grid.getDataLoader().getOffset() : 0;
        return index - (offset < 0 ? 0 : offset);
    }

    public Grid getGrid() {
        return (Grid)this.getParent();
    }

    public int getGroupCount() {
        return this._groupsInfo.size();
    }

    public List<Group> getGroups() {
        return this._groups;
    }

    public boolean hasGroup() {
        return !this._groupsInfo.isEmpty();
    }

    public int getVisibleItemCount() {
        return this._visibleItemCount;
    }

    void addVisibleItemCount(int count) {
        if (count != 0) {
            this._visibleItemCount += count;
            Grid grid = this.getGrid();
            if (grid != null) {
                if (grid.inPagingMold()) {
                    int maxPageIndex;
                    Pageable p;
                    int actpg;
                    Paginal pgi = grid.getPaginal();
                    int newTotalSize = grid.getDataLoader().getTotalSize();
                    ListModel model = grid.getModel();
                    if (count < 0 && model instanceof Pageable && (actpg = (p = (Pageable)((Object)model)).getActivePage()) > (maxPageIndex = p.getPageCount() - 1)) {
                        p.setActivePage(maxPageIndex);
                    }
                    pgi.setTotalSize(newTotalSize);
                    if (grid.getModel() != null) {
                        grid.invalidate();
                    } else {
                        this.invalidate();
                        grid.getDataLoader().updateModelInfo();
                    }
                } else if (((Cropper)grid.getDataLoader()).isCropper()) {
                    this.invalidate();
                    grid.getDataLoader().updateModelInfo();
                } else {
                    this.smartUpdate("visibleItemCount", this._visibleItemCount);
                }
            }
        }
    }

    boolean setReplacingRow(boolean b) {
        boolean old = this._isReplacingRow;
        Grid grid = this.getGrid();
        if (grid != null && grid.getModel() != null) {
            this._isReplacingRow = b;
        }
        return old;
    }

    void fixGroupIndex(int j, int to, boolean infront) {
        int realj = this.getRealIndex(j);
        if (realj < 0) {
            realj = 0;
        }
        if (realj < this.getChildren().size()) {
            int beginning = j;
            ListIterator it = this.getChildren().listIterator(realj);
            while (it.hasNext() && (to < 0 || j <= to)) {
                int[] g;
                Component o = (Component)it.next();
                ((Row)o).setIndexDirectly(j);
                if (this._isReplacingRow) break;
                if ((!infront || beginning != j) && o instanceof Group && (g = this.getLastGroupsInfoAt(j + (infront ? -1 : 1))) != null) {
                    g[0] = j;
                    if (g[2] != -1) {
                        g[2] = g[2] + (infront ? 1 : -1);
                    }
                }
                ++j;
            }
        }
    }

    Group getGroup(int index) {
        int realIndex;
        if (this._groupsInfo.isEmpty()) {
            return null;
        }
        int[] g = this.getGroupsInfoAt(index);
        if (g != null && (realIndex = this.getRealIndex(g[0])) >= 0 && realIndex < this.getChildren().size()) {
            Row row = (Row)((Object)this.getChildren().get(realIndex));
            return (Group)row;
        }
        return null;
    }

    int[] getGroupsInfoAt(int index) {
        return this.getGroupsInfoAt(index, false);
    }

    int[] getGroupsInfoAt(int index, boolean isGroup) {
        for (int[] g : this._groupsInfo) {
            if (!(isGroup ? index == g[0] : index > g[0] && index <= g[0] + g[1])) continue;
            return g;
        }
        return null;
    }

    int[] getLastGroupsInfoAt(int index) {
        int[] rg = null;
        for (int[] g : this._groupsInfo) {
            if (index == g[0]) {
                rg = g;
                continue;
            }
            if (index >= g[0]) continue;
            break;
        }
        return rg;
    }

    int getGroupIndex(int index) {
        int j = 0;
        int gindex = -1;
        int[] g2 = null;
        for (int[] g2 : this._groupsInfo) {
            if (index == g2[0]) {
                gindex = j;
            } else if (index < g2[0]) break;
            ++j;
        }
        return gindex != -1 ? gindex : (g2 != null && index < g2[0] + g2[1] ? j - 1 : (g2 != null && index == g2[0] + g2[1] && g2[2] == -1 ? j - 1 : gindex));
    }

    public void beforeParentChanged(Component parent) {
        if (parent != null && !(parent instanceof Grid)) {
            throw new UiException("Unsupported parent for rows: " + String.valueOf(parent));
        }
        super.beforeParentChanged(parent);
    }

    public void beforeChildAdded(Component child, Component refChild) {
        if (!(child instanceof Row)) {
            throw new UiException("Unsupported child for rows: " + String.valueOf(child));
        }
        if (child instanceof Groupfoot) {
            if (!this.hasGroup()) {
                throw new UiException("Groupfoot cannot exist alone, you have to add a Group first");
            }
            if (refChild == null && this.getLastChild() instanceof Groupfoot) {
                throw new UiException("Only one Groupfoot is allowed per Group");
            }
        }
        super.beforeChildAdded(child, refChild);
    }

    private boolean hasGroupsModel() {
        Grid grid = this.getGrid();
        return grid != null && grid.getModel() instanceof GroupsListModel;
    }

    public boolean insertBefore(Component child, Component refChild) {
        boolean isReorder;
        Grid grid = this.getGrid();
        boolean bl = isReorder = child.getParent() == this;
        if (isReorder) {
            this.checkInvalidateForMoved(child, true);
        }
        Row newItem = (Row)child;
        int jfrom = this.hasGroup() && newItem.getParent() == this ? newItem.getIndex() : -1;
        this.fixGroupsInfoBeforeInsert(newItem, (Row)refChild, isReorder);
        if (super.insertBefore(child, refChild)) {
            int fixFrom;
            int jto = refChild instanceof Row ? ((Row)refChild).getIndex() : -1;
            int n = fixFrom = jfrom < 0 || jto >= 0 && jfrom > jto ? jto : jfrom;
            if (fixFrom < 0) {
                newItem.setIndexDirectly(this.getChildren().size() - 1 + (grid != null ? grid.getDataLoader().getOffset() : 0));
            } else {
                this.fixGroupIndex(fixFrom, jfrom >= 0 && jto >= 0 ? (jfrom > jto ? jfrom : jto) : -1, !isReorder);
            }
            this.fixGroupsInfoAfterInsert(newItem);
            if (!isReorder) {
                this.afterInsert(child);
            }
            return true;
        }
        return false;
    }

    public boolean removeChild(Component child) {
        if (child.getParent() == this) {
            this.beforeRemove(child);
        }
        boolean hasGroup = this.hasGroup();
        int index = ((Row)child).getIndex();
        if (super.removeChild(child)) {
            ((Row)child).setIndexDirectly(-1);
            this.fixGroupsInfoAfterRemove((Row)child, index);
            return true;
        }
        return false;
    }

    private void fixRowIndices(int j, int to) {
        List items;
        int realj = this.getRealIndex(j);
        if (realj < 0) {
            realj = 0;
        }
        if (realj < (items = this.getChildren()).size()) {
            ListIterator it = items.listIterator(realj);
            while (it.hasNext() && (to < 0 || j <= to)) {
                ((Row)((Object)it.next())).setIndexDirectly(j);
                ++j;
            }
        }
    }

    protected void afterInsert(Component comp) {
        if (this._isReplacingRow) {
            return;
        }
        this.updateVisibleCount((Row)comp, false);
        this.checkInvalidateForMoved(comp, false);
    }

    protected void beforeRemove(Component comp) {
        if (this._isReplacingRow) {
            return;
        }
        this.updateVisibleCount((Row)comp, true);
        this.checkInvalidateForMoved(comp, true);
    }

    private void fixGroupsInfoBeforeInsert(Row newItem, Row refChild, boolean isReorder) {
        if (this._isReplacingRow) {
            return;
        }
        if (newItem instanceof Groupfoot) {
            if (refChild == null) {
                int idx;
                int[] ginfo;
                if (isReorder && (ginfo = this.getGroupsInfoAt(idx = newItem.getIndex())) != null) {
                    ginfo[1] = ginfo[1] - 1;
                    ginfo[2] = -1;
                }
                int[] g = this._groupsInfo.get(this.getGroupCount() - 1);
                g[2] = this.getChildren().size() - (isReorder ? 2 : 1);
            } else {
                int nindex;
                int[] ginfo;
                int idx = refChild.getIndex();
                int[] g = this.getGroupsInfoAt(idx);
                if (g == null) {
                    throw new UiException("Groupfoot cannot exist alone, you have to add a Group first");
                }
                if (g[2] != -1) {
                    throw new UiException("Only one Goupfooter is allowed per Group");
                }
                if (idx != g[0] + g[1]) {
                    throw new UiException("Groupfoot must be placed after the last Row of the Group");
                }
                g[2] = idx - 1;
                if (isReorder && (ginfo = this.getGroupsInfoAt(nindex = newItem.getIndex())) != null) {
                    ginfo[1] = ginfo[1] - 1;
                    ginfo[2] = -1;
                }
            }
        }
    }

    private void fixGroupsInfoAfterInsert(Row newItem) {
        int index;
        int[] g;
        if (this._isReplacingRow) {
            return;
        }
        if (newItem instanceof Group) {
            Group group = (Group)newItem;
            int index2 = group.getIndex();
            if (this._groupsInfo.isEmpty()) {
                this._groupsInfo.add(new int[]{group.getIndex(), this.getChildren().size() - index2, -1});
            } else {
                int idx = 0;
                int[] prev = null;
                int[] next = null;
                for (int[] g2 : this._groupsInfo) {
                    if (g2[0] <= index2) {
                        prev = g2;
                        ++idx;
                        continue;
                    }
                    next = g2;
                    break;
                }
                if (prev != null) {
                    int leng = index2 - prev[0];
                    int size = prev[1] - leng + 1;
                    prev[1] = leng;
                    this._groupsInfo.add(idx, new int[]{index2, size, size > 1 && prev[2] >= index2 ? prev[2] + 1 : -1});
                    if (size > 1 && prev[2] >= index2) {
                        prev[2] = -1;
                    }
                } else if (next != null) {
                    this._groupsInfo.add(idx, new int[]{index2, next[0] - index2, -1});
                }
            }
        } else if (this.hasGroup() && (g = this.getGroupsInfoAt(index = newItem.getIndex())) != null) {
            g[1] = g[1] + 1;
            if (g[2] != -1 && (g[2] >= index || newItem instanceof Groupfoot)) {
                g[2] = g[0] + g[1] - 1;
            }
        }
    }

    private void fixGroupsInfoAfterRemove(Row child, int index) {
        if (!this._isReplacingRow) {
            if (child instanceof Group) {
                int[] prev = null;
                int[] remove = null;
                for (int[] g : this._groupsInfo) {
                    if (g[0] == index) {
                        remove = g;
                        break;
                    }
                    prev = g;
                }
                if (prev != null && remove != null) {
                    prev[1] = prev[1] + (remove[1] - 1);
                }
                this.fixGroupIndex(index, -1, false);
                if (remove != null) {
                    int realIndex;
                    this._groupsInfo.remove(remove);
                    int idx = remove[2];
                    if (idx != -1 && (realIndex = this.getRealIndex(idx) - 1) >= 0 && realIndex < this.getChildren().size()) {
                        this.removeChild((Component)this.getChildren().get(realIndex));
                    }
                }
            } else if (this.hasGroup()) {
                int[] g1;
                int[] g = this.getGroupsInfoAt(index);
                if (g != null) {
                    g[1] = g[1] - 1;
                    if (g[2] != -1) {
                        g[2] = g[2] - 1;
                    }
                    this.fixGroupIndex(index, -1, false);
                } else {
                    this.fixGroupIndex(index, -1, false);
                }
                if (child instanceof Groupfoot && (g1 = this.getGroupsInfoAt(index)) != null) {
                    g1[2] = -1;
                }
            } else {
                this.fixRowIndices(index, -1);
            }
        }
        if (this.hasGroupsModel() && this.getChildren().size() <= 0) {
            this._groupsInfo = new LinkedList<int[]>();
        }
    }

    private void updateVisibleCount(Row row, boolean isRemove) {
        Grid grid;
        if (row instanceof Group || row.isVisible()) {
            Group g = this.getGroup(row.getIndex());
            if (row.isVisible() && (row instanceof Groupfoot || row instanceof Group || g == null || g.isOpen())) {
                this.addVisibleItemCount(isRemove ? -1 : 1);
            }
            if (row instanceof Group) {
                Group group = (Group)row;
                Row preRow = (Row)row.getPreviousSibling();
                if (preRow == null) {
                    if (!group.isOpen()) {
                        this.addVisibleItemCount(isRemove ? group.getVisibleItemCount() : -group.getVisibleItemCount());
                    }
                } else {
                    Group preGroup;
                    Group group2 = preGroup = preRow instanceof Group ? (Group)preRow : this.getGroup(preRow.getIndex());
                    if (preGroup != null) {
                        if (!preGroup.isOpen() && group.isOpen()) {
                            this.addVisibleItemCount(isRemove ? -group.getVisibleItemCount() : group.getVisibleItemCount());
                        } else if (preGroup.isOpen() && !group.isOpen()) {
                            this.addVisibleItemCount(isRemove ? group.getVisibleItemCount() : -group.getVisibleItemCount());
                        }
                    } else if (!group.isOpen()) {
                        this.addVisibleItemCount(isRemove ? group.getVisibleItemCount() : -group.getVisibleItemCount());
                    }
                }
            }
        }
        if ((grid = this.getGrid()) != null && grid.inPagingMold()) {
            int maxPageIndex;
            Pageable p;
            int actpg;
            int newTotalSize = grid.getDataLoader().getTotalSize();
            ListModel model = grid.getModel();
            if (isRemove && model instanceof Pageable && (actpg = (p = (Pageable)((Object)model)).getActivePage()) > (maxPageIndex = p.getPageCount() - 1)) {
                p.setActivePage(maxPageIndex);
            }
            grid.getPaginal().setTotalSize(newTotalSize);
        }
    }

    private void checkInvalidateForMoved(Component child, boolean bRemove) {
        Grid grid = this.getGrid();
        if (grid != null && grid.inPagingMold() && !this.isInvalidated()) {
            List children = this.getChildren();
            int sz = children.size();
            int pgsz = grid.getPageSize();
            int n = sz - (grid.getActivePage() + 1) * pgsz;
            if (n <= 0) {
                if (bRemove && (n += pgsz) <= 1) {
                    this.invalidate();
                    return;
                }
            } else if (n > 50) {
                n = 50;
            }
            ListIterator it = children.listIterator(sz);
            while (--n >= 0 && it.hasPrevious()) {
                if (it.previous() != child) continue;
                return;
            }
            this.invalidate();
        }
    }

    public String getZclass() {
        return this._zclass == null ? "z-rows" : this._zclass;
    }

    public void setWidth(String width) {
    }

    public void setHflex(String flex) {
    }

    @Override
    public Object clone() {
        Rows clone = (Rows)((Object)super.clone());
        clone.init();
        clone._groupsInfo.addAll(this._groupsInfo);
        Grid grid = this.getGrid();
        int offset = grid != null ? grid.getDataLoader().getOffset() : 0;
        clone.afterUnmarshal(offset);
        return clone;
    }

    private void afterUnmarshal(int index) {
        Iterator it = this.getChildren().iterator();
        while (it.hasNext()) {
            ((Row)((Object)it.next())).setIndexDirectly(index++);
        }
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        Grid grid;
        DataLoader loader;
        s.defaultWriteObject();
        int size = this._groupsInfo.size();
        s.writeInt(size);
        if (size > 0) {
            s.writeObject(this._groupsInfo);
        }
        DataLoader dataLoader = loader = (grid = this.getGrid()) != null ? grid.getDataLoader() : null;
        if (loader != null) {
            s.writeInt(loader.getOffset());
        } else {
            s.writeInt(0);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.init();
        int size = s.readInt();
        if (size > 0) {
            List groupsInfo = (List)s.readObject();
            for (int i = 0; i < size; ++i) {
                this._groupsInfo.add((int[])groupsInfo.get(i));
            }
        }
        int offset = s.readInt();
        this.afterUnmarshal(offset);
    }

    public <T extends Component> List<T> getChildren() {
        return new Children();
    }

    @Override
    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        Grid grid = this.getGrid();
        renderer.render("_offset", grid == null ? 0 : grid.getDataLoader().getOffset());
        renderer.render("visibleItemCount", this._visibleItemCount);
    }

    public Object getExtraCtrl() {
        return new ExtraCtrl();
    }

    private class IterGroups
    implements Iterator<Group> {
        private final Iterator<int[]> _it;
        private int _j;

        private IterGroups() {
            this._it = Rows.this._groupsInfo.iterator();
        }

        @Override
        public boolean hasNext() {
            return this._j < Rows.this.getGroupCount();
        }

        @Override
        public Group next() {
            ++this._j;
            int realIndex = Rows.this.getRealIndex(this._it.next()[0]);
            return realIndex >= 0 && realIndex < Rows.this.getChildren().size() ? (Group)((Object)Rows.this.getChildren().get(realIndex)) : null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    protected class ExtraCtrl
    extends HtmlBasedComponent.ExtraCtrl
    implements Cropper {
        protected ExtraCtrl() {
            super((HtmlBasedComponent)Rows.this);
        }

        public boolean isCropper() {
            Grid grid = Rows.this.getGrid();
            return grid != null && ((Cropper)grid.getDataLoader()).isCropper();
        }

        public Component getCropOwner() {
            return Rows.this.getGrid();
        }

        public Set<? extends Component> getAvailableAtClient() {
            Grid grid = Rows.this.getGrid();
            return grid != null ? ((Cropper)grid.getDataLoader()).getAvailableAtClient() : null;
        }
    }

    protected class Children
    extends AbstractComponent.Children {
        protected Children() {
            super((AbstractComponent)Rows.this);
        }

        protected void removeRange(int fromIndex, int toIndex) {
            ListIterator it = this.listIterator(toIndex);
            int n = toIndex - fromIndex;
            while (--n >= 0 && it.hasPrevious()) {
                it.previous();
                it.remove();
            }
        }

        public void clear() {
            boolean oldFlag = Rows.this.setReplacingRow(true);
            try {
                super.clear();
            }
            finally {
                Rows.this.setReplacingRow(oldFlag);
            }
        }
    }
}

