/******/ (function() { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./extends.js":
/*!********************!*\
  !*** ./extends.js ***!
  \********************/
/***/ (function(__unused_webpack_module, exports) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
/* extends.js

    Purpose:

    Description:

    History:
        1:02 PM 2023/8/21, Created by jumperchen

Copyright (C) 2023 Potix Corporation. All Rights Reserved.
*/
var extendStatics = function (d, b) {
  extendStatics = Object.setPrototypeOf || {
    __proto__: []
  } instanceof Array && function (d, b) {
    d.__proto__ = b;
  } || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
  };
  return extendStatics(d, b);
};
// refer tslib#__extends
function default_1(d, b) {
  extendStatics(d, b);
  function __() {
    this.constructor = d;
  }
  d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  d.prototype._$super = d.name == '$subclass$' && b.prototype._$super ? b.prototype._$super : b.prototype; // Potix: Jumper Chen adds to support `$supers(foo.Bar, 'bind_')`
}
exports["default"] = default_1;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/db/Calendar.ts":
/*!**********************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/db/Calendar.ts ***!
  \**********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


/* Calendar.js

{{IS_NOTE
    Purpose:

    Description:

    History:
        Fri Jan 23 10:32:34 TST 2009, Created by Flyworld
}}IS_NOTE

Copyright (C) 2008 Potix Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
/** The date related widgets, such as datebox and calendar.
 */
//zk.$package('zul.db');
if (!window.zul) window.zul = {};
if (!window.zul.db) window.zul.db = {};
if (!window.zul.db.Calendar_) window.zul.db.Calendar_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Calendar = exports.Renderer = void 0;
window.zul.db.Calendar_._newDate = function (year, month, day, bFix, tz) {
  var v = Dates.newInstance([year, month, day], tz);
  return bFix && v.getMonth() != month && v.getDate() != day ?
  //Bug ZK-1213: also need to check date
  Dates.newInstance([year, month + 1, 0], tz) /*last day of month*/ : v;
};
window.zul.db.Calendar_._getTimeZone = function (wgt) {
  var _a;
  var parent = wgt.parent,
    tz = (_a = parent === null || parent === void 0 ? void 0 : parent.getTimeZone) === null || _a === void 0 ? void 0 : _a.call(parent);
  return tz ? tz : wgt._defaultTzone;
};
/** @class zul.db.Renderer
 * The renderer used to render a calendar.
 * It is designed to be overridden
 */
exports.Renderer = {
  /**
   * @returns the HTML fragment representing a day cell.
   * By overriding this method, you could customize the look of a day cell.
   * @defaultValue day
   * @param cal - the calendar
   * @param y - the year
   * @param m - the month (between 0 to 11)
   * @param day - the day (between 1 to 31)
   * @param monthofs - the month offset. If the day is in the same month
   * @since 5.0.3
   */
  cellHTML: function (cal, y, m, day, monthofs) {
    return String(day);
  },
  /**
   * @returns the label of a date cell.
   * By overriding this method, you could customize the aria-label of a day cell.
   * @defaultValue dd MMMM, yyyy
   * @param cal - the calendar
   * @param y - the year
   * @param m - the month (between 0 to 11)
   * @param day - the day (between 1 to 31)
   * @param monthofs - the month offset. If the day is in the same month
   * @param dayofweek - the day of the week (between 0 to 6)
   * @since 9.5.0
   */
  cellAriaLabel: function (cal, y, m, day, monthofs, dayofweek) {
    var localizedSymbols = cal.getLocalizedSymbols();
    return day + ' ' + localizedSymbols.FMON[m] + ', ' + y;
  },
  /**
   * Called before {@link zul.db.Calendar#redraw} is invoked.
   * @defaultValue does nothing
   * @param cal - the calendar
   * @since 5.0.3
   */
  beforeRedraw: function (cal) {
    // empty on purpose
  },
  /**
   * Tests if the specified date is disabled.
   * @defaultValue it depends on the constraint, if any
   * @param cal - the calendar
   * @param y - the year
   * @param m - the month (between 0 to 11)
   * @param v - the day (between 1 to 31)
   * @param today - today
   * @since 5.0.3
   */
  disabled: function (cal, y, m, v, today) {
    var d = Dates.newInstance([y, m, v, 0, 0, 0, 0], window.zul.db.Calendar_._getTimeZone(cal)),
      constraint;
    if (cal._disabledDates) {
      var disabled_1 = false;
      cal._disabledDates.some(function (each) {
        if (each.getTime() === d.getTime()) {
          return disabled_1 = true;
        }
        return false;
      });
      if (disabled_1) {
        return disabled_1;
      }
    }
    if ((constraint = cal._constraint) && typeof constraint == 'string') {
      // Bug ID: 3106676
      if (constraint.includes('no past') && (+d - +today) / 86400000 < 0 || constraint.includes('no future') && (+today - +d) / 86400000 < 0 || constraint.includes('no today') && +today - +d == 0) return true;
    }
    var result = false;
    if (cal._beg && (result = (+d - +cal._beg) / 86400000 < 0)) return result;
    if (cal._end && (result = (+cal._end - +d) / 86400000 < 0)) return result;
    return result;
  },
  /**
   * @returns the label of the week of year.
   * @defaultValue the string of the value
   * @param wgt - the calendar widget
   * @param val - number of the week of the value
   * @since 6.5.0
   */
  labelOfWeekOfYear: function (wgt, val) {
    return String(val);
  },
  /**
   * @returns the title of the week of year.
   * @defaultValue 'Wk'
   * @param wgt - the calendar widget
   * @since 6.5.0
   */
  titleOfWeekOfYear: function (wgt) {
    return 'Wk';
  },
  /**
   * Generates the title of the content HTML.
   * @param wgt - the calendar widget
   * @param out - an array to output HTML fragments.
   * @param localizedSymbols - the symbols for localization
   * @since 6.5.3
   */
  titleHTML: function (wgt, out, localizedSymbols) {
    var uuidHTML = /*safe*/wgt.uuid,
      view = wgt._view,
      val = wgt.getTime(),
      m = val.getMonth(),
      y = val.getFullYear(),
      date = val._moment.toDate(),
      localeDateTimeFormat = new Intl.DateTimeFormat(localizedSymbols.LAN_TAG, {
        year: 'numeric'
      }),
      displayYear = this._getDisplayYear(date, localizedSymbols, localeDateTimeFormat),
      yofs = y - (y % 10 + 1),
      ydec = zk.parseInt(y / 100),
      textHTML = wgt.$s('text'),
      minyear = wgt._minyear,
      maxyear = wgt._maxyear,
      endYearLength = this._getPadYearLength(wgt, localizedSymbols, localeDateTimeFormat);
    switch (view) {
      case 'day':
        out.push('<span id="', uuidHTML, '-tm" class="', textHTML, '">', /*safe*/localizedSymbols.SMON[m], '</span> <span id="', uuidHTML, '-ty" class="', textHTML, '">', /*safe*/displayYear, '</span>');
        break;
      case 'month':
        out.push('<span id="', uuidHTML, '-ty" class="', textHTML, '">', /*safe*/displayYear, '</span>');
        break;
      case 'year':
        var yearGap = 11,
          startYear = yofs < minyear ? minyear : yofs,
          startDate = new Date(startYear, m),
          displayStartYear = this._getDisplayYear(startDate, localizedSymbols, localeDateTimeFormat, endYearLength),
          expectedEndYear = yofs + yearGap;
        endYear = expectedEndYear > maxyear ? maxyear : expectedEndYear, endDate = new Date(endYear, m), displayEndYear = this._getDisplayYear(endDate, localizedSymbols, localeDateTimeFormat, endYearLength);
        out.push('<span id="', uuidHTML, '-tyd" class="', textHTML, '">', /*safe*/displayStartYear, ' - ', /*safe*/displayEndYear, '</span>');
        break;
      case 'decade':
        // each start year of cell is ten more than previous one,
        // so the end year of last cell equals the start year of first cell add 10 * 11 + 9.
        var yearGap = 10 * 11 + 9,
          expectedStartYear = ydec * 100 - 10,
          startYear = expectedStartYear < minyear ? minyear : expectedStartYear,
          startDate = new Date(startYear, m),
          displayStartYear = this._getDisplayYear(startDate, localizedSymbols, localeDateTimeFormat, endYearLength),
          expectedEndYear = expectedStartYear + yearGap,
          endYear = expectedEndYear > maxyear ? maxyear : expectedEndYear,
          endDate = new Date(endYear, m),
          displayEndYear = this._getDisplayYear(endDate, localizedSymbols, localeDateTimeFormat, endYearLength);
        out.push('<span id="', uuidHTML, '-tyd" class="', textHTML, '">', /*safe*/displayStartYear, ' - ', /*safe*/displayEndYear, '</span>');
        break;
    }
  },
  /**
   * Renderer the dayView for this calendar
   * @param wgt - the calendar widget
   * @param out - an array to output HTML fragments.
   * @param localizedSymbols - the symbols for localization
   * @since 6.5.0
   */
  dayView: function (wgt, out, localizedSymbols) {
    var uuidHTML = /*safe*/wgt.uuid,
      sun = (7 - localizedSymbols.DOW_1ST) % 7,
      sat = (6 + sun) % 7,
      wkend = wgt.$s('weekend'),
      wkday = wgt.$s('weekday'),
      cell = wgt.$s('cell');
    out.push('<table role="grid" class="', wgt.$s('body'), '" id="', uuidHTML, '-mid"', /*safe*/zUtl.cellps0, '>', '<thead><tr>');
    for (var j = 0; j < 7; ++j) out.push('<th class="', j == sun || j == sat ? /*safe*/wkend : /*safe*/wkday, '" aria-label="', /*safe*/localizedSymbols.FDOW[j], '">', /*safe*/localizedSymbols.S2DOW[j], '</th>');
    out.push('</tr></thead><tbody>');
    for (var j = 0; j < 6; ++j) {
      //at most 7 rows
      out.push('<tr id="', uuidHTML, '-w', j, '">');
      for (var k = 0; k < 7; ++k) out.push('<td id="', uuidHTML, '-w', j, '-p', k, '" class="', /*safe*/cell, ' ', k == sun || k == sat ? /*safe*/wkend : /*safe*/wkday, '"></td>');
      out.push('</tr>');
    }
    out.push('</tbody></table>');
  },
  /**
   * Renderer the monthView for this calendar
   * @param wgt - the calendar widget
   * @param out - an array to output HTML fragments.
   * @param localizedSymbols - the symbols for localization
   * @since 6.5.0
   */
  monthView: function (wgt, out, localizedSymbols) {
    var uuid = wgt.uuid,
      cell = wgt.$s('cell');
    out.push('<table role="grid" class="', wgt.$s('body'), ' ', wgt.$s('month'), '" id="', /*safe*/uuid, '-mid"', /*safe*/zUtl.cellps0, '><tbody>');
    for (var j = 0; j < 12; ++j) {
      if (!(j % 4)) out.push('<tr>');
      out.push('<td class="', /*safe*/cell, '" id="', /*safe*/uuid, '-m', j, '" data-value="', j, '" aria-label="', /*safe*/localizedSymbols.FMON[j], '">', /*safe*/localizedSymbols.SMON[j], '</td>');
      if (!((j + 1) % 4)) out.push('</tr>');
    }
    out.push('</tbody></table>');
  },
  /**
   * Renderer the yearView for this calendar
   * @param wgt - the calendar widget
   * @param out - an array to output HTML fragments.
   * @param localizedSymbols - the symbols for localization
   * @since 6.5.0
   */
  yearView: function (wgt, out, localizedSymbols) {
    var uuid = wgt.uuid,
      cell = wgt.$s('cell'),
      disd = wgt.$s('disabled'),
      val = wgt.getTime(),
      y = val.getFullYear(),
      yofs = y - (y % 10 + 1),
      minyear = wgt._minyear,
      maxyear = wgt._maxyear,
      localeDateTimeFormat = new Intl.DateTimeFormat(localizedSymbols.LAN_TAG, {
        year: 'numeric'
      }),
      endYearLength = this._getPadYearLength(wgt, localizedSymbols, localeDateTimeFormat);
    out.push('<table role="grid" class="', wgt.$s('body'), ' ', wgt.$s('year'), '" id="', /*safe*/uuid, '-mid"', /*safe*/zUtl.cellps0, '><tbody>');
    for (var j = 0; j < 12; ++j) {
      if (!(j % 4)) out.push('<tr>');
      if (yofs < minyear || yofs > maxyear) {
        out.push('<td class="', /*safe*/disd, '">&nbsp;</td>');
        if (j + 1 == 12) out.push('</tr>');
        yofs++;
        continue;
      }
      var date = new Date(yofs, 0);
      out.push('<td class="', /*safe*/cell, '" data-value="', yofs, '" id="', /*safe*/uuid, '-y', j, '" >', /*safe*/this._getDisplayYear(date, localizedSymbols, localeDateTimeFormat, endYearLength), '</td>');
      if (!((j + 1) % 4)) out.push('</tr>');
      yofs++;
    }
    out.push('</tbody></table>');
  },
  /**
   * Renderer the decadeView for this calendar
   * @param wgt - the calendar widget
   * @param out - an array to output HTML fragments.
   * @param localizedSymbols - the symbols for localization
   * @since 6.5.0
   */
  decadeView: function (wgt, out, localizedSymbols) {
    var uuid = wgt.uuid,
      cell = wgt.$s('cell'),
      disd = wgt.$s('disabled'),
      val = wgt.getTime(),
      y = val.getFullYear(),
      ydec = zk.parseInt(y / 100),
      minyear = wgt._minyear,
      maxyear = wgt._maxyear,
      mindec = zk.parseInt(minyear / 10) * 10,
      maxdec = zk.parseInt(maxyear / 10) * 10,
      localeDateTimeFormat = new Intl.DateTimeFormat(localizedSymbols.LAN_TAG, {
        year: 'numeric'
      }),
      endYearLength = this._getPadYearLength(wgt, localizedSymbols, localeDateTimeFormat);
    out.push('<table role="grid" class="', wgt.$s('body'), ' ', wgt.$s('decade'), '" id="', /*safe*/uuid, '-mid"', /*safe*/zUtl.cellps0, '><tbody>');
    var temp = ydec * 100 - 10,
      selected = wgt.$s('selected');
    for (var j = 0; j < 12; ++j, temp += 10) {
      if (!(j % 4)) out.push('<tr>');
      if (temp < mindec || temp > maxdec) {
        out.push('<td class="', /*safe*/disd, '">&nbsp;</td>');
        if (j + 1 == 12) out.push('</tr>');
        continue;
      }
      var startDate = new Date(temp < minyear ? minyear : temp, 0),
        endDate = new Date(temp + 9 > maxyear ? maxyear : temp + 9, 11);
      out.push('<td data-value="', temp, '" id="', /*safe*/uuid, '-de', j, '" class="', /*safe*/cell, y >= temp && y <= temp + 9 ? ' ' + /*safe*/selected : '', '" >', /*safe*/this._getDisplayYear(startDate, localizedSymbols, localeDateTimeFormat, endYearLength) + ' -<br aria-hidden="true" />' + /*safe*/this._getDisplayYear(endDate, localizedSymbols, localeDateTimeFormat, endYearLength) + '</td>');
      if (!((j + 1) % 4)) out.push('</tr>');
    }
    out.push('</tbody></table>');
  },
  /**
   * Renderer the today link for this calendar
   * @param wgt - the calendar widget
   * @param out - an array to output HTML fragments.
   * @param localizedSymbols - the symbols for localization
   * @since 8.0.0
   */
  todayView: function (wgt, out, localizedSymbols) {
    var val = wgt.getTodayLinkLabel();
    if (!val) {
      var tz = window.zul.db.Calendar_._getTimeZone(wgt);
      val = new zk.fmt.Calendar().formatDate(zUtl.today(!!wgt.parent, tz), wgt.getFormat(), localizedSymbols);
    }
    out.push(zUtl.encodeXML(val));
  },
  /** @internal */
  _getDisplayYear: function (date, localizedSymbols, localeDateTimeFormat, padLength) {
    return date.getFullYear() + localizedSymbols.YDELTA + '';
  },
  /** @internal */
  _getPadYearLength: function (wgt, localizedSymbols, localeDateTimeFormat) {
    var y = wgt.getTime().getFullYear(),
      yearGap = 10 * 11 + 9,
      maxyear = wgt._maxyear,
      ydec = zk.parseInt(y / 100),
      expectedStartYear = ydec * 100 - 10,
      expectedEndYear = expectedStartYear + yearGap,
      endYear = expectedEndYear > maxyear ? maxyear : expectedEndYear,
      endYearLength = this._getDisplayYear(new Date(endYear, 0), localizedSymbols, localeDateTimeFormat).replace(/^\D+/g, '').length;
    return endYearLength;
  }
};
zul.db.Renderer = exports.Renderer;
var Calendar = /** @class */function (_super) {
  __extends(Calendar, _super);
  function Calendar() {
    var _this = _super.call(this) || this;
    /** @internal */
    _this._view = 'day';
    /** @internal */
    _this._minyear = 1900; //"day", "month", "year", "decade",
    /** @internal */
    _this._maxyear = 2099;
    _this.listen({
      onChange: _this
    }, -1000);
    return _this;
  }
  /**
   * Assigns a value to this component.
   * @param value - the date to assign. If null, today is assumed.
   */
  Calendar.prototype.setValue = function (value, opts) {
    var o = this._value;
    this._value = value;
    if (o !== value || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var parent = this.parent;
      if (!parent || !parent.getTimeZone) {
        this._value.tz(this._defaultTzone);
      }
      this.rerender();
    }
    return this;
  };
  /**
   * @returns the value that is assigned to this component.
   */
  Calendar.prototype.getValue = function () {
    return this._value;
  };
  /**
   * Sets default time zone that this calendar belongs to.
   * @param defaultTzone - the time zone's ID, such as "America/Los_Angeles".
   */
  Calendar.prototype.setDefaultTzone = function (defaultTzone) {
    this._defaultTzone = defaultTzone;
    return this;
  };
  /**
   * @returns default time zone that this calendar belongs to, such as "America/Los_Angeles".
   */
  Calendar.prototype.getDefaultTzone = function () {
    return this._defaultTzone;
  };
  /**
   * Set the date limit for this component with yyyyMMdd format,
   * such as 20100101 is mean Jan 01 2010
   *
   * <dl>
   * <dt>Example:</dt>
   * <dd>between 20091201 and 20091231</dd>
   * <dd>before 20091201</dd>
   * <dd>after 20091231</dd>
   * </dl>
   *
   */
  Calendar.prototype.setConstraint = function (constraint, opts) {
    var o = this._constraint;
    this._constraint = constraint;
    if (o !== constraint || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      this._fixConstraint();
      // ZK-3619, this method could be called when datebox opening the calendar,
      // inServer means there is a calendar tag in zul file.
      if (this.desktop && this.inServer) {
        this.rerender();
      }
    }
    return this;
  };
  /**
   * @returns the constraint of this component.
   */
  Calendar.prototype.getConstraint = function () {
    return this._constraint;
  };
  /**
   * Sets the name of this component.
   * <p>The name is used only to work with "legacy" Web application that
   * handles user's request by servlets.
   * It works only with HTTP/HTML-based browsers. It doesn't work
   * with other kind of clients.
   * <p>Don't use this method if your application is purely based
   * on ZK's event-driven model.
   *
   * @param name - the name of this component.
   */
  Calendar.prototype.setName = function (name, opts) {
    var o = this._name;
    this._name = name;
    if (o !== name || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      if (this.efield) this.efield.name = this._name;
    }
    return this;
  };
  /**
   * @returns the name of this component.
   * <p>The name is used only to work with "legacy" Web application that
   * handles user's request by servlets.
   * It works only with HTTP/HTML-based browsers. It doesn't work
   * with other kind of clients.
   * <p>Don't use this method if your application is purely based
   * on ZK's event-driven model.
   * @defaultValue `null`.
   */
  Calendar.prototype.getName = function () {
    return this._name;
  };
  /**
   * Sets whether enable to show the week number within the current year or
   * not. [ZK EE]
   * @since 6.5.0
   */
  Calendar.prototype.setWeekOfYear = function (weekOfYear, opts) {
    var o = this._weekOfYear;
    this._weekOfYear = weekOfYear;
    if (o !== weekOfYear || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      if (this.desktop && zk.feature.ee) this.rerender();
    }
    return this;
  };
  /**
   * @returns whether enable to show the week number within the current year or not.
   * @defaultValue `false`
   * @since 6.5.0
   */
  Calendar.prototype.isWeekOfYear = function () {
    return !!this._weekOfYear;
  };
  /**
   * Sets whether enable to show the link that jump to today in day view
   * @since 8.0.0
   */
  Calendar.prototype.setShowTodayLink = function (showTodayLink, opts) {
    var o = this._showTodayLink;
    this._showTodayLink = showTodayLink;
    if (o !== showTodayLink || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      this.rerender();
    }
    return this;
  };
  /**
   * @returns whether enable to show the link that jump to today in day view
   * @defaultValue `false`
   * @since 8.0.0
   */
  Calendar.prototype.isShowTodayLink = function () {
    return !!this._showTodayLink;
  };
  /**
   * Sets the label of the link that jump to today in day view
   * @since 8.0.4
   */
  Calendar.prototype.setTodayLinkLabel = function (todayLinkLabel, opts) {
    var o = this._todayLinkLabel;
    this._todayLinkLabel = todayLinkLabel;
    if (o !== todayLinkLabel || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      this.rerender();
    }
    return this;
  };
  /**
   * @returns the label of the link that jump to today in day view
   * @since 8.0.4
   */
  Calendar.prototype.getTodayLinkLabel = function () {
    return this._todayLinkLabel;
  };
  /**
   * A method for component getter symmetry, it will call getValue
   * @since 10.0.0
   */
  Calendar.prototype.getValueInZonedDateTime = function () {
    return this.getValue();
  };
  /**
   * A method for component setter symmetry, it will call setValue
   * @since 10.0.0
   */
  Calendar.prototype.setValueInZonedDateTime = function (valueInZonedDateTime, opts) {
    return this.setValue(valueInZonedDateTime, opts);
  };
  /**
   * A method for component getter symmetry, it will call getValue
   * @since 10.0.0
   */
  Calendar.prototype.getValueInLocalDateTime = function () {
    return this.getValue();
  };
  /**
   * A method for component setter symmetry, it will call setValue
   * @since 10.0.0
   */
  Calendar.prototype.setValueInLocalDateTime = function (valueInLocalDateTime, opts) {
    return this.setValue(valueInLocalDateTime, opts);
  };
  /**
   * A method for component getter symmetry, it will call getValue
   * @since 10.0.0
   */
  Calendar.prototype.getValueInLocalDate = function () {
    return this.getValue();
  };
  /**
   * A method for component setter symmetry, it will call setValue
   * @since 10.0.0
   */
  Calendar.prototype.setValueInLocalDate = function (valueInLocalDate, opts) {
    return this.setValue(valueInLocalDate, opts);
  };
  /**
   * A method for component getter symmetry, it will call getValue
   * @since 10.0.0
   */
  Calendar.prototype.getValueInLocalTime = function () {
    return this.getValue();
  };
  /**
   * A method for component setter symmetry, it will call setValue
   * @since 10.0.0
   */
  Calendar.prototype.setValueInLocalTime = function (valueInLocalTime, opts) {
    return this.setValue(valueInLocalTime, opts);
  };
  Calendar.prototype.redraw = function (out, skipper) {
    exports.Renderer.beforeRedraw(this);
    _super.prototype.redraw.call(this, out, skipper);
  };
  Calendar.prototype.onChange = function (evt) {
    this._updFormData(evt.data.value);
  };
  /** @internal */
  Calendar.prototype.doKeyDown_ = function (evt) {
    var currentView = this._view;
    if (evt.key === 'PageUp') {
      // PageUp: prev month ; Shift + PageUp: prev year
      this._setView(evt.shiftKey ? 'year' : 'month');
      this._shift(-1);
    } else if (evt.key === 'PageDown') {
      // PageDown: next month ; Shift + PageDown: next year
      this._setView(evt.shiftKey ? 'year' : 'month');
      this._shift(1);
    }
    this._setView(currentView);
    var keyCode = evt.keyCode,
      ofs = keyCode == 37 ? -1 : keyCode == 39 ? 1 : keyCode == 38 ? -7 : keyCode == 40 ? 7 : 0;
    if (ofs) {
      this._shift(ofs);
      evt.stop(); // Bug ZK-2306: using the arrow keys in the calendar widget scrolls the browser window
    } else if (keyCode == 32 || keyCode == 13) {
      // pass a fake event
      this._clickDate({
        target: this,
        domTarget: jq(this.$n('mid')).find('.' + this.$s('selected'))[0],
        stop: zk.$void
      });
    }
  };
  /** @internal */
  Calendar.prototype.setMinYear_ = function (minYear) {
    if (minYear) {
      var y = this.getTime().getFullYear();
      this._minyear = minYear > y ? y : minYear > 100 ? minYear : 100;
    } else {
      this._minyear = 1900;
    }
  };
  /** @internal */
  Calendar.prototype.setMaxYear_ = function (maxYear) {
    if (maxYear) {
      var y = this.getTime().getFullYear();
      this._maxyear = maxYear < y ? y : maxYear > this._minyear ? maxYear : this._minyear;
    } else {
      this._maxyear = 2099;
    }
  };
  /** @internal */
  Calendar.prototype._shift = function (ofs, opts) {
    var oldTime = this.getTime(),
      tz = window.zul.db.Calendar_._getTimeZone(this),
      shiftTime = Dates.newInstance(oldTime.getTime(), tz),
      minTime = Dates.newInstance([this._minyear, 0, 1, 0, 0, 0, 0], tz),
      maxTime = Dates.newInstance([this._maxyear, 11, 31, 23, 59, 59, 999], tz),
      today = zUtl.today(false, tz);
    switch (this._view) {
      case 'day':
        shiftTime.setDate(oldTime.getDate() + ofs);
        break;
      case 'month':
        if (ofs == 7) ofs = 4;else if (ofs == -7) ofs = -4;
        shiftTime.setMonth(oldTime.getMonth() + ofs);
        break;
      case 'year':
        if (ofs == 7) ofs = 4;else if (ofs == -7) ofs = -4;
        shiftTime.setYear(oldTime.getFullYear() + ofs);
        break;
      case 'decade':
        if (ofs == 7) ofs = 4;else if (ofs == -7) ofs = -4;
        ofs *= 10;
        shiftTime.setYear(oldTime.getFullYear() + ofs);
        break;
    }
    //Bug B65-ZK-1804: Constraint the shifted time should not be out of range between _minyear and _maxyear
    //Bug B96-ZK-4543: Calendar should respect the constraint while Month changing
    if (shiftTime.getTime() < minTime.getTime() || shiftTime.getTime() > maxTime.getTime() || exports.Renderer.disabled(this, shiftTime.getFullYear(), shiftTime.getMonth(), shiftTime.getDate(), today)) return; // out of range
    this._shiftDate(this._view, ofs);
    var newTime = this.getTime();
    switch (this._view) {
      case 'day':
        if (oldTime.getYear() == newTime.getYear() && oldTime.getMonth() == newTime.getMonth()) {
          opts = opts || {};
          opts.sameMonth = true; //optimize
          this._markCal(opts);
        } else {
          this.rerender(-1);
          this.focus();
        }
        break;
      case 'month':
        if (oldTime.getYear() == newTime.getYear()) this._markCal(opts);else {
          this.rerender(-1);
          this.focus();
        }
        break;
      default:
        this.rerender(-1);
        this.focus();
    }
  };
  /** @internal */
  Calendar.prototype._fixConstraint = function () {
    var constraint = this._constraint || '';
    // ZK-4641: Datebox doesn't clean beginning and end at client when removing constraint
    this._beg = undefined;
    this._end = undefined;
    this._disabledDates = [];
    if (typeof constraint != 'string' || constraint == '') return;
    // B50-ZK-591: Datebox constraint combination yyyymmdd and
    // no empty cause javascript error in zksandbox
    var constraints = constraint.split(','),
      format = 'yyyyMMdd',
      len = format.length + 1,
      tz = window.zul.db.Calendar_._getTimeZone(this);
    // eslint-disable-next-line @typescript-eslint/prefer-for-of
    for (var i = 0; i < constraints.length; i++) {
      constraint = jq.trim(constraints[i]); //Bug ZK-1718: should trim whitespace
      if (constraint.startsWith('between')) {
        var dates = this._parseBetweenDates(constraint, format, len, tz);
        this._beg = dates[0];
        this._end = dates[1];
      } else if (constraint.startsWith('before_') || constraint.startsWith('after_')) {
        continue; //Constraint start with 'before_' and 'after_' means errorbox position, skip it
      } else if (constraint.startsWith('before')) {
        this._end = new zk.fmt.Calendar(undefined, this._localizedSymbols).parseDate(constraint.substring(6, 6 + len), format, undefined, undefined, undefined, tz);
        this._end.setHours(0, 0, 0, 0);
      } else if (constraint.startsWith('after')) {
        this._beg = new zk.fmt.Calendar(undefined, this._localizedSymbols).parseDate(constraint.substring(5, 5 + len), format, undefined, undefined, undefined, tz);
        this._beg.setHours(0, 0, 0, 0);
      } else if (constraint.startsWith('not')) {
        if (constraint.startsWith('not between')) {
          var dates = this._parseBetweenDates(constraint, format, len, tz);
          var disabled = dates[0];
          this._disabledDates.push(disabled);
          while (disabled.getTime() != dates[1].getTime()) {
            disabled = Dates.newInstance(disabled.getTime() + 86400 * 1000);
            this._disabledDates.push(disabled);
          }
        } else {
          var disabled = new zk.fmt.Calendar(undefined, this._localizedSymbols).parseDate(constraint.substring(3, 3 + len), format, undefined, undefined, undefined, tz);
          disabled.setHours(0, 0, 0, 0);
          this._disabledDates.push(disabled);
        }
      }
    }
  };
  /** @internal */
  Calendar.prototype._parseBetweenDates = function (constraint, format, len, tz) {
    var j = constraint.indexOf('and', 7);
    if (j < 0 && zk.debugJS) {
      zk.error('Unknown constraint: ' + constraint);
    }
    var datesStrIndex = constraint.indexOf('between') + 7,
      beg = new zk.fmt.Calendar(undefined, this._localizedSymbols).parseDate(constraint.substring(datesStrIndex, j), format, undefined, undefined, undefined, tz),
      end = new zk.fmt.Calendar(undefined, this._localizedSymbols).parseDate(constraint.substring(j + 3, j + 3 + len), format, undefined, undefined, undefined, tz);
    if (beg.getTime() > end.getTime()) {
      var d = beg;
      beg = end;
      end = d;
    }
    beg.setHours(0, 0, 0, 0);
    end.setHours(0, 0, 0, 0);
    return [beg, end];
  };
  /**
   * @returns the format of this component.
   */
  Calendar.prototype.getFormat = function () {
    return this._fmt || 'yyyy/MM/dd';
  };
  /** @internal */
  Calendar.prototype._updFormData = function (formData) {
    var val = new zk.fmt.Calendar().formatDate(formData, this.getFormat(), this._localizedSymbols);
    if (this._name) {
      val = val || '';
      if (!this.efield) this.efield = jq.newHidden(this._name, val, this.$n());else this.efield.value = val;
    }
  };
  /** @internal */
  Calendar.prototype.focus_ = function (timeout) {
    if (this._view != 'decade') this._markCal({
      timeout: timeout
    });else {
      var anc;
      if (anc = this.getAnchor_()) this._doFocus(anc, true);
    }
    return true;
  };
  /** @internal */
  Calendar.prototype.bind_ = function (desktop, skipper, after) {
    _super.prototype.bind_.call(this, desktop, skipper, after);
    var node = this.$n(),
      title = this.$n('title'),
      mid = this.$n('mid'),
      left = this.$n('left'),
      right = this.$n('right'),
      today = this.$n('today');
    if (this._view != 'decade') this._markCal({
      silent: true
    });
    this.domListen_(title, 'onClick', '_changeView').domListen_(mid, 'onClick', '_clickDate').domListen_(left, 'onClick', '_clickArrow').domListen_(right, 'onClick', '_clickArrow').domListen_(today, 'onClick', '_clickToday').domListen_(node, 'onMousewheel');
    this._updFormData(this.getTime());
  };
  /** @internal */
  Calendar.prototype.unbind_ = function (skipper, after, keepRod) {
    var node = this.$n(),
      title = this.$n('title'),
      mid = this.$n('mid'),
      left = this.$n('left'),
      right = this.$n('right'),
      today = this.$n('today');
    this.domUnlisten_(title, 'onClick', '_changeView').domUnlisten_(mid, 'onClick', '_clickDate').domUnlisten_(left, 'onClick', '_clickArrow').domUnlisten_(right, 'onClick', '_clickArrow').domUnlisten_(today, 'onClick', '_clickToday').domUnlisten_(node, 'onMousewheel');
    _super.prototype.unbind_.call(this, skipper, after, keepRod);
    this.efield = undefined;
  };
  Calendar.prototype.rerender = function (skipper) {
    if (this.desktop) {
      var s = this.$n().style,
        w = s.width,
        h = s.height,
        result = _super.prototype.rerender.call(this, skipper);
      s = this.$n().style;
      s.width = w;
      s.height = h;
      return result;
    }
    return this;
  };
  /** @internal */
  Calendar.prototype._clickArrow = function (evt) {
    if (zk.animating()) return; // ignore
    var node = jq.nodeName(evt.domTarget, 'a') ? evt.domTarget : jq(evt.domTarget).parent('a')[0];
    if (jq(node).attr('disabled')) return;
    this._shiftView(jq(node).hasClass(this.$s('left')) ? -1 : 1);
    //ZK-2679: prevent default behavior of clicking anchor
    evt.stop();
  };
  /** @internal */
  Calendar.prototype._clickToday = function () {
    this.setValue(zUtl.today(!!this.parent, window.zul.db.Calendar_._getTimeZone(this)));
    this._setView('day');
  };
  /** @internal */
  Calendar.prototype._shiftView = function (ofs, disableAnima) {
    switch (this._view) {
      case 'day':
        this._shiftDate('month', ofs);
        break;
      case 'month':
        this._shiftDate('year', ofs);
        break;
      case 'year':
        this._shiftDate('year', ofs * 10);
        break;
      case 'decade':
        this._shiftDate('year', ofs * 100);
        break;
    }
    if (!disableAnima) this._setView(this._view, ofs);else {
      this.rerender(-1);
      this.focus();
    }
  };
  /** @internal */
  Calendar.prototype._doMousewheel = function (evt, intDelta) {
    if (jq(this.$n(-intDelta > 0 ? 'right' : 'left')).attr('disabled')) return;
    this._shiftView(intDelta > 0 ? -1 : 1, true);
    evt.stop();
  };
  /**
   * @returns the Date that is assigned to this component.
   *  <p>returns today if value is null
   */
  Calendar.prototype.getTime = function () {
    return this._value || zUtl.today(this.getFormat(), window.zul.db.Calendar_._getTimeZone(this));
  };
  /** @internal */
  Calendar.prototype._setTime = function (y, m, d, fireOnChange) {
    var dateobj = this.getTime(),
      year = y != null ? y : dateobj.getFullYear(),
      month = m != null ? m : dateobj.getMonth(),
      day = d != null ? d : dateobj.getDate(),
      tz = window.zul.db.Calendar_._getTimeZone(this),
      val = new zk.fmt.Calendar().escapeDSTConflict(window.zul.db.Calendar_._newDate(year, month, day, d == null, tz), tz); // B70-ZK-2382
    this._value = val;
    this._selectedValue = val;
    if (fireOnChange) this.fire('onChange', {
      value: val
    });
    return this;
  };
  // calendar-ctrl.js will override this function
  /** @internal */
  Calendar.prototype._clickDate = function (evt) {
    var target = evt.domTarget,
      val;
    for (; target; target = target.parentNode) try {
      //Note: data-dt is also used in mold/calendar.js
      if ((val = jq(target).data('value')) !== undefined) {
        val = zk.parseInt(val);
        break;
      }
    } catch (e) {
      continue; //skip
    }
    this._chooseDate(target, val);
    var anc;
    if (anc = this.getAnchor_()) this._doFocus(anc, true);
    evt.stop();
  };
  /** @internal */
  Calendar.prototype._chooseDate = function (target, val) {
    if (target && !jq(target).hasClass(this.$s('disabled'))) {
      var cell = target,
        dateobj = this.getTime();
      switch (this._view) {
        case 'day':
          var oldTime = this.getTime();
          this._setTime(undefined, cell._monofs != null && cell._monofs != 0 ? dateobj.getMonth() + cell._monofs : undefined, val, true /*fire onChange */);
          var newTime = this.getTime();
          if (oldTime.getYear() == newTime.getYear() && oldTime.getMonth() == newTime.getMonth()) {
            this._markCal({
              sameMonth: true
            }); // optimize
          } else {
            this.rerender(-1);
            this.focus();
          }
          break;
        case 'month':
          this._setTime(undefined, val);
          this._setView('day');
          break;
        case 'year':
          this._setTime(val);
          this._setView('month');
          break;
        case 'decade':
          //Decade mode Set Year Also
          this._setTime(val);
          this._setView('year');
          break;
      }
    }
  };
  /** @internal */
  Calendar.prototype._shiftDate = function (opt, ofs, ignoreUpdate) {
    var dateobj = this.getTime(),
      year = dateobj.getFullYear(),
      month = dateobj.getMonth(),
      day = dateobj.getDate(),
      tz = window.zul.db.Calendar_._getTimeZone(this),
      nofix;
    switch (opt) {
      case 'day':
        day += ofs;
        nofix = true;
        break;
      case 'month':
        month += ofs;
        break;
      case 'year':
        year += ofs;
        break;
      case 'decade':
        year += ofs;
        break;
    }
    var newTime = window.zul.db.Calendar_._newDate(year, month, day, !nofix, tz);
    if (!ignoreUpdate) {
      this._value = newTime;
      if (!exports.Renderer.disabled(this, year, month, day, zUtl.today(false, this._defaultTzone))) {
        this._selectedValue = newTime;
        this.fire('onChange', {
          value: this._selectedValue,
          shallClose: false,
          shiftView: true
        });
      }
    }
    return newTime;
  };
  /** @internal */
  Calendar.prototype._changeView = function (evt) {
    var tm = this.$n('tm'),
      ty = this.$n('ty'),
      tyd = this.$n('tyd'),
      title = this.$n('title');
    if (evt.domTarget == tm) this._setView('month');else if (evt.domTarget == ty) this._setView('year');else if (evt.domTarget == tyd) this._setView('decade');else if (evt.domTarget == title) {
      if (tm == null && ty != null) this._setView('year');else if (ty == null) this._setView('decade');else this._setView('month');
    }
    evt.stop();
  };
  /** @internal */
  Calendar.prototype._setView = function (view, force) {
    // check whether to disable the arrow
    /** @internal */
    function _updateArrow(wgt) {
      if (wgt.isOutOfRange(true)) {
        jq(wgt.$n('left')).attr('disabled', 'disabled');
      } else {
        jq(wgt.$n('left')).removeAttr('disabled');
      }
      if (wgt.isOutOfRange()) {
        jq(wgt.$n('right')).attr('disabled', 'disabled');
      } else {
        jq(wgt.$n('right')).removeAttr('disabled');
      }
    }
    if (this._view != view) {
      this._view = view;
      var out = new zk.Buffer(),
        localizedSymbols = this.getLocalizedSymbols();
      exports.Renderer[view + 'View'](this, out, localizedSymbols);
      jq(this.$n('mid')).after(out.join('')).remove();
      var after = [];
      // unlisten event
      this.unbind_(undefined, after);
      // listen event
      this.bind_(this.desktop, undefined, after);
      out = []; // reset
      exports.Renderer.titleHTML(this, out, localizedSymbols);
      // eslint-disable-next-line @microsoft/sdl/no-html-method
      jq(this.$n('title')).html(DOMPurify.sanitize(out.join('')));
      jq(this.$n('mid')).transition({
        scale: 0
      }, 0).transition({
        scale: 1
      }, this.animationSpeed_());
      _updateArrow(this);
      var anc = this.getAnchor_();
      if (anc) this._doFocus(anc, true);
    } else if (force) {
      var out = [],
        localizedSymbols = this.getLocalizedSymbols(),
        oldMid = this.$n('mid'),
        isLeft = force == -1,
        width = oldMid.offsetWidth,
        x = width * -1,
        self = this,
        animaCSSHTML = this.$s('anima'),
        todayBtn = this.isShowTodayLink() ? jq(this.$n('today')).parent() : undefined;
      if (todayBtn) todayBtn.is(':hidden') && todayBtn.css('display', 'none');
      exports.Renderer[view + 'View'](this, out, localizedSymbols);
      jq(oldMid).after( /*safe*/'<div style="height:' + jq.px(oldMid.offsetHeight) + ';width:' + jq.px(width) + '" class="' + animaCSSHTML + '"><div class="' + animaCSSHTML + '-inner"></div');
      var animaInner = oldMid.nextSibling.firstChild;
      jq(animaInner).append(oldMid);
      oldMid = animaInner.firstChild;
      if (isLeft) {
        jq(oldMid).before(out.join('')).remove();
      } else {
        jq(oldMid).after(out.join('')).remove();
      }
      // clear for _makrCal to get the latest reference
      this.clearCache();
      if (view != 'decade') this._markCal();
      var newMid;
      if (isLeft) {
        jq(animaInner.firstChild).after(oldMid);
        newMid = oldMid.previousSibling;
        jq(animaInner).css({
          left: x
        });
        x = 0;
      } else {
        jq(animaInner.firstChild).before(oldMid);
        newMid = oldMid.nextSibling;
      }
      jq(animaInner).animate({
        left: x
      }, {
        duration: this.animationSpeed_(),
        always: function /*callback*/
        () {
          self.domUnlisten_(oldMid, 'onClick', '_clickDate');
          jq(animaInner.parentNode).after(newMid).remove();
          self.domListen_(newMid, 'onClick', '_clickDate');
          var out = []; // reset
          exports.Renderer.titleHTML(self, out, localizedSymbols);
          // eslint-disable-next-line @microsoft/sdl/no-html-method
          jq(self.$n('title')).html(DOMPurify.sanitize(out.join('')));
          self.clearCache();
          if (todayBtn) todayBtn.css('display', '');
        }
      });
      _updateArrow(this);
    }
    return this;
  };
  Calendar.prototype.getLocalizedSymbols = function () {
    return this._localizedSymbols || {
      DOW_1ST: zk.DOW_1ST,
      MINDAYS: zk.MINDAYS,
      ERA: zk.ERA,
      YDELTA: zk.YDELTA,
      LAN_TAG: zk.LAN_TAG,
      SDOW: zk.SDOW,
      S2DOW: zk.S2DOW,
      FDOW: zk.FDOW,
      SMON: zk.SMON,
      S2MON: zk.S2MON,
      FMON: zk.FMON,
      APM: zk.APM
    };
  };
  /**
   * Check whether the date is out of range between 1900~2100 years
   * @param left - it is used for the left arrow button
   * @param date - the date object for the range if null, the current value
   * of {@link getTime} is assumed.
   * @returns if true it means the date is out of range.
   * @since 6.5.3
   */
  Calendar.prototype.isOutOfRange = function (left, date) {
    var view = this._view,
      val = date || this.getTime(),
      y = val.getFullYear(),
      yofs = y - (y % 10 + 1),
      ydec = zk.parseInt(y / 100),
      minyear = this._minyear,
      maxyear = this._maxyear,
      mincen = zk.parseInt(minyear / 100) * 100,
      maxcen = zk.parseInt(maxyear / 100) * 100;
    if (view == 'decade') {
      var value = ydec * 100;
      return left ? value == mincen : value == maxcen;
    } else if (view == 'year') {
      var value = yofs;
      return left ? value < minyear : value + 10 >= maxyear;
    } else if (view == 'day') {
      var value = y,
        m = val.getMonth();
      return left ? value <= minyear && m == 0 : value >= maxyear && m == 11;
    } else {
      var value = y;
      return left ? value <= minyear : value >= maxyear;
    }
  };
  /** @internal */
  Calendar.prototype._markCal = function (opts) {
    this._markCal0(opts);
    var anc;
    if ((anc = this.getAnchor_()) && (!opts || !opts.silent)) this._doFocus(anc, opts && opts.timeout);
  };
  // calendar-ctrl.js will override this function
  /** @internal */
  Calendar.prototype._markCal0 = function (opts) {
    var seldate = this.getTime(),
      m = seldate.getMonth(),
      mid = this.$n('mid'),
      $mid = jq(mid),
      seldClass = this.$s('selected'),
      y = seldate.getFullYear(),
      minyear = this._minyear,
      maxyear = this._maxyear;
    if (this._view == 'day') {
      //B70-ZK-2477, if zul declares the locale, don't use system's locale
      var DOW_1ST = zk.DOW_1ST;
      if (this._localizedSymbols && this._localizedSymbols.DOW_1ST != undefined) {
        DOW_1ST = this._localizedSymbols.DOW_1ST;
      }
      var d = seldate.getDate(),
        tz = seldate.getTimeZone(),
        v = Dates.newInstance([y, m, 1], 'UTC').getDay() - DOW_1ST,
        last = Dates.newInstance([y, m + 1, 0], 'UTC').getDate(),
        //last date of this month
        prev = Dates.newInstance([y, m, 0], 'UTC').getDate(),
        //last date of previous month
        today = zUtl.today(false, tz),
        //no time part
        outsideClass = this.$s('outside'),
        disdClass = this.$s('disabled');
      $mid.find('.' + seldClass).removeClass(seldClass);
      if (!opts || !opts.sameMonth) {
        $mid.find('.' + outsideClass).removeClass(outsideClass);
        $mid.find('.' + disdClass).removeClass(disdClass);
      }
      if (v < 0) v += 7;
      for (var j = 0, cur = -v + 1; j < 6; ++j) {
        var week = this.$n('w' + j);
        if (week != null) {
          for (var k = 0; k < 7; ++k, ++cur) {
            v = cur <= 0 ? prev + cur : cur <= last ? cur : cur - last;
            if (k == 0 && cur > last) week.style.display = 'none';else {
              if (k == 0) week.style.display = '';
              var monofs = cur <= 0 ? -1 : cur <= last ? 0 : 1,
                bSel = cur == d;
              // Bug B65-ZK-1804: check whether the date is out of range
              if (y >= maxyear && m == 11 && monofs == 1 || y <= minyear && m == 0 && monofs == -1) continue;
              var $cell = jq(week.cells[k]),
                isSelectDisabled = exports.Renderer.disabled(this, y, m + monofs, v, today);
              $cell[0]._monofs = monofs;
              if (bSel && !isSelectDisabled) {
                $cell.addClass(seldClass);
              }
              //not same month
              if (!opts || !opts.sameMonth) {
                // optimize
                if (monofs) {
                  $cell.addClass(outsideClass);
                }
                if (isSelectDisabled) {
                  $cell.addClass(disdClass);
                }
                // eslint-disable-next-line @microsoft/sdl/no-inner-html
                $cell[0].innerHTML = DOMPurify.sanitize(exports.Renderer.cellHTML(this, y, m + monofs, v, monofs));
                $cell[0].setAttribute('aria-label', exports.Renderer.cellAriaLabel(this, y, m + monofs, v, monofs, k));
                $cell.data('value', v);
              }
            }
          }
        }
      }
    } else {
      var isMon = this._view == 'month',
        field = isMon ? 'm' : 'y',
        index = isMon ? m : y % 10 + 1,
        node;
      $mid.find('.' + seldClass).removeClass(seldClass);
      for (var j = 0; j < 12; ++j) if (index == j && (node = this.$n(field + j))) jq(node).addClass(seldClass);
    }
  };
  /** @internal */
  Calendar.prototype.domClass_ = function (no) {
    var cls = '';
    if (this._weekOfYear) cls += this.$s('wk') + ' ';
    return cls + _super.prototype.domClass_.call(this, no);
  };
  /** @internal */
  Calendar.prototype.animationSpeed_ = function () {
    return zk(this).getAnimationSpeed();
  };
  /** @internal */
  Calendar.prototype.getAnchor_ = function () {
    return this.$n('a');
  };
  // Bug 2936994, fixed unnecessary setting scrollTop
  /** @internal */
  Calendar.prototype._doFocus = function (n, timeout) {
    if (zk.gecko && timeout) setTimeout(function () {
      return zk(n).focus();
    }); // FIXME: missing timeout argument?
    else zk(n).focus();
  };
  Calendar = __decorate([zk.WrapClass('zul.db.Calendar')], Calendar);
  return Calendar;
}(zul.Widget);
exports.Calendar = Calendar;
window.zul.db.Calendar_.Calendar = Calendar;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/db/Datebox.ts":
/*!*********************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/db/Datebox.ts ***!
  \*********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


if (!window.zul) window.zul = {};
if (!window.zul.db) window.zul.db = {};
if (!window.zul.db.Datebox_) window.zul.db.Datebox_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.DateboxCtrl = exports.CalendarTime = exports.CalendarPop = exports.Datebox = void 0;
/* Datebox.ts

{{IS_NOTE
    Purpose:

    Description:

    History:
        Fri Jan 23 10:32:34 TST 2009, Created by Flyworld
}}IS_NOTE

Copyright (C) 2008 Potix Corporation. All Rights Reserved.

{{IS_RIGHT
}}IS_RIGHT
*/
var globallocalizedSymbols = {},
  _quotePattern = /'/g,
  // move pattern string here to avoid jsdoc failure
  _innerDateFormat = 'yyyy/MM/dd ';
var Datebox = /** @class */function (_super) {
  __extends(Datebox, _super);
  function Datebox() {
    var _this = _super.call(this) || this;
    /** @internal */
    _this._buttonVisible = true;
    /** @internal */
    _this._lenient = true;
    /** @internal */
    _this._strictDate = false;
    /** @internal */
    _this._selectLevel = 'day';
    /** @internal */
    _this._closePopupOnTimezoneChange = true;
    _this.listen({
      onChange: _this
    }, -1000);
    _this._pop = new zul.db.CalendarPop();
    _this._tm = new zul.db.CalendarTime();
    _this.appendChild(_this._pop);
    _this.appendChild(_this._tm);
    return _this;
  }
  Datebox_1 = Datebox;
  Datebox.prototype.setPosition = function (position) {
    this._position = position;
    return this;
  };
  Datebox.prototype.getPosition = function () {
    return this._position;
  };
  /**
   * Sets whether the button (on the right of the textbox) is visible.
   */
  Datebox.prototype.setButtonVisible = function (buttonVisible, opts) {
    var o = this._buttonVisible;
    this._buttonVisible = buttonVisible;
    if (o !== buttonVisible || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      zul.inp.RoundUtl.buttonVisible(this, buttonVisible);
    }
    return this;
  };
  /**
   * @returns whether the button (on the right of the textbox) is visible.
   * @defaultValue `true`.
   */
  Datebox.prototype.isButtonVisible = function () {
    return this._buttonVisible;
  };
  /**
   * Sets the date format.
   * <p>The following pattern letters are defined:
   * <table border="0" cellspacing="3" cellpadding="0">
   * <tr bgcolor="#ccccff">
   * <th align="left">Letter
   * <th align="left">Date or Time Component
   * <th align="left">Presentation
   * <th align="left">Examples
   * <tr><td>`G`
   * <td>Era designator
   * <td>Text</a>
   * <td>`AD`
   * <tr bgcolor="#eeeeff">
   * <td>`y`
   * <td>Year
   * <td>Year</a>
   * <td>`1996`; `96`
   * <tr><td>`M`
   * <td>Month in year
   * <td>Month</a>
   * <td>`July`; `Jul`; `07`
   * <tr bgcolor="#eeeeff">
   * <td>`w`
   * <td>Week in year (starting at 1)
   * <td>Number</a>
   * <td>`27`
   * <tr><td>`W`
   * <td>Week in month (starting at 1)
   * <td>Number</a>
   * <td>`2`
   * <tr bgcolor="#eeeeff">
   * <td>`D`
   * <td>Day in year (starting at 1)
   * <td>Number</a>
   * <td>`189`
   * <tr><td>`d`
   * <td>Day in month (starting at 1)
   * <td>Number</a>
   * <td>`10`
   * <tr bgcolor="#eeeeff">
   * <td>`F`
   * <td>Day of week in month
   * <td>Number</a>
   * <td>`2`
   * <tr><td>`E`
   * <td>Day in week
   * <td>Text</a>
   * <td>`Tuesday`; `Tue`
   * </table>
   * @param format - the pattern.
   */
  Datebox.prototype.setFormat = function (format, opts) {
    var o = this._format;
    this._format = format;
    if (o !== format || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      if (this._pop) {
        this._pop.setFormat(this._format);
        if (this._value) this._value = this._pop.getTime();
      }
      var inp = this.getInputNode();
      if (inp) inp.value = this.getText();
    }
    return this;
  };
  /**
   * @returns the full date format of the specified format
   */
  Datebox.prototype.getFormat = function () {
    return this._format;
  };
  /**
   * Sets the constraint.
   * @defaultValue `null` (means no constraint all all).
   */
  Datebox.prototype.setConstraint = function (constraint, opts) {
    var o = this._constraint;
    this._constraint = constraint;
    if (o !== constraint || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      if (typeof constraint == 'string' && !constraint.startsWith('[') /*by server*/) this._cst = new zul.inp.SimpleDateConstraint(constraint, this);else this._cst = constraint;
      if (this._cst) this._reVald = true; //revalidate required
      if (this._pop) {
        this._pop.setConstraint(this._constraint);
        this._pop.rerender();
      }
    }
    return this;
  };
  /**
   * @returns the constraint, or null if no constraint at all.
   */
  Datebox.prototype.getConstraint = function () {
    return this._constraint;
  };
  /**
   * Sets the time zone that this date box belongs to.
   * @param timezone - the time zone's ID, such as "America/Los_Angeles".
   */
  Datebox.prototype.setTimeZone = function (timeZone, opts) {
    var _a;
    var o = this._timeZone;
    this._timeZone = timeZone;
    if (o !== timeZone || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      this._timeZone = timeZone;
      this._tm.setTimezone(timeZone);
      this._setTimeZonesIndex();
      (_a = this._value) === null || _a === void 0 ? void 0 : _a.tz(timeZone);
      this._pop && this._pop._fixConstraint();
      var cst = this._cst;
      if (cst && cst instanceof zul.inp.SimpleConstraint) cst.reparseConstraint();
    }
    return this;
  };
  /**
   * @returns the time zone that this date box belongs to, such as "America/Los_Angeles"
   */
  Datebox.prototype.getTimeZone = function () {
    return this._timeZone;
  };
  /**
   * Sets whether the list of the time zones to display is readonly.
   * If readonly, the user cannot change the time zone at the client.
   */
  Datebox.prototype.setTimeZonesReadonly = function (timeZonesReadonly, opts) {
    var o = this._timeZonesReadonly;
    this._timeZonesReadonly = timeZonesReadonly;
    if (o !== timeZonesReadonly || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var select = this.$n('dtzones');
      if (select) select.disabled = timeZonesReadonly;
    }
    return this;
  };
  /**
   * @returns whether the list of the time zones to display is readonly.
   * If readonly, the user cannot change the time zone at the client.
   */
  Datebox.prototype.isTimeZonesReadonly = function () {
    return !!this._timeZonesReadonly;
  };
  /**
   * Sets a catenation of a list of the time zones' ID, separated by comma,
   * that will be displayed at the client and allow user to select.
   * @param dtzones - a catenation of a list of the timezones' ID, such as
   * `"America/Los_Angeles,GMT+8"`
   */
  Datebox.prototype.setDisplayedTimeZones = function (displayedTimeZones, opts) {
    var o = this._displayedTimeZones;
    this._displayedTimeZones = displayedTimeZones;
    if (o !== displayedTimeZones || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      this._dtzones = displayedTimeZones ? displayedTimeZones.split(',') : undefined;
    }
    return this;
  };
  /**
   * @returns a list of the time zones that will be displayed at the
   * client and allow user to select.
   * @defaultValue `null`
   */
  Datebox.prototype.getDisplayedTimeZones = function () {
    return this._displayedTimeZones;
  };
  /**
   * Sets the unformater function. This method is called from Server side.
   * @param unf - the unformater function
   */
  Datebox.prototype.setUnformater = function (unformater, opts) {
    var o = this._unformater;
    this._unformater = unformater.toString();
    if (o !== this._unformater || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      Datebox_1._unformater = unformater;
    }
    return this;
  };
  /**
   * @returns the unformater.
   */
  Datebox.prototype.getUnformater = function () {
    return this._unformater;
  };
  /**
   * Sets whether or not date/time parsing is to be lenient.
   *
   * <p>
   * With lenient parsing, the parser may use heuristics to interpret inputs
   * that do not precisely match this object's format. With strict parsing,
   * inputs must match this object's format.
   *
   * @defaultValue `true`.
   */
  Datebox.prototype.setLenient = function (lenient) {
    this._lenient = lenient;
    return this;
  };
  /**
   * @returns whether or not date/time parsing is to be lenient.
   *
   * <p>
   * With lenient parsing, the parser may use heuristics to interpret inputs
   * that do not precisely match this object's format. With strict parsing,
   * inputs must match this object's format.
   */
  Datebox.prototype.isLenient = function () {
    return this._lenient;
  };
  Datebox.prototype.getLocalizedSymbols = function () {
    return this._localizedSymbols;
  };
  Datebox.prototype.setLocalizedSymbols = function (localizedSymbols, opts) {
    var o = this._localizedSymbols;
    if (localizedSymbols) {
      if (!globallocalizedSymbols[localizedSymbols[0]]) globallocalizedSymbols[localizedSymbols[0]] = localizedSymbols[1];
      this._localizedSymbols = globallocalizedSymbols[localizedSymbols[0]];
    }
    if (o !== localizedSymbols || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      // in this case, we cannot use setLocalizedSymbols() for Timebox
      if (this._tm) this._tm._localizedSymbols = this._localizedSymbols;
      if (this._pop) this._pop.setLocalizedSymbols(this._localizedSymbols);
    }
    return this;
  };
  /**
   * Sets whether enable to show the week number in the current calendar or
   * not. [ZK EE]
   * @since 6.5.0
   */
  Datebox.prototype.setWeekOfYear = function (weekOfYear, opts) {
    var o = this._weekOfYear;
    this._weekOfYear = weekOfYear;
    if (o !== weekOfYear || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      if (this._pop) this._pop.setWeekOfYear(weekOfYear);
    }
    return this;
  };
  /**
   * @returns whether enable to show the week number in the current calendar
   * or not.
   * @defaultValue `false`
   * @since 6.5.0
   */
  Datebox.prototype.isWeekOfYear = function () {
    return !!this._weekOfYear;
  };
  /**
   * Sets whether enable to show the link that jump to today in day view
   * @since 8.0.0
   */
  Datebox.prototype.setShowTodayLink = function (showTodayLink, opts) {
    var o = this._showTodayLink;
    this._showTodayLink = showTodayLink;
    if (o !== showTodayLink || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      if (this._pop) {
        this._pop.setShowTodayLink(showTodayLink);
      }
    }
    return this;
  };
  /**
   * @returns whether enable to show the link that jump to today in day view
   * @defaultValue `false`
   * @since 8.0.0
   */
  Datebox.prototype.isShowTodayLink = function () {
    return !!this._showTodayLink;
  };
  /**
   * Sets the label of the link that jump to today in day view
   * @since 8.0.4
   */
  Datebox.prototype.setTodayLinkLabel = function (todayLinkLabel, opts) {
    var o = this._todayLinkLabel;
    this._todayLinkLabel = todayLinkLabel;
    if (o !== todayLinkLabel || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      if (this._pop) {
        this._pop.setTodayLinkLabel(todayLinkLabel);
      }
    }
    return this;
  };
  /**
   * @returns the label of the link that jump to today in day view
   * @since 8.0.4
   */
  Datebox.prototype.getTodayLinkLabel = function () {
    return this._todayLinkLabel;
  };
  /**
   * Sets whether or not date/time should be strict.
   * If true, any invalid input like "Jan 0" or "Nov 31" would be refused.
   * If false, it won't be checked and let lenient parsing decide.
   * @since 8.6.0
   */
  Datebox.prototype.setStrictDate = function (strictDate) {
    this._strictDate = strictDate;
    return this;
  };
  /**
   * @returns whether or not date/time should be strict.
   * @defaultValue `false`.
   * @since 8.6.0
   */
  Datebox.prototype.isStrictDate = function () {
    return this._strictDate;
  };
  /**
   * Sets the default datetime if the value is empty.
   * @since 9.0.0
   * @param defaultDateTime - Default datetime. null means current datetime.
   */
  Datebox.prototype.setDefaultDateTime = function (defaultDateTime) {
    this._defaultDateTime = defaultDateTime;
    return this;
  };
  /**
   * @returns the default datetime if the value is empty.
   * @defaultValue `null` (means current datetime).
   * @since 9.0.0
   */
  Datebox.prototype.getDefaultDateTime = function () {
    return this._defaultDateTime;
  };
  /**
   * Sets the level that a user can select.
   * The valid options are "day", "month", and "year".
   *
   * @param selectLevel - the level that a user can select
   * @since 9.5.1
   */
  Datebox.prototype.setSelectLevel = function (selectLevel) {
    this._selectLevel = selectLevel;
    return this;
  };
  /**
   * @returns the level that a user can select.
   * @defaultValue `"day"`
   * @since 9.5.1
   */
  Datebox.prototype.getSelectLevel = function () {
    return this._selectLevel;
  };
  /**
   * Sets whether to auto close the datebox popup after changing the timezone.
   *
   * @param closePopupOnTimezoneChange - shall close the datebox popup or not
   * @since 9.6.0
   */
  Datebox.prototype.setClosePopupOnTimezoneChange = function (closePopupOnTimezoneChange) {
    this._closePopupOnTimezoneChange = closePopupOnTimezoneChange;
    return this;
  };
  /**
   * @returns whether to auto close the datebox popup after changing the timezone.
   * @defaultValue `true`
   * @since 9.6.0
   */
  Datebox.prototype.isClosePopupOnTimezoneChange = function () {
    return this._closePopupOnTimezoneChange;
  };
  /**
   * A method for component getter symmetry, it will call getValue
   * @since 10.0.0
   */
  Datebox.prototype.getValueInZonedDateTime = function () {
    return this.getValue();
  };
  /**
   * A method for component setter symmetry, it will call setValue
   * @since 10.0.0
   */
  Datebox.prototype.setValueInZonedDateTime = function (valueInZonedDateTime, fromServer) {
    return this.setValue(valueInZonedDateTime, fromServer);
  };
  /**
   * A method for component getter symmetry, it will call getValue
   * @since 10.0.0
   */
  Datebox.prototype.getValueInLocalDateTime = function () {
    return this.getValue();
  };
  /**
   * A method for component setter symmetry, it will call setValue
   * @since 10.0.0
   */
  Datebox.prototype.setValueInLocalDateTime = function (valueInLocalDateTime, fromServer) {
    return this.setValue(valueInLocalDateTime, fromServer);
  };
  /**
   * A method for component getter symmetry, it will call getValue
   * @since 10.0.0
   */
  Datebox.prototype.getValueInLocalDate = function () {
    return this.getValue();
  };
  /**
   * A method for component setter symmetry, it will call setValue
   * @since 10.0.0
   */
  Datebox.prototype.setValueInLocalDate = function (valueInLocalDate, fromServer) {
    return this.setValue(valueInLocalDate, fromServer);
  };
  /**
   * A method for component getter symmetry, it will call getValue
   * @since 10.0.0
   */
  Datebox.prototype.getValueInLocalTime = function () {
    return this.getValue();
  };
  /**
   * A method for component setter symmetry, it will call setValue
   * @since 10.0.0
   */
  Datebox.prototype.setValueInLocalTime = function (valueInLocalTime, fromServer) {
    return this.setValue(valueInLocalTime, fromServer);
  };
  /**
   * @returns the iconSclass name of this Datebox.
   * @since 8.6.2
   */
  Datebox.prototype.getIconSclass = function () {
    return 'z-icon-calendar';
  };
  Datebox.prototype.inRoundedMold = function () {
    return true;
  };
  /** @internal */
  Datebox.prototype._setTimeZonesIndex = function () {
    var select = this.$n('dtzones');
    if (select && this._timeZone) {
      var opts = jq(select).children('option');
      for (var i = opts.length; i--;) {
        if (opts[i].text == this._timeZone) select.selectedIndex = i;
      }
    }
    return this;
  };
  Datebox.prototype.onSize = function () {
    if (this.isOpen()) Datebox_1._reposition(this, true);
  };
  /**
   * @returns the Time format of the specified format
   */
  Datebox.prototype.getTimeFormat = function () {
    //Note: S (milliseconds not supported yet)
    var fmt = this._format,
      aa = fmt.indexOf('a'),
      hh = fmt.indexOf('h'),
      KK = fmt.indexOf('K'),
      HH = fmt.indexOf('H'),
      // ZK-2964: local nl time format has only one 'H'
      kk = fmt.indexOf('k'),
      mm = fmt.indexOf('m'),
      ss = fmt.indexOf('s'),
      hasAM = aa > -1,
      //bug 3284144: The databox format parse a wrong result with hh:mm:ss
      hasHour1 = hasAM || hh ? hh > -1 || KK > -1 : false,
      mv = mm > -1 ? 'mm' : '',
      sv = ss > -1 ? 'ss' : '';
    if (hasHour1) {
      var time = Datebox_1._prepareTimeFormat(hh < KK ? 'KK' : 'hh', mv, sv);
      if (aa == -1) return time;else if (hh != -1 && aa < hh || KK != -1 && aa < KK) return 'a ' + time;else return time + ' a';
    } else return Datebox_1._prepareTimeFormat(HH < kk ? 'kk' : HH > -1 ? 'HH' : '', mv, sv);
  };
  /**
   * @returns the Date format of the specified format
   */
  Datebox.prototype.getDateFormat = function () {
    return this._format.replace(/[(s.S{1,3})ahKHksm]*:?/g, '').trim();
  };
  /**
   * Drops down or closes the calendar to select a date.
   */
  Datebox.prototype.setOpen = function (open, _focus_) {
    if (this.isRealVisible()) {
      var pop = this._pop;
      if (pop) {
        if (open) pop.open(!_focus_);else pop.close(!_focus_);
      }
    }
    return this;
  };
  Datebox.prototype.isOpen = function () {
    return !!this._pop && this._pop.isOpen();
  };
  Datebox.prototype.setValue = function (value, fromServer) {
    var tz = this.getTimeZone();
    if (tz && value) value.tz(tz);
    return _super.prototype.setValue.call(this, value, fromServer);
  };
  /** @internal */
  Datebox.prototype.coerceFromString_ = function (val, pattern) {
    var unf = Datebox_1._unformater,
      tz = this.getTimeZone();
    if (unf && jq.isFunction(unf)) {
      var cusv = unf(val);
      if (cusv) {
        this._shortcut = val;
        return cusv;
      }
    }
    if (val) {
      var refDate = this._refDate || this._value,
        format = this.getFormat(),
        d = new zk.fmt.Calendar().parseDate(val, pattern || format, !this._lenient, refDate, this._localizedSymbols, tz, this._strictDate);
      this._refDate = undefined;
      if (!d) return {
        error: zk.fmt.Text.format(msgzul.DATE_REQUIRED + this.localizedFormat.replace(_quotePattern, ''))
      };
      // B70-ZK-2382 escape shouldn't be used in format including hour
      if (!format.match(/[HkKh]/)) d = new zk.fmt.Calendar().escapeDSTConflict(d, tz);
      return d;
    }
    return undefined;
  };
  /** @internal */
  Datebox.prototype.coerceToString_ = function (val, pattern) {
    return val ? new zk.fmt.Calendar().formatDate(val, pattern || this.getFormat(), this._localizedSymbols) : '';
  };
  /** @internal */
  Datebox.prototype.doClick_ = function (evt, popupOnly) {
    if (this._disabled) return;
    if (this._readonly && this._buttonVisible && this._pop && !this._pop.isOpen()) this._pop.open();
    _super.prototype.doClick_.call(this, evt, popupOnly);
  };
  /** @internal */
  Datebox.prototype.doKeyDown_ = function (evt) {
    this._doKeyDown(evt);
    if (!evt.stopped) _super.prototype.doKeyDown_.call(this, evt);
  };
  /** @internal */
  Datebox.prototype._doKeyDown = function (evt) {
    if (jq.nodeName(evt.domTarget, 'option', 'select')) return;
    var keyCode = evt.keyCode,
      bOpen = this._pop.isOpen();
    if (!evt.shiftKey && keyCode == 9 && evt.domTarget == this.$n('real') && bOpen) {
      // Tab focus to popup
      this._pop.focus();
      evt.stop();
      return;
    }
    if (keyCode == 9 || zk.webkit && keyCode == 0) {
      //TAB or SHIFT-TAB (safari)
      if (evt.target != this._tm) {
        // avoid closing the popup if moving focus to the timezone dropdown
        if (bOpen) this._pop.close();
        return;
      }
    }
    if (evt.altKey && (keyCode == 38 || keyCode == 40)) {
      //UP/DN
      if (bOpen) this._pop.close();else this._pop.open();
      //FF: if we eat UP/DN, Alt+UP degenerate to Alt (select menubar)
      var opts = {
        propagation: true
      };
      evt.stop(opts);
      return;
    }
    //Request 1537962: better responsive
    if (bOpen && (keyCode == 13 || keyCode == 27 || keyCode == 32)) {
      //ENTER or ESC or SPACE
      if (keyCode == 13) this.enterPressed_(evt);else if (keyCode == 27) this.escPressed_(evt);
      return;
    }
    if (keyCode == 18 || keyCode == 27 || keyCode == 13 || keyCode >= 112 && keyCode <= 123)
      //ALT, ESC, Enter, Fn
      return; //ignore it (doc will handle it)
    // ZK-2202: should not trigger too early when key code is ENTER
    // select current time
    if (this._pop.isOpen()) {
      this._pop.doKeyDown_(evt);
    }
  };
  /**
   * Called when the user presses enter when this widget has the focus ({@link focus}).
   * <p>call the close function
   * @param evt - the widget event.
   * The original DOM event and target can be retrieved by {@link zk.Event#domEvent} and {@link zk.Event#domTarget}
   * @internal
   */
  Datebox.prototype.enterPressed_ = function (evt) {
    this._pop.close();
    this.updateChange_();
    evt.stop();
  };
  /**
   * Called when the user presses escape key when this widget has the focus ({@link focus}).
   * <p>call the close function
   * @param evt - the widget event.
   * The original DOM event and target can be retrieved by {@link zk.Event#domEvent} and {@link zk.Event#domTarget}
   * @internal
   */
  Datebox.prototype.escPressed_ = function (evt) {
    this._pop.close();
    evt.stop();
  };
  /** @internal */
  Datebox.prototype.afterKeyDown_ = function (evt, simulated) {
    if (!simulated && this._inplace) jq(this.$n_()).toggleClass(this.getInplaceCSS(), evt.keyCode == 13);
    return _super.prototype.afterKeyDown_.call(this, evt, simulated);
  };
  /** @internal */
  Datebox.prototype.bind_ = function (desktop, skipper, after) {
    _super.prototype.bind_.call(this, desktop, skipper, after);
    var btn = this.$n('btn');
    if (btn) {
      this.domListen_(btn, 'onClick', '_doBtnClick');
      if (this._inplace) this.domListen_(btn, 'onMouseDown', '_doBtnMouseDown');
    }
    zWatch.listen({
      onSize: this,
      onScroll: this,
      onShow: this
    });
    this._pop.setFormat(this.getDateFormat());
  };
  /** @internal */
  Datebox.prototype.unbind_ = function (skipper, after, keepRod) {
    var pop = this._pop;
    if (pop) pop.close(true);
    var btn = this.$n('btn');
    if (btn) {
      this.domUnlisten_(btn, 'onClick', '_doBtnClick');
      if (this._inplace) this.domUnlisten_(btn, 'onMouseDown', '_doBtnMouseDown');
    }
    zWatch.unlisten({
      onSize: this,
      onScroll: this,
      onShow: this
    });
    _super.prototype.unbind_.call(this, skipper, after, keepRod);
  };
  /** @internal */
  Datebox.prototype._doBtnClick = function (evt) {
    this._inplaceIgnore = false;
    if (!this._buttonVisible) return;
    if (!this._disabled) this.setOpen(!jq(this.$n_('pp')).zk.isVisible(), zul.db.DateboxCtrl.isPreservedFocus(this));
    // Bug ZK-2544, B70-ZK-2849
    evt.stop(this._pop && this._pop._open ? {
      propagation: true
    } : undefined);
  };
  /** @internal */
  Datebox.prototype._doBtnMouseDown = function () {
    this._inplaceIgnore = true;
  };
  /** @internal */
  Datebox.prototype._doTimeZoneChange = function (evt) {
    var select = this.$n_('dtzones'),
      timezone = select.value;
    this.updateChange_();
    this.fire('onTimeZoneChange', {
      timezone: timezone
    }, {
      toServer: true
    }, 150);
    if (this._pop && this._closePopupOnTimezoneChange) this._pop.close();
  };
  // NOTE: data value will become string after event handler
  Datebox.prototype.onChange = function (evt) {
    var data = evt.data,
      inpValue = this.getInputNode().value;
    if (this._pop) this._pop.setValue(data.value);
    // B50-ZK-631: Datebox format error message not shown with implements CustomConstraint
    // pass input value to server for showCustomError
    if (!data.value && inpValue && this.getFormat() && this._cst == '[c') data.value = inpValue; // FIXME: type mismatch
  };
  Datebox.prototype.onScroll = function (wgt) {
    if (this.isOpen()) {
      var pp = this._pop;
      // ZK-1552: fix the position of popup when scroll
      if (wgt && pp) {
        // ZK-2211: should close when the input is out of view
        if (this.getInputNode() && zul.inp.InputWidget._isInView(this)) Datebox_1._reposition(this, true);else pp.close();
      }
    }
  };
  Datebox.prototype.onShow = function () {
    if (this.__ebox) {
      this.setFloating_(true);
      this.__ebox.show();
    }
  };
  /**
   * @returns the label of the time zone
   */
  Datebox.prototype.getTimeZoneLabel = function () {
    return '';
  };
  /** @internal */
  Datebox.prototype.redrawpp_ = function (out) {
    out.push('<div id="', this.uuid, '-pp" class="', this.$s('popup'), '" style="display:none" role="dialog" aria-labelledby="', /*safe*/this._pop.uuid, '-title" tabindex="-1">');
    for (var w = this.firstChild; w; w = w.nextSibling) w.redraw(out);
    this._redrawTimezone(out);
    out.push('</div>');
  };
  /** @internal */
  Datebox.prototype._redrawTimezone = function (out) {
    var timezones = this._dtzones;
    if (timezones) {
      out.push('<div class="', this.$s('timezone'), '">', DOMPurify.sanitize(this.getTimeZoneLabel()), '<select id="', this.uuid, '-dtzones">');
      for (var i = 0, len = timezones.length; i < len; i++) {
        var timezoneHTML = zUtl.encodeXML(timezones[i]);
        out.push('<option value="', timezoneHTML, '">', timezoneHTML, '</option>');
      }
      out.push('</select></div>');
      // B50-ZK-577: Rendering Issue using Datebox with displayedTimeZones
    }
  };
  /** @internal */
  Datebox.prototype.updateChange_ = function (clear) {
    if (!this.isOpen()) _super.prototype.updateChange_.call(this, clear);
    return false;
  };
  /** @internal */
  Datebox._reposition = function (db, silent) {
    if (!db.$n()) return;
    var pp = db.$n('pp'),
      n = db.$n_(),
      inp = db.getInputNode();
    if (pp) {
      // dodgeRef is only ever tested for truthiness, and only here is it set to a non-boolean value.
      zk(pp).position(n, db._position, {
        dodgeRef: n
      });
      db._pop.syncShadow();
      if (!silent) zk(inp).focus();
    }
  };
  /** @internal */
  Datebox._prepareTimeFormat = function (h, m, s) {
    var o = [];
    if (h) o.push(h);
    if (m) o.push(m);
    if (s) o.push(s);
    return o.join(':');
  };
  var Datebox_1;
  Datebox = Datebox_1 = __decorate([zk.WrapClass('zul.db.Datebox')], Datebox);
  return Datebox;
}(zul.inp.FormatWidget);
exports.Datebox = Datebox;
var CalendarPop = /** @class */function (_super) {
  __extends(CalendarPop, _super);
  function CalendarPop() {
    var _this = _super.call(this) || this;
    _this.listen({
      onChange: _this
    }, -1000);
    return _this;
  }
  CalendarPop_1 = CalendarPop;
  CalendarPop.prototype.setFormat = function (format) {
    this._fmt = format;
    return this;
  };
  CalendarPop.prototype.setLocalizedSymbols = function (localizedSymbols) {
    this._localizedSymbols = localizedSymbols;
    return this;
  };
  // ZK-2047: should sync shadow when shiftView
  CalendarPop.prototype.rerender = function (skipper) {
    _super.prototype.rerender.call(this, skipper);
    if (this.desktop) this.syncShadow();
    return this;
  };
  CalendarPop.prototype.close = function (silent) {
    var db = this.parent,
      pp = db.$n('pp');
    if (!pp || !zk(pp).isVisible()) return;
    if (db._inplace) {
      db._inplaceIgnore = false;
      db._inplaceTimerId = setTimeout(function () {
        if (db.desktop) jq(db.$n_()).addClass(db.getInplaceCSS());
      }, db._inplaceTimeout);
    }
    // firefox and safari only
    try {
      if ((zk.ff || zk.safari) && zk.currentFocus) {
        var n = zk.currentFocus.getInputNode ? zk.currentFocus.getInputNode() : zk.currentFocus.$n_();
        if (jq.nodeName(n, 'input') && jq.isAncestor(pp, n))
          // Bug ZK-2922, check ancestor first.
          jq(n).blur(); // trigger a missing blur event.
      }
    } catch (e) {
      zk.debugLog(e.message || e);
    }
    if (this._shadow) {
      // B65-ZK-1904: Make shadow behavior the same as ComboWidget
      this._shadow.destroy();
      this._shadow = undefined;
    }
    pp.style.display = 'none';
    pp.className = db.$s('popup');
    jq(pp).zk.undoVParent();
    db.setFloating_(false);
    if (silent) db.updateChange_();else if (zul.db.DateboxCtrl.isPreservedFocus(this)) zk(db.getInputNode()).focus();
    //remove extra CSS class
    var openClass = db.$s('open');
    jq(db.$n_()).removeClass(openClass);
    jq(pp).removeClass(openClass);
  };
  CalendarPop.prototype.isOpen = function () {
    return zk(this.parent.$n('pp')).isVisible();
  };
  CalendarPop.prototype.open = function (silent) {
    var db = this.parent,
      dbn = db.$n(),
      pp = db.$n('pp');
    if (!dbn || !pp) return;
    if (db._inplace) db._inplaceIgnore = true;
    db.setFloating_(true, {
      node: pp
    });
    zWatch.fire('onFloatUp', db); //notify all
    var topZIndex = this.setTopmost();
    this._setView(db._selectLevel);
    var /*safe*/zcls = db.getZclass();
    pp.className = dbn.className + ' ' + pp.className;
    jq(pp).removeClass(zcls);
    pp.style.width = 'auto'; //reset
    pp.style.display = 'block';
    pp.style.zIndex = topZIndex > 0 ? topZIndex : 1;
    this.setDomVisible_(pp, true, {
      visibility: true
    });
    //FF: Bug 1486840
    //IE: Bug 1766244 (after specifying position:relative to grid/tree/listbox)
    jq(pp).zk.makeVParent();
    if (pp.offsetWidth < dbn.offsetWidth) {
      pp.style.width = "".concat(dbn.offsetWidth, "px");
    } else {
      var wd = jq.innerWidth() - 20;
      if (wd < dbn.offsetWidth) wd = dbn.offsetWidth;
      if (pp.offsetWidth > wd) pp.style.width = wd;
    }
    delete db._shortcut;
    var fmt = db.getTimeFormat(),
      tz = db.getTimeZone(),
      value = db._value || db._defaultDateTime || zUtl.today(fmt, tz);
    if (value) this.setValue(value);
    if (fmt) {
      var tm = db._tm;
      tm.setVisible(true);
      tm.setFormat(fmt);
      tm.setValue(value || Dates.newInstance().tz(tz));
      tm.onSize();
    } else {
      db._tm.setVisible(false);
    }
    //add extra CSS class for easy customize
    var openClass = db.$s('open');
    jq(db.$n_()).addClass(openClass);
    jq(pp).addClass(openClass);
    Datebox._reposition(db, silent); //ZK-3217: only need to calculate position once during open
  };
  CalendarPop.prototype.syncShadow = function () {
    if (!this._shadow) this._shadow = new zk.eff.Shadow(this.parent.$n_('pp'), {
      left: -4,
      right: 4,
      top: 2,
      bottom: 3
    });
    this._shadow.sync();
  };
  CalendarPop.prototype.onChange = function (evt) {
    var date = this.getTime(),
      db = this.parent,
      fmt = db.getTimeFormat(),
      oldDate = db.getValue(),
      tz = db.getTimeZone(),
      cal = new zk.fmt.Calendar();
    if (fmt) {
      var tm = db._tm,
        time = tm.getValue();
      if (fmt.match(/[HK]/i)) date.setHours(time.getHours());
      if (fmt.match(/[m]/)) date.setMinutes(time.getMinutes());
      if (fmt.match(/[s]/)) date.setSeconds(time.getSeconds());
      if (fmt.match(/[S]/)) date.setMilliseconds(time.getMilliseconds());
      // B70-ZK-2382 escape shouldn't be used in format including hour
      if (!fmt.match(/[HkKh]/)) date = cal.escapeDSTConflict(date, tz);
    } else if (oldDate) {
      date = Dates.newInstance([date.getFullYear(), date.getMonth(), date.getDate(), oldDate.getHours(), oldDate.getMinutes(), oldDate.getSeconds(), oldDate.getMilliseconds()], tz);
      //Note: we cannot call setFullYear(), setMonth(), then setDate(),
      //since Date object will adjust month if date larger than max one
      // B70-ZK-2382 escape shouldn't be used in format including hour
      if (!this.getFormat().match(/[HkKh]/)) date = cal.escapeDSTConflict(date, tz);
    }
    //Bug ZK-1712: no need to set datebox input value when shift view
    if (!evt.data.shiftView) db.getInputNode().value = db.coerceToString_(date);
    // eslint-disable-next-line @typescript-eslint/no-unnecessary-boolean-literal-compare
    if (this._view == db._selectLevel && evt.data.shallClose !== false) {
      this.close();
      // Bug 3122159 and 3301374
      evt.data.value = date;
      if (!CalendarPop_1._equalDate(date, oldDate)) {
        db._refDate = date; // for coerceFromString_
        db.updateChange_();
      }
    }
    evt.stop();
  };
  CalendarPop.prototype.onFloatUp = function (ctl) {
    if (this.isOpen()) {
      var db = this.parent;
      if (!zUtl.isAncestor(db, ctl.origin)) {
        this.close(true);
      }
    }
  };
  /** @internal */
  CalendarPop.prototype.bind_ = function (desktop, skipper, after) {
    _super.prototype.bind_.call(this, desktop, skipper, after);
    this._bindTimezoneEvt();
    zWatch.listen({
      onFloatUp: this
    });
  };
  /** @internal */
  CalendarPop.prototype.unbind_ = function (skipper, after, keepRod) {
    zWatch.unlisten({
      onFloatUp: this
    });
    this._unbindfTimezoneEvt();
    if (this._shadow) {
      this._shadow.destroy();
      this._shadow = undefined;
    }
    _super.prototype.unbind_.call(this, skipper, after, keepRod);
  };
  /** @internal */
  CalendarPop.prototype._bindTimezoneEvt = function () {
    var db = this.parent,
      select = db.$n('dtzones');
    if (select) {
      select.disabled = db.isTimeZonesReadonly() ? 'disable' : '';
      db.domListen_(select, 'onChange', '_doTimeZoneChange');
      db._setTimeZonesIndex();
    }
  };
  /** @internal */
  CalendarPop.prototype._unbindfTimezoneEvt = function () {
    var db = this.parent,
      select = db.$n('dtzones');
    if (select) db.domUnlisten_(select, 'onChange', '_doTimeZoneChange');
  };
  /** @internal */
  CalendarPop.prototype._setView = function (val, force) {
    if (this.parent.getTimeFormat()) this.parent._tm.setVisible(val == 'day');
    _super.prototype._setView.call(this, val, force);
    return this;
  };
  // ZK-2308
  /** @internal */
  CalendarPop.prototype.doKeyDown_ = function (evt) {
    _super.prototype.doKeyDown_.call(this, evt);
    if (evt.keyCode == 27) {
      this.parent.escPressed_(evt);
    }
  };
  /** @internal */
  CalendarPop.prototype.animationSpeed_ = function () {
    return zk(this.parent).getAnimationSpeed();
  };
  /** @internal */
  CalendarPop.prototype._chooseDate = function (target, val) {
    var db = this.parent,
      selectLevel = db._selectLevel;
    if (target && !jq(target).hasClass(this.$s('disabled'))) {
      var cell = target,
        dateobj = this.getTime();
      switch (this._view) {
        case 'day':
          var oldTime = this.getTime();
          this._setTime(undefined, cell._monofs != null && cell._monofs != 0 ? dateobj.getMonth() + cell._monofs : undefined, val, true /*fire onChange */);
          var newTime = this.getTime();
          if (oldTime.getYear() == newTime.getYear() && oldTime.getMonth() == newTime.getMonth()) {
            this._markCal({
              sameMonth: true
            }); // optimize
          } else {
            this.rerender(-1);
            this.focus();
          }
          break;
        case 'month':
          if (selectLevel == 'month') {
            this._setTime(undefined, val, 1, true);
            break;
          }
          this._setTime(undefined, val);
          this._setView('day');
          break;
        case 'year':
          if (selectLevel == 'year') {
            this._setTime(val, 0, 1, true);
            break;
          }
          this._setTime(val);
          this._setView('month');
          break;
        case 'decade':
          //Decade mode Set Year Also
          this._setTime(val);
          this._setView('year');
          break;
      }
    }
  };
  /** @internal */
  CalendarPop._equalDate = function (d1, d2) {
    return !!(d1 == d2 || d1 && d2 && d1.getTime() == d2.getTime());
  };
  var CalendarPop_1;
  CalendarPop = CalendarPop_1 = __decorate([zk.WrapClass('zul.db.CalendarPop')], CalendarPop);
  return CalendarPop;
}(zul.db.Calendar);
exports.CalendarPop = CalendarPop;
var CalendarTime = /** @class */function (_super) {
  __extends(CalendarTime, _super);
  function CalendarTime() {
    var _this = _super.call(this) || this;
    _this.listen({
      onChanging: _this
    }, -1000);
    return _this;
  }
  CalendarTime.prototype.onChanging = function (evt) {
    var db = this.parent,
      oldDate = db.getValue() || db._pop.getValue(),
      // ZK-2382 we must do the conversion with date and time in the same time
      // otherwise the result may be affcted by DST adjustment
      dateTime = db.coerceToString_(oldDate, _innerDateFormat) + evt.data.value,
      //onChanging's data is string
      pattern = _innerDateFormat + db.getTimeFormat();
    // add 'AM' (or APM in localizedSymbols) by default, if pattern specified AMPM
    if (pattern.indexOf('a') > -1) {
      var localizedSymbols = db.getLocalizedSymbols();
      if (localizedSymbols && localizedSymbols.APM) {
        dateTime += dateTime.indexOf(localizedSymbols.APM[0]) < 0 && dateTime.indexOf(localizedSymbols.APM[1]) < 0 ? localizedSymbols.APM[0] : '';
      } else {
        dateTime += dateTime.indexOf('AM') < 0 && dateTime.indexOf('PM') < 0 ? 'AM' : '';
      }
    }
    var date = db.coerceFromString_(dateTime, pattern);
    // do nothing if date converted from String is not a valid Date object e.g. dateTime = "2014/10/10 1 :  :     "
    if (date instanceof DateImpl) {
      db.getInputNode().value = evt.data.value = db.coerceToString_(date);
      db.fire(evt.name, evt.data); //onChanging
    }
    evt.stop();
  };
  CalendarTime = __decorate([zk.WrapClass('zul.db.CalendarTime')], CalendarTime);
  return CalendarTime;
}(zul.db.Timebox);
exports.CalendarTime = CalendarTime;
/** @class zul.db.DateboxCtrl
 * @import zk.Widget
 * The extra control for the Datebox.
 * It is designed to be overriden
 * @since 6.5.0
 */
exports.DateboxCtrl = {
  /**
   * @returns whether to preserve the focus state.
   * @param wgt - a widget
   */
  isPreservedFocus: function (wgt) {
    return true;
  }
};
zul.db.DateboxCtrl = exports.DateboxCtrl;
window.zul.db.Datebox_.globallocalizedSymbols = globallocalizedSymbols;
window.zul.db.Datebox_._quotePattern = _quotePattern;
window.zul.db.Datebox_._innerDateFormat = _innerDateFormat;
window.zul.db.Datebox_.Datebox = Datebox;
window.zul.db.Datebox_.CalendarPop = CalendarPop;
window.zul.db.Datebox_.CalendarTime = CalendarTime;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/db/Timebox.ts":
/*!*********************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/db/Timebox.ts ***!
  \*********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


if (!window.zul) window.zul = {};
if (!window.zul.db) window.zul.db = {};
if (!window.zul.db.Timebox_) window.zul.db.Timebox_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.AMPMHandler = exports.SecondHandler = exports.MinuteHandler = exports.HourHandler2 = exports.HourHandler = exports.HourInDayHandler2 = exports.HourInDayHandler = exports.TimeHandler = exports.Timebox = void 0;
/* Timebox.ts

    Purpose:
        testing textbox.intbox.spinner,timebox,doublebox,longbox and decimalbox on zk5
    Description:

    History:
        Thu June 11 10:17:24     2009, Created by kindalu

Copyright (C) 2009 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
var LEGAL_CHARS = 'ahKHksmz',
  /* constant for MINUTE (m) field alignment. */
  MINUTE_FIELD = 1,
  /* constant for SECOND (s) field alignment. */
  SECOND_FIELD = 2,
  /* constant for AM_PM (a) field alignment. */
  AM_PM_FIELD = 3,
  /* constant for HOUR0 (H) field alignment. (Hour in day (0-23)) */
  HOUR0_FIELD = 4,
  /* constant for HOUR1 (k) field alignment. (Hour in day (1-24)) */
  HOUR1_FIELD = 5,
  /* constant for HOUR2 (h) field alignment. (Hour in am/pm (1-12)) */
  HOUR2_FIELD = 6,
  /* constant for HOUR3 (K) field alignment. (Hour in am/pm (0-11)) */
  HOUR3_FIELD = 7,
  globallocalizedSymbols = {};
var Timebox = /** @class */function (_super) {
  __extends(Timebox, _super);
  function Timebox() {
    var _this = _super.call(this) || this;
    /** @internal */
    _this._buttonVisible = true;
    /** @internal */
    _this._format = 'HH:mm';
    /** @internal */
    _this._timezoneAbbr = '';
    _this.onHide = undefined;
    _this.validate = undefined;
    Timebox_1._updFormat(_this, _this._format);
    return _this;
  }
  Timebox_1 = Timebox;
  Timebox.prototype.getTimezoneAbbr = function () {
    return this._timezoneAbbr;
  };
  Timebox.prototype.setTimezoneAbbr = function (timezoneAbbr, opts) {
    var o = this._timezoneAbbr;
    this._timezoneAbbr = timezoneAbbr;
    if (o !== timezoneAbbr || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      Timebox_1._updFormat(this, this._format);
    }
    return this;
  };
  /**
   * Sets the time zone ID that this time box belongs to.
   * @param timeZone - the time zone's ID, such as "America/Los_Angeles".
   * @since 9.0.0
   */
  Timebox.prototype.setTimeZone = function (timeZone, opts) {
    var _a;
    var o = this._timeZone;
    this._timeZone = timeZone;
    if (o !== timeZone || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      (_a = this._value) === null || _a === void 0 ? void 0 : _a.tz(timeZone);
    }
    return this;
  };
  /**
   * @returns the time zone ID that this time box belongs to, such as "America/Los_Angeles".
   * @since 9.0.0
   */
  Timebox.prototype.getTimeZone = function () {
    return this._timeZone;
  };
  /**
   * @returns whether the button (on the right of the textbox) is visible.
   * @defaultValue `true`.
   */
  Timebox.prototype.isButtonVisible = function () {
    return this._buttonVisible;
  };
  /**
   * Sets whether the button (on the right of the textbox) is visible.
   */
  Timebox.prototype.setButtonVisible = function (buttonVisible, opts) {
    var o = this._buttonVisible;
    this._buttonVisible = buttonVisible;
    if (o !== buttonVisible || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      zul.inp.RoundUtl.buttonVisible(this, buttonVisible);
    }
    return this;
  };
  /**
   * Sets the unformater function. This method is called from Server side.
   * @param unformater - the unformater function
   */
  Timebox.prototype.setUnformater = function (unformater, opts) {
    var o = this._unformater;
    this._unformater = unformater.toString();
    if (o !== this._unformater || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      Timebox_1._unformater = unformater;
    }
    return this;
  };
  /**
   * @returns the unformater.
   */
  Timebox.prototype.getUnformater = function () {
    return this._unformater;
  };
  Timebox.prototype.getLocalizedSymbols = function () {
    return this._localizedSymbols;
  };
  Timebox.prototype.setLocalizedSymbols = function (localizedSymbols) {
    if (localizedSymbols) {
      if (!globallocalizedSymbols[localizedSymbols[0]]) globallocalizedSymbols[localizedSymbols[0]] = localizedSymbols[1];
      this._localizedSymbols = globallocalizedSymbols[localizedSymbols[0]];
    }
    return this;
  };
  /**
   * Sets the constraint.
   * @defaultValue `null` (means no constraint all all).
   */
  Timebox.prototype.setConstraint = function (constraint, opts) {
    var o = this._constraint;
    this._constraint = constraint;
    if (o !== constraint || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      if (typeof constraint == 'string' && !constraint.startsWith('[') /*by server*/) this._cst = new zul.inp.SimpleLocalTimeConstraint(constraint, this);else this._cst = constraint;
      if (this._cst) this._reVald = true; //revalidate required
      // FIXME: never assigned
      // if (this._pop) {
      // 	this._pop.setConstraint(this._constraint);
      // 	this._pop.rerender();
      // }
    }
    return this;
  };
  /**
   * @returns the constraint, or null if no constraint at all.
   */
  Timebox.prototype.getConstraint = function () {
    return this._constraint;
  };
  /**
   * A method for component getter symmetry, it will call getValue
   * @since 10.0.0
   */
  Timebox.prototype.getValueInZonedDateTime = function () {
    return this.getValue();
  };
  /**
   * A method for component setter symmetry, it will call setValue
   * @since 10.0.0
   */
  Timebox.prototype.setValueInZonedDateTime = function (valueInZonedDateTime, fromServer) {
    return this.setValue(valueInZonedDateTime, fromServer);
  };
  /**
   * A method for component getter symmetry, it will call getValue
   * @since 10.0.0
   */
  Timebox.prototype.getValueInLocalDateTime = function () {
    return this.getValue();
  };
  /**
   * A method for component setter symmetry, it will call setValue
   * @since 10.0.0
   */
  Timebox.prototype.setValueInLocalDateTime = function (valueInLocalDateTime, fromServer) {
    return this.setValue(valueInLocalDateTime, fromServer);
  };
  /**
   * A method for component getter symmetry, it will call getValue
   * @since 10.0.0
   */
  Timebox.prototype.getValueInLocalDate = function () {
    return this.getValue();
  };
  /**
   * A method for component setter symmetry, it will call setValue
   * @since 10.0.0
   */
  Timebox.prototype.setValueInLocalDate = function (valueInLocalDate, fromServer) {
    return this.setValue(valueInLocalDate, fromServer);
  };
  /**
   * A method for component getter symmetry, it will call getValue
   * @since 10.0.0
   */
  Timebox.prototype.getValueInLocalTime = function () {
    return this.getValue();
  };
  /**
   * A method for component setter symmetry, it will call setValue
   * @since 10.0.0
   */
  Timebox.prototype.setValueInLocalTime = function (valueInLocalTime, fromServer) {
    return this.setValue(valueInLocalTime, fromServer);
  };
  /**
   * Sets the time zone ID that this time box belongs to.
   * @param timezone - the time zone's ID, such as "America/Los_Angeles".
   * @deprecated Use {@link setTimeZone} instead.
   */
  Timebox.prototype.setTimezone = function (timezone) {
    return this.setTimeZone(timezone);
  };
  /**
   * @returns the time zone ID that this time box belongs to, such as "America/Los_Angeles"
   * @since 8.5.1
   * @deprecated Use {@link getTimeZone} instead.
   */
  Timebox.prototype.getTimezone = function () {
    return this._timeZone;
  };
  Timebox.prototype.inRoundedMold = function () {
    return true;
  };
  Timebox.prototype.setFormat = function (format, opts) {
    format = format ? format.replace(/'/g, '') : format;
    Timebox_1._updFormat(this, format);
    return _super.prototype.setFormat.call(this, format, opts);
  };
  Timebox.prototype.setValue = function (value, fromServer) {
    var tz = this.getTimeZone();
    if (tz && value) value.tz(tz);
    if (fromServer && value == null)
      //Bug ZK-1322: if from server side, return empty string
      this._changed = false;
    return _super.prototype.setValue.call(this, value, fromServer);
  };
  /** @internal */
  Timebox.prototype.coerceToString_ = function (date) {
    if (!this._changed && !date && arguments.length) return '';
    var out = '',
      th,
      text,
      offset;
    for (var i = 0, f = this._fmthdler, l = f.length; i < l; i++) {
      th = f[i];
      text = th.format(date);
      out += text;
      //sync handler index
      if (th.type && (offset = th.isSingleLength()) !== false && (offset += text.length - 1)) th._doShift(this, offset);
    }
    return out;
  };
  /** @internal */
  Timebox.prototype.coerceFromString_ = function (val) {
    var unf = Timebox_1._unformater,
      tz = this.getTimeZone();
    if (unf && jq.isFunction(unf)) {
      var cusv = unf(val);
      if (cusv) {
        this._shortcut = val;
        return cusv;
      }
    }
    if (!val) return undefined;
    // F65-ZK-1825: use this._value instead of "today"
    // We cannot use this._value in this case, which won't trigger onChange
    // event. Using clone date instead.
    var date = this._value ? Dates.newInstance(this._value) : zUtl.today(this._format, tz),
      hasAM,
      isAM,
      fmt = [],
      fmtObeyCount = [],
      emptyCount = 0;
    date.setSeconds(0);
    date.setMilliseconds(0);
    for (var i = 0, f = this._fmthdler, l = f.length; i < l; i++) {
      var th = f[i];
      if (th.type == AM_PM_FIELD) {
        hasAM = true;
        isAM = th.unformat(date, val, {});
        if (!th.getText(val).trim().length) emptyCount++;
      } else if (th.type) {
        var shouldObeyCount = i + 1 < l && Timebox_1._shouldObeyCount(f[i + 1].type);
        fmt.push(th);
        fmtObeyCount.push(shouldObeyCount);
        th.parse(val, {
          obeyCount: shouldObeyCount
        }); // in order to shift if necessary
        if (!th.getText(val).trim().length)
          // ZK-4342: no need to pass obeyCount to determine if part is empty
          emptyCount++;
      }
    }
    if (fmt.length == (hasAM ? --emptyCount : emptyCount)) {
      this._changed = false; //for return empty string
      return;
    }
    for (var i = 0, l = fmt.length; i < l; i++) {
      if (!hasAM && (fmt[i].type == HOUR2_FIELD || fmt[i].type == HOUR3_FIELD)) isAM = true;
      date = fmt[i].unformat(date, val, {
        am: isAM,
        obeyCount: fmtObeyCount[i]
      }); // FIXME: inconsistent use of unformat
    }
    return date;
  };
  Timebox.prototype.onSize = function () {
    var inp = this.getInputNode();
    if (inp && this._value && !inp.value) inp.value = this.coerceToString_(this._value);
  };
  /** @internal */
  Timebox.prototype.doClick_ = function (evt, popupOnly) {
    if (evt.domTarget == this.getInputNode()) this._doCheckPos();
    _super.prototype.doClick_.call(this, evt, popupOnly);
  };
  /** @internal */
  Timebox.prototype.doKeyPress_ = function (evt) {
    if (zk.opera && evt.keyCode != 9) {
      evt.stop();
      return;
    }
    _super.prototype.doKeyPress_.call(this, evt);
  };
  /** @internal */
  Timebox.prototype._doBeforeInput = function (evt) {
    var inp = this.getInputNode();
    if (inp.disabled || inp.readOnly) return;
    // control input keys only when no custom unformater is given
    if (!Timebox_1._unformater) {
      var char = evt.domEvent.originalEvent.data;
      if (char.length <= 1) {
        if (/\d/.test(char)) {
          // only accept 0~9
          this._doType(parseInt(char));
        }
        // ZK-4861, android only IME issue
        // In desktop browser, keys that has real input value will be stopped at doKeyDown_(),
        // but in android device, keys that has real input value will have the keyCode 229 (evt.key === 'Unidentified'),
        // so we have to block them here to prevent the further event propagation
        evt.stop();
      } else {
        // if char more than 1 character, might triggered by doPaste_(),
        // we only handle single-character here,
        // do nothing to let the event continue to propagate,
        // the further doInput_() will handle it
      }
    }
  };
  /** @internal */
  Timebox.prototype.doKeyDown_ = function (evt) {
    var inp = this.getInputNode();
    if (inp.disabled || inp.readOnly) return;
    // control input keys only when no custom unformater is given
    if (!Timebox_1._unformater) {
      var code = evt.keyCode;
      switch (code) {
        case 48:
        case 96: //0
        case 49:
        case 97: //1
        case 50:
        case 98: //2
        case 51:
        case 99: //3
        case 52:
        case 100: //4
        case 53:
        case 101: //5
        case 54:
        case 102: //6
        case 55:
        case 103: //7
        case 56:
        case 104: //8
        case 57:
        case 105:
          //9
          // should handle all the number input value at _doBeforeInput()
          break;
        case 229:
          // ZK-4861, android only IME issue
          // 229 (evt.key === 'Unidentified') means the input value is not ready yet, so we should continue the event propagation,
          // we'll get the actual input value and handle it in _doBeforeInput()
          break;
        case 35:
          //end
          this.lastPos = inp.value.length;
          return;
        case 36:
          //home
          this.lastPos = 0;
          return;
        case 37:
          //left
          if (this.lastPos > 0) this.lastPos--;
          return;
        case 39:
          //right
          if (this.lastPos < inp.value.length) this.lastPos++;
          return;
        case 38:
          //up
          this._doUp();
          evt.stop();
          return;
        case 40:
          //down
          this._doDown();
          evt.stop();
          return;
        case 46:
          //del
          this._doDel();
          evt.stop();
          return;
        case 8:
          //backspace
          this._doBack();
          evt.stop();
          return;
        case 9:
          // do nothing
          break;
        case 13:
        case 27:
          //enter,esc,tab
          break;
        default:
          if (!(code >= 112 && code <= 123) //F1-F12
          && !evt.ctrlKey && !evt.metaKey && !evt.altKey) {
            if (evt.shiftKey && code == 45) break; // Allow macOS paste (shift + insert)
            evt.stop();
          }
      }
    }
    _super.prototype.doKeyDown_.call(this, evt);
  };
  /** @internal */
  Timebox.prototype.doPaste_ = function (evt) {
    this._updateChanged();
    _super.prototype.doPaste_.call(this, evt);
  };
  /** @internal */
  Timebox.prototype._updateChanged = function () {
    var inp = this.getInputNode(),
      self = this,
      curVal = inp.value;
    setTimeout(function () {
      var inpNode = self.getInputNode();
      if (inpNode) {
        if (curVal != inpNode.value) {
          self._changed = true;
        }
      }
    }, 0);
  };
  /** @internal */
  Timebox.prototype._ondropbtnup = function (evt) {
    this.domUnlisten_(document.body, 'onZMouseup', '_ondropbtnup');
    this._stopAutoIncProc();
    this._currentbtn = undefined;
  };
  /** @internal */
  Timebox.prototype._btnDown = function (evt) {
    if (!this._buttonVisible || this._disabled) return;
    // cache it for IE and others to keep the same position at the first time being clicked.
    this._lastPos = this._getPos();
    var btn = this.$n('btn'),
      inp = this.getInputNode();
    if (!zk.dragging) {
      if (this._currentbtn)
        // just in case
        this._ondropbtnup(evt);
      this.domListen_(document.body, 'onZMouseup', '_ondropbtnup');
      this._currentbtn = btn;
    }
    // if btn down before blur, needs to convert to real time string first
    if (inp.value && Timebox_1._unformater) inp.value = this.coerceToString_(this.coerceFromString_(inp.value));
    if (!inp.value) inp.value = this.coerceToString_();
    var ofs = zk(btn).revisedOffset(),
      isOverUpBtn = evt.pageY - ofs[1] < btn.offsetHeight / 2;
    if (zk.webkit) {
      zk(inp).focus(); //Bug ZK-1527: chrome and safari will trigger focus if executing setSelectionRange, focus it early here
    }
    var newLastPos = this._getPos();
    // Chrome and Firefox get wrong position at initial case
    if (this._lastPos != newLastPos) zk(inp).setSelectionRange(this._lastPos);
    if (isOverUpBtn) {
      //up
      this._doUp();
      this._startAutoIncProc(true);
    } else {
      this._doDown();
      this._startAutoIncProc(false);
    }
    this._changed = true;
    delete this._shortcut;
    zk.Widget.mimicMouseDown_(this); //set zk.currentFocus
    zk(inp).focus(); //we have to set it here; otherwise, if it is in popup of
    //datebox, datebox's onblur will find zk.currentFocus is null
    // disable browser's text selection
    evt.stop();
  };
  /** @internal */
  Timebox.prototype._btnUp = function (evt) {
    if (!this._buttonVisible || this._disabled || zk.dragging) return;
    if (zk.opera) zk(this.getInputNode()).focus();
    //unfortunately, in opera, it won't gain focus if we set in _btnDown
    this._onChanging();
    this._stopAutoIncProc();
    if (zk.webkit && this._lastPos) zk(this.getInputNode()).setSelectionRange(this._lastPos, this._lastPos);
  };
  /** @internal */
  Timebox.prototype._getPos = function () {
    return zk(this.getInputNode()).getSelectionRange()[0];
  };
  /** @internal */
  Timebox.prototype._doCheckPos = function () {
    this.lastPos = this._getPos();
  };
  /** @internal */
  Timebox.prototype._doUp = function () {
    this._changed = true;
    this.getTimeHandler().increase(this, 1);
    this._onChanging();
  };
  /** @internal */
  Timebox.prototype._doDown = function () {
    this._changed = true;
    this.getTimeHandler().increase(this, -1);
    this._onChanging();
  };
  /** @internal */
  Timebox.prototype._doBack = function () {
    this._changed = true;
    this.getTimeHandler().deleteTime(this, true);
  };
  /** @internal */
  Timebox.prototype._doDel = function () {
    this._changed = true;
    this.getTimeHandler().deleteTime(this, false);
  };
  /** @internal */
  Timebox.prototype._doType = function (val) {
    this._changed = true;
    this.getTimeHandler().addTime(this, val);
  };
  Timebox.prototype.getTimeHandler = function () {
    var sr = zk(this.getInputNode()).getSelectionRange(),
      start = sr[0],
      end = sr[1],
      //don't use [0] as the end variable, it may have a bug when the format is aHH:mm:ss
      //when use UP/Down key to change the time
      hdler;
    // Bug ZK-434
    for (var i = 0, f = this._fmthdler, l = f.length; i < l; i++) {
      if (!f[i].type) continue;
      if (f[i].index[0] <= start) {
        hdler = f[i];
        if (f[i].index[1] + 1 >= end) return f[i];
      }
    }
    return hdler || this._fmthdler[0];
  };
  Timebox.prototype.getNextTimeHandler = function (th) {
    var f = this._fmthdler,
      index = f.$indexOf(th),
      lastHandler;
    while ((lastHandler = f[++index]) && (!lastHandler.type || lastHandler.type == AM_PM_FIELD));
    return lastHandler;
  };
  /** @internal */
  Timebox.prototype._startAutoIncProc = function (up) {
    if (this.timerId) clearInterval(this.timerId);
    var self = this,
      fn = up ? '_doUp' : '_doDown';
    this.timerId = setInterval(function () {
      if (zk.webkit && self._lastPos) zk(self.getInputNode()).setSelectionRange(self._lastPos, self._lastPos);
      self[fn]();
    }, 300);
    jq(this.$n('btn-' + (up ? 'up' : 'down'))).addClass(this.$s('active'));
  };
  /** @internal */
  Timebox.prototype._stopAutoIncProc = function () {
    if (this.timerId) clearTimeout(this.timerId);
    // this.currentStep = this.defaultStep; // FIXME: both properties are not initialized
    this.timerId = undefined;
    jq('.' + this.$s('icon'), this.$n('btn')).removeClass(this.$s('active'));
  };
  /** @internal */
  Timebox.prototype.doFocus_ = function (evt) {
    _super.prototype.doFocus_.call(this, evt);
    var inp = this.getInputNode(),
      selrng = zk(inp).getSelectionRange();
    if (!inp.value) inp.value = Timebox_1._unformater ? '' : this.coerceToString_();
    this._doCheckPos();
    // Bug 2688620
    if (selrng[0] !== selrng[1]) {
      zk(inp).setSelectionRange(selrng[0], selrng[1]);
      this.lastPos = selrng[1];
    }
    zul.inp.RoundUtl.doFocus_(this);
  };
  /** @internal */
  Timebox.prototype.doBlur_ = function (evt) {
    // skip onchange, Bug 2936568
    if (!this._value && !this._changed && !Timebox_1._unformater) this.getInputNode().value = this._defRawVal = '';
    _super.prototype.doBlur_.call(this, evt);
    zul.inp.RoundUtl.doBlur_(this);
  };
  /** @internal */
  Timebox.prototype.afterKeyDown_ = function (evt, simulated) {
    if (!simulated && this._inplace) jq(this.$n_()).toggleClass(this.getInplaceCSS(), evt.keyCode == 13);
    return _super.prototype.afterKeyDown_.call(this, evt, simulated);
  };
  /** @internal */
  Timebox.prototype.bind_ = function (desktop, skipper, after) {
    _super.prototype.bind_.call(this, desktop, skipper, after);
    var btn;
    this.domListen_(this.getInputNode(), 'onBeforeInput', '_doBeforeInput');
    if (btn = this.$n('btn')) this.domListen_(btn, 'onZMouseDown', '_btnDown').domListen_(btn, 'onZMouseUp', '_btnUp');
    zWatch.listen({
      onSize: this
    });
  };
  /** @internal */
  Timebox.prototype.unbind_ = function (skipper, after, keepRod) {
    if (this.timerId) {
      clearTimeout(this.timerId);
      this.timerId = undefined;
    }
    zWatch.unlisten({
      onSize: this
    });
    var btn = this.$n('btn');
    if (btn) {
      this.domUnlisten_(btn, 'onZMouseDown', '_btnDown').domUnlisten_(btn, 'onZMouseUp', '_btnUp');
    }
    this.domUnlisten_(this.getInputNode(), 'onBeforeInput', '_doBeforeInput');
    this._changed = false;
    _super.prototype.unbind_.call(this, skipper, after, keepRod);
  };
  /** @internal */
  Timebox.prototype.getBtnUpIconClass_ = function () {
    return 'z-icon-angle-up';
  };
  /** @internal */
  Timebox.prototype.getBtnDownIconClass_ = function () {
    return 'z-icon-angle-down';
  };
  /** @internal */
  Timebox._updFormat = function (wgt, fmt) {
    var index = [],
      APM = wgt._localizedSymbols ? wgt._localizedSymbols.APM : zk.APM;
    for (var i = 0, l = fmt.length; i < l; i++) {
      var c = fmt.charAt(i);
      switch (c) {
        case 'a':
          var len = APM[0].length;
          index.push(new zul.inp.AMPMHandler([i, i + len - 1], AM_PM_FIELD, wgt));
          break;
        case 'K':
          var start = i,
            end = fmt.charAt(i + 1) == 'K' ? ++i : i;
          index.push(new zul.inp.HourHandler2([start, end], HOUR3_FIELD, wgt));
          break;
        case 'h':
          var start = i,
            end = fmt.charAt(i + 1) == 'h' ? ++i : i;
          index.push(new zul.inp.HourHandler([start, end], HOUR2_FIELD, wgt));
          break;
        case 'H':
          var start = i,
            end = fmt.charAt(i + 1) == 'H' ? ++i : i;
          index.push(new zul.inp.HourInDayHandler([start, end], HOUR0_FIELD, wgt));
          break;
        case 'k':
          var start = i,
            end = fmt.charAt(i + 1) == 'k' ? ++i : i;
          index.push(new zul.inp.HourInDayHandler2([start, end], HOUR1_FIELD, wgt));
          break;
        case 'm':
          var start = i,
            end = fmt.charAt(i + 1) == 'm' ? ++i : i;
          index.push(new zul.inp.MinuteHandler([start, end], MINUTE_FIELD, wgt));
          break;
        case 's':
          var start = i,
            end = fmt.charAt(i + 1) == 's' ? ++i : i;
          index.push(new zul.inp.SecondHandler([start, end], SECOND_FIELD, wgt));
          break;
        case 'z':
          index.push({
            index: [i, i],
            format: function (text) {
              return function () {
                return text;
              };
            }(wgt._timezoneAbbr)
          });
          break;
        default:
          var ary = '',
            start = i,
            end = i;
          while ((ary += c) && ++end < l) {
            c = fmt.charAt(end);
            if (LEGAL_CHARS.includes(c)) {
              end--;
              break;
            }
          }
          index.push({
            index: [start, end],
            format: function (text) {
              return function () {
                return text;
              };
            }(ary)
          });
          i = end;
      }
    }
    for (var shift, i = 0, l = index.length; i < l; i++) {
      if (index[i].type == AM_PM_FIELD) {
        shift = index[i].index[1] - index[i].index[0];
        if (!shift) break; // no need to shift.
      } else if (shift) {
        index[i].index[0] += shift;
        index[i].index[1] += shift;
      }
    }
    wgt._fmthdler = index;
  };
  /** @internal */
  Timebox._shouldObeyCount = function (nextType) {
    switch (nextType) {
      case MINUTE_FIELD:
      case SECOND_FIELD:
      case HOUR0_FIELD:
      case HOUR1_FIELD:
      case HOUR2_FIELD:
      case HOUR3_FIELD:
        return true;
      default:
        return false;
    }
  };
  var Timebox_1;
  Timebox = Timebox_1 = __decorate([zk.WrapClass('zul.db.Timebox')], Timebox);
  return Timebox;
}(zul.inp.FormatWidget);
exports.Timebox = Timebox;
var TimeHandler = /** @class */function (_super) {
  __extends(TimeHandler, _super);
  function TimeHandler(index, type, wgt) {
    var _this = _super.call(this) || this;
    _this.maxsize = 59;
    _this.minsize = 0;
    _this.digits = 2;
    _this.index = index;
    _this.type = type;
    if (index[0] == index[1]) _this.digits = 1;
    _this.wgt = wgt;
    return _this;
  }
  TimeHandler_1 = TimeHandler;
  TimeHandler.prototype.format = function (date) {
    return '00';
  };
  TimeHandler.prototype.unformat = function (date, val, opt) {
    return date;
  };
  TimeHandler.prototype.increase = function (wgt, up) {
    var inp = wgt.getInputNode(),
      start = this.index[0],
      end = this.index[1] + 1,
      val = inp.value,
      text = this.getText(val),
      singleLen = this.isSingleLength() !== false,
      ofs;
    text = zk.parseInt(singleLen ? text : text.replace(/ /g, '0')) + up;
    var max = this.maxsize + 1;
    if (text < this.minsize) {
      text = this.maxsize;
      ofs = 1;
    } else if (text >= max) {
      text = this.minsize;
      ofs = -1;
    } else if (singleLen) ofs = up > 0 ? text == 10 ? 1 : 0 : text == 9 ? -1 : 0;
    if (text < 10 && !singleLen) text = '0' + text;
    inp.value = val.substring(0, start) + text + val.substring(end);
    if (singleLen && ofs) {
      this._doShift(wgt, ofs);
      end += ofs;
    }
    zk(inp).setSelectionRange(start, end);
  };
  TimeHandler.prototype.deleteTime = function (wgt, backspace) {
    var inp = wgt.getInputNode(),
      sel = zk(inp).getSelectionRange(),
      pos = sel[0],
      val = inp.value,
      maxLength = TimeHandler_1._getMaxLen(wgt);
    // clean over text
    if (val.length > maxLength) {
      val = inp.value = val.substr(0, maxLength);
      sel = [Math.min(sel[0], maxLength), Math.min(sel[1], maxLength)];
      pos = sel[0];
    }
    if (pos != sel[1]) {
      //select delete
      inp.value = val.substring(0, pos) + TimeHandler_1._cleanSelectionText(wgt, this) + val.substring(sel[1]);
    } else {
      var fmthdler = wgt._fmthdler,
        index = fmthdler.$indexOf(this),
        ofs = backspace ? -1 : 1,
        ofs2 = backspace ? 0 : 1,
        ofs3 = backspace ? 1 : 0,
        hdler,
        posOfs;
      if (pos == this.index[ofs2] + ofs2) {
        // on start or end
        //delete by sibling handler
        if (hdler = fmthdler[index + ofs * 2]) pos = hdler.index[ofs3] + ofs3 + ofs;
      } else {
        // delete self
        pos += ofs;
        hdler = this;
      }
      if (hdler) {
        posOfs = hdler.isSingleLength();
        inp.value = val.substring(0, (ofs3 += pos) - 1) + (posOfs ? '' : ' ') + val.substring(ofs3);
        if (posOfs) hdler._doShift(wgt, posOfs);
      }
      if (posOfs && !backspace) pos--;
    }
    zk(inp).setSelectionRange(pos, pos);
  };
  /** @internal */
  TimeHandler.prototype._addNextTime = function (wgt, num) {
    var inp = wgt.getInputNode(),
      index,
      NTH;
    if (NTH = wgt.getNextTimeHandler(this)) {
      index = NTH.index[0];
      zk(inp).setSelectionRange(index, Math.max(index, zk(inp).getSelectionRange()[1]));
      NTH.addTime(wgt, num);
    }
  };
  TimeHandler.prototype.addTime = function (wgt, num) {
    var inp = wgt.getInputNode(),
      sel = zk(inp).getSelectionRange(),
      val = inp.value,
      pos = sel[0],
      maxLength = TimeHandler_1._getMaxLen(wgt),
      posOfs = this.isSingleLength();
    // clean over text
    if (val.length > maxLength) {
      val = inp.value = val.substr(0, maxLength);
      sel = [Math.min(sel[0], maxLength), Math.min(sel[1], maxLength)];
      pos = sel[0];
    }
    if (pos == maxLength) return;
    // first number (hendle max bound)
    if (pos == this.index[0]) {
      var text = this.getText(val).substring(posOfs === 0 ? 0 : 2).trim(),
        i;
      if (!text.length) text = '0';
      if ((i = zk.parseInt(num + text)) > this.maxsize) {
        if (posOfs !== 0) {
          val = inp.value = val.substring(0, pos) + (posOfs ? '0' : '00') + val.substring(pos + 2);
          if (!posOfs) pos++;
          zk(inp).setSelectionRange(pos, Math.max(sel[1], pos));
          sel = zk(inp).getSelectionRange();
        }
        if (posOfs) this._doShift(wgt, posOfs);
      }
    } else if (pos == this.index[1] + 1) {
      //end of handler
      var i;
      if (posOfs !== false) {
        var text = this.getText(val);
        if ((i = zk.parseInt(text + num)) <= this.maxsize) {
          //allow add number
          if (i && i < 10)
            // 1-9
            pos--;else if (i || posOfs) {
            // 0 or larger then 10, except zero and non-posOfs
            val = inp.value = val.substring(0, pos + posOfs) + (posOfs ? '' : '0') + val.substring(pos);
            if (i)
              // larger then 10
              this._doShift(wgt, 1);else {
              // 0
              zk(inp).setSelectionRange(pos, Math.max(sel[1], pos));
              if (posOfs)
                //2 digits zero
                this._doShift(wgt, posOfs);
            }
          }
        }
      }
      if (!i || i > this.maxsize) {
        this._addNextTime(wgt, num);
        return;
      }
    }
    if (pos != sel[1]) {
      //select edit
      var s = TimeHandler_1._cleanSelectionText(wgt, this),
        ofs;
      //in middle position
      if (posOfs !== false && (ofs = pos - this.index[1])) this._doShift(wgt, ofs);
      inp.value = val.substring(0, pos++) + num + s.substring(ofs ? 0 : 1) + val.substring(sel[1]);
    } else {
      inp.value = val.substring(0, pos) + num + val.substring(++pos);
    }
    wgt.lastPos = pos;
    zk(inp).setSelectionRange(pos, pos);
  };
  TimeHandler.prototype.getText = function (val, obeyCount) {
    var start = this.index[0],
      end = this.index[1] + 1;
    return obeyCount !== false ? val.substring(start, end) : val.substring(start);
  };
  /** @internal */
  TimeHandler.prototype._doShift = function (wgt, shift) {
    var f = wgt._fmthdler,
      index = f.$indexOf(this),
      NTH;
    this.index[1] += shift;
    while (NTH = f[++index]) {
      NTH.index[0] += shift;
      NTH.index[1] += shift;
    }
  };
  TimeHandler.prototype.isSingleLength = function () {
    return this.digits == 1 && this.index[0] - this.index[1];
  };
  TimeHandler.prototype.parse = function (val, opt) {
    var text = this.getText(val, opt.obeyCount),
      parsed = /^\s*\d*/.exec(text),
      offset = parsed.length ? parsed[0].length - (this.index[1] - this.index[0] + 1) : 0;
    if (offset) {
      this._doShift(this.wgt, offset);
    }
    return zk.parseInt(text);
  };
  /** @internal */
  TimeHandler._getMaxLen = function (wgt) {
    var val = wgt.getInputNode().value,
      len = 0,
      th,
      lastTh;
    for (var i = 0, f = wgt._fmthdler, l = f.length; i < l; i++) {
      th = f[i];
      if (i == l - 1) {
        len += th.format().length;
      } else len += (th.type ? th.getText(val) : th.format()).length;
      if (th.type) lastTh = th;
    }
    return lastTh.digits == 1 ? ++len : len;
  };
  /** @internal */
  TimeHandler._cleanSelectionText = function (wgt, startHandler) {
    var inp = wgt.getInputNode(),
      sel = zk(inp).getSelectionRange(),
      pos = sel[0],
      selEnd = sel[1],
      fmthdler = wgt._fmthdler,
      index = fmthdler.$indexOf(startHandler),
      text = '',
      hdler = startHandler,
      isFirst = true,
      prevStart,
      ofs,
      hStart,
      hEnd,
      posOfs;
    //restore separator
    do {
      hStart = hdler.index[0];
      hEnd = hdler.index[1] + 1;
      if (hdler.type && (posOfs = hdler.isSingleLength())) {
        //sync handler index
        hdler._doShift(wgt, posOfs);
        selEnd--;
      }
      //latest one
      if (hEnd >= selEnd && hdler.type) {
        ofs = selEnd - hStart;
        while (ofs-- > 0)
        //replace by space (after)
        text += ' ';
        break;
      }
      if (hdler.type) {
        prevStart = isFirst ? pos : hStart;
        isFirst = false;
        continue;
      }
      ofs = hStart - prevStart;
      while (ofs-- > 0)
      //replace by space (before)
      text += ' ';
      text += hdler.format();
    } while (hdler = fmthdler[++index]);
    return text;
  };
  var TimeHandler_1;
  TimeHandler = TimeHandler_1 = __decorate([zk.WrapClass('zul.inp.TimeHandler')], TimeHandler);
  return TimeHandler;
}(zk.Object);
exports.TimeHandler = TimeHandler;
var HourInDayHandler = /** @class */function (_super) {
  __extends(HourInDayHandler, _super);
  function HourInDayHandler() {
    var _this = _super !== null && _super.apply(this, arguments) || this;
    _this.maxsize = 23;
    _this.minsize = 0;
    return _this;
  }
  HourInDayHandler.prototype.format = function (date) {
    var singleLen = this.digits == 1;
    if (!date) return singleLen ? '0' : '00';else {
      var h = date.getHours();
      if (!singleLen && h < 10) h = '0' + h;
      return h.toString();
    }
  };
  HourInDayHandler.prototype.unformat = function (date, val, opt) {
    date.setHours(this.parse(val, opt));
    return date;
  };
  HourInDayHandler = __decorate([zk.WrapClass('zul.inp.HourInDayHandler')], HourInDayHandler);
  return HourInDayHandler;
}(zul.inp.TimeHandler);
exports.HourInDayHandler = HourInDayHandler;
var HourInDayHandler2 = /** @class */function (_super) {
  __extends(HourInDayHandler2, _super);
  function HourInDayHandler2() {
    var _this = _super !== null && _super.apply(this, arguments) || this;
    _this.maxsize = 24;
    _this.minsize = 1;
    return _this;
  }
  HourInDayHandler2.prototype.format = function (date) {
    if (!date) return '24';else {
      var h = date.getHours();
      if (h == 0) h = '24';else if (this.digits == 2 && h < 10) h = '0' + h;
      return h.toString();
    }
  };
  HourInDayHandler2.prototype.unformat = function (date, val, opt) {
    var hours = this.parse(val, opt);
    if (hours >= this.maxsize) hours = 0;
    date.setHours(hours);
    return date;
  };
  HourInDayHandler2 = __decorate([zk.WrapClass('zul.inp.HourInDayHandler2')], HourInDayHandler2);
  return HourInDayHandler2;
}(zul.inp.TimeHandler);
exports.HourInDayHandler2 = HourInDayHandler2;
var HourHandler = /** @class */function (_super) {
  __extends(HourHandler, _super);
  function HourHandler() {
    var _this = _super !== null && _super.apply(this, arguments) || this;
    _this.maxsize = 12;
    _this.minsize = 1;
    return _this;
  }
  HourHandler.prototype.format = function (date) {
    if (!date) return '12';else {
      var h = date.getHours();
      h = h % 12;
      if (h == 0) h = '12';else if (this.digits == 2 && h < 10) h = '0' + h;
      return h.toString();
    }
  };
  HourHandler.prototype.unformat = function (date, val, opt) {
    var hours = this.parse(val, opt);
    if (hours >= this.maxsize) hours = 0;
    date.setHours(opt.am ? hours : hours + 12);
    return date;
  };
  HourHandler = __decorate([zk.WrapClass('zul.inp.HourHandler')], HourHandler);
  return HourHandler;
}(zul.inp.TimeHandler);
exports.HourHandler = HourHandler;
var HourHandler2 = /** @class */function (_super) {
  __extends(HourHandler2, _super);
  function HourHandler2() {
    var _this = _super !== null && _super.apply(this, arguments) || this;
    _this.maxsize = 11;
    _this.minsize = 0;
    return _this;
  }
  HourHandler2.prototype.format = function (date) {
    var singleLen = this.digits == 1;
    if (!date) return singleLen ? '0' : '00';else {
      var h = date.getHours();
      h = h % 12;
      if (!singleLen && h < 10) h = '0' + h;
      return h.toString();
    }
  };
  HourHandler2.prototype.unformat = function (date, val, opt) {
    var hours = this.parse(val, opt);
    date.setHours(opt.am ? hours : hours + 12);
    return date;
  };
  HourHandler2 = __decorate([zk.WrapClass('zul.inp.HourHandler2')], HourHandler2);
  return HourHandler2;
}(zul.inp.TimeHandler);
exports.HourHandler2 = HourHandler2;
var MinuteHandler = /** @class */function (_super) {
  __extends(MinuteHandler, _super);
  function MinuteHandler() {
    return _super !== null && _super.apply(this, arguments) || this;
  }
  MinuteHandler.prototype.format = function (date) {
    var singleLen = this.digits == 1;
    if (!date) return singleLen ? '0' : '00';else {
      var m = date.getMinutes();
      if (!singleLen && m < 10) m = '0' + m;
      return m.toString();
    }
  };
  MinuteHandler.prototype.unformat = function (date, val, opt) {
    date.setMinutes(this.parse(val, opt));
    return date;
  };
  MinuteHandler = __decorate([zk.WrapClass('zul.inp.MinuteHandler')], MinuteHandler);
  return MinuteHandler;
}(zul.inp.TimeHandler);
exports.MinuteHandler = MinuteHandler;
var SecondHandler = /** @class */function (_super) {
  __extends(SecondHandler, _super);
  function SecondHandler() {
    return _super !== null && _super.apply(this, arguments) || this;
  }
  SecondHandler.prototype.format = function (date) {
    var singleLen = this.digits == 1;
    if (!date) return singleLen ? '0' : '00';else {
      var s = date.getSeconds();
      if (!singleLen && s < 10) s = '0' + s;
      return s.toString();
    }
  };
  SecondHandler.prototype.unformat = function (date, val, opt) {
    date.setSeconds(this.parse(val, opt));
    return date;
  };
  SecondHandler = __decorate([zk.WrapClass('zul.inp.SecondHandler')], SecondHandler);
  return SecondHandler;
}(zul.inp.TimeHandler);
exports.SecondHandler = SecondHandler;
var AMPMHandler = /** @class */function (_super) {
  __extends(AMPMHandler, _super);
  function AMPMHandler() {
    return _super !== null && _super.apply(this, arguments) || this;
  }
  AMPMHandler.prototype.format = function (date) {
    var APM = this.wgt._localizedSymbols ? this.wgt._localizedSymbols.APM : zk.APM;
    if (!date) return APM[0];
    var h = date.getHours();
    return APM[h < 12 ? 0 : 1];
  };
  AMPMHandler.prototype.unformat = function (date, val, opt) {
    var text = this.getText(val).trim(),
      APM = this.wgt._localizedSymbols ? this.wgt._localizedSymbols.APM : zk.APM;
    return text.length == APM[0].length ? APM[0] == text : true;
  };
  AMPMHandler.prototype.addTime = function (wgt, num) {
    var inp = wgt.getInputNode(),
      start = this.index[0],
      end = this.index[1] + 1,
      val = inp.value,
      text = val.substring(start, end),
      APM = wgt._localizedSymbols ? wgt._localizedSymbols.APM : zk.APM;
    //restore A/PM text
    if (text != APM[0] && text != APM[1]) {
      text = APM[0];
      inp.value = val.substring(0, start) + text + val.substring(end);
    }
    this._addNextTime(wgt, num);
  };
  // Bug ZK-434, we have to delete a sets of "AM/PM", rather than a single word "A/P/M"
  AMPMHandler.prototype.deleteTime = function (wgt, backspace) {
    var inp = wgt.getInputNode(),
      sel = zk(inp).getSelectionRange(),
      pos = sel[0],
      pos1 = sel[1],
      start = this.index[0],
      end = this.index[1] + 1,
      val = inp.value;
    if (pos1 - pos > end - start) return _super.prototype.deleteTime.call(this, wgt, backspace);
    var t = [''];
    for (var i = end - start; i > 0; i--) t.push(' ');
    inp.value = val.substring(0, start) + t.join('') + val.substring(end);
    zk(inp).setSelectionRange(start, start);
  };
  AMPMHandler.prototype.increase = function (wgt, up) {
    var inp = wgt.getInputNode(),
      start = this.index[0],
      end = this.index[1] + 1,
      val = inp.value,
      text = val.substring(start, end),
      APM = wgt._localizedSymbols ? wgt._localizedSymbols.APM : zk.APM;
    text = APM[0] == text ? APM[1] : APM[0];
    inp.value = val.substring(0, start) + text + val.substring(end);
    zk(inp).setSelectionRange(start, end);
  };
  AMPMHandler.prototype.parse = function (val, opt) {
    return zk.parseInt(this.getText(val).trim());
  };
  AMPMHandler = __decorate([zk.WrapClass('zul.inp.AMPMHandler')], AMPMHandler);
  return AMPMHandler;
}(zul.inp.TimeHandler);
exports.AMPMHandler = AMPMHandler;
window.zul.db.Timebox_.LEGAL_CHARS = LEGAL_CHARS;
window.zul.db.Timebox_.MINUTE_FIELD = MINUTE_FIELD;
window.zul.db.Timebox_.SECOND_FIELD = SECOND_FIELD;
window.zul.db.Timebox_.AM_PM_FIELD = AM_PM_FIELD;
window.zul.db.Timebox_.HOUR0_FIELD = HOUR0_FIELD;
window.zul.db.Timebox_.HOUR1_FIELD = HOUR1_FIELD;
window.zul.db.Timebox_.HOUR2_FIELD = HOUR2_FIELD;
window.zul.db.Timebox_.HOUR3_FIELD = HOUR3_FIELD;
window.zul.db.Timebox_.globallocalizedSymbols = globallocalizedSymbols;
window.zul.db.Timebox_.Timebox = Timebox;
window.zul.db.Timebox_.TimeHandler = TimeHandler;
window.zul.db.Timebox_.HourInDayHandler = HourInDayHandler;
window.zul.db.Timebox_.HourInDayHandler2 = HourInDayHandler2;
window.zul.db.Timebox_.HourHandler = HourHandler;
window.zul.db.Timebox_.HourHandler2 = HourHandler2;
window.zul.db.Timebox_.MinuteHandler = MinuteHandler;
window.zul.db.Timebox_.SecondHandler = SecondHandler;
window.zul.db.Timebox_.AMPMHandler = AMPMHandler;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/db/datefmt.ts":
/*!*********************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/db/datefmt.ts ***!
  \*********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


/* datefmt.ts

    Purpose:

    Description:

    History:
        Fri Jan 16 19:13:43	 2009, Created by Flyworld

Copyright (C) 2008 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
if (!window.zul) window.zul = {};
if (!window.zul.db) window.zul.db = {};
if (!window.zul.db.datefmt_) window.zul.db.datefmt_ = {};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Calendar = exports.Date = void 0;
// ZK-5615: Rewrite _parseTextToArray() and add method _buildTrie(), _isLetter() since ZK 10.2
window.zul.db.datefmt_._parseTextToArray = function (txt, fmt) {
  //trim the whitespace if exist in String (ex. txt pass from constraint)
  txt = txt.trim();
  //java Class SimpleDateFormat Date and time formats.
  var formatTokens = new Set(['G', 'y', 'Y', 'M', 'w', 'L', 'W', 'D', 'd', 'F', 'E', 'u', 'a', 'H', 'k', 'K', 'h', 'm', 's', 'S', 'z', 'Z', 'X']),
    //Remove duplicates
    allSeparators = new Set();
  var i = 0;
  while (i < fmt.length) {
    // Handle separators that are wrapped in quotes
    if (fmt[i] === '\'') {
      i++; // skip opening quote
      var literal = '';
      while (i < fmt.length && fmt[i] !== '\'') {
        literal += fmt[i];
        i++;
      }
      i++; // skip closing quote
      if (literal) {
        allSeparators.add(literal);
      }
    } else {
      // Handle single-word separators
      var char = fmt[i];
      if (!formatTokens.has(char)) {
        allSeparators.add(char);
      }
      i++;
    }
  }
  var trie = window.zul.db.datefmt_._buildTrie(Array.from(allSeparators)),
    result = [];
  var current = '';
  i = 0;
  while (i < txt.length) {
    var node = trie,
      j = i,
      char = txt.charAt(j);
    while (j < txt.length && node.children && node.children[char]) {
      node = node.children[char];
      j++;
      char = txt.charAt(j);
      if (node.isEnd && !node.children) {
        break;
      }
    }
    if (node.isEnd) {
      // For cases like '30 de dezembro de 2024 18:42:39' in the pt locale
      // Check if there is a letter before or after the separator, meaning it's part of a word and not an actual separator
      var isValidSeparator = true;
      if (node.isMultiCharSeparator) {
        var prevChar = txt[i - 1],
          nextChar = txt[j];
        if (window.zul.db.datefmt_._isLetter(prevChar) || window.zul.db.datefmt_._isLetter(nextChar)) {
          isValidSeparator = false;
        }
      }
      if (isValidSeparator) {
        if (current !== '') {
          result.push(current);
          current = '';
        }
        i = j;
        continue;
      }
    }
    current += txt[i];
    i++;
  }
  if (current !== '') {
    result.push(current);
  }
  return result;
};
/** @internal */
window.zul.db.datefmt_._isLetter = function (char) {
  // Supports both standard Latin letters (a-z, A-Z) and extended Latin characters (e.g., à, é, ç).
  return !!char && /[a-zA-Z\u00C0-\u017F]/.test(char);
};
/** @internal */
window.zul.db.datefmt_._buildTrie = function (separators) {
  var root = {};
  for (var _i = 0, separators_1 = separators; _i < separators_1.length; _i++) {
    var sep = separators_1[_i];
    var node = root;
    for (var _a = 0, sep_1 = sep; _a < sep_1.length; _a++) {
      var char = sep_1[_a];
      if (!node.children) node.children = {};
      if (!node.children[char]) {
        node.children[char] = {};
      }
      node = node.children[char];
    }
    node.isEnd = true;
    node.isMultiCharSeparator = sep.length > 1;
  }
  return root;
};
window.zul.db.datefmt_._parseToken = function (token, ts, i, len) {
  if (len < 2) len = 2;
  if (token && token.length > len) {
    ts[i] = token.substring(len);
    return token.substring(0, len);
  }
  return token;
};
window.zul.db.datefmt_._parseInt = function (v) {
  return parseInt(v, 10);
};
window.zul.db.datefmt_._digitFixed = function (val, digits) {
  var s = String(val);
  for (var j = digits - s.length; --j >= 0;) s = '0' + s;
  return s;
};
window.zul.db.datefmt_._dayInYear = function (d, ref) {
  return Math.round((+Dates.newInstance([d.getFullYear(), d.getMonth(), d.getDate()], d.getTimeZone()) - +ref) / 864e5);
}; // Converts milli-second to day.
//	function _ms2day(t) {
//		return Math.round(t / 86400000);
//	}
// Day in year (starting at 1).
window.zul.db.datefmt_.dayInYear = function (d) {
  var ref = Dates.newInstance([d.getFullYear(), 0, 1], d.getTimeZone());
  return window.zul.db.datefmt_._digitFixed(1 + window.zul.db.datefmt_._dayInYear(d, ref));
}; //Day in month (starting at 1).
window.zul.db.datefmt_.dayInMonth = function (d) {
  return d.getDate();
}; //Week in month (starting at 1).
window.zul.db.datefmt_.weekInMonth = function (d, firstDayOfWeek) {
  var ref = Dates.newInstance([d.getFullYear(), d.getMonth(), 1], d.getTimeZone()),
    day = ref.getDay(),
    shift = (firstDayOfWeek > day ? day + 7 : day) - firstDayOfWeek;
  return window.zul.db.datefmt_._digitFixed(1 + Math.floor((window.zul.db.datefmt_._dayInYear(d, ref) + shift) / 7));
}; //Day of week in month.
window.zul.db.datefmt_.dayOfWeekInMonth = function (d) {
  var ref = Dates.newInstance([d.getFullYear(), d.getMonth(), 1], d.getTimeZone());
  return window.zul.db.datefmt_._digitFixed(1 + Math.floor(window.zul.db.datefmt_._dayInYear(d, ref) / 7));
}; // a proxy of Date object for leap day on Thai locale - B60-ZK-1010
var LeapDay = /** @class */function (_super) {
  __extends(LeapDay, _super);
  function LeapDay(y, m, d, hr, min, sec, msec, tz) {
    var _this = _super.call(this) || this;
    if (arguments.length > 1) {
      _this._date = Dates.newInstance([y, m, d, hr, min, sec, msec], tz);
    } else _this._date = y;
    return _this;
  }
  // eslint-disable-next-line zk/javaStyleSetterSignature
  LeapDay.prototype.setOffset = function (offset) {
    this._offset = offset;
  };
  // eslint-disable-next-line zk/javaStyleSetterSignature
  LeapDay.prototype.setFullYear = function (fullYear) {
    // no need to subtract the._offset, the caller will handle
    this._date.setFullYear(fullYear);
  };
  LeapDay.prototype.getFullYear = function () {
    return this._date.getFullYear() + (this._offset || 0);
  };
  LeapDay.prototype.getDate = function () {
    return this._date.getDate();
  };
  // eslint-disable-next-line zk/javaStyleSetterSignature
  LeapDay.prototype.setDate = function (date) {
    this._date.setDate(date);
  };
  LeapDay.prototype.getDay = function () {
    return this._date.getDay();
  };
  LeapDay.prototype.getMonth = function () {
    return this._date.getMonth();
  };
  // eslint-disable-next-line zk/javaStyleSetterSignature
  LeapDay.prototype.setMonth = function (month) {
    this._date.setMonth(month);
  };
  LeapDay.prototype.getHours = function () {
    return this._date.getHours();
  };
  // eslint-disable-next-line zk/javaStyleSetterSignature
  LeapDay.prototype.setHours = function (hours) {
    this._date.setHours(hours);
  };
  LeapDay.prototype.getMinutes = function () {
    return this._date.getMinutes();
  };
  // eslint-disable-next-line zk/javaStyleSetterSignature
  LeapDay.prototype.setMinutes = function (minutes) {
    this._date.setMinutes(minutes);
  };
  LeapDay.prototype.getSeconds = function () {
    return this._date.getSeconds();
  };
  // eslint-disable-next-line zk/javaStyleSetterSignature
  LeapDay.prototype.setSeconds = function (seconds) {
    this._date.setSeconds(seconds);
  };
  LeapDay.prototype.getMilliseconds = function () {
    return this._date.getMilliseconds();
  };
  // eslint-disable-next-line zk/javaStyleSetterSignature
  LeapDay.prototype.setMilliseconds = function (milliseconds) {
    this._date.setMilliseconds(milliseconds);
  };
  LeapDay.prototype.getTimezoneOffset = function () {
    return this._date.getTimezoneOffset();
  };
  LeapDay.prototype.getRealDate = function () {
    return this._date;
  };
  LeapDay.prototype.getTimeZone = function () {
    return this._date.getTimeZone();
  };
  LeapDay = __decorate([zk.WrapClass('zul.fmt.LeapDay')], LeapDay);
  return LeapDay;
}(zk.Object);
var DateFmt = {
  _isoDateTimeFormat: new Intl.DateTimeFormat('en-US', {
    year: 'numeric'
  }),
  // strictDate: No invalid date allowed (e.g., Jan 0 or Nov 31)
  // nonLenient: strictDate + inputs must match this object's format (no additional character allowed)
  parseDate: function (txt, fmt, nonLenient, refval, localizedSymbols, tz, strictDate) {
    if (!fmt) fmt = 'yyyy/MM/dd';
    refval !== null && refval !== void 0 ? refval : refval = zUtl.today(fmt, tz);
    localizedSymbols !== null && localizedSymbols !== void 0 ? localizedSymbols : localizedSymbols = {
      DOW_1ST: zk.DOW_1ST,
      MINDAYS: zk.MINDAYS,
      ERA: zk.ERA,
      YDELTA: zk.YDELTA,
      LAN_TAG: zk.LAN_TAG,
      SDOW: zk.SDOW,
      S2DOW: zk.S2DOW,
      FDOW: zk.FDOW,
      SMON: zk.SMON,
      S2MON: zk.S2MON,
      FMON: zk.FMON,
      APM: zk.APM
    };
    var y = refval.getFullYear(),
      m = refval.getMonth(),
      d = refval.getDate(),
      dFound,
      hr = refval.getHours(),
      min = refval.getMinutes(),
      sec = refval.getSeconds(),
      msec = refval.getMilliseconds(),
      aa = fmt.indexOf('a'),
      hasAM = aa > -1,
      hasG = fmt.includes('G'),
      hasHour1 = hasAM && (fmt.includes('h') || fmt.includes('K')),
      isAM,
      ts = window.zul.db.datefmt_._parseTextToArray(txt, fmt),
      regexp = /^\d+$/,
      // ZK-2026: Don't use isNaN(), it will treat float as number.
      isNumber = regexp.test(txt),
      eras = localizedSymbols.ERAS,
      era,
      eraKey;
    if (hasG && txt && eras) {
      // ZK-4745: parsing era for specific calendar system
      eraKey = this._findEraKey(txt, eras);
      if (eraKey) era = eras[eraKey];
    }
    fmt = fmt.replace(/'.*?'/g, ' '); //ZK-5475 remove any string enclosed by single quotes
    var refDate = refval._moment.toDate(),
      localeDateTimeFormat = new Intl.DateTimeFormat(localizedSymbols.LAN_TAG, {
        year: 'numeric'
      }),
      eraName = localizedSymbols.ERA || (eraKey ? eraKey : this.getEraName(refDate, localizedSymbols, localeDateTimeFormat)),
      ydelta = localizedSymbols.YDELTA || (era ? 0 - era.firstYear + era.direction * 1 : this.getYDelta(refDate, localeDateTimeFormat));
    if (!ts || !ts.length) return;
    for (var i = 0, j = 0, offs = 0, fl = fmt.length; j < fl; ++j) {
      var cc = fmt.charAt(j);
      if (cc >= 'a' && cc <= 'z' || cc >= 'A' && cc <= 'Z') {
        var len = 1,
          k;
        for (k = j; ++k < fl; ++len) if (fmt.charAt(k) != cc) break;
        var nosep, nv; //no separator
        if (k < fl) {
          var c2 = fmt.charAt(k);
          nosep = 'yuMdEmsShHkKaAG'.includes(c2);
        }
        var token = isNumber ? ts[0].substring(j - offs, k - offs) : ts[i++];
        switch (cc) {
          case 'u':
          case 'y':
            // ZK-1985: Determine if token's length is less than the expected when nonLenient is true.
            if (nonLenient && token && token.length < len) return;
            if (nosep) {
              if (len < 3) len = 2;
              if (token && token.length > len) {
                ts[--i] = token.substring(len);
                token = token.substring(0, len);
              }
            }
            // ZK-1985:	Determine if token contains non-digital word when nonLenient is true.
            if (nonLenient && token && !regexp.test(token)) return;
            if (!isNaN(nv = window.zul.db.datefmt_._parseInt(token))) {
              var newY = Math.min(nv, 200000); // Bug B50-3288904: js year limit
              if (ydelta === 0 && newY < 100) {
                // only handle twoDigitYearStart with ISO calendar for now
                // ZK-4235: Datefmt parseDate always return date between 1930-2029 when using yy format
                var twoDigitYearStart = zk.TDYS,
                  lowerBoundary = Math.floor(twoDigitYearStart / 100) * 100 + newY,
                  upperBoundary = lowerBoundary + 100;
                y = lowerBoundary >= twoDigitYearStart ? lowerBoundary : upperBoundary;
              } else {
                if (cc == 'y') {
                  if (era) newY = era.firstYear + era.direction * (newY - 1);else {
                    if (newY < 100 && newY === (y + ydelta) % 100) break; // assume yy is not modified
                    newY = y + ydelta > 0 ? newY - ydelta : 1 - newY - ydelta;
                  }
                }
                y = newY;
              }
            }
            break;
          case 'M':
            var mon = token ? token.toLowerCase() : '',
              isNumber0 = !isNaN(token) || len <= 2; // could be MM with nosep token
            if (!mon) break;
            if (!isNumber0 && token) {
              // MMM or MMMM
              var symbols;
              if (len == 3) symbols = localizedSymbols.SMON;else if (len == 4) symbols = localizedSymbols.FMON;else break;
              for (var index = symbols.length, brkswch; --index >= 0;) {
                var monStr = symbols[index].toLowerCase();
                if (nonLenient && mon == monStr || !nonLenient && mon.startsWith(monStr)) {
                  var monStrLen = monStr.length;
                  if (token && token.length > monStrLen) ts[--i] = token.substring(monStrLen);
                  m = index;
                  brkswch = true;
                  break; // shall break to switch level: B50-3314513
                }
              }
              if (brkswch) break;
            }
            if (len == 3 && token) {
              if (nosep) token = window.zul.db.datefmt_._parseToken(token, ts, --i, token.length); //token.length: the length of French month is 4
              if (isNaN(nv = window.zul.db.datefmt_._parseInt(token))) return; // failed, B50-3314513
              m = nv - 1;
            } else if (len <= 2) {
              if (nosep && token && token.length > 2) {
                //Bug 2560497 : if no separator, token must be assigned.
                ts[--i] = token.substring(2);
                token = token.substring(0, 2);
              }
              if (isNaN(nv = window.zul.db.datefmt_._parseInt(token))) return; // failed, B50-3314513
              m = nv - 1;
            } else {
              for (var l = 0;; ++l) {
                if (l == 12) return; //failed
                if (len == 3) {
                  if (localizedSymbols.SMON[l] == token) {
                    m = l;
                    break;
                  }
                } else {
                  if (token && localizedSymbols.FMON[l].startsWith(token)) {
                    m = l;
                    break;
                  }
                }
              }
            }
            if (m > 11 /*|| m < 0 accept 0 since it is a common-yet-acceptable error*/)
              //restrict since user might input year for month
              return; //failed
            break;
          case 'E':
            if (nosep) window.zul.db.datefmt_._parseToken(token, ts, --i, len);
            break;
          case 'd':
            // ZK-1985:	Determine if token's length is less than expected when nonLenient is true.
            if (nonLenient && token && token.length < len) return;
            if (nosep) token = window.zul.db.datefmt_._parseToken(token, ts, --i, len);
            // ZK-1985:	Determine if token contains non-digital word when nonLenient is true.
            if (nonLenient && token && !regexp.test(token)) return;
            //ZK-5615: Determine if token contains non-digital word when nonLenient is false.
            nv = window.zul.db.datefmt_._parseInt(token);
            if (!token || isNaN(nv)) return;
            d = nv;
            dFound = true;
            if (d < 0 || d > 31)
              //restrict since user might input year for day (ok to allow 0 and 31 for easy entry)
              return; //failed
            break;
          case 'H':
          case 'h':
          case 'K':
          case 'k':
            // ZK-1985:	Determine if token's length is less than the expected when nonLenient is true.
            if (nonLenient && token && token.length < len) return;
            if (hasHour1 ? cc == 'H' || cc == 'k' : cc == 'h' || cc == 'K') break;
            if (nosep) token = window.zul.db.datefmt_._parseToken(token, ts, --i, len);
            // ZK-1985:	Determine if token contains non-digital word when nonLenient is true.
            if (nonLenient && token && !regexp.test(token)) return;
            if (!isNaN(nv = window.zul.db.datefmt_._parseInt(token))) hr = cc == 'h' && nv == 12 || cc == 'k' && nv == 24 ? 0 : cc == 'K' ? nv % 12 : nv;
            break;
          case 'm':
          case 's':
          case 'S':
            // ZK-1985:	Determine if token's length is less than the expected when nonLenient is true.
            if (nonLenient && token && token.length < len) return;
            if (nosep) token = window.zul.db.datefmt_._parseToken(token, ts, --i, len);
            // ZK-1985:	Determine if token contains non-digital word when nonLenient is true.
            if (nonLenient && token && !regexp.test(token)) return;
            if (!isNaN(nv = window.zul.db.datefmt_._parseInt(token))) {
              if (cc == 'm') min = nv;else if (cc == 's') sec = nv;else msec = nv;
            }
            break;
          case 'a':
            if (!hasHour1) break;
            if (nosep) token = window.zul.db.datefmt_._parseToken(token, ts, --i, len);
            if (!token) return; //failed
            var tokenUpperCase = token.toUpperCase(),
              apmText = localizedSymbols.APM[0].toUpperCase();
            if (tokenUpperCase.startsWith(apmText)) {
              isAM = true;
            } else if (apmText.startsWith(tokenUpperCase) && ts[i] && apmText.endsWith(ts[i].toUpperCase())) {
              // ZK-5216, Spanish AM/PM
              isAM = true;
              i++;
            } else {
              isAM = false;
            }
            break;
          case 'G':
            if (nosep && eras) {
              if (!eraName) return; // no era match
              token = window.zul.db.datefmt_._parseToken(token, ts, --i, eraName.length);
            }
            if (eraName && token != eraName && eraName.length > token.length) {
              // there is space in eraName
              token = eraName;
              i += eraName.match(/([\s]+)/g).length;
            }
            break;
          //default: ignored
        }
        j = k - 1;
      } else offs++;
    }
    if (hasHour1 && isAM === false) hr += 12;
    var dt; // TODO: enforce common interface?
    if (m == 1 && d == 29 && ydelta) {
      dt = new LeapDay(y, m, d, hr, min, sec, msec, tz);
      dt.setOffset(ydelta);
    } else {
      dt = Dates.newInstance([y, m, d, hr, min, sec, msec], tz);
    }
    if (!dFound && dt.getMonth() != m) dt = Dates.newInstance([y, m + 1, 0, hr, min, sec, msec], tz); //last date of m
    if (nonLenient || strictDate) if (dt.getFullYear() != y || dt.getMonth() != m || dt.getDate() != d || dt.getHours() != hr || dt.getMinutes() != min || dt.getSeconds() != sec)
      //ignore msec (safer though not accurate)
      return; //failed
    if (nonLenient) {
      txt = ts.reduce(function (txt, t) {
        return txt.replace(t, '');
      }, txt.trim());
      for (var k = txt.length; k--;) {
        var cc = txt.charAt(k);
        if ((cc > '9' || cc < '0') && !fmt.includes(cc)) return; //failed
      }
    }
    return +dt == +refval ? refval : dt;
    //we have to use getTime() since dt == refVal always false
  },
  formatDate: function (val, fmt, localizedSymbols) {
    if (!fmt) fmt = 'yyyy/MM/dd';
    localizedSymbols !== null && localizedSymbols !== void 0 ? localizedSymbols : localizedSymbols = {
      DOW_1ST: zk.DOW_1ST,
      MINDAYS: zk.MINDAYS,
      ERA: zk.ERA,
      YDELTA: zk.YDELTA,
      LAN_TAG: zk.LAN_TAG,
      SDOW: zk.SDOW,
      S2DOW: zk.S2DOW,
      FDOW: zk.FDOW,
      SMON: zk.SMON,
      S2MON: zk.S2MON,
      FMON: zk.FMON,
      APM: zk.APM
    };
    var txt = '',
      localeDateTimeFormat = new Intl.DateTimeFormat(localizedSymbols.LAN_TAG, {
        year: 'numeric'
      }),
      singleQuote;
    for (var j = 0, fl = fmt.length; j < fl; ++j) {
      var cc = fmt.charAt(j);
      if (cc >= 'a' && cc <= 'z' || cc >= 'A' && cc <= 'Z') {
        if (singleQuote) {
          txt += cc;
          continue;
        }
        var len = 1,
          k;
        for (k = j; ++k < fl; ++len) if (fmt.charAt(k) != cc) {
          if (fmt.charAt(k) == 'r') k++; // ZK-2964: for nl local uur
          break;
        }
        switch (cc) {
          case 'y':
          case 'u':
            var ydelta = 0;
            if (cc == 'y') ydelta = localizedSymbols.YDELTA || this.getYDelta(val._moment.toDate(), localeDateTimeFormat);
            var y = val.getFullYear() + ydelta;
            // ZK-4851: the year is truncated to 2 digits only if the number of pattern letters is 2
            if (len == 2) txt += window.zul.db.datefmt_._digitFixed(y % Math.pow(10, len), len);else txt += window.zul.db.datefmt_._digitFixed(y, len);
            break;
          case 'M':
            if (len <= 2) txt += window.zul.db.datefmt_._digitFixed(val.getMonth() + 1, len);else if (len == 3) txt += localizedSymbols.SMON[val.getMonth()];else txt += localizedSymbols.FMON[val.getMonth()];
            break;
          case 'd':
            txt += window.zul.db.datefmt_._digitFixed(window.zul.db.datefmt_.dayInMonth(val), len);
            break;
          case 'E':
            if (len <= 3) txt += localizedSymbols.SDOW[(val.getDay() - localizedSymbols.DOW_1ST + 7) % 7];else txt += localizedSymbols.FDOW[(val.getDay() - localizedSymbols.DOW_1ST + 7) % 7];
            break;
          case 'D':
            txt += window.zul.db.datefmt_.dayInYear(val);
            break;
          case 'w':
            txt += zUtl.getWeekOfYear(val.getFullYear(), val.getMonth(), val.getDate(), localizedSymbols.DOW_1ST, localizedSymbols.MINDAYS);
            break;
          case 'W':
            txt += window.zul.db.datefmt_.weekInMonth(val, localizedSymbols.DOW_1ST);
            break;
          case 'G':
            txt += localizedSymbols.ERA || this.getEraName(val._moment.toDate(), localizedSymbols, localeDateTimeFormat);
            break;
          case 'F':
            txt += window.zul.db.datefmt_.dayOfWeekInMonth(val);
            break;
          case 'H':
            if (len <= 2) txt += window.zul.db.datefmt_._digitFixed(val.getHours(), len);
            break;
          case 'k':
            var h = val.getHours();
            if (h == 0) h = '24';
            if (len <= 2) txt += window.zul.db.datefmt_._digitFixed(h, len);
            break;
          case 'K':
            if (len <= 2) txt += window.zul.db.datefmt_._digitFixed(val.getHours() % 12, len);
            break;
          case 'h':
            var h = val.getHours();
            h %= 12;
            if (h == 0) h = '12';
            if (len <= 2) txt += window.zul.db.datefmt_._digitFixed(h, len);
            break;
          case 'm':
            if (len <= 2) txt += window.zul.db.datefmt_._digitFixed(val.getMinutes(), len);
            break;
          case 's':
            if (len <= 2) txt += window.zul.db.datefmt_._digitFixed(val.getSeconds(), len);
            break;
          case 'S':
            if (len <= 3) txt += window.zul.db.datefmt_._digitFixed(val.getMilliseconds(), len);
            break;
          case 'Z':
            txt += -(val.getTimezoneOffset() / 60);
            break;
          case 'z':
            txt += -(val.getTimezoneOffset() / 60);
            break;
          case 'a':
            txt += localizedSymbols.APM[val.getHours() > 11 ? 1 : 0];
            break;
          default:
            txt += '1';
          //fake; SimpleDateFormat.parse might ignore it
          //However, it must be an error if we don't generate a digit
        }
        j = k - 1;
      } else if (cc != "'") {
        txt += cc;
      } else if (cc === "'") {
        singleQuote = !singleQuote;
      }
    }
    return txt;
  },
  getYDelta: function (date, localeDateTimeFormat) {
    return 0;
  },
  getEraName: function (date, localizedSymbols, localeDateTimeFormat) {
    var langTag = localizedSymbols.LAN_TAG.split('-').slice(0, 2).join('-'),
      localeDateString = date.toLocaleDateString(langTag, {
        era: 'short',
        day: 'numeric'
      });
    return localeDateString.split(' ')[0];
  },
  /** @internal */
  _findEraKey: function (txt, eras) {
    return undefined;
  }
};
exports.Date = DateFmt;
zk.fmt.Date = DateFmt;
/**
 * The `calendar` object provides a way
 * to convert between a specific instant in time for locale-sensitive
 * like buddhist's time.
 * <p>By default the year offset is specified from server if any.</p>
 * @since 5.0.1
 */
var Calendar = /** @class */function (_super) {
  __extends(Calendar, _super);
  function Calendar(date, localizedSymbols) {
    var _this = _super.call(this) || this;
    /** @internal */
    _this._offset = zk.YDELTA;
    _this._date = date;
    if (localizedSymbols) {
      var localeDateTimeFormat = new Intl.DateTimeFormat(localizedSymbols.LAN_TAG, {
        year: 'numeric'
      });
      _this._offset = localizedSymbols.YDELTA || zk.fmt.Date.getYDelta(date ? date._moment.toDate() : undefined, localeDateTimeFormat);
    }
    return _this;
  }
  Calendar.prototype.getTime = function () {
    return this._date;
  };
  Calendar.prototype.setTime = function (time) {
    this._date = time;
    return this;
  };
  Calendar.prototype.setYearOffset = function (yearOffset) {
    this._offset = yearOffset;
    return this;
  };
  Calendar.prototype.getYearOffset = function () {
    return this._offset;
  };
  Calendar.prototype.formatDate = function (val, fmt, localizedSymbols) {
    var d;
    if (localizedSymbols) {
      var localeDateTimeFormat = new Intl.DateTimeFormat(localizedSymbols.LAN_TAG, {
        year: 'numeric'
      });
      this._offset = localizedSymbols.YDELTA || zk.fmt.Date.getYDelta(val._moment.toDate(), localeDateTimeFormat);
    }
    if (this._offset) {
      if (val.getMonth() == 1 && val.getDate() == 29) {
        d = new LeapDay(val); // a proxy of Date
        d.setOffset(this._offset);
      }
    }
    return zk.fmt.Date.formatDate(d !== null && d !== void 0 ? d : val, fmt, localizedSymbols);
  };
  Calendar.prototype.toUTCDate = function () {
    if (this._date instanceof LeapDay) return this._date.getRealDate();
    var d;
    if ((d = this._date) && this._offset) d = Dates.newInstance(d);
    return d;
  };
  Calendar.prototype.parseDate = function (txt, fmt, strict, refval, localizedSymbols, tz, strictDate) {
    var d = zk.fmt.Date.parseDate(txt, fmt, strict, refval, localizedSymbols, tz, strictDate);
    if (localizedSymbols) {
      var localeDateTimeFormat = new Intl.DateTimeFormat(localizedSymbols.LAN_TAG, {
        year: 'numeric'
      });
      this._offset = localizedSymbols.YDELTA || d ? zk.fmt.Date.getYDelta(d._moment.toDate(), localeDateTimeFormat) : 0;
    }
    if (this._offset && fmt) {
      if (d instanceof LeapDay) {
        return d.getRealDate();
      }
    }
    return d;
  };
  Calendar.prototype.getYear = function () {
    return this._date.getFullYear();
  };
  // B70-ZK-2382: in Daylight Saving Time (DST), choose the last time at the end of this mechanism, it will display previous day.
  // e.g. 2014/10/19 at Brasilia (UTC-03:00), it will show 2014/10/18 23:00:00
  // so we need to increase a hour.
  Calendar.prototype.escapeDSTConflict = function (val, tz) {
    if (!val) return;
    var newVal = Dates.newInstance(val.getTime() + 3600000, tz); //plus 60*60*1000
    return newVal.getHours() != (val.getHours() + 1) % 24 ? newVal : val;
  };
  Calendar = __decorate([zk.WrapClass('zk.fmt.Calendar')], Calendar);
  return Calendar;
}(zk.Object);
exports.Calendar = Calendar;
window.zul.db.datefmt_.LeapDay = LeapDay;
window.zul.db.datefmt_.DateFmt = DateFmt;
window.zul.db.datefmt_.Calendar = Calendar;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/db/index.ts":
/*!*******************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/db/index.ts ***!
  \*******************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __exportStar = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__exportStar"];


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Timebox = void 0;
exports["default"] = {};
__webpack_require__(/*! ./datefmt */ "./zul/src/main/resources/web/js/zul/db/datefmt.ts"); // Side-effect-only import to register zk.fmt members
__webpack_require__(/*! ./Timebox */ "./zul/src/main/resources/web/js/zul/db/Timebox.ts"); // Side-effect-only import to register zul.inp members
var Timebox_1 = __webpack_require__(/*! ./Timebox */ "./zul/src/main/resources/web/js/zul/db/Timebox.ts"); // Expose Timebox via zul.db
Object.defineProperty(exports, "Timebox", ({
  enumerable: true,
  get: function () {
    return Timebox_1.Timebox;
  }
}));
__exportStar(__webpack_require__(/*! ./Calendar */ "./zul/src/main/resources/web/js/zul/db/Calendar.ts"), exports);
__exportStar(__webpack_require__(/*! ./Datebox */ "./zul/src/main/resources/web/js/zul/db/Datebox.ts"), exports);

/***/ }),

/***/ "./node_modules/tslib/tslib.es6.js":
/*!*****************************************!*\
  !*** ./node_modules/tslib/tslib.es6.js ***!
  \*****************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __addDisposableResource: function() { return /* binding */ __addDisposableResource; },
/* harmony export */   __assign: function() { return /* binding */ __assign; },
/* harmony export */   __asyncDelegator: function() { return /* binding */ __asyncDelegator; },
/* harmony export */   __asyncGenerator: function() { return /* binding */ __asyncGenerator; },
/* harmony export */   __asyncValues: function() { return /* binding */ __asyncValues; },
/* harmony export */   __await: function() { return /* binding */ __await; },
/* harmony export */   __awaiter: function() { return /* binding */ __awaiter; },
/* harmony export */   __classPrivateFieldGet: function() { return /* binding */ __classPrivateFieldGet; },
/* harmony export */   __classPrivateFieldIn: function() { return /* binding */ __classPrivateFieldIn; },
/* harmony export */   __classPrivateFieldSet: function() { return /* binding */ __classPrivateFieldSet; },
/* harmony export */   __createBinding: function() { return /* binding */ __createBinding; },
/* harmony export */   __decorate: function() { return /* binding */ __decorate; },
/* harmony export */   __disposeResources: function() { return /* binding */ __disposeResources; },
/* harmony export */   __esDecorate: function() { return /* binding */ __esDecorate; },
/* harmony export */   __exportStar: function() { return /* binding */ __exportStar; },
/* harmony export */   __extends: function() { return /* binding */ __extends; },
/* harmony export */   __generator: function() { return /* binding */ __generator; },
/* harmony export */   __importDefault: function() { return /* binding */ __importDefault; },
/* harmony export */   __importStar: function() { return /* binding */ __importStar; },
/* harmony export */   __makeTemplateObject: function() { return /* binding */ __makeTemplateObject; },
/* harmony export */   __metadata: function() { return /* binding */ __metadata; },
/* harmony export */   __param: function() { return /* binding */ __param; },
/* harmony export */   __propKey: function() { return /* binding */ __propKey; },
/* harmony export */   __read: function() { return /* binding */ __read; },
/* harmony export */   __rest: function() { return /* binding */ __rest; },
/* harmony export */   __runInitializers: function() { return /* binding */ __runInitializers; },
/* harmony export */   __setFunctionName: function() { return /* binding */ __setFunctionName; },
/* harmony export */   __spread: function() { return /* binding */ __spread; },
/* harmony export */   __spreadArray: function() { return /* binding */ __spreadArray; },
/* harmony export */   __spreadArrays: function() { return /* binding */ __spreadArrays; },
/* harmony export */   __values: function() { return /* binding */ __values; }
/* harmony export */ });
/******************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */
/* global Reflect, Promise, SuppressedError, Symbol */

var extendStatics = function(d, b) {
    extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
    return extendStatics(d, b);
};

function __extends(d, b) {
    if (typeof b !== "function" && b !== null)
        throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
    extendStatics(d, b);
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
}

var __assign = function() {
    __assign = Object.assign || function __assign(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
        }
        return t;
    }
    return __assign.apply(this, arguments);
}

function __rest(s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
}

function __decorate(decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
}

function __param(paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
}

function __esDecorate(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
    function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
    var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
    var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
    var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
    var _, done = false;
    for (var i = decorators.length - 1; i >= 0; i--) {
        var context = {};
        for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
        for (var p in contextIn.access) context.access[p] = contextIn.access[p];
        context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
        var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
        if (kind === "accessor") {
            if (result === void 0) continue;
            if (result === null || typeof result !== "object") throw new TypeError("Object expected");
            if (_ = accept(result.get)) descriptor.get = _;
            if (_ = accept(result.set)) descriptor.set = _;
            if (_ = accept(result.init)) initializers.unshift(_);
        }
        else if (_ = accept(result)) {
            if (kind === "field") initializers.unshift(_);
            else descriptor[key] = _;
        }
    }
    if (target) Object.defineProperty(target, contextIn.name, descriptor);
    done = true;
};

function __runInitializers(thisArg, initializers, value) {
    var useValue = arguments.length > 2;
    for (var i = 0; i < initializers.length; i++) {
        value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
    }
    return useValue ? value : void 0;
};

function __propKey(x) {
    return typeof x === "symbol" ? x : "".concat(x);
};

function __setFunctionName(f, name, prefix) {
    if (typeof name === "symbol") name = name.description ? "[".concat(name.description, "]") : "";
    return Object.defineProperty(f, "name", { configurable: true, value: prefix ? "".concat(prefix, " ", name) : name });
};

function __metadata(metadataKey, metadataValue) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(metadataKey, metadataValue);
}

function __awaiter(thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
}

function __generator(thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
}

var __createBinding = Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
});

function __exportStar(m, o) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(o, p)) __createBinding(o, m, p);
}

function __values(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
}

function __read(o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
}

/** @deprecated */
function __spread() {
    for (var ar = [], i = 0; i < arguments.length; i++)
        ar = ar.concat(__read(arguments[i]));
    return ar;
}

/** @deprecated */
function __spreadArrays() {
    for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
    for (var r = Array(s), k = 0, i = 0; i < il; i++)
        for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
            r[k] = a[j];
    return r;
}

function __spreadArray(to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
}

function __await(v) {
    return this instanceof __await ? (this.v = v, this) : new __await(v);
}

function __asyncGenerator(thisArg, _arguments, generator) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var g = generator.apply(thisArg, _arguments || []), i, q = [];
    return i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i;
    function verb(n) { if (g[n]) i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); }; }
    function resume(n, v) { try { step(g[n](v)); } catch (e) { settle(q[0][3], e); } }
    function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
    function fulfill(value) { resume("next", value); }
    function reject(value) { resume("throw", value); }
    function settle(f, v) { if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]); }
}

function __asyncDelegator(o) {
    var i, p;
    return i = {}, verb("next"), verb("throw", function (e) { throw e; }), verb("return"), i[Symbol.iterator] = function () { return this; }, i;
    function verb(n, f) { i[n] = o[n] ? function (v) { return (p = !p) ? { value: __await(o[n](v)), done: false } : f ? f(v) : v; } : f; }
}

function __asyncValues(o) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var m = o[Symbol.asyncIterator], i;
    return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
    function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
    function settle(resolve, reject, d, v) { Promise.resolve(v).then(function(v) { resolve({ value: v, done: d }); }, reject); }
}

function __makeTemplateObject(cooked, raw) {
    if (Object.defineProperty) { Object.defineProperty(cooked, "raw", { value: raw }); } else { cooked.raw = raw; }
    return cooked;
};

var __setModuleDefault = Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
};

function __importStar(mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
}

function __importDefault(mod) {
    return (mod && mod.__esModule) ? mod : { default: mod };
}

function __classPrivateFieldGet(receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
}

function __classPrivateFieldSet(receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
}

function __classPrivateFieldIn(state, receiver) {
    if (receiver === null || (typeof receiver !== "object" && typeof receiver !== "function")) throw new TypeError("Cannot use 'in' operator on non-object");
    return typeof state === "function" ? receiver === state : state.has(receiver);
}

function __addDisposableResource(env, value, async) {
    if (value !== null && value !== void 0) {
        if (typeof value !== "object" && typeof value !== "function") throw new TypeError("Object expected.");
        var dispose;
        if (async) {
            if (!Symbol.asyncDispose) throw new TypeError("Symbol.asyncDispose is not defined.");
            dispose = value[Symbol.asyncDispose];
        }
        if (dispose === void 0) {
            if (!Symbol.dispose) throw new TypeError("Symbol.dispose is not defined.");
            dispose = value[Symbol.dispose];
        }
        if (typeof dispose !== "function") throw new TypeError("Object not disposable.");
        env.stack.push({ value: value, dispose: dispose, async: async });
    }
    else if (async) {
        env.stack.push({ async: true });
    }
    return value;
}

var _SuppressedError = typeof SuppressedError === "function" ? SuppressedError : function (error, suppressed, message) {
    var e = new Error(message);
    return e.name = "SuppressedError", e.error = error, e.suppressed = suppressed, e;
};

function __disposeResources(env) {
    function fail(e) {
        env.error = env.hasError ? new _SuppressedError(e, env.error, "An error was suppressed during disposal.") : e;
        env.hasError = true;
    }
    function next() {
        while (env.stack.length) {
            var rec = env.stack.pop();
            try {
                var result = rec.dispose && rec.dispose.call(rec.value);
                if (rec.async) return Promise.resolve(result).then(next, function(e) { fail(e); return next(); });
            }
            catch (e) {
                fail(e);
            }
        }
        if (env.hasError) throw env.error;
    }
    return next();
}

/* harmony default export */ __webpack_exports__["default"] = ({
    __extends: __extends,
    __assign: __assign,
    __rest: __rest,
    __decorate: __decorate,
    __param: __param,
    __metadata: __metadata,
    __awaiter: __awaiter,
    __generator: __generator,
    __createBinding: __createBinding,
    __exportStar: __exportStar,
    __values: __values,
    __read: __read,
    __spread: __spread,
    __spreadArrays: __spreadArrays,
    __spreadArray: __spreadArray,
    __await: __await,
    __asyncGenerator: __asyncGenerator,
    __asyncDelegator: __asyncDelegator,
    __asyncValues: __asyncValues,
    __makeTemplateObject: __makeTemplateObject,
    __importStar: __importStar,
    __importDefault: __importDefault,
    __classPrivateFieldGet: __classPrivateFieldGet,
    __classPrivateFieldSet: __classPrivateFieldSet,
    __classPrivateFieldIn: __classPrivateFieldIn,
    __addDisposableResource: __addDisposableResource,
    __disposeResources: __disposeResources,
});


/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	!function() {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = function(exports, definition) {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	!function() {
/******/ 		__webpack_require__.o = function(obj, prop) { return Object.prototype.hasOwnProperty.call(obj, prop); }
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	!function() {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = function(exports) {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	}();
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module is referenced by other modules so it can't be inlined
/******/ 	var __webpack_exports__ = __webpack_require__("./zul/src/main/resources/web/js/zul/db/index.ts");
/******/ 	var __webpack_export_target__ = window;
/******/ 	var __webpack_exports_export__ = __webpack_exports__["default"];
/******/ 	for(var i in __webpack_exports_export__) __webpack_export_target__[i] = __webpack_exports_export__[i];
/******/ 	if(__webpack_exports_export__.__esModule) Object.defineProperty(__webpack_export_target__, "__esModule", { value: true });
/******/ 	
/******/ })()
;