/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zml;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.owasp.encoder.Encode;
import org.zkoss.idom.Namespace;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.ext.DynamicTag;
import org.zkoss.zk.ui.ext.Native;
import org.zkoss.zk.ui.impl.NativeHelpers;
import org.zkoss.zk.ui.sys.ComponentCtrl;
import org.zkoss.zk.ui.sys.ComponentsCtrl;

public class XmlNativeComponent
extends AbstractComponent
implements DynamicTag,
Native {
    private static final Native.Helper _helper = new XmlHelper();
    private String _tag;
    private String _prolog = "";
    private String _epilog = "";
    private Map<String, Object> _props;
    private List<Namespace> _dns;

    public XmlNativeComponent() {
    }

    public XmlNativeComponent(String tag) {
        this.setTag(tag);
    }

    public String getTag() {
        return this._tag;
    }

    public List<Namespace> getDeclaredNamespaces() {
        if (this._dns != null) {
            return this._dns;
        }
        return Collections.emptyList();
    }

    public void addDeclaredNamespace(Namespace ns) {
        if (ns == null) {
            throw new IllegalArgumentException();
        }
        if (this._dns == null) {
            this._dns = new LinkedList<Namespace>();
        }
        this._dns.add(ns);
    }

    public String getPrologContent() {
        return this._prolog;
    }

    public void setPrologContent(String prolog) {
        this._prolog = prolog != null ? prolog : "";
    }

    public String getEpilogContent() {
        return this._epilog;
    }

    public void setEpilogContent(String epilog) {
        this._epilog = epilog != null ? epilog : "";
    }

    public Native.Helper getHelper() {
        return _helper;
    }

    public void setId(String id) {
        super.setId(id);
        this.setDynamicProperty("id", id);
    }

    public boolean setVisible(boolean visible) {
        throw new UnsupportedOperationException("Use client-dependent attribute, such as display:none");
    }

    public void redraw(Writer out) throws IOException {
        StringBuffer sb = new StringBuffer(128);
        Native.Helper helper = this.getHelper();
        helper.getFirstHalf(sb, this._tag, this._props, this._dns);
        XmlNativeComponent.write(out, sb);
        sb.append(this._prolog);
        XmlNativeComponent.write(out, sb);
        for (Component child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            ((ComponentCtrl)child).redraw(out);
        }
        sb.append(this._epilog);
        XmlNativeComponent.write(out, sb);
        helper.getSecondHalf(sb, this._tag);
        out.write(sb.toString());
    }

    private static void write(Writer out, StringBuffer sb) throws IOException {
        out.write(sb.toString());
        sb.setLength(0);
    }

    public void setTag(String tag) throws WrongValueException {
        this._tag = tag != null && tag.length() > 0 ? tag : null;
    }

    public boolean hasTag(String tag) {
        return true;
    }

    public boolean hasDynamicProperty(String name) {
        return ComponentsCtrl.isReservedAttribute((String)name);
    }

    public Object getDynamicProperty(String name) {
        return this._props != null ? this._props.get(name) : null;
    }

    public Map<String, Object> getDynamicProperties() {
        return this._props;
    }

    public void setDynamicProperty(String name, Object value) throws WrongValueException {
        if (name == null) {
            throw new WrongValueException("name required");
        }
        if (value == null) {
            if (this._props != null) {
                this._props.remove(name);
            }
        } else {
            if (this._props == null) {
                this._props = new LinkedHashMap<String, Object>();
            }
            this._props.put(name, value);
        }
    }

    public static class XmlHelper
    implements Native.Helper {
        public Component newNative(String text) {
            XmlNativeComponent nc = new XmlNativeComponent();
            if (text != null) {
                nc.setPrologContent(text);
            }
            return nc;
        }

        public void getFirstHalf(StringBuffer sb, String tag, Map<String, Object> props, Collection<Namespace> namespaces) {
            if (tag != null) {
                sb.append('<').append(tag);
            }
            NativeHelpers.getAttributes((StringBuffer)sb, props, namespaces);
            if (tag != null) {
                sb.append(">");
            }
        }

        public void getSecondHalf(StringBuffer sb, String tag) {
            if (tag != null) {
                sb.append("</").append(tag).append(">\n");
            }
        }

        public void appendText(StringBuffer sb, String text) {
            sb.append(Encode.forHtmlContent((String)text));
        }
    }
}

