/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zml;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.zkoss.io.Serializables;
import org.zkoss.lang.Library;
import org.zkoss.lang.Objects;
import org.zkoss.xel.VariableResolver;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.ext.Macro;
import org.zkoss.zk.ui.select.Selectors;
import org.zkoss.zk.ui.sys.ComponentCtrl;
import org.zkoss.zk.ui.util.ConventionWires;

public class XmlMacroComponent
extends AbstractComponent
implements Macro {
    private transient Map<String, Object> _props;
    private String _uri;
    private Component[] _inlines;
    protected final List<VariableResolver> _resolvers;
    private static Integer _autowireflag;

    public XmlMacroComponent() {
        this.init();
        this._resolvers = Selectors.newVariableResolvers(((Object)((Object)this)).getClass(), XmlMacroComponent.class);
        if (XmlMacroComponent.getAutowireFlag() == 0) {
            Selectors.wireVariables((Component)this, (Object)((Object)this), this._resolvers);
        }
    }

    private void init() {
        this._props = new LinkedHashMap<String, Object>();
        this._props.put("includer", (Object)this);
    }

    public void afterCompose() {
        this.compose();
    }

    protected void compose() {
        Execution exec = Executions.getCurrent();
        if (exec == null) {
            throw new IllegalStateException("No execution available.");
        }
        if (this.isInline()) {
            if (this._inlines != null) {
                return;
            }
            this._inlines = exec.createComponents(this._uri != null ? this._uri : this.getDefinition().getMacroURI(), this._props);
        } else {
            if (!this.getChildren().isEmpty()) {
                return;
            }
            exec.createComponents(this._uri != null ? this._uri : this.getDefinition().getMacroURI(), (Component)this, this._props);
        }
        switch (XmlMacroComponent.getAutowireFlag()) {
            case 0: {
                Selectors.wireComponents((Component)this, (Object)((Object)this), (boolean)false);
                Selectors.wireEventListeners((Component)this, (Object)((Object)this));
                break;
            }
            case 1: {
                ConventionWires.wireVariables((Component)this, (Object)((Object)this), (char)'$', (boolean)true, (boolean)true);
                ConventionWires.addForwards((Component)this, (Object)((Object)this), (char)'$');
            }
        }
    }

    private static int getAutowireFlag() {
        if (_autowireflag == null) {
            _autowireflag = "true".equals(Library.getProperty((String)"org.zkoss.zk.ui.macro.autowire.disabled")) ? -1 : ("true".equals(Library.getProperty((String)"org.zkoss.zk.ui.macro.autowire.convention")) ? 1 : 0);
        }
        return _autowireflag;
    }

    public void setMacroURI(String uri) {
        if (!Objects.equals((Object)this._uri, (Object)uri)) {
            if (uri != null && uri.length() == 0) {
                throw new IllegalArgumentException("empty uri");
            }
            this._uri = uri;
            if (this.getParent() != null) {
                this.recreate();
            }
        }
    }

    public String getMacroURI() {
        return this._uri != null ? this._uri : this.getDefinition().getMacroURI();
    }

    public void recreate() {
        if (this._inlines != null) {
            for (int j = 0; j < this._inlines.length; ++j) {
                this._inlines[j].detach();
            }
            this._inlines = null;
        } else {
            this.getChildren().clear();
        }
        this.compose();
    }

    public boolean isInline() {
        return this.getDefinition().isInlineMacro();
    }

    public void setParent(Component parent) {
        if (this.isInline()) {
            if (this._inlines == null) {
                this.compose();
            }
            for (int j = 0; j < this._inlines.length; ++j) {
                this._inlines[j].setParent(parent);
            }
        } else {
            super.setParent(parent);
        }
    }

    public boolean setInlineParent(Component parent, Component beforeSibling) {
        if (!this.isInline()) {
            throw new InternalError("inline only");
        }
        if (this._inlines == null) {
            this.compose();
        }
        boolean inserted = false;
        for (int j = 0; j < this._inlines.length; ++j) {
            if (!parent.insertBefore(this._inlines[j], beforeSibling)) continue;
            inserted = true;
        }
        return inserted;
    }

    public void setPage(Page page) {
        if (this.isInline()) {
            if (this._inlines == null) {
                this.compose();
            }
            for (int j = 0; j < this._inlines.length; ++j) {
                this._inlines[j].setPage(page);
            }
        } else {
            super.setPage(page);
        }
    }

    protected boolean isChildable() {
        return !this.isInline();
    }

    public void redraw(Writer out) throws IOException {
        for (Component child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            ((ComponentCtrl)child).redraw(out);
        }
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        this._props.remove("includer");
        Serializables.smartWrite((ObjectOutputStream)s, this._props);
        this._props.put("includer", (Object)this);
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.init();
        Serializables.smartRead((ObjectInputStream)s, this._props);
    }

    public Object clone() {
        XmlMacroComponent clone = (XmlMacroComponent)((Object)super.clone());
        clone.init();
        clone._props.putAll(this._props);
        clone._props.put("includer", (Object)clone);
        if (this._inlines != null) {
            clone._inlines = new Component[this._inlines.length];
            for (int j = 0; j < this._inlines.length; ++j) {
                clone._inlines[j] = (Component)this._inlines[j].clone();
            }
        }
        return clone;
    }

    public boolean hasDynamicProperty(String name) {
        return this._props.containsKey(name);
    }

    public Map<String, Object> getDynamicProperties() {
        return this._props;
    }

    public Object getDynamicProperty(String name) {
        return this._props.get(name);
    }

    public void setDynamicProperty(String name, Object value) throws WrongValueException {
        this._props.put(name, value);
    }
}

