/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.zul;

import java.io.IOException;
import org.zkoss.lang.Objects;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.OpenEvent;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zkex.rt.Runtime;
import org.zkoss.zkmax.zul.event.DivisionSizeEvent;
import org.zkoss.zul.impl.Utils;
import org.zkoss.zul.impl.XulElement;

public class Splitlayout
extends XulElement {
    private static final long serialVersionUID = -5548413964313808225L;
    private String _orient = "vertical";
    private String _collapse = "none";
    private boolean _open = true;
    private boolean _resizable = true;
    private String[] _widths;
    private String[] _heights;
    private String[] _minWidths;
    private String[] _minHeights;

    public void setOrient(String orient) throws WrongValueException {
        if (!"horizontal".equals(orient) && !"vertical".equals(orient)) {
            throw new WrongValueException("Unknow orient : " + orient);
        }
        if (!Objects.equals((Object)this._orient, (Object)orient)) {
            this._orient = orient;
            this.invalidate();
        }
    }

    public String getOrient() {
        return this._orient;
    }

    public String getCollapse() {
        return this._collapse;
    }

    public void setCollapse(String collapse) throws WrongValueException {
        if (collapse == null || collapse.length() == 0) {
            collapse = "none";
        } else if (!("none".equals(collapse) || "before".equals(collapse) || "after".equals(collapse))) {
            throw new WrongValueException("Unknown collpase: " + collapse);
        }
        if (!Objects.equals((Object)this._collapse, (Object)collapse)) {
            this._collapse = collapse;
            this.smartUpdate("collapse", collapse);
        }
    }

    public boolean isOpen() {
        return this._open;
    }

    public void setOpen(boolean open) {
        if (this._open != open) {
            this._open = open;
            this.smartUpdate("open", open);
        }
    }

    public boolean isResizable() {
        return this._resizable;
    }

    public void setResizable(boolean resizable) {
        if (this._resizable != resizable) {
            this._resizable = resizable;
            this.smartUpdate("resizable", resizable);
        }
    }

    public String getWidths() {
        Object widths = "";
        if (this._widths != null) {
            widths = this._widths[0] + "," + this._widths[1];
        }
        return widths;
    }

    public void setWidths(String widthsStr) throws WrongValueException {
        String[] widths = Utils.stringToArray((String)(widthsStr != null ? widthsStr.replaceAll("px", "") : ""), null);
        if (!Objects.equals((Object)widths, (Object)this._widths)) {
            this._widths = widths;
            this.smartUpdate("widths", widths);
        }
    }

    public String getHeights() {
        Object heights = "";
        if (this._heights != null) {
            heights = this._heights[0] + "," + this._heights[1];
        }
        return heights;
    }

    public void setHeights(String heightsStr) throws WrongValueException {
        String[] heights = Utils.stringToArray((String)(heightsStr != null ? heightsStr.replaceAll("px", "") : ""), null);
        if (!Objects.equals((Object)heights, (Object)this._heights)) {
            this._heights = heights;
            this.smartUpdate("heights", heights);
        }
    }

    public String getMinWidths() {
        Object minWidths = "";
        if (this._minWidths != null) {
            minWidths = this._minWidths[0] + "," + this._minWidths[1];
        }
        return minWidths;
    }

    public void setMinWidths(String minWidthsStr) throws WrongValueException {
        String[] minWidths = Utils.stringToArray((String)minWidthsStr, null);
        if (!Objects.equals((Object)minWidths, (Object)this._minWidths)) {
            this._minWidths = minWidths;
            this.smartUpdate("minWidths", minWidths);
        }
    }

    public String getMinHeights() {
        Object minHeights = "";
        if (this._minHeights != null) {
            minHeights = this._minHeights[0] + "," + this._minHeights[1];
        }
        return minHeights;
    }

    public void setMinHeights(String minHeightsStr) throws WrongValueException {
        String[] minHeights = Utils.stringToArray((String)minHeightsStr, null);
        if (!Objects.equals((Object)minHeights, (Object)this._minHeights)) {
            this._minHeights = minHeights;
            this.smartUpdate("minHeights", this._minHeights);
        }
    }

    public void beforeChildAdded(Component child, Component refChild) {
        if (this.getChildren().size() == 2) {
            throw new UiException("Only support two children in Splitlayout");
        }
        super.beforeChildAdded(child, refChild);
    }

    public boolean isVertical() {
        return "vertical".equals(this.getOrient());
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        Runtime.init((Object)((Object)this));
        if (this.getChildren().size() > 2) {
            throw new UiException("Only support two children in Splitlayout");
        }
        super.renderProperties(renderer);
        if (!this._orient.equals("vertical")) {
            renderer.render("orient", this._orient);
        }
        if (!this._open) {
            renderer.render("open", false);
        }
        if (!this._resizable) {
            this.render(renderer, "resizable", this._resizable);
        }
        if (!"none".equals(this._collapse)) {
            this.render(renderer, "collapse", this._collapse);
        }
        if (this._widths != null) {
            this.render(renderer, "widths", this._widths);
        }
        if (this._heights != null) {
            this.render(renderer, "heights", this._heights);
        }
        if (this._minWidths != null) {
            this.render(renderer, "minWidths", this._minWidths);
        }
        if (this._minHeights != null) {
            this.render(renderer, "minHeights", this._minHeights);
        }
    }

    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        if (cmd.equals("onOpen")) {
            OpenEvent evt = OpenEvent.getOpenEvent((AuRequest)request);
            this._open = evt.isOpen();
            Events.postEvent((Event)evt);
        } else if (cmd.equals("onDivisionSize")) {
            DivisionSizeEvent evt = DivisionSizeEvent.getDivisionSizeEvent(request);
            int[] sizes = evt.getSizesArray();
            String[] sizeStr = new String[]{String.valueOf(sizes[0]), String.valueOf(sizes[1])};
            if (evt.isVertical()) {
                this._heights = sizeStr;
            } else {
                this._widths = sizeStr;
            }
            Events.postEvent((Event)evt);
        } else {
            super.service(request, everError);
        }
    }

    public String getZclass() {
        return this._zclass != null ? this._zclass : "z-splitlayout";
    }

    static {
        Splitlayout.addClientEvent(Splitlayout.class, (String)"onOpen", (int)8193);
        Splitlayout.addClientEvent(Splitlayout.class, (String)"onDivisionSize", (int)8193);
    }
}

