/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.zul.impl;

import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.lang.Exceptions;
import org.zkoss.lang.Objects;
import org.zkoss.xel.VariableResolver;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.sys.ShadowElementsCtrl;
import org.zkoss.zk.ui.util.ForEachStatus;
import org.zkoss.zk.ui.util.Template;
import org.zkoss.zul.Label;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.Tab;
import org.zkoss.zul.Tabbox;
import org.zkoss.zul.TabboxRenderer;
import org.zkoss.zul.Tabpanel;
import org.zkoss.zul.Tabpanels;
import org.zkoss.zul.Tabs;
import org.zkoss.zul.event.ListDataEvent;
import org.zkoss.zul.ext.Selectable;
import org.zkoss.zul.impl.TabboxEngine;
import org.zkoss.zul.impl.Utils;

public class TabboxEngineImpl
implements TabboxEngine {
    private static final Logger log = LoggerFactory.getLogger(TabboxEngineImpl.class);
    private Boolean SELECTIVE_COMPONENT_UPDATE = null;
    private static final TabboxRenderer<Object> _defRend = new TabboxRenderer<Object>(){

        public void renderTab(Tab tab, final Object data, final int index) throws Exception {
            final Tabbox tabbox = tab.getTabbox();
            Template tm = tabbox.getTemplate("model:tab");
            if (tm == null) {
                tab.setLabel(Objects.toString((Object)data));
            } else {
                Component[] items = ShadowElementsCtrl.filterOutShadows((Component[])tm.create((Component)tabbox.getTabs(), (Component)tab, new VariableResolver(){

                    public Object resolveVariable(String name) {
                        if ("each".equals(name)) {
                            return data;
                        }
                        if ("forEachStatus".equals(name)) {
                            return new ForEachStatus(){

                                public ForEachStatus getPrevious() {
                                    return null;
                                }

                                public Object getEach() {
                                    return this.getCurrent();
                                }

                                public int getIndex() {
                                    return index;
                                }

                                public Integer getBegin() {
                                    return 0;
                                }

                                public Integer getEnd() {
                                    return tabbox.getModel().getSize();
                                }

                                public Object getCurrent() {
                                    return data;
                                }

                                public boolean isFirst() {
                                    return this.getCount() == 1;
                                }

                                public boolean isLast() {
                                    return this.getIndex() + 1 == this.getEnd();
                                }

                                public Integer getStep() {
                                    return null;
                                }

                                public int getCount() {
                                    return this.getIndex() + 1;
                                }
                            };
                        }
                        return null;
                    }
                }, null));
                if (items.length != 1) {
                    throw new UiException("The model template must have exactly one item, not " + items.length);
                }
                if (!(items[0] instanceof Tab)) {
                    throw new UiException("The model template can only support Tab component, not " + String.valueOf(items[0]));
                }
                Tab ntab = (Tab)items[0];
                if (ntab.getValue() == null) {
                    ntab.setValue(data);
                }
                tab.setAttribute("org.zkoss.zul.model.renderAs", (Object)ntab);
                tab.detach();
            }
        }

        public void renderTabpanel(Tabpanel tabpanel, final Object data, final int index) throws Exception {
            final Tabbox tabbox = tabpanel.getTabbox();
            Template tm = tabbox.getTemplate("model:tabpanel");
            if (tm == null) {
                tabpanel.appendChild((Component)new Label(Objects.toString((Object)data)));
            } else {
                Component[] items = ShadowElementsCtrl.filterOutShadows((Component[])tm.create((Component)tabbox.getTabpanels(), (Component)tabpanel, new VariableResolver(){

                    public Object resolveVariable(String name) {
                        if ("each".equals(name)) {
                            return data;
                        }
                        if ("forEachStatus".equals(name)) {
                            return new ForEachStatus(){

                                public ForEachStatus getPrevious() {
                                    return null;
                                }

                                public Object getEach() {
                                    return this.getCurrent();
                                }

                                public int getIndex() {
                                    return index;
                                }

                                public Integer getBegin() {
                                    return 0;
                                }

                                public Integer getEnd() {
                                    return tabbox.getModel().getSize();
                                }

                                public Object getCurrent() {
                                    return data;
                                }

                                public boolean isFirst() {
                                    return this.getCount() == 1;
                                }

                                public boolean isLast() {
                                    return this.getIndex() + 1 == this.getEnd();
                                }

                                public Integer getStep() {
                                    return null;
                                }

                                public int getCount() {
                                    return this.getIndex() + 1;
                                }
                            };
                        }
                        return null;
                    }
                }, null));
                if (items.length != 1) {
                    throw new UiException("The model template must have exactly one item, not " + items.length);
                }
                if (!(items[0] instanceof Tabpanel)) {
                    throw new UiException("The model template can only support Tabpanel component, not " + String.valueOf(items[0]));
                }
                Tabpanel ntabpanel = (Tabpanel)items[0];
                tabpanel.setAttribute("org.zkoss.zul.model.renderAs", (Object)ntabpanel);
                tabpanel.detach();
            }
        }
    };

    public void doInitRenderer(Tabbox tabbox) {
        ListModel model = tabbox.getModel();
        Renderer renderer = new Renderer(tabbox);
        try {
            if (tabbox.getTabs() == null) {
                new Tabs().setParent((Component)tabbox);
            } else {
                tabbox.getTabs().getChildren().clear();
            }
            if (tabbox.getTabpanels() == null) {
                new Tabpanels().setParent((Component)tabbox);
            } else {
                tabbox.getTabpanels().getChildren().clear();
            }
            int j = model.getSize();
            for (int i = 0; i < j; ++i) {
                renderer.render(tabbox, model.getElementAt(i), i);
            }
            if (tabbox.getSelectedTab() == null && model.getSize() > 0) {
                tabbox.setSelectedTab((Tab)tabbox.getTabs().getFirstChild());
            }
        }
        catch (Throwable ex) {
            log.error("", ex);
        }
    }

    protected Tabpanel newUnloadedTabpanel() {
        Tabpanel tab = new Tabpanel();
        tab.applyProperties();
        return tab;
    }

    protected Tab newUnloadedTab() {
        Tab tab = new Tab();
        tab.applyProperties();
        return tab;
    }

    private void doSelectionChanged(Tabbox tabbox, Integer previousSelectionIndex) {
        if (previousSelectionIndex != null) {
            Selectable smodel = tabbox.getSelectableModel();
            ListModel model = tabbox.getModel();
            int size = model.getSize();
            if (smodel.isSelectionEmpty() && tabbox.getSelectedTab() == null && size > 0) {
                if (size <= previousSelectionIndex) {
                    previousSelectionIndex = size - 1;
                }
                smodel.addToSelection(model.getElementAt(previousSelectionIndex.intValue()));
                tabbox.setSelectedIndex(previousSelectionIndex.intValue());
                return;
            }
        }
        this.doSelectionChanged(tabbox);
    }

    private void doSelectionChanged(Tabbox tabbox) {
        Selectable smodel = tabbox.getSelectableModel();
        ListModel model = tabbox.getModel();
        if (smodel.isSelectionEmpty()) {
            if (tabbox.getSelectedTab() == null && model.getSize() > 0) {
                smodel.addToSelection(model.getElementAt(0));
                tabbox.setSelectedIndex(0);
            }
            return;
        }
        Tab selTab = tabbox.getSelectedTab();
        if (selTab != null && smodel.isSelected(model.getElementAt(selTab.getIndex()))) {
            return;
        }
        int sz = model.getSize();
        for (int i = 0; i < sz; ++i) {
            if (!smodel.isSelected(model.getElementAt(i))) continue;
            tabbox.setSelectedIndex(i);
            return;
        }
        tabbox.setSelectedIndex(0);
    }

    public void doDataChange(Tabbox tabbox, ListDataEvent event) {
        if (this.SELECTIVE_COMPONENT_UPDATE == null) {
            this.SELECTIVE_COMPONENT_UPDATE = Utils.testAttribute((Component)tabbox, (String)"org.zkoss.zul.model.selectiveComponentUpdate.enable", (boolean)false, (boolean)true);
        }
        switch (event.getType()) {
            case 0: {
                if (tabbox.getAttribute("org.zkoss.zul.onInitLaterPosted") == null) {
                    int min = event.getIndex0();
                    int max = event.getIndex1();
                    Renderer renderer = new Renderer(tabbox);
                    ListModel model = tabbox.getModel();
                    Selectable smodel = tabbox.getSelectableModel();
                    try {
                        int setIndex = tabbox.getSelectedIndex();
                        int j = max;
                        for (int i = min; i <= j; ++i) {
                            boolean shallUpdateSelectedIndex = setIndex == i;
                            Tab tab = (Tab)tabbox.getTabs().getChildren().get(i);
                            Tabpanel tabpanel = tab.getLinkedPanel();
                            Object data = model.getElementAt(i);
                            renderer.render(tabbox, data, i);
                            if (tabpanel != null) {
                                tabpanel.detach();
                            }
                            tab.detach();
                            if (!shallUpdateSelectedIndex) continue;
                            smodel.addToSelection(data);
                        }
                    }
                    catch (Throwable ex) {
                        log.error("", ex);
                    }
                    return;
                }
            }
            case 4: {
                if (tabbox.getAttribute("org.zkoss.zul.tabbox.changingSelection") == null && tabbox.getAttribute("org.zkoss.zul.onInitLaterPosted") == null) {
                    this.doSelectionChanged(tabbox);
                }
                return;
            }
            case 1: {
                if (tabbox.getAttribute("org.zkoss.zul.onInitLaterPosted") != null) break;
                int min = event.getIndex0();
                int max = event.getIndex1();
                Renderer renderer = new Renderer(tabbox);
                try {
                    if (tabbox.getTabs() == null) {
                        new Tabs().setParent((Component)tabbox);
                    }
                    if (tabbox.getTabpanels() == null) {
                        new Tabpanels().setParent((Component)tabbox);
                    }
                    int j = max;
                    for (int i = min; i <= j; ++i) {
                        renderer.render(tabbox, tabbox.getModel().getElementAt(i), i);
                    }
                    if (!this.SELECTIVE_COMPONENT_UPDATE.booleanValue()) {
                        int setIndex = tabbox.getSelectedIndex();
                        int j2 = tabbox.getModel().getSize();
                        for (int i = max + 1; i < j2; ++i) {
                            boolean shallUpdateSelectedIndex = setIndex == i;
                            Tab tab = (Tab)tabbox.getTabs().getChildren().get(i);
                            Tabpanel tabpanel = tab.getLinkedPanel();
                            Object data = tabbox.getModel().getElementAt(i);
                            renderer.render(tabbox, data, i);
                            if (tabpanel != null) {
                                tabpanel.detach();
                            }
                            tab.detach();
                            if (!shallUpdateSelectedIndex) continue;
                            tabbox.getSelectableModel().addToSelection(data);
                        }
                    }
                }
                catch (Throwable ex) {
                    log.error("", ex);
                }
                this.doSelectionChanged(tabbox);
                return;
            }
            case 2: {
                if (tabbox.getAttribute("org.zkoss.zul.onInitLaterPosted") != null) break;
                int min = event.getIndex0();
                int max = event.getIndex1();
                Renderer renderer = new Renderer(tabbox);
                Integer previousSelectedIndex = null;
                try {
                    Iterator it = tabbox.getTabs().getChildren().iterator();
                    int i = 0;
                    while (it.hasNext()) {
                        Object item = it.next();
                        if (i >= min && i <= max) {
                            if (item instanceof Tab) {
                                Tabpanel panel;
                                Tab tab = (Tab)item;
                                if (tab.isSelected()) {
                                    previousSelectedIndex = i;
                                }
                                if ((panel = tab.getLinkedPanel()) != null) {
                                    panel.detach();
                                }
                            }
                            it.remove();
                        }
                        if (++i <= max) continue;
                        break;
                    }
                    if (!this.SELECTIVE_COMPONENT_UPDATE.booleanValue()) {
                        int setIndex = tabbox.getSelectedIndex();
                        int j = tabbox.getModel().getSize();
                        for (i = max; i < j; ++i) {
                            boolean shallUpdateSelectedIndex = setIndex == i;
                            Tab tab = (Tab)tabbox.getTabs().getChildren().get(i);
                            Tabpanel tabpanel = tab.getLinkedPanel();
                            Object data = tabbox.getModel().getElementAt(i);
                            renderer.render(tabbox, data, i);
                            if (tabpanel != null) {
                                tabpanel.detach();
                            }
                            tab.detach();
                            if (!shallUpdateSelectedIndex) continue;
                            tabbox.getSelectableModel().addToSelection(data);
                        }
                    }
                }
                catch (Throwable ex) {
                    log.error("", ex);
                }
                this.doSelectionChanged(tabbox, previousSelectedIndex);
                return;
            }
            case 6: {
                return;
            }
        }
        tabbox.postOnInitRender();
    }

    class Renderer {
        private final TabboxRenderer _renderer;
        private final Tabbox _tabbox;

        Renderer(Tabbox tabbox) {
            this._renderer = this.getRealRenderer(tabbox);
            this._tabbox = tabbox;
        }

        private <T> TabboxRenderer<T> getRealRenderer(Tabbox tabbox) {
            TabboxRenderer<Object> renderer = tabbox.getTabboxRenderer();
            return renderer != null ? renderer : _defRend;
        }

        private void render(Tabbox tabbox, Object value, int index) throws Throwable {
            ListModel model = tabbox.getModel();
            boolean selected = ((Selectable)model).isSelected(value);
            Tab tab = TabboxEngineImpl.this.newUnloadedTab();
            List tabList = tabbox.getTabs().getChildren();
            Component tabRef = null;
            if (!tabList.isEmpty() && index < tabList.size()) {
                tabRef = (Component)tabList.get(index);
            }
            tabbox.getTabs().insertBefore((Component)tab, tabRef);
            try {
                this._renderer.renderTab(tab, value, index);
                Object v = tab.getAttribute("org.zkoss.zul.model.renderAs");
                if (v != null) {
                    tab = (Tab)v;
                }
            }
            catch (Throwable ex) {
                try {
                    tab.setLabel(Exceptions.getMessage((Throwable)ex));
                }
                catch (Throwable t) {
                    log.error("", t);
                }
                throw ex;
            }
            if (selected) {
                tabbox.setSelectedTab(tab);
            }
            Tabpanel tabpanel = TabboxEngineImpl.this.newUnloadedTabpanel();
            List tabpanelList = tabbox.getTabpanels().getChildren();
            Component tabpanelRef = null;
            if (!tabpanelList.isEmpty() && index < tabpanelList.size()) {
                tabpanelRef = (Component)tabpanelList.get(index);
            }
            tabbox.getTabpanels().insertBefore((Component)tabpanel, tabpanelRef);
            try {
                this._renderer.renderTabpanel(tabpanel, value, index);
                Object v = tab.getAttribute("org.zkoss.zul.model.renderAs");
                if (v != null) {
                    tabpanel = (Tabpanel)v;
                }
            }
            catch (Throwable ex) {
                try {
                    tabpanel.appendChild((Component)new Label(Exceptions.getMessage((Throwable)ex)));
                }
                catch (Throwable t) {
                    log.error("", t);
                }
                throw ex;
            }
        }
    }
}

