/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.zul;

import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.json.JSONObject;
import org.zkoss.json.JSONValue;
import org.zkoss.lang.Objects;
import org.zkoss.lang.Strings;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuInvoke;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.DOMExceptionEvent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.StateChangeEvent;
import org.zkoss.zk.ui.event.UploadEvent;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zkex.rt.Runtime;
import org.zkoss.zul.impl.XulElement;

public class Camera
extends XulElement {
    private static final Logger log = LoggerFactory.getLogger(Camera.class);
    public static final int STOP = 0;
    public static final int START = 1;
    public static final int PAUSE = 2;
    public static final int RESUME = 3;
    private boolean _audio = true;
    private boolean _previewRecord = true;
    private int _currentState = 0;
    private int _maxsize;
    private int _lengthLimit = 60;
    private String _snapshotFormat;
    private String _recordFormat;
    private Map _constraints;

    public void start() {
        if (this._currentState != 1) {
            this.response("ctrl", (AuResponse)new AuInvoke((Component)this, "start"));
        }
    }

    public void start(double delay) {
        if (this._currentState != 1) {
            this.response("ctrl", (AuResponse)new AuInvoke((Component)this, "start", delay));
        }
    }

    public void stop() {
        if (this._currentState != 0) {
            this.response("ctrl", (AuResponse)new AuInvoke((Component)this, "stop"));
        }
    }

    public void pause() {
        if (this._currentState != 2) {
            this.response("ctrl", (AuResponse)new AuInvoke((Component)this, "pause"));
        }
    }

    public void resume() {
        if (this._currentState != 3) {
            this.response("ctrl", (AuResponse)new AuInvoke((Component)this, "resume"));
        }
    }

    public void snapshot() {
        this.response(null, (AuResponse)new AuInvoke((Component)this, "snapshot"));
    }

    public void snapshot(double delay) {
        this.response(null, (AuResponse)new AuInvoke((Component)this, "snapshot", delay));
    }

    public void requestCamera() {
        this.response(null, (AuResponse)new AuInvoke((Component)this, "requestCamera"));
    }

    public void stopStreaming() {
        this.response(null, (AuResponse)new AuInvoke((Component)this, "stopStreaming"));
    }

    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        if ("onVideoUpload".equals(cmd) || "onSnapshotUpload".equals(cmd)) {
            Events.postEvent((Event)UploadEvent.getUploadEvent((String)cmd, (Component)this, (AuRequest)request));
        } else if ("onMaxsizeExceed".equals(cmd)) {
            Events.postEvent((Event)new Event(cmd, (Component)this, request.getData().get("dataSize")));
        } else if ("onLengthLimitExceed".equals(cmd)) {
            Events.postEvent((Event)new Event(cmd, (Component)this));
        } else if ("onStateChange".equals(cmd)) {
            StateChangeEvent stateChangeEvent = StateChangeEvent.getStateChangeEvent((AuRequest)request);
            this._currentState = stateChangeEvent.getState();
            Events.postEvent((Event)stateChangeEvent);
        } else if ("onCameraUnavailable".equals(cmd)) {
            DOMExceptionEvent event = DOMExceptionEvent.getDOMExceptionEvent((AuRequest)request);
            log.error("Camera unavailable: {} - {}", (Object)event.getErrorName(), (Object)event.getErrorMessage());
            Events.postEvent((Event)event);
        } else {
            super.service(request, everError);
        }
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        Runtime.init((Object)((Object)this));
        if (this._maxsize == 0) {
            this._maxsize = this.getDesktop().getWebApp().getConfiguration().getMaxUploadSize();
        }
        renderer.render("audio", this._audio);
        renderer.render("previewRecord", this._previewRecord);
        this.render(renderer, "maxsize", this._maxsize);
        this.render(renderer, "snapshotFormat", this._snapshotFormat);
        this.render(renderer, "recordFormat", this._recordFormat);
        this.render(renderer, "constraints", this._constraints);
        if (this._lengthLimit != 60) {
            this.render(renderer, "lengthLimit", this._lengthLimit);
        }
    }

    public boolean isStopped() {
        return this._currentState == 0;
    }

    public boolean isPaused() {
        return this._currentState == 2;
    }

    public boolean isRecording() {
        return this._currentState == 1 || this._currentState == 3;
    }

    public void setRecording(boolean recording) {
        if (recording) {
            if (this._currentState == 0) {
                this.start();
            } else if (this._currentState == 2) {
                this.resume();
            }
        } else {
            this.stop();
        }
    }

    public boolean isAudio() {
        return this._audio;
    }

    public void setAudio(boolean audio) {
        if (this._audio != audio) {
            this._audio = audio;
            this.smartUpdate("audio", this._audio);
        }
    }

    public int getMaxsize() {
        return this._maxsize;
    }

    public void setMaxsize(int maxsize) {
        if (maxsize < 0) {
            maxsize = -1;
        }
        if (this._maxsize != maxsize) {
            this._maxsize = maxsize;
            this.setAttribute("org.zkoss.zk.upload.maxsize", maxsize);
            this.smartUpdate("maxsize", this._maxsize);
        }
    }

    public int getLengthLimit() {
        return this._lengthLimit;
    }

    public void setLengthLimit(int lengthLimit) {
        if (this._lengthLimit != lengthLimit) {
            this._lengthLimit = lengthLimit;
            this.smartUpdate("lengthLimit", this._lengthLimit);
        }
    }

    public boolean isPreviewRecord() {
        return this._previewRecord;
    }

    public void setPreviewRecord(boolean previewRecord) {
        if (this._previewRecord != previewRecord) {
            this._previewRecord = previewRecord;
            this.smartUpdate("previewRecord", this._previewRecord);
        }
    }

    public String getSnapshotFormat() {
        return this._snapshotFormat;
    }

    public void setSnapshotFormat(String snapshotFormat) {
        if (snapshotFormat != null && !snapshotFormat.equalsIgnoreCase(this._snapshotFormat)) {
            this._snapshotFormat = snapshotFormat;
            this.smartUpdate("snapshotFormat", this._snapshotFormat);
        }
    }

    public String getRecordFormat() {
        return this._recordFormat;
    }

    public void setRecordFormat(String recordFormat) {
        if (recordFormat != null && !recordFormat.equalsIgnoreCase(this._recordFormat) && (recordFormat.equalsIgnoreCase("video/mp4") || recordFormat.equalsIgnoreCase("video/ogg") || recordFormat.equalsIgnoreCase("video/webm"))) {
            this._recordFormat = recordFormat;
            this.smartUpdate("recordFormat", this._recordFormat);
        }
    }

    public Map getConstraints() {
        return this._constraints;
    }

    public void setConstraints(Map constraints) {
        if (!Objects.equals((Object)this._constraints, (Object)constraints)) {
            this._constraints = constraints;
            this.smartUpdate("constraints", constraints);
        }
    }

    public String getConstraintsString() {
        return JSONObject.toJSONString((Map)this._constraints);
    }

    public void setConstraintsString(String constraints) {
        this.setConstraints(Strings.isEmpty((String)constraints) ? null : (Map)JSONValue.parse((String)constraints));
    }

    static {
        Camera.addClientEvent(Camera.class, (String)"onVideoUpload", (int)0);
        Camera.addClientEvent(Camera.class, (String)"onSnapshotUpload", (int)0);
        Camera.addClientEvent(Camera.class, (String)"onMaxsizeExceed", (int)0);
        Camera.addClientEvent(Camera.class, (String)"onLengthLimitExceed", (int)3);
        Camera.addClientEvent(Camera.class, (String)"onStateChange", (int)3);
        Camera.addClientEvent(Camera.class, (String)"onCameraUnavailable", (int)0);
    }
}

