/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.bind.impl;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.zkoss.lang.Objects;

class SingleObjectSet<T>
extends AbstractSet<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    T _single;

    public SingleObjectSet(T object) {
        this._single = object;
    }

    public SingleObjectSet() {
    }

    @Override
    public boolean add(T object) {
        if (this._single != null) {
            if (!Objects.equals(object, this._single)) {
                throw new IllegalStateException("can only add one element");
            }
            return false;
        }
        this._single = object;
        return true;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int pos = -1;

            @Override
            public boolean hasNext() {
                return this.pos == -1 && SingleObjectSet.this._single != null;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("pos " + (this.pos + 1));
                }
                ++this.pos;
                return SingleObjectSet.this._single;
            }

            @Override
            public void remove() {
                if (this.pos != 0 || SingleObjectSet.this._single == null) {
                    throw new IllegalStateException("pos " + this.pos + ", object " + String.valueOf(SingleObjectSet.this._single));
                }
                SingleObjectSet.this._single = null;
                SingleObjectSet.this.afterIteratorRemoveObject();
            }
        };
    }

    protected void afterIteratorRemoveObject() {
    }

    @Override
    public int size() {
        return this._single == null ? 0 : 1;
    }
}

