/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.zkoss.io.Serializables;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Objects;
import org.zkoss.lang.Strings;
import org.zkoss.util.Converter;
import org.zkoss.xel.VariableResolver;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.OpenEvent;
import org.zkoss.zk.ui.event.SelectEvent;
import org.zkoss.zk.ui.ext.Disable;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zk.ui.sys.DesktopCtrl;
import org.zkoss.zk.ui.sys.ShadowElementsCtrl;
import org.zkoss.zk.ui.util.ComponentCloneListener;
import org.zkoss.zk.ui.util.ForEachStatus;
import org.zkoss.zk.ui.util.Template;
import org.zkoss.zkex.rt.Runtime;
import org.zkoss.zul.ItemRenderer;
import org.zkoss.zul.Label;
import org.zkoss.zul.TreeModel;
import org.zkoss.zul.event.TreeDataEvent;
import org.zkoss.zul.event.TreeDataListener;
import org.zkoss.zul.ext.Selectable;
import org.zkoss.zul.ext.TreeSelectableModel;

public class Cascader<E>
extends HtmlBasedComponent
implements Disable {
    private static final String ATTR_ON_INIT_RENDER_POSTED = "org.zkoss.zul.onInitLaterPosted";
    private transient TreeModel<E> _model;
    private transient TreeDataListener _dataListener;
    private transient ItemRenderer<E> _renderer;
    private transient Converter<Collection<E>, String> _converter;
    private transient boolean _ignoreDataSelectionEvent;
    private String _placeholder;
    private boolean _open;
    private boolean _disabled;
    private transient List<E> _items;
    private transient Map<String, E> _itemIdElementMap;
    private transient Map<E, String> _itemElementIdMap;
    private transient Map<E, String> _itemElementContentMap;
    private static final ItemRenderer<?> DEFAULT_ITEM_RENDERER;
    private static final Converter<Collection<?>, String> DEFAULT_CONVERTER;

    public TreeModel<E> getModel() {
        return this._model;
    }

    private Selectable<E> getSelectableModel() {
        return (Selectable)this._model;
    }

    public void setModel(TreeModel model) {
        if (!(model instanceof TreeSelectableModel)) {
            throw new UiException(String.valueOf(model.getClass()) + " must implement " + String.valueOf(TreeSelectableModel.class));
        }
        if (this._model != model) {
            if (this._model != null) {
                this._model.removeTreeDataListener(this._dataListener);
            }
            this._model = model;
            if (this._model != null) {
                this.initDataListener();
            }
            this.postOnInitRender();
        }
    }

    private void initDataListener() {
        if (this._dataListener == null) {
            this._dataListener = this::onTreeDataChange;
        }
        this._model.addTreeDataListener(this._dataListener);
    }

    private void onTreeDataChange(TreeDataEvent event) {
        switch (event.getType()) {
            case 4: {
                if (!this._ignoreDataSelectionEvent) {
                    this.doSelectionChanged();
                }
                return;
            }
        }
        this.postOnInitRender();
    }

    private void doSelectionChanged() {
        this.updateLabel();
        this.smartUpdate("selectedUuids", this.getSelectedUuids());
    }

    private void prepareData() {
        this.prepareItems(this._model);
    }

    private void prepareItems(TreeModel<E> model) {
        this._items = new ArrayList();
        if (this._model == null) {
            return;
        }
        try {
            ItemRenderer<E> renderer = this.getRealRenderer();
            this.prepareChildren(renderer, model.getRoot());
        }
        catch (Exception e) {
            throw UiException.Aide.wrap((Throwable)e);
        }
        finally {
            this.getChildren().clear();
        }
    }

    private void prepareChildren(ItemRenderer renderer, E node) throws Exception {
        int count = this._model.getChildCount(node);
        for (int i = 0; i < count; ++i) {
            this.prepareChildren0(renderer, this._model.getChild(node, i), i);
        }
    }

    private void prepareChildren0(ItemRenderer<E> renderer, E node, int i) throws Exception {
        String content = renderer.render((Component)this, node, i);
        this.getItemElementContentMap().put(node, content);
        this._items.add(node);
        if (node != null && this._model.getChildCount(node) != 0) {
            this.prepareChildren(renderer, node);
        }
    }

    private void postOnInitRender() {
        if (this.getAttribute(ATTR_ON_INIT_RENDER_POSTED) == null) {
            this.setAttribute(ATTR_ON_INIT_RENDER_POSTED, Boolean.TRUE);
            Events.postEvent((String)"onInitRender", (Component)this, null);
        }
    }

    public void onInitRender() {
        this.removeAttribute(ATTR_ON_INIT_RENDER_POSTED);
        this.resetItems();
        this.prepareData();
        this.updateLabel();
        this.smartUpdate("items", this.encloseItems(this.getItems()));
        this.smartUpdate("selectedUuids", this.getSelectedUuids());
        Events.postEvent((String)"onAfterRender", (Component)this, null);
    }

    private ItemRenderer<E> getRealRenderer() {
        return this._renderer != null ? this._renderer : DEFAULT_ITEM_RENDERER;
    }

    public ItemRenderer<E> getItemRenderer() {
        return this._renderer;
    }

    public void setItemRenderer(ItemRenderer<E> renderer) {
        if (this._renderer != renderer) {
            this._renderer = renderer;
            this.invalidate();
        }
    }

    public void setItemRenderer(String clsnm) throws ReflectiveOperationException {
        if (clsnm != null) {
            this.setItemRenderer((ItemRenderer)Classes.newInstanceByThread((String)clsnm));
        }
    }

    public Converter<Collection<E>, String> getItemConverter() {
        return this._converter;
    }

    public void setItemConverter(Converter<Collection<E>, String> converter) {
        if (this._converter != converter) {
            this._converter = converter;
            this.updateLabel();
        }
    }

    public void setItemConverter(String clsnm) throws ReflectiveOperationException {
        if (clsnm != null) {
            this.setItemConverter((Converter)Classes.newInstanceByThread((String)clsnm));
        }
    }

    private void updateLabel() {
        this.smartUpdate("label", this.getLabel());
    }

    private String getLabel() {
        String label = "";
        Set<E> selectedItems = this.getSelectedItems();
        if (selectedItems.size() > 0) {
            label = this._converter != null ? (String)this._converter.convert(selectedItems) : (String)DEFAULT_CONVERTER.convert(selectedItems);
        }
        return label;
    }

    public String getPlaceholder() {
        return this._placeholder;
    }

    public void setPlaceholder(String placeholder) {
        if (!Objects.equals((Object)this._placeholder, (Object)placeholder)) {
            this._placeholder = placeholder;
            this.smartUpdate("placeholder", this._placeholder);
        }
    }

    public boolean isOpen() {
        return this._open;
    }

    public void setOpen(boolean open) {
        if (this._open != open) {
            this._open = open;
            this.smartUpdate("open", this._open);
        }
    }

    public boolean isDisabled() {
        return this._disabled;
    }

    public void setDisabled(boolean disabled) {
        if (this._disabled != disabled) {
            this._disabled = disabled;
            this.smartUpdate("disabled", this._disabled);
        }
    }

    public Set<E> getSelectedItems() {
        Set emptySet = Collections.emptySet();
        if (this._model == null) {
            return emptySet;
        }
        E selectedItem = this.getSelectedItem();
        if (selectedItem == null) {
            return emptySet;
        }
        LinkedHashSet<Object> selectionItems = new LinkedHashSet<Object>();
        int[] path = this._model.getPath(selectedItem);
        Object node = this._model.getRoot();
        for (int index : path) {
            node = this._model.getChild(node, index);
            selectionItems.add(node);
        }
        return selectionItems;
    }

    public E getSelectedItem() {
        if (this._model == null) {
            return null;
        }
        Set selectedItems = this.getSelectableModel().getSelection();
        return selectedItems.isEmpty() ? null : (E)selectedItems.iterator().next();
    }

    public void setSelectedItem(E item) {
        Selectable<E> smodel;
        if (item != this.getSelectedItem() && (smodel = this.getSelectableModel()) != null) {
            smodel.setSelection(Collections.singleton(item));
        }
    }

    private List<String> getSelectedUuids() {
        E selectedItem = this.getSelectedItem();
        if (selectedItem == null) {
            return Collections.emptyList();
        }
        ArrayList<String> uuidList = new ArrayList<String>();
        int[] path = this._model.getPath(selectedItem);
        Object node = this._model.getRoot();
        Map<E, String> itemElementIdMap = this.getItemElementIdMap();
        for (int index : path) {
            node = this._model.getChild(node, index);
            uuidList.add(itemElementIdMap.get(node));
        }
        return uuidList;
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        Runtime.init((Object)((Object)this));
        super.renderProperties(renderer);
        this.render(renderer, "placeholder", this._placeholder);
        this.render(renderer, "open", this._open);
        this.render(renderer, "disabled", this._disabled);
        this.render(renderer, "items", this.encloseItems(this.getItems()));
        this.render(renderer, "label", this.getLabel());
        this.render(renderer, "selectedUuids", this.getSelectedUuids());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        Map data = request.getData();
        switch (cmd) {
            case "onOpen": {
                OpenEvent evt = OpenEvent.getOpenEvent((AuRequest)request);
                this._open = evt.isOpen();
                Events.postEvent((Event)evt);
                break;
            }
            case "onSelect": {
                String selectedUuid = (String)data.get("selectedUuid");
                Selectable<E> smodel = this.getSelectableModel();
                Set prevSelection = smodel.getSelection();
                boolean oldIDSE = this._ignoreDataSelectionEvent;
                this._ignoreDataSelectionEvent = true;
                try {
                    smodel.clearSelection();
                    if (!Strings.isEmpty((String)selectedUuid)) {
                        smodel.addToSelection(this.getItemElementById(selectedUuid));
                    }
                }
                finally {
                    this._ignoreDataSelectionEvent = oldIDSE;
                }
                Set selection = smodel.getSelection();
                Events.postEvent((Event)new SelectEvent("onSelect", (Component)this, null, null, null, selection, prevSelection, this.collectUnselectedObjects(prevSelection, selection), null, null, 0));
                this.updateLabel();
                break;
            }
            default: {
                super.service(request, everError);
            }
        }
    }

    private Set<E> collectUnselectedObjects(Set<E> previousSelection, Set<E> currentSelection) {
        LinkedHashSet<E> prevSelectedItems = new LinkedHashSet<E>(previousSelection);
        if (currentSelection != null && prevSelectedItems.size() > 0) {
            prevSelectedItems.removeAll(currentSelection);
        }
        return prevSelectedItems;
    }

    public void onPageAttached(Page newpage, Page oldpage) {
        super.onPageAttached(newpage, oldpage);
        if (this._model != null) {
            this.postOnInitRender();
            if (this._dataListener != null) {
                this._model.removeTreeDataListener(this._dataListener);
                this._model.addTreeDataListener(this._dataListener);
            }
        }
    }

    public void onPageDetached(Page page) {
        super.onPageDetached(page);
        if (this._model != null && this._dataListener != null) {
            this._model.removeTreeDataListener(this._dataListener);
        }
    }

    public void invalidate() {
        if (this._model != null && !this.getSelectableModel().isSelectionEmpty()) {
            this.postOnInitRender();
        } else {
            super.invalidate();
        }
    }

    public Object clone() {
        Cascader clone = (Cascader)((Object)super.clone());
        if (clone._model != null) {
            TreeModel model;
            if (clone._model instanceof ComponentCloneListener && (model = (TreeModel)((ComponentCloneListener)clone._model).willClone((Component)clone)) != null) {
                clone._model = model;
            }
            clone.postOnInitRender();
            clone._dataListener = null;
            clone.initDataListener();
        }
        return clone;
    }

    private Map<String, E> getItemIdElementMap() {
        if (this._itemIdElementMap == null) {
            this._itemIdElementMap = new HashMap<String, E>();
        }
        return this._itemIdElementMap;
    }

    private Map<E, String> getItemElementContentMap() {
        if (this._itemElementContentMap == null) {
            this._itemElementContentMap = new HashMap<E, String>();
        }
        return this._itemElementContentMap;
    }

    private Map<E, String> getItemElementIdMap() {
        if (this._itemElementIdMap == null) {
            this._itemElementIdMap = new HashMap<E, String>();
        }
        return this._itemElementIdMap;
    }

    private String getItemIdByElement(E element, boolean autoCreate) {
        String uuid = this.getItemElementIdMap().get(element);
        DesktopCtrl dc = (DesktopCtrl)this.getDesktop();
        if (uuid == null && autoCreate && dc != null) {
            uuid = dc.getNextUuid((Component)this);
            this.getItemIdElementMap().put(uuid, element);
            this.getItemElementIdMap().put(element, uuid);
        }
        return uuid;
    }

    private E getItemElementById(String uuid) {
        return this.getItemIdElementMap().get(uuid);
    }

    private String getItemContentByElement(E element) {
        return this.getItemElementContentMap().get(element);
    }

    private List<E> getItems() {
        if (this._items == null) {
            this._items = new ArrayList();
        }
        return this._items;
    }

    private void resetItems() {
        this._itemElementContentMap = null;
        this._itemIdElementMap = null;
        this._itemElementIdMap = null;
        this._items = null;
    }

    private List<Map<String, String>> encloseItems(List<E> items) {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        if (items != null) {
            for (E item : items) {
                HashMap<String, String> map = new HashMap<String, String>(3);
                int[] path = this._model.getPath(item);
                String parentId = null;
                int length = path.length;
                if (length > 1) {
                    parentId = this.getItemIdByElement(this._model.getChild(Arrays.copyOfRange(path, 0, length - 1)), true);
                }
                map.put("parentId", parentId);
                map.put("id", this.getItemIdByElement(item, true));
                map.put("content", this.getItemContentByElement(item));
                result.add(map);
            }
        }
        return result;
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        this.willSerialize(this._model);
        Serializables.smartWrite((ObjectOutputStream)s, this._model);
        this.willSerialize(this._renderer);
        Serializables.smartWrite((ObjectOutputStream)s, this._renderer);
        this.willSerialize(this._converter);
        Serializables.smartWrite((ObjectOutputStream)s, this._converter);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this._model = (TreeModel)s.readObject();
        this.didDeserialize(this._model);
        this._renderer = (ItemRenderer)s.readObject();
        this.didDeserialize(this._renderer);
        this._converter = (Converter)s.readObject();
        this.didDeserialize(this._converter);
        if (this._model != null) {
            this.initDataListener();
        }
        this.onInitRender();
    }

    public void sessionWillPassivate(Page page) {
        super.sessionWillPassivate(page);
        this.willPassivate(this._model);
        this.willPassivate(this._renderer);
        this.willPassivate(this._converter);
    }

    public void sessionDidActivate(Page page) {
        super.sessionDidActivate(page);
        this.didActivate(this._model);
        this.didActivate(this._renderer);
        this.didActivate(this._converter);
        if (this._model != null) {
            this.postOnInitRender();
        }
    }

    public String getZclass() {
        return this._zclass != null ? this._zclass : "z-cascader";
    }

    static {
        Cascader.addClientEvent(Cascader.class, (String)"onOpen", (int)8193);
        Cascader.addClientEvent(Cascader.class, (String)"onSelect", (int)3);
        Cascader.addClientEvent(Cascader.class, (String)"onFocus", (int)8192);
        Cascader.addClientEvent(Cascader.class, (String)"onBlur", (int)8192);
        DEFAULT_ITEM_RENDERER = new ItemRenderer(){

            public String render(Component owner, final Object node, final int index) {
                Template tm = owner.getTemplate("model");
                if (tm == null) {
                    return Objects.toString((Object)node);
                }
                Component[] items = ShadowElementsCtrl.filterOutShadows((Component[])tm.create(owner, null, new VariableResolver(){

                    public Object resolveVariable(String name) {
                        if ("each".equals(name)) {
                            return node;
                        }
                        if ("forEachStatus".equals(name)) {
                            return new ForEachStatus(){

                                public ForEachStatus getPrevious() {
                                    return null;
                                }

                                public Object getEach() {
                                    return this.getCurrent();
                                }

                                public int getIndex() {
                                    return index;
                                }

                                public Integer getBegin() {
                                    return 0;
                                }

                                public Integer getEnd() {
                                    throw new UnsupportedOperationException("end not available");
                                }

                                public Object getCurrent() {
                                    return node;
                                }

                                public boolean isFirst() {
                                    return this.getCount() == 1;
                                }

                                public boolean isLast() {
                                    return this.getIndex() + 1 == this.getEnd();
                                }

                                public Integer getStep() {
                                    return null;
                                }

                                public int getCount() {
                                    return this.getIndex() + 1;
                                }
                            };
                        }
                        return null;
                    }
                }, null));
                if (items.length != 1) {
                    throw new UiException("The model template must have exactly one item, not " + items.length);
                }
                return ((Label)items[0]).getValue();
            }
        };
        DEFAULT_CONVERTER = obj -> obj.stream().map(Object::toString).collect(Collectors.joining("/"));
    }
}

