/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.ui.comet;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRegistration;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.http.ExecutionImpl;
import org.zkoss.zk.ui.http.I18Ns;
import org.zkoss.zk.ui.http.WebManager;
import org.zkoss.zk.ui.sys.DesktopCtrl;
import org.zkoss.zk.ui.sys.ServerPush;
import org.zkoss.zk.ui.sys.SessionCtrl;
import org.zkoss.zk.ui.sys.SessionsCtrl;
import org.zkoss.zk.ui.sys.WebAppCtrl;
import org.zkoss.zkex.ui.comet.CometServerPush;
import org.zkoss.zkmax.ui.comet.CometServerPush;

public class CometAsyncServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(CometAsyncServlet.class);
    private static final String ATTR_INSTALLED = "org.zkoss.zkmax.ui.comet.async.installed";

    public static void install(ServletContext ctx) {
        if (!CometAsyncServlet.isInstalled(ctx)) {
            log.debug("Installing CometAsyncServlet...");
            ServletRegistration.Dynamic dn = ctx.addServlet("CometAsyncServlet", CometAsyncServlet.class);
            dn.setAsyncSupported(true);
            dn.addMapping(new String[]{"/zkcomet/*"});
            ctx.setAttribute(ATTR_INSTALLED, (Object)true);
        }
    }

    public static boolean isInstalled(ServletContext ctx) {
        Object o = ctx.getAttribute(ATTR_INSTALLED);
        return o instanceof Boolean && (Boolean)o != false;
    }

    public void init() throws ServletException {
        this.getServletContext().setAttribute(ATTR_INSTALLED, (Object)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Session sess = this.getSession(request);
        if (sess == null) {
            response.setIntHeader("ZK-Error", 410);
            return;
        }
        SessionCtrl sessCtrl = (SessionCtrl)sess;
        sessCtrl.notifyClientRequest(false);
        String dtid = request.getParameter("dtid");
        if (dtid == null || dtid.length() == 0) {
            response.setHeader("ZK-Comet-Error", "DesktopID");
            return;
        }
        Desktop desktop = ((WebAppCtrl)sess.getWebApp()).getDesktopCache(sess).getDesktopIfAny(dtid);
        if (desktop == null) {
            response.setHeader("ZK-Comet-Error", "DesktopUnavailable");
            return;
        }
        WebManager.setDesktop((HttpServletRequest)request, (Desktop)desktop);
        DesktopCtrl desktopCtrl = (DesktopCtrl)desktop;
        ServerPush sp = desktopCtrl.getServerPush();
        if (!(sp instanceof CometServerPush)) {
            response.setHeader("ZK-Comet-Error", "Disabled");
            return;
        }
        CometServerPush cmsp = (CometServerPush)sp;
        if (cmsp.setBusy()) {
            response.setHeader("ZK-Comet-Error", "Busy");
            return;
        }
        Object old = I18Ns.setup((Session)sess, (ServletRequest)request, (ServletResponse)response, (String)"UTF-8");
        try {
            AsyncContext actx = request.startAsync((ServletRequest)request, (ServletResponse)response);
            actx.setTimeout(0L);
            ExecutionImpl exec = new ExecutionImpl(this.getServletContext(), (HttpServletRequest)actx.getRequest(), (HttpServletResponse)actx.getResponse(), desktop, null);
            ((CometServerPush)sp).processRequest((Execution)exec, new AsyncInfo(actx, desktop));
        }
        finally {
            I18Ns.cleanup((ServletRequest)request, (Object)old);
        }
        if (sessCtrl.isInvalidated()) {
            sessCtrl.invalidateNow();
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    private Session getSession(HttpServletRequest request) {
        HttpSession hsess;
        WebApp wapp = WebManager.getWebAppIfAny((ServletContext)this.getServletContext());
        if (wapp != null && (hsess = request.getSession(false)) != null) {
            return SessionsCtrl.getSession((WebApp)wapp, (Object)hsess);
        }
        return null;
    }

    private class AsyncInfo
    implements CometServerPush.AsyncInfo {
        private final AsyncContext _actx;
        private final Desktop _desktop;

        private AsyncInfo(AsyncContext actx, Desktop desktop) {
            this._actx = actx;
            this._desktop = desktop;
        }

        public void complete() {
            DesktopCtrl desktopCtrl = (DesktopCtrl)this._desktop;
            if (desktopCtrl.piggyResponse(null, false) != null || desktopCtrl.scheduledServerPush()) {
                ((HttpServletResponse)this._actx.getResponse()).setHeader("ZK-Comet", "echo");
            }
            try {
                this._actx.complete();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }
}

