/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.init;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.util.DesktopInit;
import org.zkoss.zk.ui.util.ExecutionCleanup;
import org.zkoss.zk.ui.util.ExecutionInit;
import org.zkoss.zkmax.zul.impl.EmbeddedPageRenderer;

public class EmbeddedDesktopInit
implements DesktopInit {
    public void init(Desktop desktop, Object request) throws Exception {
        HttpServletRequest hsRequest;
        String token;
        if (request instanceof HttpServletRequest && (token = (hsRequest = (HttpServletRequest)request).getParameter("_zEmbeddedID_")) != null) {
            Object zkHostURL = "";
            String zEmbeddedAbsURL = hsRequest.getParameter("_zEmbeddedAbsURL_");
            if (zEmbeddedAbsURL != null) {
                if (zEmbeddedAbsURL.equals("$fromZKEmbeddedScriptSrc$")) {
                    zkHostURL = hsRequest.getScheme() + "://" + hsRequest.getServerName();
                    int serverPort = hsRequest.getServerPort();
                    if (serverPort != 80 && serverPort != 443) {
                        zkHostURL = (String)zkHostURL + ":" + serverPort;
                    }
                } else {
                    if (zEmbeddedAbsURL.endsWith("/")) {
                        zEmbeddedAbsURL = zEmbeddedAbsURL.substring(0, zEmbeddedAbsURL.length() - 1);
                    }
                    zkHostURL = zEmbeddedAbsURL;
                }
                desktop.setAttribute("org.zkoss.desktop.auHost", zkHostURL);
            }
            desktop.addListener((Object)new EmbeddedExecutionHandler(token, (String)zkHostURL));
        }
    }

    private static class EmbeddedExecutionHandler
    implements ExecutionInit,
    ExecutionCleanup {
        private final String _domId;
        private final String _zkHostURL;

        EmbeddedExecutionHandler(String domId, String zkHostURL) {
            this._domId = domId;
            this._zkHostURL = zkHostURL;
        }

        public void init(Execution exec, Execution parent) throws Exception {
            exec.setAttribute("org.zkoss.zk.ui.page.renderer", (Object)new EmbeddedPageRenderer(this._domId, this._zkHostURL));
        }

        public void cleanup(Execution exec, Execution parent, List<Throwable> errs) throws Exception {
            exec.removeAttribute("org.zkoss.zk.ui.page.renderer");
        }
    }
}

