/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.zul;

import java.util.Set;
import org.zkoss.zkmax.zul.StepModel;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.ListModelList;

public class DefaultStepModel<E>
implements StepModel<E> {
    private final ListModelList<E> _steps;

    public DefaultStepModel() {
        this._steps = new ListModelList();
    }

    public DefaultStepModel(ListModelList<E> steps) {
        this._steps = steps;
    }

    @Override
    public boolean back() {
        if (this.getActiveIndex() == 0) {
            return false;
        }
        this.setActiveIndex(this.getActiveIndex() - 1);
        return true;
    }

    @Override
    public boolean next() {
        int size = this._steps.getSize();
        if (this.getActiveIndex() == size - 1) {
            return false;
        }
        this.setActiveIndex(this.getActiveIndex() + 1);
        return true;
    }

    @Override
    public int getActiveIndex() {
        return this._steps.indexOf(this.getActiveStep());
    }

    @Override
    public E getActiveStep() {
        Set selection = this._steps.getSelection();
        if (selection.size() == 0 && this._steps.getSize() > 0) {
            this._steps.addToSelection(this._steps.getElementAt(0));
        }
        return this._steps.getSelection().iterator().next();
    }

    @Override
    public void setActiveIndex(int index) {
        if (index < 0 || index > this._steps.getSize() - 1) {
            return;
        }
        this._steps.addToSelection(this._steps.getElementAt(index));
    }

    @Override
    public void setActiveStep(E item) {
        this._steps.addToSelection(item);
    }

    @Override
    public void add(E item) {
        this._steps.add(item);
    }

    @Override
    public void add(int index, E item) {
        this._steps.add(index, item);
    }

    @Override
    public E remove(int index) {
        return (E)this._steps.remove(index);
    }

    @Override
    public boolean remove(E item) {
        return this._steps.remove(item);
    }

    @Override
    public ListModel<E> getSteps() {
        return this._steps;
    }

    @Override
    public int size() {
        return this._steps.getSize();
    }
}

