/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.bind.impl;

import org.zkoss.bind.BindContext;
import org.zkoss.bind.sys.ConditionType;
import org.zkoss.bind.sys.FormBinding;
import org.zkoss.bind.xel.zel.BindELContext;
import org.zkoss.bind.xel.zel.BindELResolver;
import org.zkoss.bind.xel.zel.DynamicPropertiedELResolver;
import org.zkoss.bind.xel.zel.FormELResolver;
import org.zkoss.bind.xel.zel.ImplicitObjectELResolver;
import org.zkoss.bind.xel.zel.ListModelELResolver;
import org.zkoss.bind.xel.zel.PathELResolver;
import org.zkoss.bind.xel.zel.TreeModelELResolver;
import org.zkoss.bind.xel.zel.ValidationMessagesELResolver;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Library;
import org.zkoss.xel.XelContext;
import org.zkoss.zel.CompositeELResolver;
import org.zkoss.zel.ELContext;
import org.zkoss.zel.ELResolver;
import org.zkoss.zel.impl.lang.EvaluationContext;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zkmax.bind.impl.BindExpressionBuilderEx;
import org.zkoss.zkmax.bind.impl.ValueExpressionImplEx;

public class BindELResolverEx
extends BindELResolver {
    private static final FormELResolver FORM_EL_RESOLVER = new FormELResolver();
    private static final ListModelELResolver LIST_MODEL_EL_RESOLVER = new ListModelELResolver();
    private static final TreeModelELResolver TREE_MODEL_EL_RESOLVER = new TreeModelELResolver();
    private static final ValidationMessagesELResolver VALIDATION_MESSAGES_EL_RESOLVER = new ValidationMessagesELResolver();
    private static final ImplicitObjectELResolver IMPLICIT_OBJECT_EL_RESOLVER = new ImplicitObjectELResolver();
    private static final DynamicPropertiedELResolver DYNAMIC_PROPERTIED_EL_RESOLVER = new DynamicPropertiedELResolver();
    private static ELResolver DEFAULT;

    public BindELResolverEx(XelContext ctx) {
        super(ctx);
    }

    protected void init() {
    }

    private void checkResolver() {
        if (this._resolver == null) {
            this._resolver = new CompositeELResolver();
            if (this._pathResolver == null) {
                this._pathResolver = new PathELResolver();
                this._resolver.add((ELResolver)this._pathResolver);
            } else {
                this._resolver.add((ELResolver)this._pathResolver);
            }
            this._resolver.add((ELResolver)FORM_EL_RESOLVER);
            this._resolver.add((ELResolver)LIST_MODEL_EL_RESOLVER);
            this._resolver.add((ELResolver)TREE_MODEL_EL_RESOLVER);
            this._resolver.add((ELResolver)VALIDATION_MESSAGES_EL_RESOLVER);
            this._resolver.add((ELResolver)this.getImplicitResolver());
            this._resolver.add((ELResolver)DYNAMIC_PROPERTIED_EL_RESOLVER);
            this._resolver.add(this.getSuperELResolver());
        }
    }

    protected ImplicitObjectELResolver getImplicitResolver() {
        return IMPLICIT_OBJECT_EL_RESOLVER;
    }

    protected ELResolver getSuperELResolver() {
        if (DEFAULT != null) {
            return DEFAULT;
        }
        return super.getSuperELResolver();
    }

    protected ELResolver getELResolver() {
        this.checkResolver();
        return this._resolver;
    }

    private String getConditionString(BindContext ctx, FormBinding binding) {
        StringBuilder condition = new StringBuilder();
        if (binding.getConditionType() == ConditionType.BEFORE_COMMAND) {
            condition.append("before = '").append(binding.getCommandName()).append("'");
        } else if (binding.getConditionType() == ConditionType.AFTER_COMMAND) {
            condition.append("after = '").append(binding.getCommandName()).append("'");
        } else {
            condition.append((String)(ctx.getTriggerEvent() == null ? "" : "event = " + ctx.getTriggerEvent().getName()));
        }
        return condition.length() == 0 ? null : condition.toString();
    }

    protected void tieValue(ELContext elCtx, Object base, Object property, Object value, boolean allownotify) {
        ELContext ec = ((EvaluationContext)elCtx).getELContext();
        BindELContext ctx = ec instanceof BindELContext ? (BindELContext)ec : (BindELContext)((EvaluationContext)ec).getELContext();
        BindExpressionBuilderEx builder = (BindExpressionBuilderEx)((Object)ctx.removeAttribute(ValueExpressionImplEx.ATTR_KEY));
        if (builder != null && !ctx.ignoreTracker()) {
            builder.buildTrackerNode(value);
        }
        super.tieValue(elCtx, base, property, value, allownotify);
    }

    static {
        String property = Library.getProperty((String)"org.zkoss.zkmax.zel.ELResolver.class");
        if (property != null) {
            try {
                Object o = Classes.newInstanceByThread((String)property);
                DEFAULT = (ELResolver)o;
            }
            catch (Exception e) {
                throw UiException.Aide.wrap((Throwable)e);
            }
        }
    }
}

