/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.zul.impl;

import java.util.LinkedList;
import java.util.List;
import org.zkoss.zul.AbstractTreeModel;
import org.zkoss.zul.ext.SelectionControl;

public class DefaultTreeSelectionControlEx<E>
implements SelectionControl<E> {
    private AbstractTreeModel<E> model;

    public DefaultTreeSelectionControlEx(AbstractTreeModel<E> model) {
        this.model = model;
    }

    public boolean isSelectable(E e) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectAll(boolean selectAll) {
        if (selectAll) {
            LinkedList<E> all = new LinkedList<E>();
            List<E> allNodes = this.getAllNodes();
            for (E o : allNodes) {
                if (!this.isSelectable(o)) continue;
                all.add(o);
            }
            this.model.fireEvent(11, null, -1, -1);
            try {
                this.model.setSelection(all);
            }
            finally {
                this.model.fireEvent(12, null, -1, -1);
            }
        } else {
            this.model.clearSelection();
        }
    }

    protected List<E> getAllNodes() {
        Object root = this.model.getRoot();
        LinkedList all = new LinkedList();
        if (root != null) {
            this.getChildNodes(all, root);
        }
        return all;
    }

    private void getChildNodes(List<E> all, E parent) {
        int j = this.model.getChildCount(parent);
        for (int i = 0; i < j; ++i) {
            Object child = this.model.getChild(parent, i);
            if (child == null) continue;
            all.add(child);
            this.getChildNodes(all, child);
        }
    }

    public boolean isSelectAll() {
        Object root = this.model.getRoot();
        boolean result = false;
        if (root != null) {
            result = !this.hasUnSelectedNode(root);
        }
        return result;
    }

    private boolean hasUnSelectedNode(E root) {
        LinkedList<E> nodeDeque = new LinkedList<E>();
        E node = root;
        nodeDeque.add(node);
        while (!nodeDeque.isEmpty()) {
            node = nodeDeque.pop();
            if (node != this.model.getRoot() && this.isSelectable(node) && !this.model.isSelected(node)) {
                return true;
            }
            nodeDeque.addAll(this.getChildrenNodes(node));
        }
        return false;
    }

    protected List<E> getChildrenNodes(E parent) {
        LinkedList<Object> result = new LinkedList<Object>();
        int j = this.model.getChildCount(parent);
        for (int i = 0; i < j; ++i) {
            Object child = this.model.getChild(parent, i);
            if (child == null) continue;
            result.add(child);
        }
        return result;
    }
}

