/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.zul;

import java.io.IOException;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.lang.Objects;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.SelectEvent;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zkex.rt.Runtime;
import org.zkoss.zkmax.zul.Nav;
import org.zkoss.zkmax.zul.Navitem;
import org.zkoss.zkmax.zul.Navseparator;
import org.zkoss.zul.impl.XulElement;

public class Navbar
extends XulElement {
    private static final Logger log = LoggerFactory.getLogger(Navbar.class);
    private boolean _collapsed = false;
    private String _orient = "horizontal";
    private Navitem _sel;
    private boolean _autoclose = true;

    public Navbar() {
    }

    public Navbar(String orient) {
        this();
        this.setOrient(orient);
    }

    public String getOrient() {
        return this._orient;
    }

    public void setOrient(String orient) throws WrongValueException {
        if (!"horizontal".equals(orient) && !"vertical".equals(orient)) {
            throw new WrongValueException("orient cannot be " + orient);
        }
        if (!Objects.equals((Object)this._orient, (Object)orient)) {
            this._orient = orient;
            this.smartUpdate("orient", this._orient);
        }
    }

    public boolean isHorizontal() {
        return "horizontal".equals(this.getOrient());
    }

    public boolean isVertical() {
        return "vertical".equals(this.getOrient());
    }

    public boolean isCollapsed() {
        return this._collapsed;
    }

    public void setCollapsed(boolean collapsed) {
        if (this._collapsed != collapsed) {
            this._collapsed = collapsed;
            this.smartUpdate("collapsed", this._collapsed);
        }
    }

    public boolean isAutoclose() {
        return this._autoclose;
    }

    public void setAutoclose(boolean autoclose) {
        if (this._autoclose != autoclose) {
            this._autoclose = autoclose;
            this.smartUpdate("autoclose", autoclose);
        }
    }

    public void setSelectedItem(Navitem item) {
        this.selectItem(item);
    }

    public Navitem getSelectedItem() {
        return this._sel;
    }

    public void clearSelection() {
        if (this._sel != null) {
            this._sel.setSelectedDirectly(false);
            this._sel = null;
            this.smartUpdate("selectedItem", null);
        }
    }

    public void selectItem(Navitem item) {
        if (item == null) {
            this.clearSelection();
        } else {
            if (item.getNavbar() != this) {
                throw new UiException("Not a child: " + String.valueOf((Object)item));
            }
            if (this._sel == null) {
                this._sel = item;
                item.setSelectedDirectly(true);
                this.smartUpdate("selectedItem", (Object)item);
            } else if (!((Object)((Object)this._sel)).equals((Object)item)) {
                this._sel.setSelectedDirectly(false);
                this._sel = item;
                item.setSelectedDirectly(true);
                this.smartUpdate("selectedItem", (Object)item);
            }
        }
    }

    public String getZclass() {
        return this._zclass == null ? "z-navbar" : this._zclass;
    }

    public void beforeChildAdded(Component child, Component refChild) {
        if (!(child instanceof Navitem || child instanceof Nav || child instanceof Navseparator)) {
            throw new UiException("Unsupported child for navbar: " + String.valueOf(child));
        }
        super.beforeChildAdded(child, refChild);
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        Runtime.init((Object)((Object)this));
        super.renderProperties(renderer);
        if (!"horizontal".equals(this.getOrient())) {
            this.render(renderer, "orient", this._orient);
        }
        if (this.isCollapsed()) {
            this.render(renderer, "collapsed", this._collapsed);
        }
        if (!this.isAutoclose()) {
            renderer.render("autoclose", false);
        }
        if (this._sel != null) {
            this.render(renderer, "selectedItem", (Object)this._sel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        if (cmd.equals("onSelect")) {
            SelectEvent evt = SelectEvent.getSelectEvent((AuRequest)request);
            Set items = evt.getSelectedItems();
            if (!items.contains((Object)this._sel)) {
                try {
                    this.disableClientUpdate(true);
                    this.setSelectedItem((Navitem)((Object)items.iterator().next()));
                    Events.postEvent((Event)evt);
                }
                finally {
                    this.disableClientUpdate(false);
                }
            }
        } else {
            super.service(request, everError);
        }
    }

    static {
        Navbar.addClientEvent(Navbar.class, (String)"onSelect", (int)8193);
    }
}

