/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.zul;

import java.io.IOException;
import org.zkoss.lang.Objects;
import org.zkoss.lang.Strings;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.MouseEvent;
import org.zkoss.zk.ui.event.OpenEvent;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zkex.rt.Runtime;
import org.zkoss.zul.impl.XulElement;

public class Coachmark
extends XulElement {
    private String _target;
    private String _position = "after_center";
    private String _next;

    public String getTarget() {
        return this._target;
    }

    public void setTarget(String id) {
        if (Objects.equals((Object)id, (Object)this.getId()) || Objects.equals((Object)id, (Object)this.getUuidExpr(this.getUuid()))) {
            throw new WrongValueException("The target Coackmark should not be the coachmark it self.");
        }
        if (!Objects.equals((Object)this._target, (Object)id)) {
            this._target = id;
            this.smartUpdate("target", this._target);
        }
    }

    public void setTarget(Component comp) {
        if (comp == this) {
            throw new WrongValueException("The target Coackmark should not be the coachmark it self.");
        }
        this.setTarget(comp != null ? this.getUuidExpr(comp.getUuid()) : "");
    }

    public String getPosition() {
        return this._position;
    }

    public void setPosition(String position) {
        if (!position.matches("^(?:before|after)_(?:start|center|end)$") && !position.matches("^(?:start|end)_(?:before|center|after)$")) {
            throw new WrongValueException("position: " + position);
        }
        if (!Objects.equals((Object)this._position, (Object)position)) {
            this._position = position;
            this.smartUpdate("position", this._position);
        }
    }

    public String getNext() {
        return this._next;
    }

    public void setNext(String coachmarkId) {
        if (Objects.equals((Object)coachmarkId, (Object)this.getId()) || Objects.equals((Object)coachmarkId, (Object)this.getUuidExpr(this.getUuid()))) {
            throw new WrongValueException("The next Coackmark should not be the coachmark it self.");
        }
        if (!Objects.equals((Object)this._next, (Object)coachmarkId)) {
            this._next = coachmarkId;
        }
    }

    public void setNext(Coachmark coachmark) {
        if (coachmark == this) {
            throw new WrongValueException("The next Coackmark should not be the coachmark it self.");
        }
        this.setNext(coachmark != null ? this.getUuidExpr(coachmark.getUuid()) : "");
    }

    public Coachmark getNextCoachmark() {
        return (Coachmark)this.getFellow(this._next, true);
    }

    public void open() {
        this.setVisible(true);
    }

    public void close() {
        this.setVisible(false);
    }

    public void next() {
        this.close();
        if (!Strings.isEmpty((String)this._next)) {
            this.getNextCoachmark().open();
        }
    }

    public void next(Coachmark coachmark) {
        this.close();
        if (coachmark != null) {
            coachmark.open();
        }
    }

    private String getUuidExpr(String uuid) {
        return "uuid(" + uuid + ")";
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        Runtime.init((Object)((Object)this));
        super.renderProperties(renderer);
        this.render(renderer, "target", this._target);
        if (!"after_center".equals(this._position)) {
            this.render(renderer, "position", this._position);
        }
    }

    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        if ("onTargetClick".equals(cmd)) {
            this.next();
            Events.postEvent((Event)MouseEvent.getMouseEvent((AuRequest)request));
        } else if ("onOpen".equals(cmd)) {
            OpenEvent evt = OpenEvent.getOpenEvent((AuRequest)request);
            this.setVisibleDirectly(evt.isOpen());
            Events.postEvent((Event)evt);
        } else {
            super.service(request, everError);
        }
    }

    static {
        Coachmark.addClientEvent(Coachmark.class, (String)"onTargetClick", (int)16385);
        Coachmark.addClientEvent(Coachmark.class, (String)"onOpen", (int)8193);
    }
}

