/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.bind.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.zkoss.lang.Objects;
import org.zkoss.zkmax.bind.impl.SingleObjectSet;

class SingleObjectMap<K, V>
implements Map<K, V>,
Serializable {
    private static final long serialVersionUID = 1L;
    K _singleKey;
    V _singleValue;

    SingleObjectMap() {
    }

    @Override
    public int size() {
        return this._singleKey == null ? 0 : 1;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return Objects.equals((Object)key, this._singleKey);
    }

    @Override
    public boolean containsValue(Object value) {
        return Objects.equals((Object)value, this._singleValue);
    }

    @Override
    public V get(Object key) {
        return Objects.equals((Object)key, this._singleKey) ? (V)this._singleValue : null;
    }

    @Override
    public V put(K key, V value) {
        if (this._singleKey != null && !Objects.equals(key, this._singleKey)) {
            throw new IllegalStateException("can only put one element");
        }
        this._singleKey = key;
        V old = this._singleValue;
        this._singleValue = value;
        return old;
    }

    @Override
    public V remove(Object key) {
        V old = this._singleValue;
        if (Objects.equals((Object)key, this._singleKey)) {
            this._singleKey = null;
            this._singleValue = null;
        }
        return old;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public void clear() {
        this._singleKey = null;
        this._singleValue = null;
    }

    @Override
    public Set<K> keySet() {
        return this._singleKey == null ? Collections.EMPTY_SET : new SingleObjectSetX<K>(this._singleKey);
    }

    @Override
    public Collection<V> values() {
        return this._singleValue == null ? Collections.EMPTY_SET : new SingleObjectSetX<V>(this._singleValue);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        SingleObjectSetX<Map.Entry<K, V>> set = new SingleObjectSetX<Map.Entry<K, V>>();
        if (this._singleKey != null) {
            set.add(new Map.Entry<K, V>(){

                @Override
                public K getKey() {
                    return SingleObjectMap.this._singleKey;
                }

                @Override
                public V getValue() {
                    return SingleObjectMap.this._singleValue;
                }

                @Override
                public V setValue(V value) {
                    Object old = SingleObjectMap.this._singleValue;
                    SingleObjectMap.this._singleValue = value;
                    return old;
                }
            });
        }
        return set;
    }

    class SingleObjectSetX<T>
    extends SingleObjectSet<T> {
        private static final long serialVersionUID = 1L;

        public SingleObjectSetX() {
        }

        public SingleObjectSetX(T obj) {
            super(obj);
        }

        @Override
        protected void afterIteratorRemoveObject() {
            SingleObjectMap.this._singleKey = null;
            SingleObjectMap.this._singleValue = null;
        }
    }
}

