/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.bind.impl;

import java.io.Serializable;
import org.zkoss.bind.Binder;
import org.zkoss.bind.impl.AbstractForEachStatus;
import org.zkoss.bind.impl.AbstractRenderer;
import org.zkoss.bind.impl.BinderUtil;
import org.zkoss.bind.impl.IndirectBinding;
import org.zkoss.lang.Objects;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.util.Template;
import org.zkoss.zkmax.zul.Lineitem;
import org.zkoss.zkmax.zul.LineitemRenderer;
import org.zkoss.zkmax.zul.Linelayout;
import org.zkoss.zul.Label;
import org.zkoss.zul.ListModel;

public class BindLineitemRenderer<E>
extends AbstractRenderer
implements LineitemRenderer<E>,
Serializable {
    private static final long serialVersionUID = 20191014142611L;

    @Override
    public void render(Lineitem item, final E data, final int index) throws Exception {
        int size;
        final Linelayout linelayout = (Linelayout)item.getParent();
        Template tm = this.resolveTemplate((Component)linelayout, (Component)item, data, index, size = linelayout.getModel().getSize(), "model");
        if (tm == null) {
            Label label = new Label(Objects.toString(data));
            label.applyProperties();
            label.setParent((Component)item);
        } else {
            AbstractForEachStatus iterStatus = new AbstractForEachStatus(){
                private static final long serialVersionUID = 1L;

                public int getIndex() {
                    return index;
                }

                public Object getCurrent() {
                    return data;
                }

                public Integer getEnd() {
                    return size;
                }
            };
            String var = (String)tm.getParameters().get("var");
            String varnm = var == null ? "each" : var;
            String itervar = (String)tm.getParameters().get("status");
            String itervarnm = itervar == null ? (var == null ? "forEachStatus" : varnm + "Status") : itervar;
            Object oldVar = linelayout.getAttribute(varnm);
            Object oldIter = linelayout.getAttribute(itervarnm);
            linelayout.setAttribute(varnm, data);
            linelayout.setAttribute(itervarnm, iterStatus);
            Component[] items = this.filterOutShadows((Component)linelayout, tm.create((Component)linelayout, (Component)item, null, null));
            if (oldVar != null) {
                linelayout.setAttribute(varnm, oldVar);
            } else {
                linelayout.removeAttribute(varnm);
            }
            if (oldIter != null) {
                linelayout.setAttribute(itervarnm, oldIter);
            } else {
                linelayout.removeAttribute(itervarnm);
            }
            if (items.length != 1) {
                throw new UiException("The model template must have exactly one item, not " + items.length);
            }
            final Lineitem nli = (Lineitem)items[0];
            nli.setAttribute("$VAR$", varnm);
            nli.setAttribute("$isTemplateModelEnabled$", true);
            nli.setAttribute("$currentIndexResolver$", new IndirectBinding(data){

                public Binder getBinder() {
                    return BinderUtil.getBinder((Component)nli, (boolean)true);
                }

                protected ListModel getModel() {
                    return linelayout.getModel();
                }

                public Component getComponent() {
                    return nli;
                }
            });
            this.addItemReference((Component)linelayout, (Component)nli, index, varnm);
            nli.setAttribute(itervarnm, iterStatus);
            Object obj = item.removeAttribute("$TemplateVar$");
            if (obj != null) {
                nli.setAttribute("$TemplateVar$", obj);
            } else {
                nli.removeAttribute("$TemplateVar$");
            }
            this.addTemplateTracking((Component)linelayout, (Component)nli, data, index, size);
            item.setAttribute("org.zkoss.zul.model.renderAs", (Object)nli);
            item.detach();
        }
    }
}

