/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.zul;

import java.io.IOException;
import org.zkoss.lang.Objects;
import org.zkoss.xel.VariableResolver;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zk.ui.sys.ShadowElementsCtrl;
import org.zkoss.zk.ui.util.ForEachStatus;
import org.zkoss.zk.ui.util.Template;
import org.zkoss.zkex.rt.Runtime;
import org.zkoss.zkmax.zul.Lineitem;
import org.zkoss.zkmax.zul.LineitemRenderer;
import org.zkoss.zul.Label;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.ListModelList;
import org.zkoss.zul.event.ListDataEvent;
import org.zkoss.zul.event.ListDataListener;
import org.zkoss.zul.impl.XulElement;

public class Linelayout
extends XulElement {
    private String _orient = "vertical";
    private String _lineStyle;
    private int _firstScale = 1;
    private int _lastScale = 1;
    private ListModel<?> _model;
    private ListDataListener _listener;
    private LineitemRenderer _lineItemRenderer;
    private static final String ATTR_ON_INIT_RENDER_POSTED = "org.zkoss.zkmax.zul.Linelayout.onInitLaterPosted";
    private LineitemRenderer _defaultRenderer = new LineitemRenderer(){

        public void render(Lineitem lineItem, final Object data, final int index) {
            final Linelayout lineLayout = (Linelayout)lineItem.getParent();
            Template template = lineLayout.getTemplate("model");
            if (template == null) {
                Label label = new Label(Objects.toString((Object)data));
                label.setParent((Component)lineItem);
            } else {
                Component[] items = ShadowElementsCtrl.filterOutShadows((Component[])template.create((Component)lineLayout, (Component)lineItem, new VariableResolver(){

                    public Object resolveVariable(String name) {
                        if ("each".equals(name)) {
                            return data;
                        }
                        if ("forEachStatus".equals(name)) {
                            return new ForEachStatus(){

                                public ForEachStatus getPrevious() {
                                    return null;
                                }

                                public Object getEach() {
                                    return this.getCurrent();
                                }

                                public int getIndex() {
                                    return index;
                                }

                                public Integer getBegin() {
                                    return 0;
                                }

                                public Integer getEnd() {
                                    return lineLayout.getModel().getSize();
                                }

                                public Object getCurrent() {
                                    return data;
                                }

                                public boolean isFirst() {
                                    return this.getCount() == 1;
                                }

                                public boolean isLast() {
                                    return this.getIndex() + 1 == this.getEnd();
                                }

                                public Integer getStep() {
                                    return null;
                                }

                                public int getCount() {
                                    return this.getIndex() + 1;
                                }
                            };
                        }
                        return null;
                    }
                }, null));
                if (items.length != 1) {
                    throw new UiException("The model template must have exactly one item, not " + items.length);
                }
                Lineitem newLineitem = (Lineitem)items[0];
                lineItem.setAttribute("org.zkoss.zul.model.renderAs", (Object)newLineitem);
                lineItem.detach();
            }
        }
    };

    public String getOrient() {
        return this._orient;
    }

    public void setOrient(String orient) {
        if (!Objects.equals((Object)this._orient, (Object)orient)) {
            this._orient = orient;
            this.smartUpdate("orient", this._orient);
        }
    }

    public String getLineStyle() {
        return this._lineStyle;
    }

    public void setLineStyle(String lineStyle) {
        if (!Objects.equals((Object)this._lineStyle, (Object)lineStyle)) {
            this._lineStyle = lineStyle;
            this.smartUpdate("lineStyle", this._lineStyle);
        }
    }

    public int getFirstScale() {
        return this._firstScale;
    }

    public void setFirstScale(int firstScale) {
        if (firstScale < 0) {
            throw new WrongValueException("The scale should be non-negative. firstscale: " + firstScale);
        }
        if (this._firstScale != firstScale) {
            this._firstScale = firstScale;
            this.smartUpdate("firstScale", this._firstScale);
        }
    }

    public int getLastScale() {
        return this._lastScale;
    }

    public void setLastScale(int lastScale) {
        if (lastScale < 0) {
            throw new WrongValueException("The scale should be non-negative. lastScale: " + lastScale);
        }
        if (this._lastScale != lastScale) {
            this._lastScale = lastScale;
            this.smartUpdate("lastScale", this._lastScale);
        }
    }

    public void beforeChildAdded(Component child, Component insertBefore) {
        if (!(child instanceof Lineitem)) {
            throw new UiException("Unsupported child for Linelayout: " + String.valueOf(child));
        }
        super.beforeChildAdded(child, insertBefore);
    }

    public LineitemRenderer<?> getLineitemRenderer() {
        return this._lineItemRenderer;
    }

    public void setLineitemRenderer(LineitemRenderer renderer) {
        if (this._lineItemRenderer != renderer) {
            this._lineItemRenderer = renderer;
            if (this._model != null) {
                this.postOnInitRender();
            }
        }
    }

    public ListModel<?> getModel() {
        return this._model;
    }

    public void setModel(ListModel<?> model) {
        if (model != null) {
            if (this._model != model) {
                if (this._model != null) {
                    this._model.removeListDataListener(this._listener);
                }
                this._model = model;
                this.initDataListener();
            }
            this.postOnInitRender();
        } else if (this._model != null) {
            this._model.removeListDataListener(this._listener);
            this._model = null;
            this.getChildren().clear();
        }
    }

    private void initDataListener() {
        if (this._listener == null) {
            this._listener = new ListDataListener(){

                public void onChange(ListDataEvent event) {
                    int eventType = event.getType();
                    switch (eventType) {
                        case 4: 
                        case 6: {
                            return;
                        }
                    }
                    Linelayout.this.postOnInitRender();
                }
            };
        }
        this._model.addListDataListener(this._listener);
    }

    private void postOnInitRender() {
        if (this.getAttribute(ATTR_ON_INIT_RENDER_POSTED) == null) {
            this.setAttribute(ATTR_ON_INIT_RENDER_POSTED, Boolean.TRUE);
            Events.postEvent((String)"onInitRender", (Component)this, null);
        }
    }

    public void onInitRender() {
        this.removeAttribute(ATTR_ON_INIT_RENDER_POSTED);
        LineitemRenderer renderer = this.getRealRenderer();
        ListModelList lineItems = (ListModelList)this._model;
        try {
            this.getChildren().clear();
            int sz = lineItems.size();
            for (int i = 0; i < sz; ++i) {
                Lineitem lineItem = new Lineitem();
                lineItem.applyProperties();
                lineItem.setParent((Component)this);
                Object data = lineItems.getElementAt(i);
                renderer.render(lineItem, data, i);
                Object v = lineItem.getAttribute("org.zkoss.zul.model.renderAs");
                if (v == null) continue;
                lineItem = (Lineitem)((Object)v);
            }
        }
        catch (Exception e) {
            throw UiException.Aide.wrap((Throwable)e);
        }
        Events.postEvent((String)"onAfterRender", (Component)this, null);
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        Runtime.init((Object)((Object)this));
        super.renderProperties(renderer);
        if (!"vertical".equals(this._orient)) {
            this.render(renderer, "orient", this._orient);
        }
        this.render(renderer, "lineStyle", this._lineStyle);
        if (this._firstScale != 1) {
            this.render(renderer, "firstScale", this._firstScale);
        }
        if (this._lastScale != 1) {
            this.render(renderer, "lastScale", this._lastScale);
        }
    }

    public String getZclass() {
        return this._zclass != null ? this._zclass : "z-linelayout";
    }

    private LineitemRenderer getRealRenderer() {
        return this._lineItemRenderer != null ? this._lineItemRenderer : this._defaultRenderer;
    }

    public LineitemRenderer<?> getItemRenderer() {
        return this._lineItemRenderer;
    }

    public void setItemRenderer(LineitemRenderer<?> renderer) {
        if (this._lineItemRenderer != renderer) {
            this._lineItemRenderer = renderer;
            this.invalidate();
        }
    }
}

