/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.au.websocket;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.zkoss.zkmax.ui.http.FacadeHttpServletRequest;

public class RequestWrapper
extends HttpServletRequestWrapper {
    private Map<String, Object> _attributes = new HashMap<String, Object>(4);
    private Map<String, String> _headers;
    private FacadeHttpServletRequest _request;

    public RequestWrapper(HttpServletRequest request, Map<String, String> headers) {
        super(request);
        this._request = (FacadeHttpServletRequest)request;
        this._headers = headers == null ? new HashMap(0) : headers;
    }

    public String getHeader(String name) {
        String value = this._headers.get(name.toLowerCase());
        return value == null ? super.getHeader(name) : value;
    }

    public Enumeration<String> getHeaders(String name) {
        HashSet<String> set = new HashSet<String>();
        String header = this._headers.get(name.toLowerCase());
        if (header != null && !"".equals(header.trim())) {
            set.add(header);
        }
        set.addAll(Collections.list(super.getHeaders(name)));
        return Collections.enumeration(set);
    }

    public Enumeration<String> getHeaderNames() {
        HashSet<String> set = new HashSet<String>();
        set.addAll(this._headers.keySet());
        set.addAll(Collections.list(super.getHeaderNames()));
        return Collections.enumeration(set);
    }

    public Object getAttribute(String name) {
        Object attr = this._attributes.get(name);
        return attr == null ? super.getAttribute(name) : attr;
    }

    public Enumeration<String> getAttributeNames() {
        HashSet<String> set = new HashSet<String>();
        set.addAll(this._attributes.keySet());
        set.addAll(Collections.list(super.getAttributeNames()));
        return Collections.enumeration(set);
    }

    public void setAttribute(String name, Object o) {
        this._attributes.put(name, o);
    }

    public void removeAttribute(String name) {
        this._attributes.remove(name);
    }

    protected void removeAllAttributes() {
        this._attributes.clear();
        this._request.removeAllAttributes();
    }
}

