/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.zul;

import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import org.zkoss.lang.Objects;
import org.zkoss.text.DateFormats;
import org.zkoss.util.Locales;
import org.zkoss.util.TimeZones;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.impl.Utils;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zkex.rt.Runtime;
import org.zkoss.zul.Constraint;
import org.zkoss.zul.Datebox;
import org.zkoss.zul.SimpleLocalTimeConstraint;
import org.zkoss.zul.impl.DateTimeFormatInputElement;
import org.zkoss.zul.mesg.MZul;

public class Timepicker
extends DateTimeFormatInputElement {
    static final String DEFAULT_FORMAT = "HH:mm";
    private static Date _dummyDate = new Date();
    private Date _min;
    private Date _max;
    private int _interval;
    private Boolean _readonly;

    public Timepicker() {
        this.setCols(5);
        this.setFormat("");
        this._interval = 3600;
    }

    public Timepicker(Date date) throws WrongValueException {
        this();
        this.setValue(date);
    }

    public Timepicker(ZonedDateTime value) throws WrongValueException {
        this();
        this.setValueInZonedDateTime(value);
    }

    public Timepicker(LocalDateTime value) throws WrongValueException {
        this();
        this.setValueInLocalDateTime(value);
    }

    public Timepicker(LocalTime value) throws WrongValueException {
        this();
        this.setValueInLocalTime(value);
    }

    public void setFormat(String format) throws WrongValueException {
        if (!Objects.equals((Object)this.getFormat(), (Object)format)) {
            String realformat = this.getRealFormat();
            if (realformat.indexOf("z") != -1) {
                String timezone = this.getFormattedTimezone();
                this.smartUpdate("timezone", timezone);
            }
            super.setFormat(format != null ? format : "");
        }
    }

    public String getRealFormat() {
        String format = this.getFormat();
        if (format == null || format.length() == 0) {
            return this.getDefaultFormat();
        }
        int ts = Datebox.toStyle((String)format);
        return ts != -111 ? DateFormats.getTimeFormat((int)ts, (Locale)this._locale, (String)DEFAULT_FORMAT) : format;
    }

    public void setValueInLocalDate(LocalDate value) throws WrongValueException {
        throw new UnsupportedOperationException("need time");
    }

    public Date getMin() {
        return this._min;
    }

    public void setMin(Date min) {
        if (this._min != min) {
            this._min = min;
            this.smartUpdate("min", min);
        }
    }

    public LocalTime getMinInLocalTime() {
        return this._min == null ? null : this.toZonedDateTime(this._min).toLocalTime();
    }

    public void setMinInLocalTime(LocalTime min) {
        this.setMin(this.toDate(min));
    }

    public Date getMax() {
        return this._max;
    }

    public void setMax(Date max) {
        if (this._max != max) {
            this._max = max;
            this.smartUpdate("max", max);
        }
    }

    public LocalTime getMaxInLocalTime() {
        return this._max == null ? null : this.toZonedDateTime(this._max).toLocalTime();
    }

    public void setMaxInLocalTime(LocalTime max) {
        this.setMax(this.toDate(max));
    }

    public int getInterval() {
        return this._interval;
    }

    public void setInterval(int interval) {
        String format = this.getRealFormat();
        if (interval > 0 && interval < 60 && !format.contains("s")) {
            throw new WrongValueException("If the format doesn't contain 'second', the interval shouldn't be smaller than 60.");
        }
        if (interval > 0 && interval < 3600 && !format.contains("m")) {
            throw new WrongValueException("If the format doesn't contain 'minute', the interval shouldn't be smaller than 3600.");
        }
        if (this._interval != interval) {
            this._interval = interval;
            this.smartUpdate("interval", interval);
        }
    }

    public boolean isReadonly() {
        return this._readonly == null ? false : this._readonly;
    }

    public void setReadonly(boolean readonly) {
        this._readonly = readonly;
        super.setReadonly(readonly);
    }

    private boolean isReadonlyUnset() {
        return this._readonly == null;
    }

    public void setConstraint(String constr) {
        this.setConstraint((Constraint)(constr != null ? new SimpleLocalTimeConstraint(constr) : null));
    }

    protected String getDefaultFormat() {
        return DateFormats.getTimeFormat((int)2, (Locale)this._locale, (String)DEFAULT_FORMAT);
    }

    protected Object coerceFromString(String value) throws WrongValueException {
        Date date;
        if (value == null || value.length() == 0) {
            return null;
        }
        String fmt = this.getRealFormat();
        DateFormat df = this.getDateFormat(fmt);
        try {
            date = df.parse(value);
        }
        catch (ParseException ex) {
            throw this.showCustomError(new WrongValueException((Component)this, MZul.DATE_REQUIRED, new Object[]{value, fmt}));
        }
        return date;
    }

    protected String coerceToString(Object value) {
        DateFormat df = this.getDateFormat(this.getRealFormat());
        return value != null ? df.format((Date)value) : "";
    }

    protected DateFormat getDateFormat(String fmt) {
        SimpleDateFormat df = new SimpleDateFormat(fmt, this._locale != null ? this._locale : Locales.getCurrent());
        TimeZone tz = this._tzone != null ? this._tzone : TimeZones.getCurrent();
        df.setTimeZone(tz);
        return df;
    }

    private Object[] getRealSymbols() {
        if (this._locale != null) {
            String localeName = this._locale.toString();
            if (Utils.markClientInfoPerDesktop((Desktop)this.getDesktop(), (String)(((Object)((Object)this)).getClass().getName() + localeName))) {
                HashMap<String, String[]> map = new HashMap<String, String[]>(2);
                Calendar cal = Calendar.getInstance(this._locale);
                SimpleDateFormat df = new SimpleDateFormat("a", this._locale);
                cal.set(11, 3);
                String[] ampm = new String[2];
                ampm[0] = df.format(cal.getTime());
                cal.set(11, 15);
                ampm[1] = df.format(cal.getTime());
                map.put("APM", ampm);
                return new Object[]{localeName, map};
            }
            return new Object[]{localeName, null};
        }
        return null;
    }

    public String getZclass() {
        return this._zclass == null ? "z-timepicker" : this._zclass;
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        Runtime.init((Object)((Object)this));
        super.renderProperties(renderer);
        String realformat = this.getRealFormat();
        if (realformat.indexOf("z") != -1) {
            String timezone = this.getFormattedTimezone();
            renderer.render("timezoneAbbr", timezone);
        }
        if (this._locale != null) {
            renderer.render("localizedSymbols", (Object)this.getRealSymbols());
        }
        if (this._min != null) {
            renderer.render("min", this._min);
        }
        if (this._max != null) {
            renderer.render("max", this._max);
        }
        if (this._interval != 0) {
            renderer.render("interval", this._interval);
        }
        if (this._readonly == null) {
            renderer.render("readonly", true);
        }
    }

    private String getFormattedTimezone() {
        return this.getDateFormat("z").format(_dummyDate);
    }
}

