/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.zul;

import java.io.IOException;
import java.util.Map;
import org.zkoss.json.JSONObject;
import org.zkoss.json.JSONValue;
import org.zkoss.lang.Objects;
import org.zkoss.lang.Strings;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zkex.rt.Runtime;
import org.zkoss.zkmax.zul.event.DetectEvent;
import org.zkoss.zul.impl.XulElement;

public class Barcodescanner
extends XulElement {
    private String _type = "CODE128";
    private boolean _continuous = false;
    private boolean _enable = true;
    private int _interval = 1000;
    private Map _constraints;
    private int _consistencyBufferSize = 5;
    private int _consistencyThreshold = 3;
    private double _errorAcceptance = 0.1;

    public String getType() {
        return this._type;
    }

    public void setType(String type) {
        if (!this._type.equals(type)) {
            this._type = type;
            this.smartUpdate("type", this._type);
        }
    }

    public boolean getContinuous() {
        return this.isContinuous();
    }

    public boolean isContinuous() {
        return this._continuous;
    }

    public void setContinuous(boolean continuous) {
        if (continuous != this._continuous) {
            this._continuous = continuous;
            this.smartUpdate("continuous", continuous);
        }
    }

    public boolean getEnable() {
        return this.isEnable();
    }

    public boolean isEnable() {
        return this._enable;
    }

    public void setEnable(boolean enable) {
        if (this._enable != enable) {
            this._enable = enable;
            this.smartUpdate("enable", enable);
        }
    }

    public double getInterval() {
        return this._interval;
    }

    public void setInterval(int interval) {
        if (interval != this._interval) {
            this._interval = interval;
            this.smartUpdate("interval", interval);
        }
    }

    public Map getConstraints() {
        return this._constraints;
    }

    public void setConstraints(Map constraints) {
        if (!Objects.equals((Object)this._constraints, (Object)constraints)) {
            this._constraints = constraints;
            this.smartUpdate("constraints", constraints);
        }
    }

    public String getConstraintsString() {
        return JSONObject.toJSONString((Map)this._constraints);
    }

    public void setConstraintsString(String constraints) {
        this.setConstraints(Strings.isEmpty((String)constraints) ? null : (Map)JSONValue.parse((String)constraints));
    }

    public int getConsistencyBufferSize() {
        return this._consistencyBufferSize;
    }

    public void setConsistencyBufferSize(int bufferSize) {
        if (bufferSize <= 0) {
            throw new UiException("bufferSize should be > 0");
        }
        if (this.isInitialized() && bufferSize < this._consistencyThreshold) {
            throw new UiException("bufferSize should be larger or equal than threshold");
        }
        if (bufferSize != this._consistencyBufferSize) {
            this._consistencyBufferSize = bufferSize;
            this.smartUpdate("consistencyBufferSize", bufferSize);
        }
    }

    public int getConsistencyThreshold() {
        return this._consistencyThreshold;
    }

    public void setConsistencyThreshold(int threshold) {
        if (threshold <= 0) {
            throw new UiException("threshold should be > 0");
        }
        if (this.isInitialized() && threshold > this._consistencyBufferSize) {
            throw new UiException("threshold should be lesser or equal than buffer size");
        }
        if (threshold != this._consistencyThreshold) {
            this._consistencyThreshold = threshold;
            this.smartUpdate("consistencyThreshold", threshold);
        }
    }

    public double getErrorAcceptance() {
        return this._errorAcceptance;
    }

    public void setErrorAcceptance(double acceptance) {
        if (acceptance < 0.0 || acceptance > 1.0) {
            throw new UiException("acceptance should be >= 0 and <= 1");
        }
        if (this._errorAcceptance != acceptance) {
            this._errorAcceptance = acceptance;
            this.smartUpdate("errorAcceptance", acceptance);
        }
    }

    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        if (cmd.equals("onDetect")) {
            Events.postEvent((Event)new DetectEvent(cmd, (Component)this, request.getData()));
        } else {
            super.service(request, everError);
        }
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        Runtime.init((Object)((Object)this));
        super.renderProperties(renderer);
        if (this._consistencyThreshold > this._consistencyBufferSize) {
            throw new UiException("threshold should be lesser or equal than buffer size");
        }
        if (!"CODE128".equals(this._type)) {
            this.render(renderer, "type", this._type);
        }
        if (this._continuous) {
            this.render(renderer, "continuous", this._continuous);
        }
        if ((double)this._interval != 1.0) {
            this.render(renderer, "interval", this._interval);
        }
        if (!this._enable) {
            renderer.render("enable", false);
        }
        this.render(renderer, "constraints", this._constraints);
        if (this._consistencyBufferSize != 5) {
            this.render(renderer, "consistencyBufferSize", this._consistencyBufferSize);
        }
        if (this._consistencyThreshold != 3) {
            this.render(renderer, "consistencyThreshold", this._consistencyThreshold);
        }
        if (this._errorAcceptance != 0.1) {
            this.render(renderer, "errorAcceptance", this._errorAcceptance);
        }
    }

    static {
        Barcodescanner.addClientEvent(Barcodescanner.class, (String)"onDetect", (int)0);
    }
}

