/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.zul;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.zkoss.util.media.Media;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.DeferredValue;
import org.zkoss.zk.au.out.AuInvoke;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.StateChangeEvent;
import org.zkoss.zk.ui.ext.render.DynamicMedia;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zkex.rt.Runtime;
import org.zkoss.zul.Track;
import org.zkoss.zul.ext.MediaElement;
import org.zkoss.zul.impl.Utils;
import org.zkoss.zul.impl.XulElement;

public class Video
extends XulElement
implements MediaElement {
    public static final int STOP = 0;
    public static final int PLAY = 1;
    public static final int PAUSE = 2;
    public static final int END = 3;
    private boolean _autoplay;
    private boolean _controls;
    private boolean _loop;
    private boolean _dimBackground;
    private boolean _playsinline;
    private boolean _clipToFit;
    private boolean _muted;
    private String _preload;
    private String _poster;
    private String _crossorigin;
    private List<String> _src = new ArrayList<String>();
    private org.zkoss.video.Video _content;
    private double _playbackRate = 1.0;
    private double _volume = 1.0;
    private byte _playerVersion;
    private int _currentState = 0;

    public Video() {
    }

    public Video(String src) {
        this.setSrc(src);
    }

    public boolean isAutoplay() {
        return this._autoplay;
    }

    public void setAutoplay(boolean autoplay) {
        if (this._autoplay != autoplay) {
            this._autoplay = autoplay;
            this.smartUpdate("autoplay", this._autoplay);
        }
    }

    public boolean isControls() {
        return this._controls;
    }

    public void setControls(boolean controls) {
        if (this._controls != controls) {
            this._controls = controls;
            this.smartUpdate("controls", this._controls);
        }
    }

    public boolean isLoop() {
        return this._loop;
    }

    public void setLoop(boolean loop) {
        if (this._loop != loop) {
            this._loop = loop;
            this.smartUpdate("loop", this._loop);
        }
    }

    public boolean isDimBackground() {
        return this._dimBackground;
    }

    public void setDimBackground(boolean dimBackground) {
        if (this._dimBackground != dimBackground) {
            this._dimBackground = dimBackground;
            this.smartUpdate("dimBackground", this._dimBackground);
        }
    }

    public String getPreload() {
        return this._preload;
    }

    public void setPreload(String preload) {
        if (!(preload = "none".equalsIgnoreCase(preload) ? "none" : ("metadata".equalsIgnoreCase(preload) ? "metadata" : "auto")).equals(this._preload)) {
            this._preload = preload;
            this.smartUpdate("preload", this._preload);
        }
    }

    public String getPoster() {
        return this._poster;
    }

    public void setPoster(String poster) {
        if (poster != null && !poster.equals(this._poster)) {
            this._poster = poster;
            this.smartUpdate("poster", this._poster);
        }
    }

    public List<String> getSrc() {
        return this._src;
    }

    public void setSrc(String src) {
        if (src == null) {
            return;
        }
        String[] split = src.split(",");
        ArrayList<String> list = new ArrayList<String>(split.length);
        for (String s : split) {
            list.add(s.trim());
        }
        if (this._content != null || !this._src.equals(list)) {
            this._content = null;
            this.setSrcList(list);
        }
    }

    public void setSrcList(List<String> src) {
        if (!this._src.equals(src)) {
            this._src = src;
            this.smartUpdate("src", new EncodedSrc());
        }
    }

    public String getCrossorigin() {
        return this._crossorigin;
    }

    public void setCrossorigin(String crossorigin) {
        this._crossorigin = "use-credentials".equalsIgnoreCase(crossorigin) ? "use-credentials" : "anonymous";
        if (!this._crossorigin.equals(crossorigin)) {
            this._crossorigin = crossorigin;
            this.smartUpdate("crossorigin", this._crossorigin);
        }
    }

    public boolean isPlaysinline() {
        return this._playsinline;
    }

    public void setPlaysinline(boolean playsinline) {
        if (this._playsinline != playsinline) {
            this._playsinline = playsinline;
            this.smartUpdate("playsinline", this._playsinline);
        }
    }

    public double getPlaybackRate() {
        return this._playbackRate;
    }

    public void setPlaybackRate(double playbackRate) {
        if (this._playbackRate != playbackRate) {
            this._playbackRate = playbackRate;
            this.smartUpdate("playbackRate", this._playbackRate);
        }
    }

    public boolean isClipToFit() {
        return this._clipToFit;
    }

    public void setClipToFit(boolean clipToFit) {
        if (this._clipToFit != clipToFit) {
            this._clipToFit = clipToFit;
            this.smartUpdate("clipToFit", this._clipToFit);
        }
    }

    public boolean isMuted() {
        return this._muted || this._volume == 0.0;
    }

    public void setMuted(boolean muted) {
        if (this._muted != muted) {
            this._muted = muted;
            this.smartUpdate("muted", this._muted);
        }
    }

    public void setPlaying(boolean playing) {
        if (playing) {
            this.play();
        } else {
            this.pause();
        }
    }

    public void setCurrentTime(double currentTime) {
        if (currentTime < 0.0) {
            throw new WrongValueException("currentTime can not be negative.");
        }
        this.response(null, (AuResponse)new AuInvoke((Component)this, "setCurrentTime", currentTime));
    }

    public double getVolume() {
        return this._volume;
    }

    public void setVolume(double volume) {
        if (this._volume != volume) {
            if (volume < 0.0 || volume > 1.0) {
                throw new WrongValueException("the value of volume must between 0 and 1.");
            }
            this._volume = volume;
            this.smartUpdate("volume", this._volume);
        }
    }

    public org.zkoss.video.Video getContent() {
        return this._content;
    }

    public void setContent(org.zkoss.video.Video content) {
        if (this._src != null || content != this._content) {
            this._content = content;
            this._src = null;
            if (this._content != null) {
                this._playerVersion = (byte)(this._playerVersion + 1);
            }
            this.smartUpdate("src", new EncodedSrc());
        }
    }

    private List<String> getEncodedSrc() {
        Desktop dt = this.getDesktop();
        ArrayList<String> list = new ArrayList<String>();
        if (this._content != null) {
            list.add(this.getPlayerSrc());
        } else if (dt != null) {
            for (String src : this._src) {
                list.add(dt.getExecution().encodeURL(src));
            }
        }
        return list;
    }

    private String getPlayerSrc() {
        return Utils.getDynamicMediaURI((AbstractComponent)this, (int)this._playerVersion, (String)this._content.getName(), (String)this._content.getFormat());
    }

    public void play() {
        if (this._currentState != 1) {
            this.response(null, (AuResponse)new AuInvoke((Component)this, "setPlaying", 1));
        }
    }

    public void pause() {
        if (this._currentState != 2) {
            this.response(null, (AuResponse)new AuInvoke((Component)this, "setPlaying", 2));
        }
    }

    public void stop() {
        if (this._currentState != 0) {
            this.response(null, (AuResponse)new AuInvoke((Component)this, "setPlaying", 0));
        }
    }

    public boolean isPlaying() {
        return this._currentState == 1;
    }

    public boolean isPaused() {
        return this._currentState == 2;
    }

    public boolean isStopped() {
        return this._currentState == 0 || this._currentState == 3;
    }

    public boolean isEnded() {
        return this._currentState == 3;
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        Runtime.init((Object)((Object)this));
        this.render(renderer, "src", this.getEncodedSrc());
        this.render(renderer, "autoplay", this._autoplay);
        this.render(renderer, "controls", this._controls);
        this.render(renderer, "loop", this._loop);
        this.render(renderer, "dimBackground", this._dimBackground);
        this.render(renderer, "preload", this._preload);
        this.render(renderer, "poster", this._poster);
        this.render(renderer, "crossorigin", this._crossorigin);
        this.render(renderer, "playsinline", this._playsinline);
        this.render(renderer, "muted", this._muted);
        this.render(renderer, "clipToFit", this._clipToFit);
        if (this._playbackRate != 1.0) {
            this.render(renderer, "playbackRate", this._playbackRate);
        }
        if (this._volume != 1.0) {
            this.render(renderer, "volume", this._volume);
        }
    }

    public void beforeChildAdded(Component child, Component insertBefore) {
        if (!(child instanceof Track)) {
            throw new UiException("Unsupported child for video: " + String.valueOf(child));
        }
        super.beforeChildAdded(child, insertBefore);
    }

    public Object getExtraCtrl() {
        return new ExtraCtrl();
    }

    protected void updateByClient(String name, Object value) {
        if ("dimBackground".equals(name) && value instanceof Boolean) {
            this._dimBackground = (Boolean)value;
        } else if ("muted".equals(name) && value instanceof Boolean) {
            this._muted = (Boolean)value;
        } else if ("volume".equals(name) && value instanceof Number) {
            this._volume = ((Number)value).doubleValue();
        } else {
            super.updateByClient(name, value);
        }
    }

    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        if ("onStateChange".equals(cmd)) {
            StateChangeEvent stateChangeEvent = StateChangeEvent.getStateChangeEvent((AuRequest)request);
            this._currentState = stateChangeEvent.getState();
            Events.postEvent((Event)stateChangeEvent);
        } else {
            super.service(request, everError);
        }
    }

    static {
        Video.addClientEvent(Video.class, (String)"onStateChange", (int)1);
    }

    private class EncodedSrc
    implements DeferredValue {
        private EncodedSrc() {
        }

        public Object getValue() {
            return Video.this.getEncodedSrc();
        }
    }

    protected class ExtraCtrl
    extends HtmlBasedComponent.ExtraCtrl
    implements DynamicMedia {
        protected ExtraCtrl() {
            super((HtmlBasedComponent)Video.this);
        }

        public Media getMedia(String pathInfo) {
            return Video.this._content;
        }
    }
}

